/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.netbeans.modules.cnd.repository.AsyncRepositoryWriter;
import org.netbeans.modules.cnd.repository.RemoveKeySupport;
import org.netbeans.modules.cnd.repository.RepositoryImpl;
import org.netbeans.modules.cnd.repository.api.RepositoryExceptions;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.storage.StorageManager;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.openide.util.RequestProcessor;

final class AsyncRepositoryWriterImpl
implements AsyncRepositoryWriter {
    private static final int ncounters = 128;
    private static final int bits = 32;
    private static final int mcounters = 4095;
    private final RequestProcessor RP = new RequestProcessor("Repository Writing Thread", 1);
    private final Map<Key, Persistent> map_small = new LinkedHashMap<Key, Persistent>(512, 0.75f, true);
    private final Map<Key, Persistent> map_large = new LinkedHashMap<Key, Persistent>(512, 0.75f, true);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition mapIsEmpty = this.lock.newCondition();
    private final Condition mapIsNotEmpty = this.lock.newCondition();
    private final Condition writerDone = this.lock.newCondition();
    private final int[] counters = new int[128];
    private final AtomicBoolean flush = new AtomicBoolean(false);
    private boolean doneFlag;
    private final RemoveKeySupport removeKeySupport;

    public AsyncRepositoryWriterImpl(StorageManager storage, RemoveKeySupport removeKeySupport) {
        this.removeKeySupport = removeKeySupport;
        this.RP.scheduleAtFixedRate((Runnable)new Worker(storage), 0L, 3L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Key key, Persistent value) {
        boolean largeObject = key.getBehavior().equals((Object)Key.Behavior.LargeAndMutable);
        int idx = key.hashCode() & 0xFFF;
        int idx1 = idx / 32;
        int idx2 = idx % 32;
        this.lock.lock();
        try {
            assert (!this.doneFlag);
            if (largeObject) {
                this.map_large.remove(key);
                this.map_large.put(key, value);
            } else {
                this.map_small.remove(key);
                this.map_small.put(key, value);
            }
            int n = idx1;
            this.counters[n] = this.counters[n] | 1 << idx2;
            this.mapIsNotEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Persistent get(Key key) {
        boolean largeObject = key.getBehavior().equals((Object)Key.Behavior.LargeAndMutable);
        this.lock.lock();
        try {
            if (largeObject) {
                Persistent persistent = this.map_large.get(key);
                return persistent;
            }
            Persistent persistent = this.map_small.get(key);
            return persistent;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUnit(int unitID) {
        this.lock.lock();
        try {
            Iterator<Map.Entry<Key, Persistent>> it = this.map_small.entrySet().iterator();
            while (it.hasNext()) {
                if (it.next().getKey().getUnitId() != unitID) continue;
                it.remove();
            }
            it = this.map_large.entrySet().iterator();
            while (it.hasNext()) {
                if (it.next().getKey().getUnitId() != unitID) continue;
                it.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException, InterruptedException {
        this.flush.set(true);
        this.lock.lock();
        try {
            while (!this.map_large.isEmpty() || !this.map_small.isEmpty()) {
                this.mapIsEmpty.await();
            }
        }
        finally {
            this.lock.unlock();
            this.flush.set(false);
        }
    }

    @Override
    public void flush(int unitID) throws IOException, InterruptedException {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.lock.lock();
        try {
            if (this.doneFlag) {
                return;
            }
            this.doneFlag = true;
            try {
                this.flush();
            }
            catch (Exception ex) {
                RepositoryExceptions.throwException((Object)this, (Throwable)ex);
            }
            this.mapIsNotEmpty.signalAll();
            try {
                this.writerDone.await();
            }
            catch (InterruptedException ex) {
                RepositoryExceptions.throwException((Object)this, (Throwable)ex);
            }
        }
        finally {
            this.RP.shutdown();
            this.lock.unlock();
        }
    }

    private class Worker
    implements Runnable {
        private final StorageManager storage;
        private boolean maintenanceIsNeeded = true;

        public Worker(StorageManager storage) {
            this.storage = storage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Persistent value = null;
            int idx = -1;
            int idx1 = -1;
            int idx2 = -1;
            boolean largeObject = false;
            boolean draining = false;
            int workSize = AsyncRepositoryWriterImpl.this.map_large.size() + AsyncRepositoryWriterImpl.this.map_small.size();
            while (true) {
                Key key;
                block24: {
                    key = null;
                    if (AsyncRepositoryWriterImpl.this.flush.get()) {
                        draining = true;
                    } else if (workSize-- <= 0) {
                        workSize = AsyncRepositoryWriterImpl.this.map_large.size() + AsyncRepositoryWriterImpl.this.map_small.size();
                        draining = false;
                    } else {
                        draining = true;
                    }
                    if (!draining) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ex) {
                            RepositoryExceptions.throwException((Object)this, (Throwable)ex);
                        }
                    }
                    AsyncRepositoryWriterImpl.this.lock.lock();
                    try {
                        if (AsyncRepositoryWriterImpl.this.map_large.isEmpty() && AsyncRepositoryWriterImpl.this.map_small.isEmpty()) {
                            AsyncRepositoryWriterImpl.this.mapIsEmpty.signalAll();
                            if (AsyncRepositoryWriterImpl.this.doneFlag) {
                                AsyncRepositoryWriterImpl.this.writerDone.signalAll();
                                return;
                            }
                            this.waitReady();
                        }
                        this.maintenanceIsNeeded = true;
                        for (Map.Entry entry : AsyncRepositoryWriterImpl.this.map_small.entrySet()) {
                            key = (Key)entry.getKey();
                            idx = key.hashCode() & 0xFFF;
                            idx1 = idx / 32;
                            idx2 = idx % 32;
                            if ((AsyncRepositoryWriterImpl.this.counters[idx1] & 1 << idx2) != 0) {
                                int[] nArray = AsyncRepositoryWriterImpl.this.counters;
                                int n = idx1;
                                nArray[n] = nArray[n] & ~(1 << idx2);
                                key = null;
                                continue;
                            }
                            value = (Persistent)entry.getValue();
                            largeObject = false;
                            break;
                        }
                        if (key != null) break block24;
                        for (Map.Entry entry : AsyncRepositoryWriterImpl.this.map_large.entrySet()) {
                            key = (Key)entry.getKey();
                            idx = key.hashCode() & 0xFFF;
                            idx1 = idx / 32;
                            idx2 = idx % 32;
                            if ((AsyncRepositoryWriterImpl.this.counters[idx1] & 1 << idx2) != 0) {
                                int[] nArray = AsyncRepositoryWriterImpl.this.counters;
                                int n = idx1;
                                nArray[n] = nArray[n] & ~(1 << idx2);
                                key = null;
                                continue;
                            }
                            value = (Persistent)entry.getValue();
                            largeObject = true;
                            break;
                        }
                    }
                    catch (Throwable th) {
                        RepositoryExceptions.throwException((Object)this, (Throwable)th);
                    }
                    finally {
                        AsyncRepositoryWriterImpl.this.lock.unlock();
                    }
                }
                if (key == null || value == null) continue;
                this.doWrite(key, value);
                AsyncRepositoryWriterImpl.this.lock.lock();
                try {
                    if ((AsyncRepositoryWriterImpl.this.counters[idx1] & 1 << idx2) != 0) continue;
                    if (largeObject) {
                        AsyncRepositoryWriterImpl.this.map_large.remove(key);
                        continue;
                    }
                    AsyncRepositoryWriterImpl.this.map_small.remove(key);
                    continue;
                }
                finally {
                    AsyncRepositoryWriterImpl.this.lock.unlock();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doWrite(Key key, Persistent value) {
            try {
                if (RepositoryImpl.REMOVED_OBJECT.equals(value)) {
                    AsyncRepositoryWriterImpl.this.removeKeySupport.removeKey(key);
                    return;
                }
            }
            catch (Throwable ex) {
                RepositoryExceptions.throwException((Object)this, (Key)key, (Throwable)ex);
            }
            RepositoryDataOutput out = null;
            try {
                out = this.storage.getOutputStream(key);
                assert (out != null);
                key.getPersistentFactory().write(out, RepositoryImpl.REMOVED_OBJECT.equals(value) ? null : value);
            }
            catch (Throwable ex) {
                RepositoryExceptions.throwException((Object)this, (Key)key, (Throwable)ex);
                out = null;
            }
            finally {
                try {
                    if (out != null) {
                        out.commit();
                    }
                }
                catch (Throwable ex) {
                    RepositoryExceptions.throwException((Object)this, (Key)key, (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitReady() throws InterruptedException {
            if (Stats.maintenanceInterval > 0) {
                while (Stats.allowMaintenance && this.maintenanceIsNeeded) {
                    AsyncRepositoryWriterImpl.this.lock.lock();
                    try {
                        if (!AsyncRepositoryWriterImpl.this.map_large.isEmpty() || !AsyncRepositoryWriterImpl.this.map_small.isEmpty()) {
                            return;
                        }
                        this.maintenanceIsNeeded = this.storage.maintenance(Stats.maintenanceInterval);
                    }
                    finally {
                        AsyncRepositoryWriterImpl.this.lock.unlock();
                    }
                    if (AsyncRepositoryWriterImpl.this.map_large.isEmpty() && AsyncRepositoryWriterImpl.this.map_small.isEmpty()) continue;
                    return;
                }
                AsyncRepositoryWriterImpl.this.mapIsNotEmpty.await();
            } else {
                if (!AsyncRepositoryWriterImpl.this.map_large.isEmpty() || !AsyncRepositoryWriterImpl.this.map_small.isEmpty()) {
                    return;
                }
                AsyncRepositoryWriterImpl.this.mapIsNotEmpty.await();
            }
        }
    }
}

