/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.cnd.repository.RepositoryImpl;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.utils.CndUtils;

public final class RepositoryCache {
    private static final boolean WEAK_REF = false;
    private static final boolean SOFT_REFS_ON_GET = true;
    private static final boolean STATISTIC = false;
    private static final int DEFAULT_SLICE_CAPACITY;
    private static final int SLICE_SIZE;
    private static final int SLICE_MASK;
    private final SlicedMap cache = new SlicedMap();
    private final Lock refQueueLock = new ReentrantLock();
    private final ReferenceQueue<Persistent> refQueue = new ReferenceQueue();
    private int readCnt = 0;
    private int readHitCnt = 0;
    private int hangs = 0;
    private int puts = 0;
    private int putIfAbs = 0;
    private int switchToSoft = 0;
    private int weakRefs = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hang(Key key, Persistent obj) {
        Slice s = this.cache.getSilce(key);
        s.w.lock();
        try {
            s.storage.put(key, obj);
        }
        finally {
            s.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Key key, Persistent obj) {
        Slice s = this.cache.getSilce(key);
        WeakValue value = new WeakValue(obj, key, this.refQueue);
        s.w.lock();
        try {
            s.storage.put(key, value);
        }
        finally {
            s.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Persistent putIfAbsent(Key key, Persistent obj) {
        Persistent prevPersistent = null;
        Slice s = this.cache.getSilce(key);
        s.w.lock();
        try {
            Object old = s.storage.get(key);
            if (old instanceof RemovedValue) {
                prevPersistent = null;
            } else if (old instanceof Reference) {
                prevPersistent = (Persistent)((Reference)old).get();
            } else if (old instanceof Persistent) {
                prevPersistent = (Persistent)old;
            } else if (old != null) {
                System.err.println("unexpected value " + old + " for key " + key);
            }
            if (prevPersistent == null) {
                Reference value = WEAK_REF && key.getBehavior() != Key.Behavior.LargeAndMutable ? new WeakValue(obj, key, this.refQueue) : new SoftValue(obj, key, this.refQueue);
                s.storage.put(key, value);
            }
        }
        finally {
            s.w.unlock();
        }
        this.processQueue();
        return prevPersistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Persistent get(Key key) {
        Object value;
        Slice s = this.cache.getSilce(key);
        s.r.lock();
        try {
            value = s.storage.get(key);
        }
        finally {
            s.r.unlock();
        }
        if (value instanceof RemovedValue) {
            return ((RemovedValue)value).value;
        }
        if (value instanceof Persistent) {
            return (Persistent)value;
        }
        if (value instanceof Reference) {
            Persistent result = (Persistent)((Reference)value).get();
            if (result != null && value instanceof WeakReference) {
                s.w.lock();
                try {
                    Object freshValue = s.storage.get(key);
                    if (freshValue == value) {
                        value = new SoftValue(result, key, this.refQueue);
                        s.storage.put(key, value);
                    }
                }
                finally {
                    s.w.unlock();
                }
            }
            return result;
        }
        return null;
    }

    public void remove(Key key) {
        this.markRemoved(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePhysically(Key key) {
        Slice s = this.cache.getSilce(key);
        s.w.lock();
        try {
            Object prev = s.storage.get(key);
            if (prev instanceof RemovedValue) {
                s.storage.remove(key);
            }
        }
        finally {
            s.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markRemoved(Key key) {
        Slice s = this.cache.getSilce(key);
        s.w.lock();
        try {
            Persistent old = this.get(key);
            s.storage.put(key, new RemovedValue(old));
        }
        finally {
            s.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSoftRefs() {
        this.processQueue();
        for (int i = 0; i < SLICE_SIZE; ++i) {
            HashSet keys;
            Slice s = this.cache.getSilce(i);
            s.r.lock();
            try {
                keys = new HashSet(s.storage.keySet());
            }
            finally {
                s.r.unlock();
            }
            for (Key key : keys) {
                s.w.lock();
                try {
                    Object value = s.storage.get(key);
                    if (value == null || value instanceof Persistent) continue;
                    s.storage.remove(key);
                }
                finally {
                    s.w.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueue() {
        if (this.refQueueLock.tryLock()) {
            try {
                CacheValue sv;
                while ((sv = (CacheValue)((Object)this.refQueue.poll())) != null) {
                    Key key = sv.getKey();
                    if (key == null) continue;
                    Slice s = this.cache.getSilce(key);
                    s.w.lock();
                    try {
                        Object value = s.storage.get(key);
                        if (value == null || !(value instanceof Reference) || ((Reference)value).get() != null) continue;
                        Object removed = s.storage.remove(key);
                        assert (value == removed);
                    }
                    finally {
                        s.w.unlock();
                    }
                }
            }
            finally {
                this.refQueueLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Pair<Key, Persistent>> clearHungObjects() {
        this.processQueue();
        ArrayList<Pair<Key, Persistent>> result = new ArrayList<Pair<Key, Persistent>>();
        for (int i = 0; i < SLICE_SIZE; ++i) {
            HashSet keys;
            Slice s = this.cache.getSilce(i);
            s.r.lock();
            try {
                keys = new HashSet(s.storage.keySet());
            }
            finally {
                s.r.unlock();
            }
            for (Key key : keys) {
                Object value;
                s.r.lock();
                try {
                    value = s.storage.get(key);
                }
                finally {
                    s.r.unlock();
                }
                if (!(value instanceof Persistent)) continue;
                result.add(new Pair<Key, Persistent>(key, (Persistent)value));
                s.w.lock();
                try {
                    s.storage.remove(key);
                }
                finally {
                    s.w.unlock();
                }
            }
        }
        return result;
    }

    private void printStatistics(String name) {
        int hitPercentage = this.readCnt == 0 ? 0 : this.readHitCnt * 100 / this.readCnt;
        System.out.printf("\n\nMemory cache statistics %s: %d reads,  %d hits (%d%%)\n\n", name, this.readCnt, this.readHitCnt, hitPercentage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"UL"})
    public void debugPrintDistribution() {
        TreeMap<String, Integer> stat = new TreeMap<String, Integer>();
        TreeMap<String, Integer> statSoft = new TreeMap<String, Integer>();
        int fullSize = 0;
        int nullSize = 0;
        for (Slice s : this.cache.slices) {
            s.r.lock();
            try {
                fullSize += s.storage.size();
                for (Map.Entry entry : s.storage.entrySet()) {
                    Key key = (Key)entry.getKey();
                    Object value = entry.getValue();
                    boolean isSoft = false;
                    if (value != null && value instanceof Reference) {
                        isSoft = true;
                        value = ((Reference)value).get();
                    }
                    String res = key.getClass().getName();
                    if (value == null) {
                        res = isSoft ? res + "-soft null" : res + "-null";
                        ++nullSize;
                    } else {
                        res = isSoft ? res + "-soft " + value.getClass().getName() : res + "-" + value.getClass().getName();
                    }
                    Integer i = isSoft ? (Integer)statSoft.get(res) : (Integer)stat.get(res);
                    i = i == null ? Integer.valueOf(1) : Integer.valueOf(i + 1);
                    if (isSoft) {
                        statSoft.put(res, i);
                        continue;
                    }
                    stat.put(res, i);
                }
            }
            finally {
                s.r.unlock();
            }
        }
        System.err.println("\tMemCache of size " + fullSize + " with null " + nullSize + " objects");
        System.err.println("\tSoft memory cache");
        for (Map.Entry entry : statSoft.entrySet()) {
            System.err.println("\t" + (String)entry.getKey() + "=" + entry.getValue());
        }
        System.err.println("\tHard memory cache");
        for (Map.Entry entry : stat.entrySet()) {
            System.err.println("\t" + (String)entry.getKey() + "=" + entry.getValue());
        }
    }

    static /* synthetic */ int access$000() {
        return DEFAULT_SLICE_CAPACITY;
    }

    static {
        int nrProc = CndUtils.getConcurrencyLevel();
        if (nrProc <= 4) {
            SLICE_SIZE = 32;
            SLICE_MASK = SLICE_SIZE - 1;
            DEFAULT_SLICE_CAPACITY = 512;
        } else {
            SLICE_SIZE = 128;
            SLICE_MASK = SLICE_SIZE - 1;
            DEFAULT_SLICE_CAPACITY = 128;
        }
    }

    private static final class RemovedValue {
        private final Persistent value;

        public RemovedValue(Persistent value) {
            this.value = value == null ? RepositoryImpl.REMOVED_OBJECT : value;
        }

        public String toString() {
            return "RemovedValue{value=" + this.value + '}';
        }
    }

    private static final class SlicedMap {
        private final Slice[] slices = new Slice[RepositoryCache.access$100()];

        private SlicedMap() {
            for (int i = 0; i < SLICE_SIZE; ++i) {
                this.slices[i] = new Slice();
            }
        }

        private Slice getSilce(Key key) {
            int i = key.hashCode() & SLICE_MASK;
            return this.slices[i];
        }

        private Slice getSilce(int i) {
            return this.slices[i];
        }
    }

    private static final class Slice {
        private final Map<Key, Object> storage = new HashMap<Key, Object>(RepositoryCache.access$000());
        private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
        private final Lock w = this.cacheLock.writeLock();
        private final Lock r = this.cacheLock.readLock();

        private Slice() {
        }
    }

    private static class WeakValue<T>
    extends WeakReference<T>
    implements CacheValue {
        private final Key key;

        private WeakValue(T k, Key key, ReferenceQueue<T> q) {
            super(k, q);
            this.key = key;
        }

        @Override
        public Key getKey() {
            return this.key;
        }
    }

    public static class Pair<T1, T2> {
        public final T1 first;
        public final T2 second;

        public Pair(T1 first, T2 second) {
            this.first = first;
            this.second = second;
        }
    }

    private static class SoftValue<T>
    extends SoftReference<T>
    implements CacheValue {
        private final Key key;

        private SoftValue(T k, Key key, ReferenceQueue<T> q) {
            super(k, q);
            this.key = key;
        }

        @Override
        public Key getKey() {
            return this.key;
        }
    }

    private static interface CacheValue {
        public Key getKey();
    }
}

