/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Formatter;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.repository.disk.index.ChunkInfo;
import org.netbeans.modules.cnd.repository.disk.index.FileIndex;
import org.netbeans.modules.cnd.repository.impl.spi.LayerKey;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.repository.util.LongHashMap;
import org.netbeans.modules.cnd.repository.util.SlicedLongHashMap;

public class CompactFileIndex
implements FileIndex,
SelfPersistent {
    private static final int shift = 37;
    private static final long mask = 0x1FFFFFFFFFL;
    private static final int DEFAULT_SLICE_CAPACITY;
    private static final int DEFAULT_SLICE_COUNT;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final SlicedLongHashMap<LayerKey> map = new SlicedLongHashMap(DEFAULT_SLICE_COUNT, DEFAULT_SLICE_CAPACITY);

    public CompactFileIndex() {
    }

    public CompactFileIndex(RepositoryDataInput input) throws IOException {
        assert (input != null);
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            LayerKey layerKey = LayerKey.read((RepositoryDataInput)input);
            long longValue = input.readLong();
            this.map.put(layerKey, longValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        try {
            this.lock.readLock().lock();
            int n = this.map.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<LayerKey> keySet() {
        try {
            this.lock.readLock().lock();
            Collection<LayerKey> collection = this.map.keySet();
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Iterator<LayerKey> getKeySetIterator() {
        return this.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(LayerKey key) {
        long data = Long.MIN_VALUE;
        try {
            this.lock.writeLock().lock();
            data = this.map.remove(key);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return data == Long.MIN_VALUE ? 0 : CompactFileIndex.convertToSize(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int put(LayerKey key, long offset, int size) {
        long data = Long.MIN_VALUE;
        try {
            this.lock.writeLock().lock();
            data = this.map.put(key, CompactFileIndex.convertToLongData(offset, size));
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return data == Long.MIN_VALUE ? 0 : CompactFileIndex.convertToSize(data);
    }

    private static long convertToLongData(long offset, int size) {
        assert (offset <= 0x1FFFFFFFFFL) : "Offset " + offset + " is too large";
        assert (size < 0x8000000) : "Size " + size + " is too large";
        long data = size;
        data <<= 37;
        return data |= offset & 0x1FFFFFFFFFL;
    }

    private static int convertToSize(long data) {
        int size = (int)(data >>> 37);
        return size;
    }

    private static long convertToOffset(long data) {
        long offset = data & 0x1FFFFFFFFFL;
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChunkInfo get(LayerKey key) {
        try {
            this.lock.readLock().lock();
            long entry = this.map.get(key);
            LongChunkInfo longChunkInfo = entry == Long.MIN_VALUE ? null : new LongChunkInfo(entry);
            return longChunkInfo;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void write(RepositoryDataOutput output) throws IOException {
        Collection<LongHashMap.Entry<LayerKey>> collection = this.map.entrySet();
        output.writeInt(collection.size());
        for (LongHashMap.Entry<LayerKey> entry : collection) {
            LayerKey.write((LayerKey)entry.getKey(), (RepositoryDataOutput)output);
            output.writeLong(entry.getValue());
        }
    }

    static {
        int nrProc = Runtime.getRuntime().availableProcessors();
        if (nrProc <= 4) {
            DEFAULT_SLICE_COUNT = 32;
            DEFAULT_SLICE_CAPACITY = 512;
        } else {
            DEFAULT_SLICE_COUNT = 128;
            DEFAULT_SLICE_CAPACITY = 128;
        }
    }

    private static class LongChunkInfo
    implements ChunkInfo,
    Comparable<ChunkInfo>,
    SelfPersistent {
        long entry;

        public LongChunkInfo(long entry) {
            this.entry = entry;
        }

        @Override
        public int getSize() {
            return CompactFileIndex.convertToSize(this.entry);
        }

        @Override
        public long getOffset() {
            return CompactFileIndex.convertToOffset(this.entry);
        }

        @Override
        public int compareTo(ChunkInfo o) {
            return this.getOffset() < o.getOffset() ? -1 : 1;
        }

        @Override
        public void setOffset(long offset) {
            this.entry = CompactFileIndex.convertToLongData(offset, this.getSize());
        }

        public String toString() {
            Formatter f = new Formatter();
            long offset = this.getOffset();
            f.format("ChunkInfo [offset=%d (%H) size=%d long=%d]", offset, offset, this.getSize(), this.entry);
            return f.toString();
        }

        public void write(RepositoryDataOutput output) throws IOException {
            output.writeLong(this.entry);
        }
    }
}

