/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathProviderImpl;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public final class ProjectHooks {
    private static final Logger LOG = Logger.getLogger(ProjectHooks.class.getName());

    private ProjectHooks() {
        throw new IllegalStateException("No instance allowed");
    }

    @NonNull
    public static ProjectOpenedHookBuilder createProjectOpenedHookBuilder(@NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull UpdateHelper updateHelper, @NonNull GeneratedFilesHelper genFilesHelper, @NonNull ClassPathProviderImpl cpProviderImpl) {
        return new ProjectOpenedHookBuilder(project, eval, updateHelper, genFilesHelper, cpProviderImpl);
    }

    @NonNull
    public static ProjectXmlSavedHookBuilder createProjectXmlSavedHookBuilder(@NonNull PropertyEvaluator eval, @NonNull UpdateHelper updateHelper, @NonNull GeneratedFilesHelper genFilesHelper) {
        return new ProjectXmlSavedHookBuilder(eval, updateHelper, genFilesHelper);
    }

    private static void runSafe(@NonNull Runnable r) {
        try {
            r.run();
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            LOG.log(Level.INFO, "Action exception", t);
        }
    }

    private static final class ProjectXmlSavedHookImpl
    extends ProjectXmlSavedHook {
        private final PropertyEvaluator eval;
        private final UpdateHelper updateHelper;
        private final GeneratedFilesHelper genFilesHelper;
        private final List<? extends Runnable> preActions;
        private final List<? extends Runnable> postActions;
        private final URL buildImplTemplate;
        private final URL buildTemplate;
        private final String buildScriptProperty;
        private final Callable<Boolean> overridePredicate;

        ProjectXmlSavedHookImpl(@NonNull PropertyEvaluator eval, @NonNull UpdateHelper updateHelper, @NonNull GeneratedFilesHelper genFilesHelper, @NonNull List<? extends Runnable> preActions, @NonNull List<? extends Runnable> postActions, @NullAllowed URL buildImplTemplate, @NullAllowed URL buildTemplate, @NonNull String buildScriptProperty, @NullAllowed Callable<Boolean> overridePredicate) {
            Parameters.notNull((CharSequence)"eval", (Object)eval);
            Parameters.notNull((CharSequence)"updateHelper", (Object)updateHelper);
            Parameters.notNull((CharSequence)"genFilesHelper", (Object)genFilesHelper);
            Parameters.notNull((CharSequence)"preActions", preActions);
            Parameters.notNull((CharSequence)"postActions", postActions);
            Parameters.notNull((CharSequence)"buildScriptProperty", (Object)buildScriptProperty);
            this.eval = eval;
            this.updateHelper = updateHelper;
            this.genFilesHelper = genFilesHelper;
            this.preActions = preActions;
            this.postActions = postActions;
            this.buildImplTemplate = buildImplTemplate;
            this.buildTemplate = buildTemplate;
            this.buildScriptProperty = buildScriptProperty;
            this.overridePredicate = overridePredicate;
        }

        protected void projectXmlSaved() throws IOException {
            try {
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws Exception {
                        for (Runnable r : ProjectXmlSavedHookImpl.this.preActions) {
                            ProjectHooks.runSafe(r);
                        }
                        if (ProjectXmlSavedHookImpl.this.updateHelper.isCurrent()) {
                            if (ProjectXmlSavedHookImpl.this.buildImplTemplate != null) {
                                FileObject projectDir;
                                FileObject buildImpl;
                                int state = ProjectXmlSavedHookImpl.this.genFilesHelper.getBuildScriptState("nbproject/build-impl.xml", ProjectXmlSavedHookImpl.this.buildImplTemplate);
                                boolean forceRewriteBuildImpl = false;
                                if ((ProjectXmlSavedHookImpl.this.shoulOverrideModifiedBuildImpl() && (state & 4) == 4 || state == 60) && (buildImpl = (projectDir = ProjectXmlSavedHookImpl.this.updateHelper.getAntProjectHelper().getProjectDirectory()).getFileObject("nbproject/build-impl.xml")) != null) {
                                    String name = buildImpl.getName();
                                    String backupext = String.format("%s~", buildImpl.getExt());
                                    FileObject oldBackup = buildImpl.getParent().getFileObject(name, backupext);
                                    if (oldBackup != null) {
                                        oldBackup.delete();
                                    }
                                    FileUtil.copyFile((FileObject)buildImpl, (FileObject)buildImpl.getParent(), (String)name, (String)backupext);
                                    forceRewriteBuildImpl = true;
                                }
                                if (forceRewriteBuildImpl) {
                                    ProjectXmlSavedHookImpl.this.genFilesHelper.generateBuildScriptFromStylesheet("nbproject/build-impl.xml", ProjectXmlSavedHookImpl.this.buildImplTemplate);
                                } else {
                                    ProjectXmlSavedHookImpl.this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", ProjectXmlSavedHookImpl.this.buildImplTemplate, false);
                                }
                            }
                            if (ProjectXmlSavedHookImpl.this.buildTemplate != null) {
                                ProjectXmlSavedHookImpl.this.genFilesHelper.refreshBuildScript(CommonProjectUtils.getBuildXmlName(ProjectXmlSavedHookImpl.this.eval, ProjectXmlSavedHookImpl.this.buildScriptProperty), ProjectXmlSavedHookImpl.this.buildTemplate, false);
                            }
                        }
                        for (Runnable r : ProjectXmlSavedHookImpl.this.postActions) {
                            ProjectHooks.runSafe(r);
                        }
                        return null;
                    }
                });
            }
            catch (MutexException e) {
                Exception inner = e.getException();
                throw inner instanceof IOException ? (IOException)inner : new IOException(inner);
            }
        }

        private boolean shoulOverrideModifiedBuildImpl() {
            try {
                return this.overridePredicate != null && this.overridePredicate.call() == Boolean.TRUE;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return false;
            }
        }
    }

    private static final class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        private static final RequestProcessor PROJECT_OPENED_RP = new RequestProcessor(ProjectOpenedHookImpl.class);
        private final Project project;
        private final PropertyEvaluator eval;
        private final UpdateHelper updateHelper;
        private final GeneratedFilesHelper genFilesHelper;
        private final ClassPathProviderImpl cpProviderImpl;
        private final Set<String> classPathTypes;
        private final List<? extends Runnable> preClose;
        private final List<? extends Runnable> postClose;
        private final List<? extends Runnable> preOpen;
        private final List<? extends Runnable> postOpen;
        private final URL buildTemplate;
        private final URL buildImplTemplate;
        private final String buildScriptProperty;

        ProjectOpenedHookImpl(@NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull UpdateHelper updateHelper, @NonNull GeneratedFilesHelper genFilesHelper, @NonNull ClassPathProviderImpl cpProviderImpl, @NonNull Set<String> classPathTypes, @NonNull List<? extends Runnable> preOpen, @NonNull List<? extends Runnable> postOpen, @NonNull List<? extends Runnable> preClose, @NonNull List<? extends Runnable> postClose, @NullAllowed URL buildImplTemplate, @NullAllowed URL buildTemplate, @NonNull String buildScriptProperty) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"eval", (Object)eval);
            Parameters.notNull((CharSequence)"updateHelper", (Object)updateHelper);
            Parameters.notNull((CharSequence)"genFilesHelper", (Object)genFilesHelper);
            Parameters.notNull((CharSequence)"cpProviderImpl", (Object)cpProviderImpl);
            Parameters.notNull((CharSequence)"classPathTypes", classPathTypes);
            Parameters.notNull((CharSequence)"preOpen", preOpen);
            Parameters.notNull((CharSequence)"postOpen", postOpen);
            Parameters.notNull((CharSequence)"preClose", preClose);
            Parameters.notNull((CharSequence)"postClose", postClose);
            Parameters.notNull((CharSequence)"buildScriptProperty", (Object)buildScriptProperty);
            this.project = project;
            this.eval = eval;
            this.updateHelper = updateHelper;
            this.genFilesHelper = genFilesHelper;
            this.cpProviderImpl = cpProviderImpl;
            this.classPathTypes = classPathTypes;
            this.preOpen = preOpen;
            this.postOpen = postOpen;
            this.preClose = preClose;
            this.postClose = postClose;
            this.buildImplTemplate = buildImplTemplate;
            this.buildTemplate = buildTemplate;
            this.buildScriptProperty = buildScriptProperty;
        }

        protected void projectOpened() {
            this.runAtomic(new Runnable(){

                @Override
                public void run() {
                    for (Runnable r : ProjectOpenedHookImpl.this.preOpen) {
                        ProjectHooks.runSafe(r);
                    }
                    try {
                        if (ProjectOpenedHookImpl.this.updateHelper.isCurrent()) {
                            if (ProjectOpenedHookImpl.this.buildImplTemplate != null) {
                                ProjectOpenedHookImpl.this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", ProjectOpenedHookImpl.this.buildImplTemplate, true);
                            }
                            if (ProjectOpenedHookImpl.this.buildTemplate != null) {
                                ProjectOpenedHookImpl.this.genFilesHelper.refreshBuildScript(CommonProjectUtils.getBuildXmlName(ProjectOpenedHookImpl.this.eval, ProjectOpenedHookImpl.this.buildScriptProperty), ProjectOpenedHookImpl.this.buildTemplate, true);
                            }
                        }
                    }
                    catch (IOException e) {
                        LOG.log(Level.INFO, NbBundle.getMessage(ProjectHooks.class, (String)"ERR_RegenerateProjectFiles"), e);
                    }
                }
            });
            GlobalPathRegistry gpr = GlobalPathRegistry.getDefault();
            for (String classPathType : this.classPathTypes) {
                gpr.register(classPathType, this.cpProviderImpl.getProjectClassPaths(classPathType));
            }
            this.runAtomic(new Runnable(){

                @Override
                public void run() {
                    ProjectOpenedHookImpl.this.updateUserBuildPropertiesRef();
                    for (Runnable r : ProjectOpenedHookImpl.this.postOpen) {
                        ProjectHooks.runSafe(r);
                    }
                    ProjectOpenedHookImpl.this.saveProject();
                }
            });
            this.verifyEncoding();
        }

        protected void projectClosed() {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    block6: {
                        for (Runnable r : ProjectOpenedHookImpl.this.preClose) {
                            ProjectHooks.runSafe(r);
                        }
                        if (ProjectOpenedHookImpl.this.project.getProjectDirectory().isValid()) {
                            try {
                                ProjectManager.getDefault().saveProject(ProjectOpenedHookImpl.this.project);
                            }
                            catch (IOException e) {
                                if (!ProjectOpenedHookImpl.this.project.getProjectDirectory().canWrite()) break block6;
                                Exceptions.printStackTrace((Throwable)e);
                            }
                        }
                    }
                    GlobalPathRegistry gpr = GlobalPathRegistry.getDefault();
                    for (String classPathType : ProjectOpenedHookImpl.this.classPathTypes) {
                        gpr.unregister(classPathType, ProjectOpenedHookImpl.this.cpProviderImpl.getProjectClassPaths(classPathType));
                    }
                    for (Runnable r : ProjectOpenedHookImpl.this.postClose) {
                        ProjectHooks.runSafe(r);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                PROJECT_OPENED_RP.execute(r);
            } else {
                r.run();
            }
        }

        private void updateUserBuildPropertiesRef() {
            EditableProperties ep = this.updateHelper.getProperties("nbproject/private/private.properties");
            File buildProperties = new File(System.getProperty("netbeans.user"), "build.properties");
            ep.setProperty("user.properties.file", buildProperties.getAbsolutePath());
            this.updateHelper.putProperties("nbproject/private/private.properties", ep);
        }

        private void verifyEncoding() {
            String prop = this.eval.getProperty("source.encoding");
            if (prop != null) {
                try {
                    Charset.forName(prop);
                }
                catch (IllegalCharsetNameException e) {
                    LOG.log(Level.WARNING, "Illegal charset: {0} in project: {1}", new Object[]{prop, FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory())});
                }
                catch (UnsupportedCharsetException e) {
                    LOG.log(Level.WARNING, "Unsupported charset: {0} in project: {1}", new Object[]{prop, FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory())});
                }
            }
        }

        private void runAtomic(final @NonNull Runnable r) {
            FileUtil.runAtomicAction((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProjectManager.mutex().writeAccess(new Runnable(){

                        @Override
                        public void run() {
                            r.run();
                        }
                    });
                }
            });
        }

        private void saveProject() {
            try {
                ProjectManager.getDefault().saveProject(this.project);
            }
            catch (IOException e) {
                if (!this.project.getProjectDirectory().canWrite()) {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ProjectHooks.class, (String)"ERR_ProjectReadOnly", (Object)this.project.getProjectDirectory().getName()));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    public static final class ProjectXmlSavedHookBuilder {
        private final PropertyEvaluator eval;
        private final UpdateHelper updateHelper;
        private final GeneratedFilesHelper genFilesHelper;
        private final List<Runnable> preActions = new LinkedList<Runnable>();
        private final List<Runnable> postActions = new LinkedList<Runnable>();
        private String buildScriptProperty = "buildfile";
        private URL buildImplTemplate;
        private URL buildTemplate;
        private Callable<Boolean> overridePredicate;

        private ProjectXmlSavedHookBuilder(@NonNull PropertyEvaluator eval, @NonNull UpdateHelper updateHelper, @NonNull GeneratedFilesHelper genFilesHelper) {
            Parameters.notNull((CharSequence)"eval", (Object)eval);
            Parameters.notNull((CharSequence)"updateHelper", (Object)updateHelper);
            Parameters.notNull((CharSequence)"genFilesHelper", (Object)genFilesHelper);
            this.eval = eval;
            this.updateHelper = updateHelper;
            this.genFilesHelper = genFilesHelper;
        }

        @NonNull
        public ProjectXmlSavedHookBuilder addPreAction(@NonNull Runnable action) {
            Parameters.notNull((CharSequence)"action", (Object)action);
            this.preActions.add(action);
            return this;
        }

        @NonNull
        public ProjectXmlSavedHookBuilder addPostAction(@NonNull Runnable action) {
            Parameters.notNull((CharSequence)"action", (Object)action);
            this.postActions.add(action);
            return this;
        }

        @NonNull
        public ProjectXmlSavedHookBuilder setBuildTemplate(@NonNull URL template) {
            Parameters.notNull((CharSequence)"template", (Object)template);
            this.buildTemplate = template;
            return this;
        }

        @NonNull
        public ProjectXmlSavedHookBuilder setBuildImplTemplate(@NonNull URL template) {
            Parameters.notNull((CharSequence)"template", (Object)template);
            this.buildImplTemplate = template;
            return this;
        }

        @NonNull
        public ProjectXmlSavedHookBuilder setBuildScriptProperty(@NonNull String propertyName) {
            Parameters.notNull((CharSequence)"propertyName", (Object)propertyName);
            this.buildScriptProperty = propertyName;
            return this;
        }

        @NonNull
        public ProjectXmlSavedHookBuilder setOverrideModifiedBuildImplPredicate(@NonNull Callable<Boolean> predicate) {
            Parameters.notNull((CharSequence)"predicate", predicate);
            this.overridePredicate = predicate;
            return this;
        }

        @NonNull
        public ProjectXmlSavedHook build() {
            return new ProjectXmlSavedHookImpl(this.eval, this.updateHelper, this.genFilesHelper, this.preActions, this.postActions, this.buildImplTemplate, this.buildTemplate, this.buildScriptProperty, this.overridePredicate);
        }
    }

    public static final class ProjectOpenedHookBuilder {
        private final Project project;
        private final PropertyEvaluator eval;
        private final UpdateHelper updateHelper;
        private final GeneratedFilesHelper genFilesHelper;
        private final ClassPathProviderImpl cpProviderImpl;
        private final Set<String> classPathTypes = new HashSet<String>();
        private final List<Runnable> preOpen = new LinkedList<Runnable>();
        private final List<Runnable> postOpen = new LinkedList<Runnable>();
        private final List<Runnable> preClose = new LinkedList<Runnable>();
        private final List<Runnable> postClose = new LinkedList<Runnable>();
        private String buildScriptProperty = "buildfile";
        private URL buildTemplate;
        private URL buildImplTemplate;

        private ProjectOpenedHookBuilder(@NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull UpdateHelper updateHelper, @NonNull GeneratedFilesHelper genFilesHelper, @NonNull ClassPathProviderImpl cpProviderImpl) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"eval", (Object)eval);
            Parameters.notNull((CharSequence)"updateHelper", (Object)updateHelper);
            Parameters.notNull((CharSequence)"genFilesHelper", (Object)genFilesHelper);
            Parameters.notNull((CharSequence)"cpProviderImpl", (Object)cpProviderImpl);
            this.project = project;
            this.eval = eval;
            this.updateHelper = updateHelper;
            this.genFilesHelper = genFilesHelper;
            this.cpProviderImpl = cpProviderImpl;
        }

        @NonNull
        public ProjectOpenedHookBuilder addClassPathType(@NonNull String classPathType) {
            Parameters.notNull((CharSequence)"classPathType", (Object)classPathType);
            this.classPathTypes.add(classPathType);
            return this;
        }

        @NonNull
        public ProjectOpenedHookBuilder addOpenPreAction(@NonNull Runnable action) {
            Parameters.notNull((CharSequence)"action", (Object)action);
            this.preOpen.add(action);
            return this;
        }

        @NonNull
        public ProjectOpenedHookBuilder addOpenPostAction(@NonNull Runnable action) {
            Parameters.notNull((CharSequence)"action", (Object)action);
            this.postOpen.add(action);
            return this;
        }

        @NonNull
        public ProjectOpenedHookBuilder addClosePreAction(@NonNull Runnable action) {
            Parameters.notNull((CharSequence)"action", (Object)action);
            this.preClose.add(action);
            return this;
        }

        @NonNull
        public ProjectOpenedHookBuilder addClosePostAction(@NonNull Runnable action) {
            Parameters.notNull((CharSequence)"action", (Object)action);
            this.postClose.add(action);
            return this;
        }

        @NonNull
        public ProjectOpenedHookBuilder setBuildTemplate(@NonNull URL template) {
            Parameters.notNull((CharSequence)"template", (Object)template);
            this.buildTemplate = template;
            return this;
        }

        @NonNull
        public ProjectOpenedHookBuilder setBuildImplTemplate(@NonNull URL template) {
            Parameters.notNull((CharSequence)"template", (Object)template);
            this.buildImplTemplate = template;
            return this;
        }

        @NonNull
        public ProjectOpenedHookBuilder setBuildScriptProperty(@NonNull String propertyName) {
            Parameters.notNull((CharSequence)"propertyName", (Object)propertyName);
            this.buildScriptProperty = propertyName;
            return this;
        }

        @NonNull
        public ProjectOpenedHook build() {
            return new ProjectOpenedHookImpl(this.project, this.eval, this.updateHelper, this.genFilesHelper, this.cpProviderImpl, this.classPathTypes, this.preOpen, this.postOpen, this.preClose, this.postClose, this.buildImplTemplate, this.buildTemplate, this.buildScriptProperty);
        }
    }
}

