/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.util;

public final class StringUtil {
    private static final String NAME_SEPARATOR = ".";
    private static final String PROPERTY_PREFIX_GET = "get";
    private static final String PROPERTY_PREFIX_IS = "is";
    private static final String PROPERTY_PREFIX_HAS = "has";

    private StringUtil() {
    }

    public static String determineFullyQualifiedClassName(String defaultPackage, String name) {
        if (StringUtil.isFullyQualified(name)) {
            return name;
        }
        return defaultPackage + NAME_SEPARATOR + name;
    }

    public static boolean isFullyQualified(String name) {
        return name.contains(NAME_SEPARATOR);
    }

    public static String packageNameFromFqcn(String fqcn) {
        return fqcn.substring(0, fqcn.lastIndexOf(NAME_SEPARATOR));
    }

    public static String classNameFromFqcn(String fqcn) {
        return fqcn.substring(fqcn.lastIndexOf(NAME_SEPARATOR) + 1);
    }

    public static boolean isProperty(String methodName, String returnTypeAsString) {
        if (methodName == null || "void".equals(returnTypeAsString)) {
            return false;
        }
        if (StringUtil.isValidPropertyName(methodName, PROPERTY_PREFIX_GET)) {
            return true;
        }
        if (StringUtil.isValidPropertyName(methodName, PROPERTY_PREFIX_IS) || StringUtil.isValidPropertyName(methodName, PROPERTY_PREFIX_HAS)) {
            return StringUtil.isBooleanGetter(returnTypeAsString);
        }
        return false;
    }

    private static boolean isBooleanGetter(String type) {
        return "Boolean".equals(type) || "java.lang.Boolean".equals(type);
    }

    private static boolean isValidPropertyName(String name, String prefix) {
        if (!name.startsWith(prefix)) {
            return false;
        }
        return name.length() >= prefix.length() + 1;
    }

    public static String getPropertyName(String name) {
        String tmp = name;
        if (name.startsWith(PROPERTY_PREFIX_GET)) {
            tmp = name.replaceFirst(PROPERTY_PREFIX_GET, "");
        } else if (name.startsWith(PROPERTY_PREFIX_IS)) {
            tmp = name.replaceFirst(PROPERTY_PREFIX_IS, "");
        } else if (name.startsWith(PROPERTY_PREFIX_HAS)) {
            tmp = name.replaceFirst(PROPERTY_PREFIX_HAS, "");
        }
        return StringUtil.decapitalize(tmp);
    }

    public static String decapitalize(String string) {
        if (string == null || string.isEmpty() || StringUtil.startsWithSeveralUpperCaseLetters(string)) {
            return string;
        }
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    private static boolean startsWithSeveralUpperCaseLetters(String string) {
        return string.length() > 1 && Character.isUpperCase(string.charAt(0)) && Character.isUpperCase(string.charAt(1));
    }
}

