/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.xml;

import org.hibernate.jpamodelgen.model.MetaAttribute;
import org.hibernate.jpamodelgen.model.MetaEntity;
import org.hibernate.jpamodelgen.xml.XmlMetaEntity;

public abstract class XmlMetaAttribute
implements MetaAttribute {
    private final XmlMetaEntity hostingEntity;
    private final String propertyName;
    private final String type;

    XmlMetaAttribute(XmlMetaEntity parent, String propertyName, String type) {
        this.hostingEntity = parent;
        this.propertyName = propertyName;
        this.type = type;
    }

    @Override
    public String getDeclarationString() {
        return "public static volatile " + this.hostingEntity.importType(this.getMetaType()) + "<" + this.hostingEntity.importType(this.hostingEntity.getQualifiedName()) + ", " + this.hostingEntity.importType(this.getTypeDeclaration()) + "> " + this.getPropertyName() + ";";
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getTypeDeclaration() {
        return this.type;
    }

    @Override
    public MetaEntity getHostingEntity() {
        return this.hostingEntity;
    }

    @Override
    public abstract String getMetaType();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XmlMetaAttribute");
        sb.append("{propertyName='").append(this.propertyName).append('\'');
        sb.append(", type='").append(this.type).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

