/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.search.completion;

import java.util.HashSet;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.search.EditorFindSupport;
import org.netbeans.modules.editor.search.SearchBar;
import org.netbeans.modules.editor.search.completion.SearchCompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.util.Exceptions;

public class SearchCompletion
implements CompletionProvider {
    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType == 1) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new Query(), component);
        }
        return null;
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    static class Query
    extends AsyncCompletionQuery {
        private Set<SearchCompletionItem> results;

        Query() {
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            SearchBar searchBar = SearchBar.getInstance();
            searchBar.setPopupMenuWasCanceled(true);
            String queryText = "";
            this.results = new HashSet<SearchCompletionItem>();
            try {
                queryText = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (!queryText.trim().isEmpty()) {
                SearchCompletionItem searchCompletionItem;
                String[] split;
                queryText = queryText.toLowerCase();
                String text = searchBar.getActualTextComponent().getText();
                for (String s : split = text.split("[\\p{Punct}\\s]")) {
                    if (!s.toLowerCase().startsWith(queryText) || s.length() == queryText.length()) continue;
                    SearchCompletionItem searchCompletionItem2 = new SearchCompletionItem(s);
                    this.results.add(searchCompletionItem2);
                }
                for (EditorFindSupport.SPW spw : EditorFindSupport.getInstance().getHistory()) {
                    String s = spw.getSearchExpression().trim();
                    if (!s.toLowerCase().startsWith(queryText) || s.length() == queryText.length()) continue;
                    searchCompletionItem = new SearchCompletionItem(s);
                    this.results.add(searchCompletionItem);
                }
                for (EditorFindSupport.RP rp : EditorFindSupport.getInstance().getReplaceHistory()) {
                    String s = rp.getReplaceExpression().trim();
                    if (!s.toLowerCase().startsWith(queryText) || s.length() == queryText.length()) continue;
                    searchCompletionItem = new SearchCompletionItem(s);
                    this.results.add(searchCompletionItem);
                }
            }
            if (resultSet != null) {
                resultSet.addAllItems(this.results);
                resultSet.finish();
            }
        }
    }
}

