/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.actions.GrailsCommandAction;
import org.netbeans.modules.groovy.grailsproject.actions.ManagePluginsAction;
import org.netbeans.modules.groovy.grailsproject.actions.ResolvePluginsAction;
import org.netbeans.modules.groovy.grailsproject.ui.TreeRootNode;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class GrailsLogicalViewProvider
implements LogicalViewProvider {
    private final GrailsProject project;
    private GrailsLogicalViewRootNode rootNode;

    public GrailsLogicalViewProvider(GrailsProject project) {
        this.project = project;
    }

    public Node createLogicalView() {
        if (this.rootNode == null) {
            this.rootNode = new GrailsLogicalViewRootNode();
        }
        return this.rootNode;
    }

    public Node findPath(Node root, Object target) {
        Project project = (Project)root.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (target instanceof FileObject) {
            FileObject fo = (FileObject)target;
            Project owner = FileOwnerQuery.getOwner((FileObject)fo);
            if (!project.equals(owner)) {
                return null;
            }
            for (Node n : root.getChildren().getNodes(true)) {
                Node treeNode = TreeRootNode.findPath(n, target);
                if (treeNode != null) {
                    return treeNode;
                }
                Node packageNode = PackageView.findPath((Node)n, (Object)target);
                if (packageNode == null) continue;
                return packageNode;
            }
        }
        return null;
    }

    private final class GrailsLogicalViewRootNode
    extends AbstractNode {
        public GrailsLogicalViewRootNode() {
            super(NodeFactorySupport.createCompositeChildren((Project)GrailsLogicalViewProvider.this.project, (String)"Projects/org-netbeans-modules-groovy-grailsproject/Nodes"), Lookups.singleton((Object)GrailsLogicalViewProvider.this.project));
            String prefix = "";
            if (!Utilities.isWindows()) {
                prefix = File.separator;
            }
            this.setShortDescription("Grails Project in " + prefix + GrailsLogicalViewProvider.this.project.getProjectDirectory().getPath());
        }

        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/groovy/grails/resources/GrailsIcon16x16.png");
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getDisplayName() {
            return GrailsLogicalViewProvider.this.project.getProjectDirectory().getName();
        }

        public Action[] getActions(boolean context) {
            return this.getAdditionalActions();
        }

        private Action[] getAdditionalActions() {
            ArrayList<Action> actions = new ArrayList<Action>();
            actions.add(CommonProjectActions.newFileAction());
            actions.add(null);
            actions.add(this.getCommandAction("build", "LBL_BuildAction_Name"));
            actions.add(this.getCommandAction("compile", "LBL_Compile_Name"));
            actions.add(this.getCommandAction("clean", "LBL_CleanAction_Name"));
            actions.add(this.getCommandAction("upgrade", "LBL_Upgrade_Name"));
            actions.add(null);
            actions.add((Action)SystemAction.get(GrailsCommandAction.class));
            actions.add(this.getCommandAction("grails-shell", "LBL_ShellAction_Name"));
            actions.add(new ManagePluginsAction(GrailsLogicalViewProvider.this.project));
            actions.add(null);
            actions.add(new ResolvePluginsAction(GrailsLogicalViewProvider.this.project));
            actions.add(null);
            actions.add(this.getCommandAction("run", "LBL_RunAction_Name"));
            actions.add(this.getCommandAction("debug", "LBL_DebugAction_Name"));
            actions.add(this.getCommandAction("test", "LBL_TestAction_Name"));
            actions.add(null);
            actions.add(CommonProjectActions.setAsMainProjectAction());
            actions.add(CommonProjectActions.closeProjectAction());
            actions.add(null);
            actions.add((Action)SystemAction.get(FindAction.class));
            actions.add(null);
            actions.add(CommonProjectActions.deleteProjectAction());
            actions.add(null);
            actions.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
            actions.add(null);
            actions.add(CommonProjectActions.customizeProjectAction());
            return actions.toArray(new Action[actions.size()]);
        }

        private Action getCommandAction(String commandName, String localizationName) {
            return ProjectSensitiveActions.projectCommandAction((String)commandName, (String)NbBundle.getMessage(GrailsLogicalViewProvider.class, (String)localizationName), null);
        }
    }
}

