/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.codegen;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.codegen.AbstractGenerator;
import org.netbeans.modules.maven.codegen.Bundle;
import org.netbeans.modules.maven.codegen.NewPluginPanel;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.PluginContainer;
import org.netbeans.modules.maven.model.pom.PluginExecution;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.w3c.dom.Node;

public class PluginGenerator
extends AbstractGenerator<POMModel> {
    private PluginGenerator(POMModel model, JTextComponent component) {
        super(model, component);
    }

    public String getDisplayName() {
        return Bundle.NAME_Plugin();
    }

    @Override
    protected void doInvoke() {
        NBVersionInfo vi;
        FileObject fo = (FileObject)((POMModel)this.model).getModelSource().getLookup().lookup(FileObject.class);
        assert (fo != null);
        Project prj = FileOwnerQuery.getOwner((FileObject)fo);
        assert (prj != null);
        final NewPluginPanel pluginPanel = new NewPluginPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)pluginPanel, Bundle.TIT_Add_plugin());
        pluginPanel.setNotificationLineSupport(dd.createNotificationLineSupport());
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION && (vi = pluginPanel.getPlugin()) != null) {
            this.writeModel(new AbstractGenerator.ModelWriter(){

                @Override
                public int write() {
                    int pos = PluginGenerator.this.component.getCaretPosition();
                    PluginContainer container = PluginGenerator.this.findContainer(pos, (POMModel)PluginGenerator.this.model);
                    Plugin plug = ((POMModel)PluginGenerator.this.model).getFactory().createPlugin();
                    plug.setGroupId(vi.getGroupId());
                    plug.setArtifactId(vi.getArtifactId());
                    plug.setVersion(vi.getVersion());
                    if (pluginPanel.isConfiguration()) {
                        Configuration config = ((POMModel)PluginGenerator.this.model).getFactory().createConfiguration();
                        config.setSimpleParameter("foo", "bar");
                        plug.setConfiguration(config);
                    }
                    if (pluginPanel.getGoals() != null && pluginPanel.getGoals().size() > 0) {
                        PluginExecution ex = ((POMModel)PluginGenerator.this.model).getFactory().createExecution();
                        String id = null;
                        for (String goal : pluginPanel.getGoals()) {
                            ex.addGoal(goal);
                            if (id != null) continue;
                            id = goal;
                        }
                        if (id != null) {
                            ex.setId(id);
                        }
                        plug.addExecution(ex);
                    }
                    container.addPlugin(plug);
                    return ((POMModel)PluginGenerator.this.model).getAccess().findPosition((Node)plug.getPeer());
                }
            });
        }
    }

    private PluginContainer findContainer(int pos, POMModel model) {
        for (DocumentComponent dc = model.findComponent(pos); dc != null; dc = dc.getParent()) {
            if (!(dc instanceof PluginContainer)) continue;
            return (PluginContainer)dc;
        }
        Build bld = model.getProject().getBuild();
        if (bld == null) {
            bld = model.getFactory().createBuild();
            model.getProject().setBuild(bld);
        }
        return bld;
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<PluginGenerator> toRet = new ArrayList<PluginGenerator>();
            POMModel model = (POMModel)context.lookup(POMModel.class);
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            if (model != null) {
                toRet.add(new PluginGenerator(model, component));
            }
            return toRet;
        }
    }
}

