/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.navigator;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.navigator.POMModelPanel;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.openide.cookies.EditCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class POMInheritancePanel
extends JPanel
implements ExplorerManager.Provider,
Runnable {
    private final transient ExplorerManager explorerManager = new ExplorerManager();
    private final BeanTreeView treeView;
    private DataObject current;
    private final FileChangeAdapter adapter = new FileChangeAdapter(){

        public void fileChanged(FileEvent fe) {
            POMInheritancePanel.this.showWaitNode();
            RequestProcessor.getDefault().post((Runnable)POMInheritancePanel.this);
        }
    };
    private JScrollPane jScrollPane1;

    public POMInheritancePanel() {
        this.initComponents();
        this.treeView = (BeanTreeView)this.jScrollPane1;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    void navigate(DataObject d) {
        if (this.current != null) {
            this.current.getPrimaryFile().removeFileChangeListener((FileChangeListener)this.adapter);
        }
        this.current = d;
        this.current.getPrimaryFile().addFileChangeListener((FileChangeListener)this.adapter);
        this.showWaitNode();
        RequestProcessor.getDefault().post((Runnable)this);
    }

    @Override
    public void run() {
        if (this.current != null && "text/x-maven-pom+xml".equals(this.current.getPrimaryFile().getMIMEType())) {
            File file = FileUtil.toFile((FileObject)this.current.getPrimaryFile());
            if (file != null) {
                try {
                    List lin = EmbedderFactory.getProjectEmbedder().createModelLineage(file);
                    final Children ch = Children.create((ChildFactory)new PomChildren(lin), (boolean)false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            POMInheritancePanel.this.treeView.setRootVisible(false);
                            POMInheritancePanel.this.explorerManager.setRootContext((Node)new AbstractNode(ch));
                        }
                    });
                }
                catch (ModelBuildingException ex) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            POMInheritancePanel.this.treeView.setRootVisible(true);
                            POMInheritancePanel.this.explorerManager.setRootContext(POMModelPanel.createErrorNode(ex));
                        }
                    });
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        POMInheritancePanel.this.treeView.setRootVisible(false);
                        POMInheritancePanel.this.explorerManager.setRootContext(POMInheritancePanel.createEmptyNode());
                    }
                });
            }
        }
    }

    void release() {
        if (this.current != null) {
            this.current.getPrimaryFile().removeFileChangeListener((FileChangeListener)this.adapter);
        }
        this.current = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                POMInheritancePanel.this.treeView.setRootVisible(false);
                POMInheritancePanel.this.explorerManager.setRootContext(POMInheritancePanel.createEmptyNode());
            }
        });
    }

    public void showWaitNode() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                POMInheritancePanel.this.treeView.setRootVisible(true);
                POMInheritancePanel.this.explorerManager.setRootContext(POMInheritancePanel.createWaitNode());
            }
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new BeanTreeView();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 292, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 307, Short.MAX_VALUE));
    }

    private static Node createWaitNode() {
        AbstractNode an = new AbstractNode(Children.LEAF);
        an.setIconBaseWithExtension("org/netbeans/modules/maven/navigator/wait.gif");
        an.setDisplayName(NbBundle.getMessage(POMInheritancePanel.class, (String)"LBL_Wait"));
        return an;
    }

    private static Node createEmptyNode() {
        AbstractNode an = new AbstractNode(Children.LEAF);
        return an;
    }

    private static class POMNode
    extends AbstractNode {
        private Image icon = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/resources/Maven2Icon.gif");
        private boolean readonly = false;
        private final DataObject dobj;

        private POMNode(@NonNull File key, @NonNull Model mdl, @NonNull DataObject dobj, @NonNull String version) {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(POMInheritancePanel.class, (String)"TITLE_PomNode", (Object)mdl.getArtifactId(), (Object)version));
            if (!dobj.getPrimaryFile().canWrite()) {
                this.readonly = true;
            }
            this.setShortDescription(key.getAbsolutePath());
            this.dobj = dobj;
        }

        public Action[] getActions(boolean context) {
            return new Action[]{new MyEditAction()};
        }

        public Action getPreferredAction() {
            return new MyEditAction();
        }

        public String getHtmlDisplayName() {
            if (this.readonly) {
                return NbBundle.getMessage(POMInheritancePanel.class, (String)"HTML_TITLE_PomNode", (Object)this.getDisplayName());
            }
            return null;
        }

        public Image getIcon(int type) {
            return this.icon;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        private class MyEditAction
        extends AbstractAction {
            public MyEditAction() {
                this.putValue("Name", NbBundle.getMessage(POMInheritancePanel.class, (String)"ACTION_Edit"));
                this.setEnabled(POMNode.this.dobj != null);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                EditCookie ec;
                if (POMNode.this.dobj != null && (ec = (EditCookie)POMNode.this.dobj.getLookup().lookup(EditCookie.class)) != null) {
                    ec.edit();
                }
            }
        }
    }

    private static class PomChildren
    extends ChildFactory<Model> {
        private final List<Model> lineage;

        PomChildren(List<Model> lineage) {
            this.lineage = lineage;
        }

        protected boolean createKeys(List<Model> toPopulate) {
            toPopulate.addAll(this.lineage);
            return true;
        }

        protected Node createNodeForKey(Model mdl) {
            FileObject fo;
            File fl = mdl.getPomFile();
            String version = mdl.getVersion();
            if (version == null && mdl.getParent() != null) {
                version = mdl.getParent().getVersion();
            }
            if (version == null) {
                return null;
            }
            if (fl == null) {
                ArtifactRepository repo = EmbedderFactory.getProjectEmbedder().getLocalRepository();
                DefaultArtifactHandler handler = new DefaultArtifactHandler();
                handler.setExtension("pom");
                String groupId = mdl.getGroupId();
                if (groupId == null && mdl.getParent() != null) {
                    groupId = mdl.getParent().getGroupId();
                }
                assert (groupId != null);
                fl = new File(repo.getBasedir(), repo.pathOf((Artifact)new DefaultArtifact(groupId, mdl.getArtifactId(), version, null, "pom", null, (ArtifactHandler)handler)));
            }
            if ((fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)fl))) != null) {
                try {
                    return new POMNode(fl, mdl, DataObject.find((FileObject)NodeUtils.readOnlyLocalRepositoryFile((FileObject)fo)), version);
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return null;
        }
    }
}

