/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.jaxb.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.xml.jaxb.api.model.JAXBWizModel;
import org.netbeans.modules.xml.jaxb.api.model.events.JAXBWizEventListener;
import org.netbeans.modules.xml.jaxb.cfg.schema.Binding;
import org.netbeans.modules.xml.jaxb.cfg.schema.Bindings;
import org.netbeans.modules.xml.jaxb.cfg.schema.Catalog;
import org.netbeans.modules.xml.jaxb.cfg.schema.Schema;
import org.netbeans.modules.xml.jaxb.cfg.schema.SchemaSource;
import org.netbeans.modules.xml.jaxb.cfg.schema.SchemaSources;
import org.netbeans.modules.xml.jaxb.cfg.schema.Schemas;
import org.netbeans.modules.xml.jaxb.cfg.schema.XjcOption;
import org.netbeans.modules.xml.jaxb.cfg.schema.XjcOptions;
import org.netbeans.modules.xml.jaxb.model.JAXBWizModelImpl;
import org.netbeans.modules.xml.jaxb.spi.JAXBWizModuleConstants;
import org.netbeans.modules.xml.jaxb.util.FileSysUtil;
import org.netbeans.modules.xml.retriever.Retriever;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.TaskListener;
import org.openide.util.WeakListeners;

public class ProjectHelper {
    public static final int PROJECT_TYPE_J2SE = 0;
    public static final int PROJECT_TYPE_EJB = 1;
    public static final int PROJECT_TYPE_WEB = 2;
    private static final String JAXB_ANT_XTN_NAME = "jaxb";
    private static final String JAXB_LIB_NAME = "jaxb";
    private static final String PROP_BUILD_DIR = "build.dir";
    private static final String PROP_SRC_DIR = "src.dir";
    private static final String PROP_SRC_ROOT = "source.root";
    private static final String NBPROJECT_DIR = "nbproject";
    private static final String XML_BINDING_CONFIG_FILE_NAME = "xml_binding_cfg.xml";
    private static final String XML_BINDING_BUILD_FILE_NAME = "xml_binding_build.xml";
    private static final String FILE_OBJECT_SEPARATOR = "/";
    private static final String XSL_RESOURCE = "org/netbeans/modules/xml/jaxb/resources/JAXBBuild.xsl";
    private static final String EJB_XSL_RESOURCE = "org/netbeans/modules/xml/jaxb/resources/JAXBBuild_ejb.xsl";
    private static final String WEB_XSL_RESOURCE = "org/netbeans/modules/xml/jaxb/resources/JAXBBuild_web.xsl";
    private static final String BUILD_GEN_JAXB_DIR = "build/generated-sources/jaxb";
    private static final String NON_JAVA_SE_CONFIG_DIR = "conf/xml-resources/jaxb";
    private static final String JAVA_SE_CONFIG_DIR = "xml-resources/jaxb";
    private static final String PROP_XJC_DEF_CLASSPATH = "jaxbwiz.xjcdef.classpath";
    private static final String PROP_XJC_RUN_CLASSPATH = "jaxbwiz.xjcrun.classpath";
    private static final String PROP_JAXB_GEN_SRC_CLASSPATH = "jaxbwiz.gensrc.classpath";
    private static final String PROP_VAL_JAXB_LIB_CLASSPATH = "${libs.jaxb.classpath}";
    private static final String JAXB_CONTEXT_CLASS_RES_PATH = "javax/xml/bind/JAXBContext.class";
    private static final String CLASSPATH_ENDORSED = "classpath/endorsed";
    private static final String JAXB_ENDORSED = "JAXB-ENDORSED";
    public static final String IDE_MODULE_INSTALL_NAME = "modules/org-netbeans-modules-xml-wsdl-model.jar";
    public static final String IDE_MODULE_INSTALL_CBN = "org.netbeans.modules.xml.wsdl.model";
    public static final String JAXB_COMPILE_ON_SAVE = "compile.on.save.unsupported.jaxb";

    private ProjectHelper() {
    }

    public static void refreshBuildScript(Project prj) {
        try {
            StreamSource xmlSource = new StreamSource(ProjectHelper.getXMLBindingConfigFile(prj));
            StreamSource xslSource = null;
            int projType = ProjectHelper.getProjectType(prj);
            xslSource = projType == 1 ? new StreamSource(ProjectHelper.class.getClassLoader().getResourceAsStream(EJB_XSL_RESOURCE)) : (projType == 2 ? new StreamSource(ProjectHelper.class.getClassLoader().getResourceAsStream(WEB_XSL_RESOURCE)) : new StreamSource(ProjectHelper.class.getClassLoader().getResourceAsStream(XSL_RESOURCE)));
            StreamResult result = new StreamResult(ProjectHelper.getXMLBindingBuildFile(prj));
            TransformerFactory fact = TransformerFactory.newInstance();
            try {
                fact.setAttribute("indent-number", 4);
            }
            catch (Exception ex) {
                // empty catch block
            }
            Transformer xformer = fact.newTransformer(xslSource);
            xformer.setOutputProperty("indent", "yes");
            xformer.setOutputProperty("method", "xml");
            xformer.transform(xmlSource, result);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static String getProperty(Project prj, String filePath, String name) {
        AntProjectHelper aph = ProjectHelper.getAntProjectHelper(prj);
        EditableProperties ep = aph.getProperties(filePath);
        String str = null;
        String value = ep.getProperty(name);
        if (value != null) {
            PropertyEvaluator pe = aph.getStandardPropertyEvaluator();
            str = pe.evaluate(value);
        }
        return str;
    }

    private static void saveProperty(Project prj, String filePath, String name, String value) {
        AntProjectHelper aph = ProjectHelper.getAntProjectHelper(prj);
        EditableProperties ep = aph.getProperties(filePath);
        if (value != null) {
            ep.put(name, value);
            aph.putProperties(filePath, ep);
        }
    }

    private static String getProjectProperty(Project prj, String prop) {
        return ProjectHelper.getProperty(prj, "nbproject/project.properties", prop);
    }

    private static String getPrivateProperty(Project prj, String prop) {
        return ProjectHelper.getProperty(prj, "nbproject/project.properties", prop);
    }

    private static void savePrivateProperty(Project prj, String prop, String value) {
        ProjectHelper.saveProperty(prj, "nbproject/private/private.properties", prop, value);
    }

    private static void saveProjectProperty(Project prj, String prop, String value) {
        ProjectHelper.saveProperty(prj, "nbproject/project.properties", prop, value);
    }

    public static String getProjectSourceDir(Project prj) {
        return ProjectHelper.getProperty(prj, "nbproject/project.properties", PROP_SRC_DIR);
    }

    public static File getSourceDirectoryFile(Project prj) {
        return new File(ProjectHelper.getProjectSourceDir(prj));
    }

    public static String getProjectBuildDir(Project prj) {
        return ProjectHelper.getProperty(prj, "nbproject/project.properties", PROP_BUILD_DIR);
    }

    public static String getProjectSourceRoot(Project prj) {
        return ProjectHelper.getProperty(prj, "nbproject/project.properties", PROP_SRC_ROOT);
    }

    public static File getProjectDirectory(Project prj) {
        return FileUtil.toFile((FileObject)prj.getProjectDirectory());
    }

    public static String getProjectRelativePath(Project prj, String absPath) {
        String relPath = null;
        if (absPath != null) {
            String projectDirectory = ProjectHelper.getProjectDirectory(prj).getAbsolutePath();
            relPath = absPath.toLowerCase().indexOf(projectDirectory.toLowerCase()) != -1 ? absPath.substring(projectDirectory.length() + 1) : absPath;
        }
        return relPath;
    }

    public static void disableCoS(Project p, final boolean enable) {
        final AntProjectHelper helper = ProjectHelper.getAntProjectHelper(p);
        if (helper == null) {
            if (enable) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ProjectHelper.class, (String)"WARN_couldNotEnableCoS"), 700);
            }
            return;
        }
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    EditableProperties ep = helper.getProperties("nbproject/project.properties");
                    if (enable) {
                        ep.setProperty(ProjectHelper.JAXB_COMPILE_ON_SAVE, Boolean.TRUE.toString());
                    } else {
                        ep.remove((Object)ProjectHelper.JAXB_COMPILE_ON_SAVE);
                    }
                    helper.putProperties("nbproject/project.properties", ep);
                    return null;
                }
            });
        }
        catch (MutexException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    private static void addJAXBLibrary(Project prj) {
        ClassPath bootClassPath;
        SourceGroup[] sgs = ProjectUtils.getSources((Project)prj).getSourceGroups("java");
        ClassPath compileClassPath = ClassPath.getClassPath((FileObject)sgs[0].getRootFolder(), (String)"classpath/compile");
        ClassPath classPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{compileClassPath, bootClassPath = ClassPath.getClassPath((FileObject)sgs[0].getRootFolder(), (String)"classpath/boot")});
        FileObject jaxbClass = classPath.findResource(JAXB_CONTEXT_CLASS_RES_PATH);
        if (jaxbClass == null) {
            SourceGroup[] srg;
            Library jaxbLib = LibraryManager.getDefault().getLibrary("jaxb");
            Sources srcs = ProjectUtils.getSources((Project)prj);
            if (srcs != null && (srg = srcs.getSourceGroups("java")) != null && srg.length > 0) {
                try {
                    ProjectClassPathModifier.addLibraries((Library[])new Library[]{jaxbLib}, (FileObject)srg[0].getRootFolder(), (String)"classpath/compile");
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public static int getProjectType(Project prj) {
        String prjClzName = prj.getClass().getName();
        int prjType = 0;
        if (prjClzName.indexOf("EjbJarProject") != -1) {
            prjType = 1;
        } else if (prjClzName.indexOf("WebProject") != -1) {
            prjType = 2;
        }
        return prjType;
    }

    public static Schemas getXMLBindingSchemas(Project prj) {
        Schemas scs = null;
        if (prj != null) {
            FileObject fo = prj.getProjectDirectory();
            String projName = fo.getName();
            File projDir = FileUtil.toFile((FileObject)fo);
            File configFile = null;
            try {
                configFile = new File(projDir, NBPROJECT_DIR + File.separator + XML_BINDING_CONFIG_FILE_NAME);
                if (configFile.exists()) {
                    scs = Schemas.read(configFile);
                } else {
                    ProjectInformation pi;
                    scs = new Schemas();
                    Lookup lookup = prj.getLookup();
                    if (lookup != null && (pi = (ProjectInformation)lookup.lookup(ProjectInformation.class)) != null) {
                        projName = pi.getName();
                    }
                    scs.setProjectName(projName);
                    scs.setDestdir(BUILD_GEN_JAXB_DIR);
                    scs.setVersion(JAXBWizModuleConstants.LATEST_CFG_VERSION);
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return scs;
    }

    private static File getXMLBindingBuildFile(Project prj) {
        File buildFile = null;
        if (prj != null) {
            FileObject fo = prj.getProjectDirectory();
            File projDir = FileUtil.toFile((FileObject)fo);
            try {
                buildFile = new File(projDir, NBPROJECT_DIR + File.separator + XML_BINDING_BUILD_FILE_NAME);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return buildFile;
    }

    private static File getXMLBindingConfigFile(Project prj) {
        File configFile = null;
        if (prj != null) {
            FileObject fo = prj.getProjectDirectory();
            File projDir = FileUtil.toFile((FileObject)fo);
            try {
                configFile = new File(projDir, NBPROJECT_DIR + File.separator + XML_BINDING_CONFIG_FILE_NAME);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return configFile;
    }

    private static void saveXMLBindingSchemas(Project prj, Schemas scs) {
        try {
            File configFile = ProjectHelper.getXMLBindingConfigFile(prj);
            if (configFile != null) {
                scs.write(configFile);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static XjcOptions populateXjcOptions(WizardDescriptor wiz) {
        XjcOptions xjcOpts = new XjcOptions();
        Map options = (Map)wiz.getProperty("jaxb.xjc.options");
        if (options != null) {
            Set keys = options.keySet();
            Iterator itr = keys.iterator();
            String key = null;
            XjcOption xjcOption = null;
            while (itr.hasNext()) {
                key = (String)itr.next();
                Boolean value = (Boolean)options.get(key);
                xjcOption = new XjcOption();
                xjcOption.setName(key);
                xjcOption.setValue(value.toString());
                xjcOpts.addXjcOption(xjcOption);
            }
        }
        return xjcOpts;
    }

    public static FileObject retrieveResource(FileObject targetFolder, URI source) {
        Retriever retriever = Retriever.getDefault();
        FileObject result = null;
        try {
            result = retriever.retrieveResource(targetFolder, source);
        }
        catch (UnknownHostException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (URISyntaxException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (result == null) {
            // empty if block
        }
        return result;
    }

    private static String replace(String str, String replace, String replaceWith) {
        return str.replaceFirst(replace, replaceWith);
    }

    private static Map<String, String> getOrigNewLocationMap(Schema oSchema, String newName, String schemasRootFolder) {
        Catalog c;
        SchemaSource[] ssArray;
        HashMap<String, String> ret = new HashMap<String, String>();
        String replace = schemasRootFolder + FILE_OBJECT_SEPARATOR + oSchema.getName();
        String replaceWith = schemasRootFolder + FILE_OBJECT_SEPARATOR + newName;
        SchemaSources ss = oSchema.getSchemaSources();
        for (SchemaSource s : ssArray = ss.getSchemaSource()) {
            ret.put(s.getOrigLocation(), ProjectHelper.replace(s.getLocation(), replace, replaceWith));
        }
        Bindings bindings = oSchema.getBindings();
        if (bindings != null) {
            Binding[] bs;
            for (Binding b : bs = bindings.getBinding()) {
                ret.put(b.getOrigLocation(), ProjectHelper.replace(b.getLocation(), replace, replaceWith));
            }
        }
        if ((c = oSchema.getCatalog()) != null && c.getOrigLocation() != null) {
            ret.put(c.getOrigLocation(), ProjectHelper.replace(c.getLocation(), replace, replaceWith));
        }
        return ret;
    }

    private static void deleteStaleResources(FileObject projRootFo, Map<String, String> map, List<String> files2skip) {
        Set<String> keys = map.keySet();
        FileObject fo = null;
        String relPath = null;
        for (String key : keys) {
            relPath = map.get(key);
            if (files2skip.contains(relPath) || (fo = projRootFo.getFileObject(relPath)) == null) continue;
            try {
                fo.delete();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema importResources(Project project, WizardDescriptor wiz, Schema oSchema) throws IOException {
        int i;
        File schemaDir;
        Map<Object, Object> res2Skip = null;
        HashMap<String, String> tobeRemoved = null;
        ArrayList<String> newProjFiles = new ArrayList<String>();
        String oSchemaName = null;
        FileObject projFO = project.getProjectDirectory();
        FileObject projectSchemaDir = ProjectHelper.getFOProjectSchemaDir(project);
        File projSchemasDir = FileUtil.toFile((FileObject)projectSchemaDir);
        File projDir = FileUtil.toFile((FileObject)projFO);
        Schema schema = new Schema();
        SchemaSources sss = new SchemaSources();
        SchemaSource ss = null;
        Bindings bindings = new Bindings();
        Binding binding = null;
        Catalog catalog = new Catalog();
        schema.setName((String)wiz.getProperty("schema.name"));
        schema.setPackage((String)wiz.getProperty("xsd.package.name"));
        schema.setCatalog(catalog);
        schema.setBindings(bindings);
        schema.setSchemaSources(sss);
        schema.setType((String)wiz.getProperty("jaxb.schema.type"));
        schema.setXjcOptions(ProjectHelper.populateXjcOptions(wiz));
        if (oSchema != null) {
            res2Skip = ProjectHelper.getOrigNewLocationMap(oSchema, schema.getName(), FileUtil.getRelativePath((FileObject)projFO, (FileObject)projectSchemaDir));
            tobeRemoved = new HashMap();
            tobeRemoved.putAll(res2Skip);
            oSchemaName = oSchema.getName();
            if (!oSchemaName.equals(schema.getName())) {
                File oSchemaDir = new File(projSchemasDir, oSchemaName);
                if (!oSchemaDir.exists()) {
                    FileUtil.createFolder((File)oSchemaDir);
                }
                FileObject oSchemaDirFO = FileUtil.toFileObject((File)oSchemaDir);
                FileLock fl = null;
                try {
                    fl = oSchemaDirFO.lock();
                    oSchemaDirFO.rename(fl, schema.getName(), null);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    if (fl != null) {
                        fl.releaseLock();
                    }
                }
            }
        } else {
            res2Skip = new HashMap();
            tobeRemoved = new HashMap<String, String>();
        }
        if (!(schemaDir = new File(projSchemasDir, schema.getName())).exists()) {
            FileUtil.createFolder((File)schemaDir);
        }
        FileObject schemaDirFO = FileUtil.toFileObject((File)schemaDir);
        File srcFile = null;
        File targetFile = null;
        FileObject newFileFO = null;
        String url = null;
        URL remoteSchema = null;
        List xsdFileList = (List)wiz.getProperty("xsd.file.list");
        List bindingFileList = (List)wiz.getProperty("jaxb.binding.files");
        String catlogFile = (String)wiz.getProperty("jaxb.catalog.file");
        boolean srcLocTypeUrl = "url".equals((String)wiz.getProperty("xsd.locatiom.type"));
        if (xsdFileList != null) {
            for (i = 0; i < xsdFileList.size(); ++i) {
                if (srcLocTypeUrl) {
                    url = (String)xsdFileList.get(i);
                    ss = new SchemaSource();
                    ss.setOrigLocation(url);
                    ss.setOrigLocationType("url");
                    sss.addSchemaSource(ss);
                    tobeRemoved.remove(url);
                    if (res2Skip.get(url) == null) {
                        remoteSchema = new URL(url);
                        try {
                            newFileFO = ProjectHelper.retrieveResource(schemaDirFO, remoteSchema.toURI());
                        }
                        catch (URISyntaxException ex) {
                            throw new IOException(ex.getMessage());
                        }
                        ss.setLocation(FileUtil.getRelativePath((FileObject)projFO, (FileObject)newFileFO));
                        newProjFiles.add(FileUtil.getRelativePath((FileObject)projFO, (FileObject)newFileFO));
                        continue;
                    }
                    ss.setLocation((String)res2Skip.get(url));
                    newProjFiles.add((String)res2Skip.get(url));
                    continue;
                }
                ss = new SchemaSource();
                ss.setOrigLocation((String)xsdFileList.get(i));
                sss.addSchemaSource(ss);
                tobeRemoved.remove(xsdFileList.get(i));
                if (res2Skip.get(xsdFileList.get(i)) == null) {
                    srcFile = FileSysUtil.Relative2AbsolutePath(projDir, (String)xsdFileList.get(i));
                    targetFile = new File(schemaDir, srcFile.getName());
                    if (targetFile.exists()) {
                        targetFile.delete();
                    }
                    newFileFO = ProjectHelper.retrieveResource(schemaDirFO, srcFile.toURI());
                    ss.setLocation(FileUtil.getRelativePath((FileObject)projFO, (FileObject)newFileFO));
                    newProjFiles.add(FileUtil.getRelativePath((FileObject)projFO, (FileObject)newFileFO));
                    continue;
                }
                ss.setLocation((String)res2Skip.get(xsdFileList.get(i)));
                newProjFiles.add((String)res2Skip.get(xsdFileList.get(i)));
            }
        }
        if (bindingFileList != null) {
            for (i = 0; i < bindingFileList.size(); ++i) {
                binding = new Binding();
                binding.setOrigLocation((String)bindingFileList.get(i));
                bindings.addBinding(binding);
                tobeRemoved.remove(bindingFileList.get(i));
                if (res2Skip.get(bindingFileList.get(i)) == null) {
                    srcFile = FileSysUtil.Relative2AbsolutePath(projDir, (String)bindingFileList.get(i));
                    targetFile = new File(schemaDir, srcFile.getName());
                    if (targetFile.exists()) {
                        targetFile.delete();
                    }
                    newFileFO = ProjectHelper.retrieveResource(schemaDirFO, srcFile.toURI());
                    binding.setLocation(FileUtil.getRelativePath((FileObject)projFO, (FileObject)newFileFO));
                    newProjFiles.add(FileUtil.getRelativePath((FileObject)projFO, (FileObject)newFileFO));
                    continue;
                }
                binding.setLocation((String)res2Skip.get(bindingFileList.get(i)));
                newProjFiles.add((String)res2Skip.get(bindingFileList.get(i)));
            }
        }
        if (catlogFile != null) {
            catalog.setOrigLocation(catlogFile);
            tobeRemoved.remove(catlogFile);
            if (res2Skip.get(catlogFile) == null) {
                srcFile = FileSysUtil.Relative2AbsolutePath(projDir, catlogFile);
                targetFile = new File(schemaDir, srcFile.getName());
                if (targetFile.exists()) {
                    targetFile.delete();
                }
                newFileFO = ProjectHelper.retrieveResource(schemaDirFO, srcFile.toURI());
                catalog.setLocation(FileUtil.getRelativePath((FileObject)projFO, (FileObject)newFileFO));
                newProjFiles.add(FileUtil.getRelativePath((FileObject)projFO, (FileObject)newFileFO));
            } else {
                catalog.setLocation((String)res2Skip.get(catlogFile));
                newProjFiles.add((String)res2Skip.get(catlogFile));
            }
        }
        ProjectHelper.deleteStaleResources(projFO, tobeRemoved, newProjFiles);
        return schema;
    }

    public static AntProjectHelper getAntProjectHelper(Project project) {
        try {
            Method getAntProjectHelperMethod = project.getClass().getMethod("getAntProjectHelper", new Class[0]);
            if (getAntProjectHelperMethod != null) {
                AntProjectHelper helper = (AntProjectHelper)getAntProjectHelperMethod.invoke((Object)project, new Object[0]);
                return helper;
            }
        }
        catch (NoSuchMethodException nme) {
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public static FileObject getFOForProjectBuildFile(Project prj) {
        FileObject buildFileFo = null;
        if (prj != null) {
            FileObject fo = prj.getProjectDirectory();
            buildFileFo = fo.getFileObject("build.xml");
        }
        return buildFileFo;
    }

    public static FileObject getFOForNBProjectDir(Project prj) {
        return prj.getProjectDirectory().getFileObject(NBPROJECT_DIR);
    }

    public static FileObject getFOForBindingConfigFile(Project prj) {
        FileObject configFile = null;
        if (prj != null) {
            FileObject fo = prj.getProjectDirectory();
            try {
                fo.getFileObject("nbproject/").refresh();
                configFile = fo.getFileObject("nbproject/xml_binding_cfg.xml");
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return configFile;
    }

    public static FileObject getFOForBindingBuildFile(Project prj) {
        FileObject buildFileFo = null;
        if (prj != null) {
            FileObject fo = prj.getProjectDirectory();
            try {
                fo.getFileObject("nbproject/").refresh();
                buildFileFo = fo.getFileObject("nbproject/xml_binding_build.xml");
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return buildFileFo;
    }

    private static void createDirs(FileObject rootDir, String relDir) {
        File fileRootDir = FileUtil.toFile((FileObject)rootDir);
        File fileRelDirs = new File(fileRootDir, relDir);
        if (!fileRelDirs.exists()) {
            try {
                FileUtil.createFolder((FileObject)rootDir, (String)relDir);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static FileObject getFOProjectSchemaDir(Project project) {
        String srcDirStr = null;
        FileObject foSchemaDir = null;
        FileObject foProjDir = project.getProjectDirectory();
        if (ProjectHelper.getProjectType(project) == 1 || ProjectHelper.getProjectType(project) == 2) {
            srcDirStr = ProjectHelper.getProjectSourceRoot(project);
            FileObject srcDir = foProjDir.getFileObject(srcDirStr);
            ProjectHelper.createDirs(srcDir, NON_JAVA_SE_CONFIG_DIR);
            foSchemaDir = srcDir.getFileObject(NON_JAVA_SE_CONFIG_DIR);
        } else {
            FileObject srcDir = foProjDir;
            ProjectHelper.createDirs(srcDir, JAVA_SE_CONFIG_DIR);
            foSchemaDir = srcDir.getFileObject(JAVA_SE_CONFIG_DIR);
        }
        return foSchemaDir;
    }

    private static void addClasspathProperties(Project prj) {
        String jaxbGenSrcClasspath;
        String xjcRunClasspath;
        String xjcClasspath = ProjectHelper.getProjectProperty(prj, PROP_XJC_DEF_CLASSPATH);
        boolean modified = false;
        if (xjcClasspath == null || "".equals(xjcClasspath)) {
            ProjectHelper.saveProjectProperty(prj, PROP_XJC_DEF_CLASSPATH, PROP_VAL_JAXB_LIB_CLASSPATH);
            modified = true;
        }
        if ((xjcRunClasspath = ProjectHelper.getProjectProperty(prj, PROP_XJC_RUN_CLASSPATH)) == null || "".equals(xjcRunClasspath)) {
            ProjectHelper.saveProjectProperty(prj, PROP_XJC_RUN_CLASSPATH, PROP_VAL_JAXB_LIB_CLASSPATH);
            modified = true;
        }
        if ((jaxbGenSrcClasspath = ProjectHelper.getProjectProperty(prj, PROP_JAXB_GEN_SRC_CLASSPATH)) == null || "".equals(jaxbGenSrcClasspath)) {
            ProjectHelper.saveProjectProperty(prj, PROP_JAXB_GEN_SRC_CLASSPATH, PROP_VAL_JAXB_LIB_CLASSPATH);
            modified = true;
        }
        if (modified) {
            try {
                ProjectManager.getDefault().saveProject(prj);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    public static Schema addSchema(Project project, Schemas scs, Schema schema) {
        try {
            scs.addSchema(schema);
            ProjectHelper.saveXMLBindingSchemas(project, scs);
            ProjectHelper.refreshBuildScript(project);
            ProjectHelper.addClasspathProperties(project);
            AntBuildExtender ext = (AntBuildExtender)project.getLookup().lookup(AntBuildExtender.class);
            if (ext != null && ext.getExtension("jaxb") == null) {
                FileObject buildFo;
                FileObject jaxbBuildXml = ProjectHelper.getFOForBindingBuildFile(project);
                AntBuildExtender.Extension jaxbBuild = ext.addExtension("jaxb", jaxbBuildXml);
                jaxbBuild.addDependency("-pre-pre-compile", "jaxb-code-generation");
                ProjectManager.getDefault().saveProject(project);
                String buildDir = ProjectHelper.getProjectBuildDir(project);
                if (project.getProjectDirectory() != null && (buildFo = project.getProjectDirectory().getFileObject(buildDir)) != null) {
                    buildFo.refresh();
                }
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return schema;
    }

    public static List<String> getSchemaNames(Project project) {
        ArrayList<String> ret = new ArrayList<String>();
        Schemas scs = ProjectHelper.getXMLBindingSchemas(project);
        if (scs != null) {
            Schema[] schemas;
            for (Schema schema : schemas = scs.getSchema()) {
                ret.add(schema.getName());
            }
        }
        return ret;
    }

    public static void removeSchema(Project project, Schemas scs, Schema schema) {
        try {
            scs.removeSchema(schema);
            ProjectHelper.saveXMLBindingSchemas(project, scs);
            ProjectHelper.refreshBuildScript(project);
            if (scs.sizeSchema() == 0) {
                ProjectHelper.disableCoS(project, false);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void compileXSDs(Project project) {
        ProjectHelper.compileXSDs(project, false);
    }

    public static void compileXSDs(Project project, boolean addLibs) {
        ProjectHelper.executeAntTarget(project, addLibs, "jaxb-code-generation");
    }

    public static void cleanCompileXSDs(Project project, boolean addLibs) {
        ProjectHelper.cleanCompileXSDs(project, addLibs, null);
    }

    public static void cleanCompileXSDs(Project project, boolean addLibs, TaskListener listener) {
        ProjectHelper.executeAntTarget(project, addLibs, "jaxb-clean-code-generation", listener);
    }

    private static void executeAntTarget(Project project, boolean addLibs, String antTarget) {
        ProjectHelper.executeAntTarget(project, addLibs, antTarget, null);
    }

    private static void executeAntTarget(final Project project, final boolean addLibs, final String antTarget, TaskListener listener) {
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ProjectHelper.class, (String)"MSG_JAXB_PROGRESS"));
        progressHandle.start();
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (addLibs) {
                        ProjectHelper.addJAXBLibrary(project);
                    }
                    FileObject buildXml = ProjectHelper.getFOForProjectBuildFile(project);
                    String[] args = new String[]{antTarget};
                    if (buildXml != null) {
                        ExecutorTask task = ActionUtils.runTarget((FileObject)buildXml, (String[])args, null);
                        task.waitFinished();
                        if (task.result() != 0) {
                            String mes = NbBundle.getMessage(ProjectHelper.class, (String)"MSG_ERROR_COMPILING");
                            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                        }
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                finally {
                    progressHandle.finish();
                }
            }
        };
        RequestProcessor.Task task = RequestProcessor.getDefault().create(run);
        if (listener != null) {
            task.addTaskListener(listener);
        }
        task.schedule(0);
    }

    public static void addCfgFileChangeListener(Project prj, FileChangeListener l) {
        FileObject fo = ProjectHelper.getFOForBindingConfigFile(prj);
        FileChangeListener fcl = null;
        if (fo != null) {
            fcl = FileUtil.weakFileChangeListener((FileChangeListener)l, (Object)fo);
            fo.addFileChangeListener(fcl);
        } else {
            fo = ProjectHelper.getFOForNBProjectDir(prj);
            if (fo != null) {
                fcl = FileUtil.weakFileChangeListener((FileChangeListener)l, (Object)fo);
                fo.addFileChangeListener(fcl);
            }
        }
    }

    public static void removeModelListner(Project prj, FileChangeListener l) {
        FileObject fo = ProjectHelper.getFOForBindingConfigFile(prj);
        if (fo != null) {
            fo.removeFileChangeListener(l);
        }
        if ((fo = ProjectHelper.getFOForNBProjectDir(prj)) != null) {
            fo.removeFileChangeListener(l);
        }
    }

    public static void addModelListener(Project prj, JAXBWizEventListener l) {
        JAXBWizModel model;
        if (prj != null && (model = (JAXBWizModel)prj.getLookup().lookup(JAXBWizModel.class)) != null) {
            JAXBWizEventListener weak = (JAXBWizEventListener)WeakListeners.create(JAXBWizEventListener.class, (EventListener)l, (Object)model);
            model.addJAXBWizEventListener(weak);
        }
    }

    public static void removeModelListener(Project prj, JAXBWizEventListener l) {
        JAXBWizModel model;
        if (prj != null && (model = (JAXBWizModel)prj.getLookup().lookup(JAXBWizModel.class)) != null) {
            model.removeJAXBWizEventListener(l);
        }
    }

    public static void addSchema2Model(Project prj, Schema schema) {
        JAXBWizModelImpl model;
        if (prj != null && (model = (JAXBWizModelImpl)prj.getLookup().lookup(JAXBWizModel.class)) != null) {
            model.addSchema(schema);
        }
    }

    public static void changeSchemaInModel(Project prj, Schema os, Schema ns) {
        JAXBWizModelImpl model;
        if (prj != null && (model = (JAXBWizModelImpl)prj.getLookup().lookup(JAXBWizModel.class)) != null) {
            model.changeSchema(os, ns);
        }
    }

    public static void deleteSchemaFromModel(Project prj, Schema os) {
        JAXBWizModelImpl model;
        if (prj != null && (model = (JAXBWizModelImpl)prj.getLookup().lookup(JAXBWizModel.class)) != null) {
            model.deleteSchema(os);
        }
    }

    public static void checkAndDeregisterScript(Project prj) {
        AntBuildExtender ext;
        Schemas ss;
        if (prj != null && ((ss = ProjectHelper.getXMLBindingSchemas(prj)) == null || ss.sizeSchema() == 0) && (ext = (AntBuildExtender)prj.getLookup().lookup(AntBuildExtender.class)) != null && ext.getExtension("jaxb") != null) {
            ext.removeExtension("jaxb");
            try {
                ProjectManager.getDefault().saveProject(prj);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static void cleanupLocalSchemaDir(Project project, Schema schema) {
        FileObject projectSchemasDir = ProjectHelper.getFOProjectSchemaDir(project);
        FileObject schemaDir = projectSchemasDir.getFileObject(schema.getName());
        if (schemaDir != null) {
            try {
                schemaDir.delete();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static void migrateProjectFromPreDot5Version(Project prj) {
        ProjectHelper.addJAXBLibrary(prj);
        ProjectHelper.saveProjectProperty(prj, PROP_XJC_DEF_CLASSPATH, PROP_VAL_JAXB_LIB_CLASSPATH);
        ProjectHelper.saveProjectProperty(prj, PROP_XJC_RUN_CLASSPATH, PROP_VAL_JAXB_LIB_CLASSPATH);
        ProjectHelper.saveProjectProperty(prj, PROP_JAXB_GEN_SRC_CLASSPATH, PROP_VAL_JAXB_LIB_CLASSPATH);
        try {
            ProjectManager.getDefault().saveProject(prj);
            Schemas scs = ProjectHelper.getXMLBindingSchemas(prj);
            ProjectHelper.refreshBuildScript(prj);
            scs.setVersion(JAXBWizModuleConstants.LATEST_CFG_VERSION);
            ProjectHelper.saveXMLBindingSchemas(prj, scs);
            ProjectHelper.disableCoS(prj, scs.sizeSchema() != 0);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void addJaxbApiEndorsed(Project prj) throws IOException {
        FileObject srcRoot = ProjectHelper.getSourceRoot(prj);
        if (srcRoot != null) {
            ProjectHelper.addJaxbApiEndorsed(srcRoot);
        }
    }

    private static void addJaxbApiEndorsed(FileObject srcRoot) throws IOException {
        String sample = "javax/xml/bind/JAXBElement.class";
        ClassPath classPath = ClassPath.getClassPath((FileObject)srcRoot, (String)CLASSPATH_ENDORSED);
        if (classPath == null || classPath.findResource(sample) == null) {
            Library jaxbApiLib = LibraryManager.getDefault().getLibrary(JAXB_ENDORSED);
            assert (jaxbApiLib != null) : "JAXB endorsed library must be present";
            try {
                if (jaxbApiLib == null) {
                    throw new UnsupportedOperationException("No JAXB endorsed library found in Libraries.");
                }
                ProjectClassPathModifier.addLibraries((Library[])new Library[]{jaxbApiLib}, (FileObject)srcRoot, (String)CLASSPATH_ENDORSED);
            }
            catch (UnsupportedOperationException x) {
                classPath = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/boot");
                if (classPath == null || classPath.findResource(sample) == null) {
                    Logger.getLogger(ProjectHelper.class.getName()).log(Level.WARNING, "Could not add JAXB at all: {0}", x.getMessage());
                }
                Logger.getLogger(ProjectHelper.class.getName()).log(Level.WARNING, "Could not add JAXB override: {0}", x.getMessage());
            }
        }
    }

    private static FileObject getSourceRoot(Project prj) {
        SourceGroup[] srcGroups;
        Sources sources = ProjectUtils.getSources((Project)prj);
        if (sources != null && (srcGroups = sources.getSourceGroups("java")) != null && srcGroups.length > 0) {
            return srcGroups[0].getRootFolder();
        }
        return null;
    }

    private static Library createJaxbApiLibrary() throws IOException {
        List<URL> apiJars = ProjectHelper.getJaxbApiJars();
        if (apiJars.size() > 0) {
            Map<String, List<URL>> map = Collections.singletonMap("classpath", apiJars);
            return LibraryManager.getDefault().createLibrary("j2se", JAXB_ENDORSED, map);
        }
        return null;
    }

    private static List<URL> getJaxbApiJars() throws IOException {
        URL url;
        ArrayList<URL> urls = new ArrayList<URL>();
        File apiJar = InstalledFileLocator.getDefault().locate("modules/ext/jaxb/api/jaxb-api.jar", null, false);
        if (apiJar != null && FileUtil.isArchiveFile((URL)(url = apiJar.toURI().toURL()))) {
            urls.add(FileUtil.getArchiveRoot((URL)url));
        }
        return urls;
    }
}

