/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver;

import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.ObjCRuntime;
import org.clang.basic.VersionTuple;
import org.clang.driver.Action;
import org.clang.driver.Driver;
import org.clang.driver.DriverGlobals;
import org.clang.driver.JobAction;
import org.clang.driver.MultilibSet;
import org.clang.driver.SanitizerArgs;
import org.clang.driver.Tool;
import org.clang.driver.options;
import org.clang.driver.tools.impl.Clang;
import org.clang.driver.tools.impl.ClangAs;
import org.clang.driver.tools.impl.arm;
import org.clang.driver.types;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.DerivedArgList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.fs;

public abstract class ToolChain
implements Destructors.ClassWithDestructor {
    private Driver D;
    private Triple Triple;
    private ArgList Args;
    private SmallVector<std.string> FilePaths;
    private SmallVector<std.string> ProgramPaths;
    private std_ptr.unique_ptr<Tool> Clang;
    private std_ptr.unique_ptr<Tool> Assemble;
    private std_ptr.unique_ptr<Tool> Link;
    private std_ptr.unique_ptr<SanitizerArgs> SanitizerArguments;
    protected MultilibSet Multilibs;

    private Tool getClang() {
        if (this.Clang.$not()) {
            this.Clang.reset((Object)new Clang(this));
        }
        return (Tool)this.Clang.get();
    }

    private Tool getAssemble() {
        if (this.Assemble.$not()) {
            this.Assemble.reset((Object)this.buildAssembler());
        }
        return (Tool)this.Assemble.get();
    }

    private Tool getLink() {
        if (this.Link.$not()) {
            this.Link.reset((Object)this.buildLinker());
        }
        return (Tool)this.Link.get();
    }

    private Tool getClangAs() {
        if (this.Assemble.$not()) {
            this.Assemble.reset((Object)new ClangAs(this));
        }
        return (Tool)this.Assemble.get();
    }

    protected ToolChain() {
    }

    protected ToolChain(Driver D, Triple T, ArgList Args) {
        this.D = D;
        this.Triple = new Triple(T);
        this.Args = Args;
        this.FilePaths = new SmallVector(16, (Object)new std.string());
        this.ProgramPaths = new SmallVector(16, (Object)new std.string());
        this.Clang = new std_ptr.unique_ptr();
        this.Assemble = new std_ptr.unique_ptr();
        this.Link = new std_ptr.unique_ptr();
        this.SanitizerArguments = new std_ptr.unique_ptr();
        this.Multilibs = new MultilibSet();
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mthread_model.getValue()));
        if (A != null && !this.isThreadModelSupported(new StringRef(A.getValue()))) {
            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)D.Diag(330L), (char.ptr)A.getValue()), (StringRef)new StringRef(A.getAsString(Args))).$destroy();
        }
    }

    protected Tool buildAssembler() {
        return new ClangAs(this);
    }

    protected Tool buildLinker() {
        throw new llvm_unreachable((CharSequence)"Linking is not supported by this toolchain");
    }

    protected Tool getTool(Action.ActionClass AC) {
        switch (AC) {
            case AssembleJobClass: {
                return this.getAssemble();
            }
            case LinkJobClass: {
                return this.getLink();
            }
            case InputClass: 
            case BindArchClass: 
            case LipoJobClass: 
            case DsymutilJobClass: 
            case VerifyDebugInfoJobClass: {
                throw new llvm_unreachable((CharSequence)"Invalid tool kind.");
            }
            case CompileJobClass: 
            case PrecompileJobClass: 
            case PreprocessJobClass: 
            case AnalyzeJobClass: 
            case MigrateJobClass: 
            case VerifyPCHJobClass: 
            case BackendJobClass: {
                return this.getClang();
            }
        }
        throw new llvm_unreachable((CharSequence)"Invalid tool kind.");
    }

    protected static void addSystemInclude(ArgList DriverArgs, SmallVector<char.ptr> CC1Args, Twine Path) {
        CC1Args.push_back((Object)NativePointer.$((String)"-internal-isystem"));
        CC1Args.push_back((Object)DriverArgs.MakeArgString(Path));
    }

    protected static void addExternCSystemInclude(ArgList DriverArgs, SmallVector<char.ptr> CC1Args, Twine Path) {
        CC1Args.push_back((Object)NativePointer.$((String)"-internal-externc-isystem"));
        CC1Args.push_back((Object)DriverArgs.MakeArgString(Path));
    }

    protected static void addExternCSystemIncludeIfExists(ArgList DriverArgs, SmallVector<char.ptr> CC1Args, Twine Path) {
        if (fs.exists((Twine)Path)) {
            ToolChain.addExternCSystemInclude(DriverArgs, CC1Args, Path);
        }
    }

    protected static void addSystemIncludes(ArgList DriverArgs, SmallVector<char.ptr> CC1Args, ArrayRef<StringRef> Paths) {
        type.ptr I = (type.ptr)Native.$tryClone((NativeCloneable)Paths.begin());
        type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)Paths.end());
        while (I.$noteq((Object)E)) {
            CC1Args.push_back((Object)NativePointer.$((String)"-internal-isystem"));
            CC1Args.push_back((Object)DriverArgs.MakeArgString((StringRef)I.$star()));
            I.$preInc();
        }
    }

    public void $destroy() {
        this.Multilibs.$destroy();
        this.SanitizerArguments.$destroy();
        this.Link.$destroy();
        this.Assemble.$destroy();
        this.Clang.$destroy();
        this.ProgramPaths.$destroy();
        this.FilePaths.$destroy();
        this.Triple.$destroy();
    }

    public Driver getDriver() {
        return this.D;
    }

    public Triple getTriple() {
        return this.Triple;
    }

    public Triple.ArchType getArch() {
        return this.Triple.getArch();
    }

    public StringRef getArchName() {
        return this.Triple.getArchName();
    }

    public StringRef getPlatform() {
        return this.Triple.getVendorName();
    }

    public StringRef getOS() {
        return this.Triple.getOSName();
    }

    public StringRef getDefaultUniversalArchName() {
        switch (this.Triple.getArch()) {
            case ppc: {
                return new StringRef(NativePointer.$((String)"ppc"));
            }
            case ppc64: {
                return new StringRef(NativePointer.$((String)"ppc64"));
            }
            case ppc64le: {
                return new StringRef(NativePointer.$((String)"ppc64le"));
            }
        }
        return this.Triple.getArchName();
    }

    public std.string getTripleString() {
        return this.Triple.getTriple();
    }

    public SmallVector<std.string> getFilePaths() {
        return this.FilePaths;
    }

    public SmallVector<std.string> getProgramPaths() {
        return this.ProgramPaths;
    }

    public SanitizerArgs getSanitizerArgs() {
        if (this.SanitizerArguments.get() == null) {
            this.SanitizerArguments.reset((Object)new SanitizerArgs(this, this.Args));
        }
        return (SanitizerArgs)this.SanitizerArguments.get();
    }

    public DerivedArgList TranslateArgs(DerivedArgList Args, char.ptr BoundArch) {
        return null;
    }

    public Tool SelectTool(JobAction JA) {
        if (this.getDriver().ShouldUseClangCompiler(JA)) {
            return this.getClang();
        }
        Action.ActionClass AC = JA.getKind();
        if (AC == Action.ActionClass.AssembleJobClass && this.useIntegratedAs()) {
            return this.getClangAs();
        }
        return this.getTool(AC);
    }

    public std.string GetFilePath(CharSequence Name) {
        return this.GetFilePath(NativePointer.create_char$ptr((CharSequence)Name));
    }

    public std.string GetFilePath(char.ptr Name) {
        return this.D.GetFilePath(Name, this);
    }

    public std.string GetProgramPath(CharSequence Name) {
        return this.GetProgramPath(NativePointer.create_char$ptr((CharSequence)Name));
    }

    public std.string GetProgramPath(char.ptr Name) {
        return this.D.GetProgramPath(Name, this);
    }

    public void printVerboseInfo(raw_ostream OS) {
    }

    public boolean HasNativeLLVMSupport() {
        return false;
    }

    public types.ID LookupTypeForExtension(char.ptr Ext) {
        return types.lookupTypeForExtension(Ext);
    }

    public boolean IsBlocksDefault() {
        return false;
    }

    public boolean IsIntegratedAssemblerDefault() {
        return false;
    }

    public boolean useIntegratedAs() {
        return this.Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fintegrated_as.getValue()), new OptSpecifier((long)options.ID.OPT_fno_integrated_as.getValue()), this.IsIntegratedAssemblerDefault());
    }

    public boolean IsMathErrnoDefault() {
        return true;
    }

    public boolean IsEncodeExtendedBlockSignatureDefault() {
        return false;
    }

    public boolean IsObjCNonFragileABIDefault() {
        return false;
    }

    public boolean UseObjCMixedDispatch() {
        return false;
    }

    public long GetDefaultStackProtectorLevel(boolean KernelOrKext) {
        return 0L;
    }

    public RuntimeLibType GetDefaultRuntimeLibType() {
        return RuntimeLibType.RLT_Libgcc;
    }

    public boolean IsUnwindTablesDefault() {
        return false;
    }

    public abstract boolean isPICDefault();

    public abstract boolean isPIEDefault();

    public abstract boolean isPICDefaultForced();

    public boolean SupportsProfiling() {
        return true;
    }

    public boolean SupportsObjCGC() {
        return true;
    }

    public void CheckObjCARC() {
    }

    public boolean UseDwarfDebugFlags() {
        return false;
    }

    public boolean UseSjLjExceptions() {
        return false;
    }

    public std.string ComputeLLVMTriple(ArgList Args) {
        return this.ComputeLLVMTriple(Args, types.ID.TY_INVALID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std.string ComputeLLVMTriple(ArgList Args, types.ID InputType) {
        switch (this.getTriple().getArch()) {
            default: {
                return this.getTripleString();
            }
            case x86_64: {
                StringRef MArch;
                Triple Triple2 = new Triple(this.getTriple());
                if (!Triple2.isOSBinFormatMachO()) {
                    return this.getTripleString();
                }
                Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_march_EQ.getValue()));
                if (A != null && llvm.$eq_StringRef((StringRef)new StringRef(MArch = new StringRef(A.getValue())), (StringRef)new StringRef(NativePointer.$((String)"x86_64h")))) {
                    Triple2.setArchName(new StringRef(MArch));
                }
                return new std.string(Triple2.getTriple());
            }
            case aarch64: {
                Triple Triple3 = new Triple(this.getTriple());
                if (!Triple3.isOSBinFormatMachO()) {
                    return this.getTripleString();
                }
                Triple3.setArchName(new StringRef(NativePointer.$((String)"arm64")));
                return new std.string(Triple3.getTriple());
            }
            case arm: 
            case armeb: 
            case thumb: 
            case thumbeb: 
        }
        std.string ArchName = null;
        try {
            boolean ThumbDefault;
            Triple Triple4 = new Triple(this.getTriple());
            boolean IsBigEndian = this.getTriple().getArch() == Triple.ArchType.armeb || this.getTriple().getArch() == Triple.ArchType.thumbeb;
            Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mlittle_endian.getValue()), new OptSpecifier((long)options.ID.OPT_mbig_endian.getValue()));
            if (A != null) {
                IsBigEndian = !A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mlittle_endian.getValue()));
            }
            StringRef Suffix = new StringRef(Triple4.isOSBinFormatMachO() ? arm.getLLVMArchSuffixForARM(new StringRef(arm.getARMCPUForMArch(Args, Triple4))) : arm.getLLVMArchSuffixForARM(arm.getARMTargetCPU(Args, Triple4)));
            boolean bl = ThumbDefault = Suffix.startswith((CharSequence)"v6m") || Suffix.startswith((CharSequence)"v7m") || Suffix.startswith((CharSequence)"v7em") || Suffix.startswith((CharSequence)"v7") && this.getTriple().isOSBinFormatMachO();
            if (this.getTriple().isOSWindows()) {
                ThumbDefault = true;
            }
            ArchName = new std.string();
            if (IsBigEndian) {
                ArchName.$assign(NativePointer.$((String)"armeb"));
            } else {
                ArchName.$assign(NativePointer.$((String)"arm"));
            }
            if (InputType != types.ID.TY_PP_Asm && Args.hasFlag(new OptSpecifier((long)options.ID.OPT_mthumb.getValue()), new OptSpecifier((long)options.ID.OPT_mno_thumb.getValue()), ThumbDefault)) {
                if (IsBigEndian) {
                    ArchName.$assign(NativePointer.$((String)"thumbeb"));
                } else {
                    ArchName.$assign(NativePointer.$((String)"thumb"));
                }
            }
            Triple4.setArchName(new StringRef(std.$plus_str((std.string)ArchName, (std.string)Suffix.str())));
            std.string string2 = new std.string(Triple4.getTriple());
            return string2;
        }
        finally {
            if (ArchName != null) {
                ArchName.$destroy();
            }
        }
    }

    public std.string ComputeEffectiveClangTriple(ArgList Args) {
        return this.ComputeEffectiveClangTriple(Args, types.ID.TY_INVALID);
    }

    public std.string ComputeEffectiveClangTriple(ArgList Args, types.ID InputType) {
        return this.ComputeLLVMTriple(Args, InputType);
    }

    public ObjCRuntime getDefaultObjCRuntime(boolean isNonFragile) {
        return new ObjCRuntime(isNonFragile ? ObjCRuntime.Kind.GNUstep : ObjCRuntime.Kind.GCC, new VersionTuple());
    }

    public boolean hasBlocksRuntime() {
        return true;
    }

    public void AddClangSystemIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
    }

    public void addClangTargetOptions(ArgList DriverArgs, ArgStringList CC1Args) {
    }

    public RuntimeLibType GetRuntimeLibType(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_rtlib_EQ.getValue()));
        if (A != null) {
            StringRef Value = new StringRef(A.getValue());
            if (llvm.$eq_StringRef((StringRef)Value, (CharSequence)"compiler-rt")) {
                return RuntimeLibType.RLT_CompilerRT;
            }
            if (llvm.$eq_StringRef((StringRef)Value, (CharSequence)"libgcc")) {
                return RuntimeLibType.RLT_Libgcc;
            }
            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDriver().Diag(328L), (StringRef)new StringRef(A.getAsString(Args))).$destroy();
        }
        return this.GetDefaultRuntimeLibType();
    }

    public CXXStdlibType GetCXXStdlibType(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_stdlib_EQ.getValue()));
        if (A != null) {
            StringRef Value = new StringRef(A.getValue());
            if (llvm.$eq_StringRef((StringRef)Value, (CharSequence)"libc++")) {
                return CXXStdlibType.CST_Libcxx;
            }
            if (llvm.$eq_StringRef((StringRef)Value, (CharSequence)"libstdc++")) {
                return CXXStdlibType.CST_Libstdcxx;
            }
            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDriver().Diag(329L), (StringRef)new StringRef(A.getAsString(Args))).$destroy();
        }
        return CXXStdlibType.CST_Libstdcxx;
    }

    public void AddClangCXXStdlibIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
        DriverArgs.AddAllArgs((SmallVector)CC1Args, new OptSpecifier((long)options.ID.OPT_stdlib_EQ.getValue()));
    }

    public void AddCXXStdlibLibArgs(ArgList Args, ArgStringList CmdArgs) {
        CXXStdlibType Type2 = this.GetCXXStdlibType(Args);
        switch (Type2) {
            case CST_Libcxx: {
                CmdArgs.push_back((CharSequence)"-lc++");
                break;
            }
            case CST_Libstdcxx: {
                CmdArgs.push_back((CharSequence)"-lstdc++");
            }
        }
    }

    public void AddCCKextLibArgs(ArgList Args, ArgStringList CmdArgs) {
        CmdArgs.push_back((CharSequence)"-lcc_kext");
    }

    public boolean AddFastMathRuntimeIfAvailable(ArgList Args, ArgStringList CmdArgs) {
        Arg A;
        if (!(DriverGlobals.isOptimizationLevelFast(Args) || (A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_ffast_math.getValue()), new OptSpecifier((long)options.ID.OPT_fno_fast_math.getValue()), new OptSpecifier((long)options.ID.OPT_funsafe_math_optimizations.getValue()), new OptSpecifier((long)options.ID.OPT_fno_unsafe_math_optimizations.getValue()))) != null && A.getOption().getID() != (long)options.ID.OPT_fno_fast_math.getValue() && A.getOption().getID() != (long)options.ID.OPT_fno_unsafe_math_optimizations.getValue())) {
            return false;
        }
        std.string Path = this.GetFilePath(NativePointer.$((String)"crtfastmath.o"));
        if (std.$eq_str_T((std.string)Path, (char.iterator)NativePointer.$((String)"crtfastmath.o"))) {
            return false;
        }
        CmdArgs.push_back((Object)Args.MakeArgString(new std.string(Path)));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std.string GetLinkerPath() {
        Arg A = this.Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fuse_ld_EQ.getValue()));
        if (A != null) {
            SmallString LinkerName = null;
            std.string LinkerPath = null;
            try {
                StringRef Suffix = new StringRef(A.getValue());
                if (Suffix.empty() || llvm.$eq_StringRef((StringRef)new StringRef(Suffix), (StringRef)new StringRef(NativePointer.$((String)"ld")))) {
                    std.string string2 = this.GetProgramPath(NativePointer.$((String)"ld"));
                    return string2;
                }
                LinkerName = new SmallString(new StringRef(NativePointer.$((String)"ld.")), 8);
                LinkerName.append(new StringRef(Suffix));
                LinkerPath = this.GetProgramPath(LinkerName.c_str());
                if (fs.exists((Twine)new Twine(LinkerPath))) {
                    std.string string3 = new std.string(LinkerPath);
                    return string3;
                }
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDriver().Diag(324L), (StringRef)new StringRef(A.getAsString(this.Args))).$destroy();
                std.string string4 = new std.string(NativePointer.$((String)""));
                return string4;
            }
            finally {
                if (LinkerPath != null) {
                    LinkerPath.$destroy();
                }
                if (LinkerName != null) {
                    LinkerName.$destroy();
                }
            }
        }
        return this.GetProgramPath(NativePointer.$((String)"ld"));
    }

    public void addClangWarningOptions(ArgStringList CC1Args) {
    }

    public MultilibSet getMultilibs() {
        return this.Multilibs;
    }

    public std.string getThreadModel() {
        return new std.string(NativePointer.$((String)"posix"));
    }

    public boolean isCrossCompiling() {
        Triple HostTriple = null;
        try {
            HostTriple = new Triple(new Twine(NativePointer.$((String)"x86_64-unknown-linux-gnu")));
            switch (HostTriple.getArch()) {
                case arm: 
                case armeb: 
                case thumb: 
                case thumbeb: {
                    boolean bl = this.getArch() != Triple.ArchType.arm && this.getArch() != Triple.ArchType.thumb && this.getArch() != Triple.ArchType.armeb && this.getArch() != Triple.ArchType.thumbeb;
                    return bl;
                }
            }
            boolean bl = HostTriple.getArch() != this.getArch();
            return bl;
        }
        finally {
            if (HostTriple != null) {
                HostTriple.$destroy();
            }
        }
    }

    public boolean isThreadModelSupported(StringRef Model) {
        if (llvm.$eq_StringRef((StringRef)new StringRef(Model), (StringRef)new StringRef(NativePointer.$((String)"single")))) {
            return this.Triple.getArch() == Triple.ArchType.arm || this.Triple.getArch() == Triple.ArchType.armeb || this.Triple.getArch() == Triple.ArchType.thumb || this.Triple.getArch() == Triple.ArchType.thumbeb;
        }
        return llvm.$eq_StringRef((StringRef)new StringRef(Model), (StringRef)new StringRef(NativePointer.$((String)"posix")));
    }

    public static final class RuntimeLibType
    extends Enum<RuntimeLibType> {
        public static final /* enum */ RuntimeLibType RLT_CompilerRT = new RuntimeLibType(0L);
        public static final /* enum */ RuntimeLibType RLT_Libgcc = new RuntimeLibType(1L);
        private final int value;
        private static final /* synthetic */ RuntimeLibType[] $VALUES;

        public static RuntimeLibType[] values() {
            return (RuntimeLibType[])$VALUES.clone();
        }

        public static RuntimeLibType valueOf(String name) {
            return Enum.valueOf(RuntimeLibType.class, name);
        }

        public static RuntimeLibType valueOf(int val) {
            RuntimeLibType out;
            RuntimeLibType runtimeLibType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private RuntimeLibType(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new RuntimeLibType[]{RLT_CompilerRT, RLT_Libgcc};
        }

        private static final class Values {
            private static final RuntimeLibType[] VALUES;
            private static final RuntimeLibType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (RuntimeLibType kind : RuntimeLibType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new RuntimeLibType[min < 0 ? 1 - min : 0];
                VALUES = new RuntimeLibType[max >= 0 ? 1 + max : 0];
                for (RuntimeLibType kind : RuntimeLibType.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((RuntimeLibType)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((RuntimeLibType)kind).value] = kind;
                }
            }
        }
    }

    public static final class CXXStdlibType
    extends Enum<CXXStdlibType> {
        public static final /* enum */ CXXStdlibType CST_Libcxx = new CXXStdlibType(0L);
        public static final /* enum */ CXXStdlibType CST_Libstdcxx = new CXXStdlibType(1L);
        private final int value;
        private static final /* synthetic */ CXXStdlibType[] $VALUES;

        public static CXXStdlibType[] values() {
            return (CXXStdlibType[])$VALUES.clone();
        }

        public static CXXStdlibType valueOf(String name) {
            return Enum.valueOf(CXXStdlibType.class, name);
        }

        public static CXXStdlibType valueOf(int val) {
            CXXStdlibType out;
            CXXStdlibType cXXStdlibType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private CXXStdlibType(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new CXXStdlibType[]{CST_Libcxx, CST_Libstdcxx};
        }

        private static final class Values {
            private static final CXXStdlibType[] VALUES;
            private static final CXXStdlibType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (CXXStdlibType kind : CXXStdlibType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new CXXStdlibType[min < 0 ? 1 - min : 0];
                VALUES = new CXXStdlibType[max >= 0 ? 1 + max : 0];
                for (CXXStdlibType kind : CXXStdlibType.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((CXXStdlibType)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((CXXStdlibType)kind).value] = kind;
                }
            }
        }
    }
}

