/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.impl;

import org.clang.driver.Multilib;
import org.clang.driver.MultilibSet;
import org.clang.driver.NativeCallback;
import org.clang.driver.impl.DetectedMultilibs;
import org.clang.driver.impl.Distro;
import org.clang.driver.impl.FilterNonExistent;
import org.clang.driver.impl.toolchains;
import org.clang.driver.options;
import org.clang.driver.tools.impl.mips;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.OptGlobals;
import org.llvm.option.OptSpecifier;
import org.llvm.option.arg_iterator;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.llvm.support.sys.fs;

public final class ToolChainsStatics {
    public static char.ptr GetArmArchForMArch(StringRef Value) {
        return (char.ptr)new StringSwitch(new StringRef(Value)).Case(NativePointer.$((String)"armv6k"), (Object)NativePointer.$((String)"armv6")).Case(NativePointer.$((String)"armv6m"), (Object)NativePointer.$((String)"armv6m")).Case(NativePointer.$((String)"armv5tej"), (Object)NativePointer.$((String)"armv5")).Case(NativePointer.$((String)"xscale"), (Object)NativePointer.$((String)"xscale")).Case(NativePointer.$((String)"armv4t"), (Object)NativePointer.$((String)"armv4t")).Case(NativePointer.$((String)"armv7"), (Object)NativePointer.$((String)"armv7")).Cases(NativePointer.$((String)"armv7a"), NativePointer.$((String)"armv7-a"), (Object)NativePointer.$((String)"armv7")).Cases(NativePointer.$((String)"armv7r"), NativePointer.$((String)"armv7-r"), (Object)NativePointer.$((String)"armv7")).Cases(NativePointer.$((String)"armv7em"), NativePointer.$((String)"armv7e-m"), (Object)NativePointer.$((String)"armv7em")).Cases(NativePointer.$((String)"armv7k"), NativePointer.$((String)"armv7-k"), (Object)NativePointer.$((String)"armv7k")).Cases(NativePointer.$((String)"armv7m"), NativePointer.$((String)"armv7-m"), (Object)NativePointer.$((String)"armv7m")).Cases(NativePointer.$((String)"armv7s"), NativePointer.$((String)"armv7-s"), (Object)NativePointer.$((String)"armv7s")).Default(null);
    }

    public static char.ptr GetArmArchForMCpu(StringRef Value) {
        return (char.ptr)new StringSwitch(new StringRef(Value)).Cases(NativePointer.$((String)"arm9e"), NativePointer.$((String)"arm946e-s"), NativePointer.$((String)"arm966e-s"), NativePointer.$((String)"arm968e-s"), NativePointer.$((String)"arm926ej-s"), (Object)NativePointer.$((String)"armv5")).Cases(NativePointer.$((String)"arm10e"), NativePointer.$((String)"arm10tdmi"), (Object)NativePointer.$((String)"armv5")).Cases(NativePointer.$((String)"arm1020t"), NativePointer.$((String)"arm1020e"), NativePointer.$((String)"arm1022e"), NativePointer.$((String)"arm1026ej-s"), (Object)NativePointer.$((String)"armv5")).Case(NativePointer.$((String)"xscale"), (Object)NativePointer.$((String)"xscale")).Cases(NativePointer.$((String)"arm1136j-s"), NativePointer.$((String)"arm1136jf-s"), NativePointer.$((String)"arm1176jz-s"), NativePointer.$((String)"arm1176jzf-s"), (Object)NativePointer.$((String)"armv6")).Case(NativePointer.$((String)"cortex-m0"), (Object)NativePointer.$((String)"armv6m")).Cases(NativePointer.$((String)"cortex-a5"), NativePointer.$((String)"cortex-a7"), NativePointer.$((String)"cortex-a8"), (Object)NativePointer.$((String)"armv7")).Cases(NativePointer.$((String)"cortex-a9"), NativePointer.$((String)"cortex-a12"), NativePointer.$((String)"cortex-a15"), NativePointer.$((String)"cortex-a17"), NativePointer.$((String)"krait"), (Object)NativePointer.$((String)"armv7")).Cases(NativePointer.$((String)"cortex-r4"), NativePointer.$((String)"cortex-r5"), (Object)NativePointer.$((String)"armv7r")).Case(NativePointer.$((String)"cortex-m3"), (Object)NativePointer.$((String)"armv7m")).Cases(NativePointer.$((String)"cortex-m4"), NativePointer.$((String)"cortex-m7"), (Object)NativePointer.$((String)"armv7em")).Case(NativePointer.$((String)"swift"), (Object)NativePointer.$((String)"armv7s")).Default(null);
    }

    public static boolean isSoftFloatABI(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_msoft_float.getValue()), new OptSpecifier((long)options.ID.OPT_mhard_float.getValue()), new OptSpecifier((long)options.ID.OPT_mfloat_abi_EQ.getValue()));
        if (A == null) {
            return false;
        }
        return A.getOption().matches(new OptSpecifier((long)options.ID.OPT_msoft_float.getValue())) || A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mfloat_abi_EQ.getValue())) && llvm.$eq_StringRef((StringRef)new StringRef(A.getValue()), (StringRef)new StringRef(NativePointer.$((String)"soft")));
    }

    public static boolean isObjCAutoRefCount(ArgList Args) {
        return Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fobjc_arc.getValue()), new OptSpecifier((long)options.ID.OPT_fno_objc_arc.getValue()), false);
    }

    public static StringRef getGCCToolchainDir(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_gcc_toolchain.getValue()));
        if (A != null) {
            return new StringRef(A.getValue());
        }
        return StringRef.EMPTY;
    }

    public static void addMultilibFlag(boolean Enabled, char.ptr Flag, std.vectorString Flags) {
        if (Enabled) {
            Flags.push_back(std.$plus_str_T((std.string)new std.string(NativePointer.$((String)"+")), (char.iterator)Flag));
        } else {
            Flags.push_back(std.$plus_str_T((std.string)new std.string(NativePointer.$((String)"-")), (char.iterator)Flag));
        }
    }

    public static boolean isMipsArch(Triple.ArchType Arch) {
        return Arch == Triple.ArchType.mips || Arch == Triple.ArchType.mipsel || Arch == Triple.ArchType.mips64 || Arch == Triple.ArchType.mips64el;
    }

    public static boolean isMips32(Triple.ArchType Arch) {
        return Arch == Triple.ArchType.mips || Arch == Triple.ArchType.mipsel;
    }

    public static boolean isMips64(Triple.ArchType Arch) {
        return Arch == Triple.ArchType.mips64 || Arch == Triple.ArchType.mips64el;
    }

    public static boolean isMipsEL(Triple.ArchType Arch) {
        return Arch == Triple.ArchType.mipsel || Arch == Triple.ArchType.mips64el;
    }

    public static boolean isMips16(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mips16.getValue()), new OptSpecifier((long)options.ID.OPT_mno_mips16.getValue()));
        return A != null && A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mips16.getValue()));
    }

    public static boolean isMicroMips(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mmicromips.getValue()), new OptSpecifier((long)options.ID.OPT_mno_micromips.getValue()));
        return A != null && A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mmicromips.getValue()));
    }

    public static Multilib makeMultilib(StringRef commonSuffix) {
        return new Multilib(new StringRef(commonSuffix), new StringRef(commonSuffix), new StringRef(commonSuffix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean findMIPSMultilibs(Triple TargetTriple, StringRef Path, ArgList Args, DetectedMultilibs Result) {
        FilterNonExistent NonExistent = null;
        MultilibSet FSFMipsMultilibs = null;
        MultilibSet CSMipsMultilibs = null;
        MultilibSet DebianMipsMultilibs = null;
        MultilibSet ImgMultilibs = null;
        std.vectorString Flags = null;
        try {
            NonExistent = new FilterNonExistent(Path.$basic_string());
            FSFMipsMultilibs = new MultilibSet();
            Multilib MArchMips32 = new Multilib(ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$((String)"/mips32"))).flag(new StringRef(NativePointer.$((String)"+m32"))).flag(new StringRef(NativePointer.$((String)"-m64"))).flag(new StringRef(NativePointer.$((String)"-mmicromips"))).flag(new StringRef(NativePointer.$((String)"+march=mips32"))));
            Multilib MArchMicroMips = new Multilib(ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$((String)"/micromips"))).flag(new StringRef(NativePointer.$((String)"+m32"))).flag(new StringRef(NativePointer.$((String)"-m64"))).flag(new StringRef(NativePointer.$((String)"+mmicromips"))));
            Multilib MArchMips64r2 = new Multilib(ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$((String)"/mips64r2"))).flag(new StringRef(NativePointer.$((String)"-m32"))).flag(new StringRef(NativePointer.$((String)"+m64"))).flag(new StringRef(NativePointer.$((String)"+march=mips64r2"))));
            Multilib MArchMips64 = new Multilib(ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$((String)"/mips64"))).flag(new StringRef(NativePointer.$((String)"-m32"))).flag(new StringRef(NativePointer.$((String)"+m64"))).flag(new StringRef(NativePointer.$((String)"-march=mips64r2"))));
            Multilib MArchDefault = new Multilib(ToolChainsStatics.makeMultilib(StringRef.EMPTY).flag(new StringRef(NativePointer.$((String)"+m32"))).flag(new StringRef(NativePointer.$((String)"-m64"))).flag(new StringRef(NativePointer.$((String)"-mmicromips"))).flag(new StringRef(NativePointer.$((String)"+march=mips32r2"))));
            Multilib Mips16 = new Multilib(ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$((String)"/mips16"))).flag(new StringRef(NativePointer.$((String)"+mips16"))));
            Multilib UCLibc = new Multilib(ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$((String)"/uclibc"))).flag(new StringRef(NativePointer.$((String)"+muclibc"))));
            Multilib MAbi64 = new Multilib(ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$((String)"/64"))).flag(new StringRef(NativePointer.$((String)"+mabi=n64"))).flag(new StringRef(NativePointer.$((String)"-mabi=n32"))).flag(new StringRef(NativePointer.$((String)"-m32"))));
            Multilib BigEndian = new Multilib(ToolChainsStatics.makeMultilib(StringRef.EMPTY).flag(new StringRef(NativePointer.$((String)"+EB"))).flag(new StringRef(NativePointer.$((String)"-EL"))));
            Multilib LittleEndian = new Multilib(ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$((String)"/el"))).flag(new StringRef(NativePointer.$((String)"+EL"))).flag(new StringRef(NativePointer.$((String)"-EB"))));
            Multilib SoftFloat = new Multilib(ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$((String)"/sof"))).flag(new StringRef(NativePointer.$((String)"+msoft-float"))));
            Multilib Nan2008 = new Multilib(ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$((String)"/nan2008"))).flag(new StringRef(NativePointer.$((String)"+mnan=2008"))));
            FSFMipsMultilibs.$assign(new MultilibSet().Either(MArchMips32, MArchMicroMips, MArchMips64r2, MArchMips64, MArchDefault).Maybe(UCLibc).Maybe(Mips16).FilterOut(new std.string(NativePointer.$((String)"/mips64/mips16"))).FilterOut(new std.string(NativePointer.$((String)"/mips64r2/mips16"))).FilterOut(new std.string(NativePointer.$((String)"/micromips/mips16"))).Maybe(MAbi64).FilterOut(new std.string(NativePointer.$((String)"/micromips/64"))).FilterOut(new std.string(NativePointer.$((String)"/mips32/64"))).FilterOut(new std.string(NativePointer.$((String)"^/64"))).FilterOut(new std.string(NativePointer.$((String)"/mips16/64"))).Either(BigEndian, LittleEndian).Maybe(SoftFloat).Maybe(Nan2008).FilterOut(new std.string(NativePointer.$((String)".*sof/nan2008"))).FilterOut(NonExistent).setIncludeDirsCallback(new NativeCallback.IncludeDirsFunc(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public std.vectorString $call(StringRef InstallDir, StringRef TripleStr, Multilib M) {
                    std.vectorString Dirs = null;
                    try {
                        Dirs = new std.vectorString(std.string.EMPTY);
                        Dirs.push_back(llvm.$plus_StringRef_char$ptr((StringRef)InstallDir, (char.ptr)NativePointer.$((String)"/include")).str());
                        std.string SysRootInc = std.$plus_str_T((std.string)InstallDir.str(), (char.iterator)NativePointer.$((String)"/../../../../sysroot"));
                        if (new StringRef(M.includeSuffix()).startswith((CharSequence)"/uclibc")) {
                            Dirs.push_back(std.$plus_str_T((std.string)SysRootInc, (char.iterator)NativePointer.$((String)"/uclibc/usr/include")));
                        } else {
                            Dirs.push_back(std.$plus_str_T((std.string)SysRootInc, (char.iterator)NativePointer.$((String)"/usr/include")));
                        }
                        std.vectorString vectorString2 = new std.vectorString(Dirs);
                        return vectorString2;
                    }
                    finally {
                        if (Dirs != null) {
                            Dirs.$destroy();
                        }
                    }
                }
            }));
            CSMipsMultilibs = new MultilibSet();
            Multilib MArchMips16 = new Multilib(ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$((String)"/mips16"))).flag(new StringRef(NativePointer.$((String)"+m32"))).flag(new StringRef(NativePointer.$((String)"+mips16"))));
            MArchMicroMips = new Multilib(ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$((String)"/micromips"))).flag(new StringRef(NativePointer.$((String)"+m32"))).flag(new StringRef(NativePointer.$((String)"+mmicromips"))));
            Multilib MArchDefault2 = new Multilib(ToolChainsStatics.makeMultilib(StringRef.EMPTY).flag(new StringRef(NativePointer.$((String)"-mips16"))).flag(new StringRef(NativePointer.$((String)"-mmicromips"))));
            Multilib UCLibc2 = new Multilib(ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$((String)"/uclibc"))).flag(new StringRef(NativePointer.$((String)"+muclibc"))));
            Multilib SoftFloat22 = new Multilib(ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$((String)"/soft-float"))).flag(new StringRef(NativePointer.$((String)"+msoft-float"))));
            Object[] Nan20082 = new Multilib(ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$((String)"/nan2008"))).flag(new StringRef(NativePointer.$((String)"+mnan=2008"))));
            Multilib DefaultFloat = new Multilib(ToolChainsStatics.makeMultilib(StringRef.EMPTY).flag(new StringRef(NativePointer.$((String)"-msoft-float"))).flag(new StringRef(NativePointer.$((String)"-mnan=2008"))));
            Multilib BigEndian2 = new Multilib(ToolChainsStatics.makeMultilib(StringRef.EMPTY).flag(new StringRef(NativePointer.$((String)"+EB"))).flag(new StringRef(NativePointer.$((String)"-EL"))));
            Multilib LittleEndian2 = new Multilib(ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$((String)"/el"))).flag(new StringRef(NativePointer.$((String)"+EL"))).flag(new StringRef(NativePointer.$((String)"-EB"))));
            Multilib MAbi642 = new Multilib(ToolChainsStatics.makeMultilib(StringRef.EMPTY).gccSuffix(new StringRef(NativePointer.$((String)"/64"))).includeSuffix(new StringRef(NativePointer.$((String)"/64"))).flag(new StringRef(NativePointer.$((String)"+mabi=n64"))).flag(new StringRef(NativePointer.$((String)"-mabi=n32"))).flag(new StringRef(NativePointer.$((String)"-m32"))));
            CSMipsMultilibs.$assign(new MultilibSet().Either(MArchMips16, MArchMicroMips, MArchDefault2).Maybe(UCLibc2).Either(SoftFloat22, (Multilib)Nan20082, DefaultFloat).FilterOut(new std.string(NativePointer.$((String)"/micromips/nan2008"))).FilterOut(new std.string(NativePointer.$((String)"/mips16/nan2008"))).Either(BigEndian2, LittleEndian2).Maybe(MAbi642).FilterOut(new std.string(NativePointer.$((String)"/mips16.*/64"))).FilterOut(new std.string(NativePointer.$((String)"/micromips.*/64"))).FilterOut(NonExistent).setIncludeDirsCallback(new NativeCallback.IncludeDirsFunc(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public std.vectorString $call(StringRef InstallDir, StringRef TripleStr, Multilib M) {
                    std.vectorString Dirs = null;
                    try {
                        Dirs = new std.vectorString(std.string.EMPTY);
                        Dirs.push_back(llvm.$plus_StringRef_char$ptr((StringRef)InstallDir, (char.ptr)NativePointer.$((String)"/include")).str());
                        std.string SysRootInc = std.$plus_str((std.string)std.$plus_str_T((std.string)InstallDir.str(), (char.iterator)NativePointer.$((String)"/../../../../")), (std.string)TripleStr.str());
                        if (new StringRef(M.includeSuffix()).startswith((CharSequence)"/uclibc")) {
                            Dirs.push_back(std.$plus_str_T((std.string)SysRootInc, (char.iterator)NativePointer.$((String)"/libc/uclibc/usr/include")));
                        } else {
                            Dirs.push_back(std.$plus_str_T((std.string)SysRootInc, (char.iterator)NativePointer.$((String)"/libc/usr/include")));
                        }
                        std.vectorString vectorString2 = new std.vectorString(Dirs);
                        return vectorString2;
                    }
                    finally {
                        if (Dirs != null) {
                            Dirs.$destroy();
                        }
                    }
                }
            }));
            MultilibSet AndroidMipsMultilibs = new MultilibSet(new MultilibSet().Maybe(new Multilib(new StringRef(NativePointer.$((String)"/mips-r2"))).flag(new StringRef(NativePointer.$((String)"+march=mips32r2")))).FilterOut(NonExistent));
            DebianMipsMultilibs = new MultilibSet();
            Multilib MAbiN32 = new Multilib(new Multilib().gccSuffix(new StringRef(NativePointer.$((String)"/n32"))).includeSuffix(new StringRef(NativePointer.$((String)"/n32"))).flag(new StringRef(NativePointer.$((String)"+mabi=n32"))));
            Multilib M64 = new Multilib(new Multilib().gccSuffix(new StringRef(NativePointer.$((String)"/64"))).includeSuffix(new StringRef(NativePointer.$((String)"/64"))).flag(new StringRef(NativePointer.$((String)"+m64"))).flag(new StringRef(NativePointer.$((String)"-m32"))).flag(new StringRef(NativePointer.$((String)"-mabi=n32"))));
            Multilib M32 = new Multilib(new Multilib().flag(new StringRef(NativePointer.$((String)"-m64"))).flag(new StringRef(NativePointer.$((String)"+m32"))).flag(new StringRef(NativePointer.$((String)"-mabi=n32"))));
            DebianMipsMultilibs.$assign(new MultilibSet().Either(M32, M64, MAbiN32).FilterOut(NonExistent));
            ImgMultilibs = new MultilibSet();
            Multilib Mips64r6 = new Multilib(ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$((String)"/mips64r6"))).flag(new StringRef(NativePointer.$((String)"+m64"))).flag(new StringRef(NativePointer.$((String)"-m32"))));
            Multilib LittleEndian3 = new Multilib(ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$((String)"/el"))).flag(new StringRef(NativePointer.$((String)"+EL"))).flag(new StringRef(NativePointer.$((String)"-EB"))));
            Multilib MAbi643 = new Multilib(ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$((String)"/64"))).flag(new StringRef(NativePointer.$((String)"+mabi=n64"))).flag(new StringRef(NativePointer.$((String)"-mabi=n32"))).flag(new StringRef(NativePointer.$((String)"-m32"))));
            ImgMultilibs.$assign(new MultilibSet().Maybe(Mips64r6).Maybe(MAbi643).Maybe(LittleEndian3).FilterOut(NonExistent).setIncludeDirsCallback(new NativeCallback.IncludeDirsFunc(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public std.vectorString $call(StringRef InstallDir, StringRef TripleStr, Multilib M) {
                    std.vectorString Dirs = null;
                    try {
                        Dirs = new std.vectorString(std.string.EMPTY);
                        Dirs.push_back(llvm.$plus_StringRef_char$ptr((StringRef)InstallDir, (char.ptr)NativePointer.$((String)"/include")).str());
                        Dirs.push_back(llvm.$plus_StringRef_char$ptr((StringRef)InstallDir, (char.ptr)NativePointer.$((String)"/../../../../sysroot/usr/include")).str());
                        std.vectorString vectorString2 = new std.vectorString(Dirs);
                        return vectorString2;
                    }
                    finally {
                        if (Dirs != null) {
                            Dirs.$destroy();
                        }
                    }
                }
            }));
            StringRef CPUName = new StringRef();
            StringRef ABIName = new StringRef();
            mips.getMipsCPUAndABI(Args, TargetTriple, CPUName, ABIName);
            Triple.ArchType TargetArch = TargetTriple.getArch();
            Flags = new std.vectorString(std.string.EMPTY);
            ToolChainsStatics.addMultilibFlag(ToolChainsStatics.isMips32(TargetArch), NativePointer.$((String)"m32"), Flags);
            ToolChainsStatics.addMultilibFlag(ToolChainsStatics.isMips64(TargetArch), NativePointer.$((String)"m64"), Flags);
            ToolChainsStatics.addMultilibFlag(ToolChainsStatics.isMips16(Args), NativePointer.$((String)"mips16"), Flags);
            ToolChainsStatics.addMultilibFlag(llvm.$eq_StringRef((StringRef)new StringRef(CPUName), (StringRef)new StringRef(NativePointer.$((String)"mips32"))), NativePointer.$((String)"march=mips32"), Flags);
            ToolChainsStatics.addMultilibFlag(llvm.$eq_StringRef((StringRef)new StringRef(CPUName), (StringRef)new StringRef(NativePointer.$((String)"mips32r2"))), NativePointer.$((String)"march=mips32r2"), Flags);
            ToolChainsStatics.addMultilibFlag(llvm.$eq_StringRef((StringRef)new StringRef(CPUName), (StringRef)new StringRef(NativePointer.$((String)"mips64"))), NativePointer.$((String)"march=mips64"), Flags);
            ToolChainsStatics.addMultilibFlag(llvm.$eq_StringRef((StringRef)new StringRef(CPUName), (StringRef)new StringRef(NativePointer.$((String)"mips64r2"))) || llvm.$eq_StringRef((StringRef)new StringRef(CPUName), (StringRef)new StringRef(NativePointer.$((String)"octeon"))), NativePointer.$((String)"march=mips64r2"), Flags);
            ToolChainsStatics.addMultilibFlag(ToolChainsStatics.isMicroMips(Args), NativePointer.$((String)"mmicromips"), Flags);
            ToolChainsStatics.addMultilibFlag(mips.isUCLibc(Args), NativePointer.$((String)"muclibc"), Flags);
            ToolChainsStatics.addMultilibFlag(mips.isNaN2008(Args, TargetTriple), NativePointer.$((String)"mnan=2008"), Flags);
            ToolChainsStatics.addMultilibFlag(llvm.$eq_StringRef((StringRef)new StringRef(ABIName), (StringRef)new StringRef(NativePointer.$((String)"n32"))), NativePointer.$((String)"mabi=n32"), Flags);
            ToolChainsStatics.addMultilibFlag(llvm.$eq_StringRef((StringRef)new StringRef(ABIName), (StringRef)new StringRef(NativePointer.$((String)"n64"))), NativePointer.$((String)"mabi=n64"), Flags);
            ToolChainsStatics.addMultilibFlag(ToolChainsStatics.isSoftFloatABI(Args), NativePointer.$((String)"msoft-float"), Flags);
            ToolChainsStatics.addMultilibFlag(!ToolChainsStatics.isSoftFloatABI(Args), NativePointer.$((String)"mhard-float"), Flags);
            ToolChainsStatics.addMultilibFlag(ToolChainsStatics.isMipsEL(TargetArch), NativePointer.$((String)"EL"), Flags);
            ToolChainsStatics.addMultilibFlag(!ToolChainsStatics.isMipsEL(TargetArch), NativePointer.$((String)"EB"), Flags);
            if (TargetTriple.getEnvironment() == Triple.EnvironmentType.Android) {
                if (AndroidMipsMultilibs.select(Flags, Result.SelectedMultilib)) {
                    Result.Multilibs.$assign(AndroidMipsMultilibs);
                    boolean SoftFloat22 = true;
                    return SoftFloat22;
                }
                boolean SoftFloat22 = false;
                return SoftFloat22;
            }
            if (TargetTriple.getVendor() == Triple.VendorType.ImaginationTechnologies && TargetTriple.getOS() == Triple.OSType.Linux && TargetTriple.getEnvironment() == Triple.EnvironmentType.GNU) {
                if (ImgMultilibs.select(Flags, Result.SelectedMultilib)) {
                    Result.Multilibs.$assign(ImgMultilibs);
                    boolean SoftFloat22 = true;
                    return SoftFloat22;
                }
                boolean SoftFloat22 = false;
                return SoftFloat22;
            }
            Object[] candidates = new MultilibSet[]{DebianMipsMultilibs, FSFMipsMultilibs, CSMipsMultilibs};
            std.sort((type.iterator)std.begin((Object[])candidates), (type.iterator)std.end((Object[])candidates), (std.Compare)new std.Compare<MultilibSet>(){

                public boolean compare(MultilibSet a, MultilibSet b) {
                    return a.size() > b.size();
                }
            });
            for (Object candidate : candidates) {
                if (!((MultilibSet)candidate).select(Flags, Result.SelectedMultilib)) continue;
                if (candidate == DebianMipsMultilibs) {
                    Result.BiarchSibling.$assign((Object)new Multilib());
                }
                Result.Multilibs.$assign((MultilibSet)candidate);
                boolean bl = true;
                return bl;
            }
            Multilib Default = null;
            try {
                Default = new Multilib();
                Result.Multilibs.push_back(Default);
                Result.Multilibs.FilterOut(NonExistent);
                if (Result.Multilibs.select(Flags, Result.SelectedMultilib)) {
                    Result.BiarchSibling.$assign((Object)new Multilib());
                    int n = 1;
                    return n != 0;
                }
            }
            finally {
                if (Default != null) {
                    Default.$destroy();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (Flags != null) {
                Flags.$destroy();
            }
            if (ImgMultilibs != null) {
                ImgMultilibs.$destroy();
            }
            if (DebianMipsMultilibs != null) {
                DebianMipsMultilibs.$destroy();
            }
            if (CSMipsMultilibs != null) {
                CSMipsMultilibs.$destroy();
            }
            if (FSFMipsMultilibs != null) {
                FSFMipsMultilibs.$destroy();
            }
            if (NonExistent != null) {
                NonExistent.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean findBiarchMultilibs(Triple TargetTriple, StringRef Path, ArgList Args, boolean NeedsBiarchSuffix, DetectedMultilibs Result) {
        Multilib Default = null;
        FilterNonExistent NonExistent = null;
        std.vectorString Flags = null;
        try {
            boolean IsX32;
            Default = new Multilib();
            Multilib Alt64 = new Multilib(new Multilib().gccSuffix(new StringRef(NativePointer.$((String)"/64"))).includeSuffix(new StringRef(NativePointer.$((String)"/64"))).flag(new StringRef(NativePointer.$((String)"-m32"))).flag(new StringRef(NativePointer.$((String)"+m64"))).flag(new StringRef(NativePointer.$((String)"-mx32"))));
            Multilib Alt32 = new Multilib(new Multilib().gccSuffix(new StringRef(NativePointer.$((String)"/32"))).includeSuffix(new StringRef(NativePointer.$((String)"/32"))).flag(new StringRef(NativePointer.$((String)"+m32"))).flag(new StringRef(NativePointer.$((String)"-m64"))).flag(new StringRef(NativePointer.$((String)"-mx32"))));
            Multilib Altx32 = new Multilib(new Multilib().gccSuffix(new StringRef(NativePointer.$((String)"/x32"))).includeSuffix(new StringRef(NativePointer.$((String)"/x32"))).flag(new StringRef(NativePointer.$((String)"-m32"))).flag(new StringRef(NativePointer.$((String)"-m64"))).flag(new StringRef(NativePointer.$((String)"+mx32"))));
            NonExistent = new FilterNonExistent(Path.$basic_string());
            Unnamed_enum Want = Unnamed_enum.UNKNOWN;
            boolean bl = IsX32 = TargetTriple.getEnvironment() == Triple.EnvironmentType.GNUX32;
            if (TargetTriple.isArch32Bit() && !NonExistent.$call(Alt32)) {
                Want = Unnamed_enum.WANT64;
            } else if (TargetTriple.isArch64Bit() && IsX32 && !NonExistent.$call(Altx32)) {
                Want = Unnamed_enum.WANT64;
            } else if (TargetTriple.isArch64Bit() && !IsX32 && !NonExistent.$call(Alt64)) {
                Want = Unnamed_enum.WANT32;
            } else if (TargetTriple.isArch32Bit()) {
                Want = NeedsBiarchSuffix ? Unnamed_enum.WANT64 : Unnamed_enum.WANT32;
            } else if (IsX32) {
                Want = NeedsBiarchSuffix ? Unnamed_enum.WANT64 : Unnamed_enum.WANTX32;
            } else {
                Unnamed_enum unnamed_enum = Want = NeedsBiarchSuffix ? Unnamed_enum.WANT32 : Unnamed_enum.WANT64;
            }
            if (Want == Unnamed_enum.WANT32) {
                Default.flag(new StringRef(NativePointer.$((String)"+m32"))).flag(new StringRef(NativePointer.$((String)"-m64"))).flag(new StringRef(NativePointer.$((String)"-mx32")));
            } else if (Want == Unnamed_enum.WANT64) {
                Default.flag(new StringRef(NativePointer.$((String)"-m32"))).flag(new StringRef(NativePointer.$((String)"+m64"))).flag(new StringRef(NativePointer.$((String)"-mx32")));
            } else if (Want == Unnamed_enum.WANTX32) {
                Default.flag(new StringRef(NativePointer.$((String)"-m32"))).flag(new StringRef(NativePointer.$((String)"-m64"))).flag(new StringRef(NativePointer.$((String)"+mx32")));
            } else {
                boolean bl2 = false;
                return bl2;
            }
            Result.Multilibs.push_back(Default);
            Result.Multilibs.push_back(Alt64);
            Result.Multilibs.push_back(Alt32);
            Result.Multilibs.push_back(Altx32);
            Result.Multilibs.FilterOut(NonExistent);
            Flags = new std.vectorString(std.string.EMPTY);
            ToolChainsStatics.addMultilibFlag(TargetTriple.isArch64Bit() && !IsX32, NativePointer.$((String)"m64"), Flags);
            ToolChainsStatics.addMultilibFlag(TargetTriple.isArch32Bit(), NativePointer.$((String)"m32"), Flags);
            ToolChainsStatics.addMultilibFlag(TargetTriple.isArch64Bit() && IsX32, NativePointer.$((String)"mx32"), Flags);
            if (!Result.Multilibs.select(Flags, Result.SelectedMultilib)) {
                boolean bl3 = false;
                return bl3;
            }
            if (Result.SelectedMultilib.$eq(Alt64) || Result.SelectedMultilib.$eq(Alt32) || Result.SelectedMultilib.$eq(Altx32)) {
                Result.BiarchSibling.$assign((Object)Default);
            }
            boolean bl4 = true;
            return bl4;
        }
        finally {
            if (Flags != null) {
                Flags.$destroy();
            }
            if (NonExistent != null) {
                NonExistent.$destroy();
            }
            if (Default != null) {
                Default.$destroy();
            }
        }
    }

    public static void GetHexagonLibraryPaths(ArgList Args, std.string Ver, std.string MarchString, std.string InstalledDir, SmallVector<std.string> LibPaths) {
        boolean buildingLib = Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue()));
        arg_iterator it = Args.filtered_begin(new OptSpecifier((long)options.ID.OPT_L.getValue()));
        arg_iterator ie = Args.filtered_end();
        while (OptGlobals.$noteq_arg_iterator((arg_iterator)new arg_iterator(it), (arg_iterator)new arg_iterator(ie))) {
            long e = it.$star().getNumValues();
            for (long i = 0L; i != e; ++i) {
                LibPaths.push_back((Object)new std.string(it.$star().getValue(i)));
            }
            it.$preInc();
        }
        std.string MarchSuffix = std.$plus_T_str((Object)NativePointer.$((String)"/"), (std.string)MarchString);
        std.string G0Suffix = new std.string(NativePointer.$((String)"/G0"));
        std.string MarchG0Suffix = std.$plus_str((std.string)MarchSuffix, (std.string)G0Suffix);
        std.string RootDir = std.$plus_str_T((std.string)toolchains.Hexagon_TC.GetGnuDir(InstalledDir, Args), (char.iterator)NativePointer.$((String)"/"));
        std.string LibGCCHexagonDir = std.$plus_str_T((std.string)RootDir, (char.iterator)NativePointer.$((String)"lib/gcc/hexagon/"));
        if (buildingLib) {
            LibPaths.push_back((Object)std.$plus_str((std.string)std.$plus_str((std.string)LibGCCHexagonDir, (std.string)Ver), (std.string)MarchG0Suffix));
            LibPaths.push_back((Object)std.$plus_str((std.string)std.$plus_str((std.string)LibGCCHexagonDir, (std.string)Ver), (std.string)G0Suffix));
        }
        LibPaths.push_back((Object)std.$plus_str((std.string)std.$plus_str((std.string)LibGCCHexagonDir, (std.string)Ver), (std.string)MarchSuffix));
        LibPaths.push_back((Object)std.$plus_str((std.string)LibGCCHexagonDir, (std.string)Ver));
        LibPaths.push_back((Object)std.$plus_str_T((std.string)RootDir, (char.iterator)NativePointer.$((String)"lib/gcc")));
        std.string HexagonLibDir = std.$plus_str_T((std.string)RootDir, (char.iterator)NativePointer.$((String)"hexagon/lib"));
        if (buildingLib) {
            LibPaths.push_back((Object)std.$plus_str((std.string)HexagonLibDir, (std.string)MarchG0Suffix));
            LibPaths.push_back((Object)std.$plus_str((std.string)HexagonLibDir, (std.string)G0Suffix));
        }
        LibPaths.push_back((Object)std.$plus_str((std.string)HexagonLibDir, (std.string)MarchSuffix));
        LibPaths.push_back((Object)HexagonLibDir);
    }

    public static int getHexagonVersion(ArgList Args) {
        int.ref Val;
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_march_EQ.getValue()), new OptSpecifier((long)options.ID.OPT_mcpu_EQ.getValue()));
        if (A == null) {
            return 4;
        }
        StringRef WhichHexagon = new StringRef(A.getValue());
        if (WhichHexagon.startswith((CharSequence)"hexagonv")) {
            Val = NativePointer.create_int$ref();
            if (!WhichHexagon.substr("hexagonv".length()).getAsInteger(10, Val)) {
                return Val.$deref();
            }
        }
        if (WhichHexagon.startswith((CharSequence)"v")) {
            Val = NativePointer.create_int$ref();
            if (!WhichHexagon.substr(1).getAsInteger(10, Val)) {
                return Val.$deref();
            }
        }
        return 4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean IsRedhat(Distro Distro2) {
        if (Distro2 == Distro.Fedora) return true;
        if (Distro2.getValue() < Distro.RHEL4.getValue()) return false;
        if (Distro2.getValue() > Distro.RHEL6.getValue()) return false;
        return true;
    }

    public static boolean IsOpenSUSE(Distro Distro2) {
        return Distro2 == Distro.OpenSUSE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean IsDebian(Distro Distro2) {
        if (Distro2.getValue() < Distro.DebianLenny.getValue()) return false;
        if (Distro2.getValue() > Distro.DebianJessie.getValue()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean IsUbuntu(Distro Distro2) {
        if (Distro2.getValue() < Distro.UbuntuHardy.getValue()) return false;
        if (Distro2.getValue() > Distro.UbuntuTrusty.getValue()) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Distro DetectDistro(Triple.ArchType Arch) {
        ErrorOr File = MemoryBuffer.getFile((Twine)new Twine(NativePointer.$((String)"/etc/lsb-release")));
        if (File.$boolean()) {
            SmallVector Lines = null;
            try {
                StringRef Data = ((MemoryBuffer)((std_ptr.unique_ptr)File.get()).$arrow()).getBuffer();
                Lines = new SmallVector(16, (Object)new StringRef());
                Data.split((SmallVectorImpl)Lines, new StringRef(NativePointer.$((String)"\n")));
                Distro Version = Distro.UnknownDistro;
                long s = Lines.size();
                for (long i = 0L; i != s; ++i) {
                    if (Version != Distro.UnknownDistro || !((StringRef)Lines.$at(i)).startswith((CharSequence)"DISTRIB_CODENAME=")) continue;
                    Version = (Distro)((Object)new StringSwitch(((StringRef)Lines.$at(i)).substr(17)).Case(NativePointer.$((String)"hardy"), (Object)Distro.UbuntuHardy).Case(NativePointer.$((String)"intrepid"), (Object)Distro.UbuntuIntrepid).Case(NativePointer.$((String)"jaunty"), (Object)Distro.UbuntuJaunty).Case(NativePointer.$((String)"karmic"), (Object)Distro.UbuntuKarmic).Case(NativePointer.$((String)"lucid"), (Object)Distro.UbuntuLucid).Case(NativePointer.$((String)"maverick"), (Object)Distro.UbuntuMaverick).Case(NativePointer.$((String)"natty"), (Object)Distro.UbuntuNatty).Case(NativePointer.$((String)"oneiric"), (Object)Distro.UbuntuOneiric).Case(NativePointer.$((String)"precise"), (Object)Distro.UbuntuPrecise).Case(NativePointer.$((String)"quantal"), (Object)Distro.UbuntuQuantal).Case(NativePointer.$((String)"raring"), (Object)Distro.UbuntuRaring).Case(NativePointer.$((String)"saucy"), (Object)Distro.UbuntuSaucy).Case(NativePointer.$((String)"trusty"), (Object)Distro.UbuntuTrusty).Default((Object)Distro.UnknownDistro));
                }
                Distro distro = Version;
                return distro;
            }
            finally {
                if (Lines != null) {
                    Lines.$destroy();
                }
            }
        }
        File.$assign(MemoryBuffer.getFile((Twine)new Twine(NativePointer.$((String)"/etc/redhat-release"))));
        if (File.$boolean()) {
            StringRef Data = ((MemoryBuffer)((std_ptr.unique_ptr)File.get()).$arrow()).getBuffer();
            if (Data.startswith((CharSequence)"Fedora release")) {
                return Distro.Fedora;
            }
            if (Data.startswith((CharSequence)"Red Hat Enterprise Linux") || Data.startswith((CharSequence)"CentOS")) {
                if (Data.find((CharSequence)"release 6") != StringRef.npos) {
                    return Distro.RHEL6;
                }
                if (Data.find((CharSequence)"release 5") != StringRef.npos) {
                    return Distro.RHEL5;
                }
                if (Data.find((CharSequence)"release 4") != StringRef.npos) {
                    return Distro.RHEL4;
                }
            }
            return Distro.UnknownDistro;
        }
        File.$assign(MemoryBuffer.getFile((Twine)new Twine(NativePointer.$((String)"/etc/debian_version"))));
        if (File.$boolean()) {
            StringRef Data = ((MemoryBuffer)((std_ptr.unique_ptr)File.get()).$arrow()).getBuffer();
            if (Data.$at(0) == NativePointer.$((char)'5')) {
                return Distro.DebianLenny;
            }
            if (Data.startswith((CharSequence)"squeeze/sid") || Data.$at(0) == NativePointer.$((char)'6')) {
                return Distro.DebianSqueeze;
            }
            if (Data.startswith((CharSequence)"wheezy/sid") || Data.$at(0) == NativePointer.$((char)'7')) {
                return Distro.DebianWheezy;
            }
            if (Data.startswith((CharSequence)"jessie/sid") || Data.$at(0) == NativePointer.$((char)'8')) {
                return Distro.DebianJessie;
            }
            return Distro.UnknownDistro;
        }
        if (fs.exists((Twine)new Twine(NativePointer.$((String)"/etc/SuSE-release")))) {
            return Distro.OpenSUSE;
        }
        if (fs.exists((Twine)new Twine(NativePointer.$((String)"/etc/exherbo-release")))) {
            return Distro.Exherbo;
        }
        if (fs.exists((Twine)new Twine(NativePointer.$((String)"/etc/arch-release")))) {
            return Distro.ArchLinux;
        }
        return Distro.UnknownDistro;
    }

    public static std.string getMultiarchTriple(Triple TargetTriple, StringRef SysRoot) {
        switch (TargetTriple.getArch()) {
            default: {
                return new std.string(TargetTriple.str());
            }
            case arm: 
            case thumb: {
                if (TargetTriple.getEnvironment() == Triple.EnvironmentType.GNUEABIHF) {
                    if (fs.exists((Twine)llvm.$plus_StringRef_char$ptr((StringRef)SysRoot, (char.ptr)NativePointer.$((String)"/lib/arm-linux-gnueabihf")))) {
                        return new std.string(NativePointer.$((String)"arm-linux-gnueabihf"));
                    }
                } else if (fs.exists((Twine)llvm.$plus_StringRef_char$ptr((StringRef)SysRoot, (char.ptr)NativePointer.$((String)"/lib/arm-linux-gnueabi")))) {
                    return new std.string(NativePointer.$((String)"arm-linux-gnueabi"));
                }
                return new std.string(TargetTriple.str());
            }
            case armeb: 
            case thumbeb: {
                if (TargetTriple.getEnvironment() == Triple.EnvironmentType.GNUEABIHF) {
                    if (fs.exists((Twine)llvm.$plus_StringRef_char$ptr((StringRef)SysRoot, (char.ptr)NativePointer.$((String)"/lib/armeb-linux-gnueabihf")))) {
                        return new std.string(NativePointer.$((String)"armeb-linux-gnueabihf"));
                    }
                } else if (fs.exists((Twine)llvm.$plus_StringRef_char$ptr((StringRef)SysRoot, (char.ptr)NativePointer.$((String)"/lib/armeb-linux-gnueabi")))) {
                    return new std.string(NativePointer.$((String)"armeb-linux-gnueabi"));
                }
                return new std.string(TargetTriple.str());
            }
            case x86: {
                if (fs.exists((Twine)llvm.$plus_StringRef_char$ptr((StringRef)SysRoot, (char.ptr)NativePointer.$((String)"/lib/i386-linux-gnu")))) {
                    return new std.string(NativePointer.$((String)"i386-linux-gnu"));
                }
                return new std.string(TargetTriple.str());
            }
            case x86_64: {
                if (TargetTriple.getEnvironment() != Triple.EnvironmentType.GNUX32 && fs.exists((Twine)llvm.$plus_StringRef_char$ptr((StringRef)SysRoot, (char.ptr)NativePointer.$((String)"/lib/x86_64-linux-gnu")))) {
                    return new std.string(NativePointer.$((String)"x86_64-linux-gnu"));
                }
                return new std.string(TargetTriple.str());
            }
            case aarch64: {
                if (fs.exists((Twine)llvm.$plus_StringRef_char$ptr((StringRef)SysRoot, (char.ptr)NativePointer.$((String)"/lib/aarch64-linux-gnu")))) {
                    return new std.string(NativePointer.$((String)"aarch64-linux-gnu"));
                }
                return new std.string(TargetTriple.str());
            }
            case aarch64_be: {
                if (fs.exists((Twine)llvm.$plus_StringRef_char$ptr((StringRef)SysRoot, (char.ptr)NativePointer.$((String)"/lib/aarch64_be-linux-gnu")))) {
                    return new std.string(NativePointer.$((String)"aarch64_be-linux-gnu"));
                }
                return new std.string(TargetTriple.str());
            }
            case mips: {
                if (fs.exists((Twine)llvm.$plus_StringRef_char$ptr((StringRef)SysRoot, (char.ptr)NativePointer.$((String)"/lib/mips-linux-gnu")))) {
                    return new std.string(NativePointer.$((String)"mips-linux-gnu"));
                }
                return new std.string(TargetTriple.str());
            }
            case mipsel: {
                if (fs.exists((Twine)llvm.$plus_StringRef_char$ptr((StringRef)SysRoot, (char.ptr)NativePointer.$((String)"/lib/mipsel-linux-gnu")))) {
                    return new std.string(NativePointer.$((String)"mipsel-linux-gnu"));
                }
                return new std.string(TargetTriple.str());
            }
            case mips64: {
                if (fs.exists((Twine)llvm.$plus_StringRef_char$ptr((StringRef)SysRoot, (char.ptr)NativePointer.$((String)"/lib/mips64-linux-gnu")))) {
                    return new std.string(NativePointer.$((String)"mips64-linux-gnu"));
                }
                if (fs.exists((Twine)llvm.$plus_StringRef_char$ptr((StringRef)SysRoot, (char.ptr)NativePointer.$((String)"/lib/mips64-linux-gnuabi64")))) {
                    return new std.string(NativePointer.$((String)"mips64-linux-gnuabi64"));
                }
                return new std.string(TargetTriple.str());
            }
            case mips64el: {
                if (fs.exists((Twine)llvm.$plus_StringRef_char$ptr((StringRef)SysRoot, (char.ptr)NativePointer.$((String)"/lib/mips64el-linux-gnu")))) {
                    return new std.string(NativePointer.$((String)"mips64el-linux-gnu"));
                }
                if (fs.exists((Twine)llvm.$plus_StringRef_char$ptr((StringRef)SysRoot, (char.ptr)NativePointer.$((String)"/lib/mips64el-linux-gnuabi64")))) {
                    return new std.string(NativePointer.$((String)"mips64el-linux-gnuabi64"));
                }
                return new std.string(TargetTriple.str());
            }
            case ppc: {
                if (fs.exists((Twine)llvm.$plus_StringRef_char$ptr((StringRef)SysRoot, (char.ptr)NativePointer.$((String)"/lib/powerpc-linux-gnuspe")))) {
                    return new std.string(NativePointer.$((String)"powerpc-linux-gnuspe"));
                }
                if (fs.exists((Twine)llvm.$plus_StringRef_char$ptr((StringRef)SysRoot, (char.ptr)NativePointer.$((String)"/lib/powerpc-linux-gnu")))) {
                    return new std.string(NativePointer.$((String)"powerpc-linux-gnu"));
                }
                return new std.string(TargetTriple.str());
            }
            case ppc64: {
                if (!fs.exists((Twine)llvm.$plus_StringRef_char$ptr((StringRef)SysRoot, (char.ptr)NativePointer.$((String)"/lib/powerpc64-linux-gnu")))) break;
                return new std.string(NativePointer.$((String)"powerpc64-linux-gnu"));
            }
            case ppc64le: 
        }
        if (fs.exists((Twine)llvm.$plus_StringRef_char$ptr((StringRef)SysRoot, (char.ptr)NativePointer.$((String)"/lib/powerpc64le-linux-gnu")))) {
            return new std.string(NativePointer.$((String)"powerpc64le-linux-gnu"));
        }
        return new std.string(TargetTriple.str());
    }

    public static void addPathIfExists(Twine Path, SmallVector<std.string> Paths) {
        if (fs.exists((Twine)Path)) {
            Paths.push_back((Object)Path.str());
        }
    }

    public static StringRef getOSLibDir(Triple Triple2, ArgList Args) {
        if (ToolChainsStatics.isMipsArch(Triple2.getArch())) {
            if (mips.hasMipsAbiArg(Args, NativePointer.$((String)"n32"))) {
                return new StringRef(NativePointer.$((String)"lib32"));
            }
            return new StringRef(Triple2.isArch32Bit() ? NativePointer.$((String)"lib") : NativePointer.$((String)"lib64"));
        }
        if (Triple2.getArch() == Triple.ArchType.x86 || Triple2.getArch() == Triple.ArchType.ppc) {
            return new StringRef(NativePointer.$((String)"lib32"));
        }
        if (Triple2.getArch() == Triple.ArchType.x86_64 && Triple2.getEnvironment() == Triple.EnvironmentType.GNUX32) {
            return new StringRef(NativePointer.$((String)"libx32"));
        }
        return new StringRef(Triple2.isArch32Bit() ? NativePointer.$((String)"lib") : NativePointer.$((String)"lib64"));
    }

    private static final class Unnamed_enum
    extends Enum<Unnamed_enum> {
        public static final /* enum */ Unnamed_enum UNKNOWN = new Unnamed_enum(0L);
        public static final /* enum */ Unnamed_enum WANT32 = new Unnamed_enum(UNKNOWN.getValue() + 1);
        public static final /* enum */ Unnamed_enum WANT64 = new Unnamed_enum(WANT32.getValue() + 1);
        public static final /* enum */ Unnamed_enum WANTX32 = new Unnamed_enum(WANT64.getValue() + 1);
        private final int value;
        private static final /* synthetic */ Unnamed_enum[] $VALUES;

        public static Unnamed_enum[] values() {
            return (Unnamed_enum[])$VALUES.clone();
        }

        public static Unnamed_enum valueOf(String name) {
            return Enum.valueOf(Unnamed_enum.class, name);
        }

        public static Unnamed_enum valueOf(int val) {
            Unnamed_enum out;
            Unnamed_enum unnamed_enum = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private Unnamed_enum(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Unnamed_enum[]{UNKNOWN, WANT32, WANT64, WANTX32};
        }

        private static final class Values {
            private static final Unnamed_enum[] VALUES;
            private static final Unnamed_enum[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Unnamed_enum[min < 0 ? 1 - min : 0];
                VALUES = new Unnamed_enum[max >= 0 ? 1 + max : 0];
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Unnamed_enum)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Unnamed_enum)kind).value] = kind;
                }
            }
        }
    }
}

