/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.impl;

import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.ObjCRuntime;
import org.clang.driver.Action;
import org.clang.driver.BackendJobAction;
import org.clang.driver.Command;
import org.clang.driver.Compilation;
import org.clang.driver.CompileJobAction;
import org.clang.driver.Driver;
import org.clang.driver.JobAction;
import org.clang.driver.SanitizerArgs;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.EHFlags;
import org.clang.driver.impl.InputInfo;
import org.clang.driver.impl.toolchains;
import org.clang.driver.options;
import org.clang.driver.tools.impl.arm;
import org.clang.driver.tools.impl.mips;
import org.clang.driver.tools.impl.ppc;
import org.clang.driver.types;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.uint;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.adt.aliases.StringMapConstIteratorUInt;
import org.llvm.adt.aliases.StringMapIteratorUInt;
import org.llvm.adt.aliases.StringMapUInt;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptGlobals;
import org.llvm.option.OptSpecifier;
import org.llvm.option.Option;
import org.llvm.option.arg_iterator;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;
import org.llvm.support.sys.sys;
import org.llvm.support.zlib.ZlibGlobals;

public final class ToolsStatics {
    public static void addAssemblerKPIC(ArgList Args, ArgStringList CmdArgs) {
        Arg LastPICArg = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fPIC.getValue()), new OptSpecifier((long)options.ID.OPT_fno_PIC.getValue()), new OptSpecifier((long)options.ID.OPT_fpic.getValue()), new OptSpecifier((long)options.ID.OPT_fno_pic.getValue()), new OptSpecifier((long)options.ID.OPT_fPIE.getValue()), new OptSpecifier((long)options.ID.OPT_fno_PIE.getValue()), new OptSpecifier((long)options.ID.OPT_fpie.getValue()), new OptSpecifier((long)options.ID.OPT_fno_pie.getValue()));
        if (LastPICArg == null) {
            return;
        }
        if (LastPICArg.getOption().matches(new OptSpecifier((long)options.ID.OPT_fPIC.getValue())) || LastPICArg.getOption().matches(new OptSpecifier((long)options.ID.OPT_fpic.getValue())) || LastPICArg.getOption().matches(new OptSpecifier((long)options.ID.OPT_fPIE.getValue())) || LastPICArg.getOption().matches(new OptSpecifier((long)options.ID.OPT_fpie.getValue()))) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-KPIC"));
        }
    }

    public static void CheckPreprocessingOptions(Driver D, ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_C.getValue()), new OptSpecifier((long)options.ID.OPT_CC.getValue()));
        if (!(A == null || Args.hasArg(new OptSpecifier((long)options.ID.OPT_E.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT__SLASH_P.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT__SLASH_EP.getValue())) || D.CCCIsCPP())) {
            ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(307L), (StringRef)new StringRef(A.getBaseArg().getAsString(Args))), (char.ptr)(D.IsCLMode() ? NativePointer.$((String)"/E, /P or /EP") : NativePointer.$((String)"-E"))).$destroy();
        }
    }

    public static void CheckCodeGenerationOptions(Driver D, ArgList Args) {
        Arg A;
        if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue())) && (A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_dynamic.getValue()), new OptSpecifier((long)options.ID.OPT_mdynamic_no_pic.getValue()))) != null) {
            ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(306L), (StringRef)new StringRef(A.getAsString(Args))), (char.ptr)NativePointer.$((String)"-static")).$destroy();
        }
    }

    public static void EscapeSpacesAndBackslashes(char.ptr Arg2, SmallVectorImplChar Res) {
        while (Arg2.$star() != 0) {
            switch (Arg2.$star()) {
                default: {
                    break;
                }
                case 32: 
                case 92: {
                    Res.push_back(NativePointer.$((char)'\\'));
                }
            }
            Res.push_back(Arg2.$star());
            Arg2.$preInc();
        }
    }

    public static void QuoteTarget(StringRef Target, SmallVectorImplChar Res) {
        long e = Target.size();
        for (long i = 0L; i != e; ++i) {
            switch (Target.$at(i)) {
                case 9: 
                case 32: {
                    for (long j = i - 1L; j >= 0L && Target.$at(j) == NativePointer.$((char)'\\'); --j) {
                        Res.push_back(NativePointer.$((char)'\\'));
                    }
                    Res.push_back(NativePointer.$((char)'\\'));
                    break;
                }
                case 36: {
                    Res.push_back(NativePointer.$((char)'$'));
                    break;
                }
                case 35: {
                    Res.push_back(NativePointer.$((char)'\\'));
                    break;
                }
            }
            Res.push_back(Target.$at(i));
        }
    }

    public static void addDirectoryList(ArgList Args, ArgStringList CmdArgs, char.ptr ArgName, char.ptr EnvVar) {
        int Delim;
        StringRef Dirs;
        char.ptr DirList = Native.$tryClone((char.ptr)std.getenv((char.ptr)EnvVar));
        boolean CombinedArg = false;
        if (DirList == null) {
            return;
        }
        StringRef Name = new StringRef(ArgName);
        if (Name.equals(new StringRef(NativePointer.$((String)"-I"))) || Name.equals(new StringRef(NativePointer.$((String)"-L")))) {
            CombinedArg = true;
        }
        if ((Dirs = new StringRef(DirList)).empty()) {
            return;
        }
        while ((Delim = Dirs.find(NativePointer.$((char)sys.EnvPathSeparator))) != StringRef.npos) {
            if (Delim == 0) {
                if (CombinedArg) {
                    CmdArgs.push_back((Object)Args.MakeArgString(std.$plus_str_T((std.string)new std.string(ArgName), (char.iterator)NativePointer.$((String)"."))));
                } else {
                    CmdArgs.push_back((Object)ArgName);
                    CmdArgs.push_back((Object)NativePointer.$((String)"."));
                }
            } else if (CombinedArg) {
                CmdArgs.push_back((Object)Args.MakeArgString(llvm.$plus_Twine((Twine)new Twine(new std.string(ArgName)), (Twine)new Twine(Dirs.substr(0, Delim)))));
            } else {
                CmdArgs.push_back((Object)ArgName);
                CmdArgs.push_back((Object)Args.MakeArgString(Dirs.substr(0, Delim)));
            }
            Dirs.$assign$substr(Delim + 1);
        }
        if (Dirs.empty()) {
            if (CombinedArg) {
                CmdArgs.push_back((Object)Args.MakeArgString(std.$plus_str_T((std.string)new std.string(ArgName), (char.iterator)NativePointer.$((String)"."))));
            } else {
                CmdArgs.push_back((Object)ArgName);
                CmdArgs.push_back((Object)NativePointer.$((String)"."));
            }
        } else if (CombinedArg) {
            CmdArgs.push_back((Object)Args.MakeArgString(llvm.$plus_Twine((Twine)new Twine(new std.string(ArgName)), (Twine)new Twine(Dirs))));
        } else {
            CmdArgs.push_back((Object)ArgName);
            CmdArgs.push_back((Object)Args.MakeArgString(new StringRef(Dirs)));
        }
    }

    public static void AddLinkerInputs(ToolChain TC, SmallVector<InputInfo> Inputs, ArgList Args, ArgStringList CmdArgs) {
        Driver D = TC.getDriver();
        Args.AddAllArgValues((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_Zlinker_input.getValue()));
        for (InputInfo II : Inputs) {
            if (!(TC.HasNativeLLVMSupport() || II.getType() != types.ID.TY_LLVM_IR && II.getType() != types.ID.TY_LTO_IR && II.getType() != types.ID.TY_LLVM_BC && II.getType() != types.ID.TY_LTO_BC)) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(339L), (StringRef)new StringRef(TC.getTripleString())).$destroy();
            }
            if (II.isFilename()) {
                CmdArgs.push_back((Object)II.getFilename());
                continue;
            }
            Arg A = II.getInputArg();
            if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_Z_reserved_lib_stdcxx.getValue()))) {
                TC.AddCXXStdlibLibArgs(Args, CmdArgs);
                continue;
            }
            if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_Z_reserved_lib_cckext.getValue()))) {
                TC.AddCCKextLibArgs(Args, CmdArgs);
                continue;
            }
            if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_z.getValue()))) {
                A.claim();
                A.render(Args, (SmallVector)CmdArgs);
                continue;
            }
            A.renderAsInput(Args, (SmallVector)CmdArgs);
        }
        if (!TC.isCrossCompiling()) {
            ToolsStatics.addDirectoryList(Args, CmdArgs, NativePointer.$((String)"-L"), NativePointer.$((String)"LIBRARY_PATH"));
        }
    }

    public static boolean isObjCAutoRefCount(ArgList Args) {
        return Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fobjc_arc.getValue()), new OptSpecifier((long)options.ID.OPT_fno_objc_arc.getValue()), false);
    }

    public static boolean isObjCRuntimeLinked(ArgList Args) {
        if (ToolsStatics.isObjCAutoRefCount(Args)) {
            Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_fobjc_link_runtime.getValue()));
            return true;
        }
        return Args.hasArg(new OptSpecifier((long)options.ID.OPT_fobjc_link_runtime.getValue()));
    }

    public static boolean forwardToGCC(Option O) {
        return O.getKind() != Option.OptionClass.InputClass && !O.hasFlag(16L) && !O.hasFlag(32L);
    }

    public static boolean isSignedCharDefault(Triple Triple2) {
        switch (Triple2.getArch()) {
            default: {
                return true;
            }
            case aarch64: 
            case aarch64_be: 
            case arm: 
            case armeb: 
            case thumb: 
            case thumbeb: {
                return Triple2.isOSDarwin() || Triple2.isOSWindows();
            }
            case ppc: 
            case ppc64: {
                return Triple2.isOSDarwin();
            }
            case ppc64le: 
            case systemz: 
            case xcore: 
        }
        return false;
    }

    public static boolean isNoCommonDefault(Triple Triple2) {
        switch (Triple2.getArch()) {
            default: {
                return false;
            }
            case xcore: 
        }
        return true;
    }

    public static void getARMHWDivFeatures(Driver D, Arg A, ArgList Args, std.vectorCharPtr Features) {
        StringRef HWDiv = new StringRef(A.getValue());
        if (llvm.$eq_StringRef((StringRef)new StringRef(HWDiv), (StringRef)new StringRef(NativePointer.$((String)"arm")))) {
            Features.push_back(NativePointer.$((String)"+hwdiv-arm"));
            Features.push_back(NativePointer.$((String)"-hwdiv"));
        } else if (llvm.$eq_StringRef((StringRef)new StringRef(HWDiv), (StringRef)new StringRef(NativePointer.$((String)"thumb")))) {
            Features.push_back(NativePointer.$((String)"-hwdiv-arm"));
            Features.push_back(NativePointer.$((String)"+hwdiv"));
        } else if (llvm.$eq_StringRef((StringRef)new StringRef(HWDiv), (StringRef)new StringRef(NativePointer.$((String)"arm,thumb"))) || llvm.$eq_StringRef((StringRef)new StringRef(HWDiv), (StringRef)new StringRef(NativePointer.$((String)"thumb,arm")))) {
            Features.push_back(NativePointer.$((String)"+hwdiv-arm"));
            Features.push_back(NativePointer.$((String)"+hwdiv"));
        } else if (llvm.$eq_StringRef((StringRef)new StringRef(HWDiv), (StringRef)new StringRef(NativePointer.$((String)"none")))) {
            Features.push_back(NativePointer.$((String)"-hwdiv-arm"));
            Features.push_back(NativePointer.$((String)"-hwdiv"));
        } else {
            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(309L), (StringRef)new StringRef(A.getAsString(Args))).$destroy();
        }
    }

    public static void getARMFPUFeatures(Driver D, Arg A, ArgList Args, std.vectorCharPtr Features) {
        StringRef FPU = new StringRef(A.getValue());
        if (llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"fpa"))) || llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"fpe2"))) || llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"fpe3"))) || llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"maverick")))) {
            Features.push_back(NativePointer.$((String)"-vfp2"));
            Features.push_back(NativePointer.$((String)"-vfp3"));
            Features.push_back(NativePointer.$((String)"-neon"));
        } else if (llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"vfp")))) {
            Features.push_back(NativePointer.$((String)"+vfp2"));
            Features.push_back(NativePointer.$((String)"-neon"));
        } else if (llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"vfp3-d16"))) || llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"vfpv3-d16")))) {
            Features.push_back(NativePointer.$((String)"+vfp3"));
            Features.push_back(NativePointer.$((String)"+d16"));
            Features.push_back(NativePointer.$((String)"-neon"));
        } else if (llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"vfp3"))) || llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"vfpv3")))) {
            Features.push_back(NativePointer.$((String)"+vfp3"));
            Features.push_back(NativePointer.$((String)"-neon"));
        } else if (llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"vfp4-d16"))) || llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"vfpv4-d16")))) {
            Features.push_back(NativePointer.$((String)"+vfp4"));
            Features.push_back(NativePointer.$((String)"+d16"));
            Features.push_back(NativePointer.$((String)"-neon"));
        } else if (llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"vfp4"))) || llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"vfpv4")))) {
            Features.push_back(NativePointer.$((String)"+vfp4"));
            Features.push_back(NativePointer.$((String)"-neon"));
        } else if (llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"fp4-sp-d16"))) || llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"fpv4-sp-d16")))) {
            Features.push_back(NativePointer.$((String)"+vfp4"));
            Features.push_back(NativePointer.$((String)"+d16"));
            Features.push_back(NativePointer.$((String)"+fp-only-sp"));
            Features.push_back(NativePointer.$((String)"-neon"));
        } else if (llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"fp5-sp-d16"))) || llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"fpv5-sp-d16")))) {
            Features.push_back(NativePointer.$((String)"+fp-armv8"));
            Features.push_back(NativePointer.$((String)"+fp-only-sp"));
            Features.push_back(NativePointer.$((String)"+d16"));
            Features.push_back(NativePointer.$((String)"-neon"));
            Features.push_back(NativePointer.$((String)"-crypto"));
        } else if (llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"fp5-dp-d16"))) || llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"fpv5-dp-d16"))) || llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"fp5-d16"))) || llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"fpv5-d16")))) {
            Features.push_back(NativePointer.$((String)"+fp-armv8"));
            Features.push_back(NativePointer.$((String)"+d16"));
            Features.push_back(NativePointer.$((String)"-neon"));
            Features.push_back(NativePointer.$((String)"-crypto"));
        } else if (llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"fp-armv8")))) {
            Features.push_back(NativePointer.$((String)"+fp-armv8"));
            Features.push_back(NativePointer.$((String)"-neon"));
            Features.push_back(NativePointer.$((String)"-crypto"));
        } else if (llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"neon-fp-armv8")))) {
            Features.push_back(NativePointer.$((String)"+fp-armv8"));
            Features.push_back(NativePointer.$((String)"+neon"));
            Features.push_back(NativePointer.$((String)"-crypto"));
        } else if (llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"crypto-neon-fp-armv8")))) {
            Features.push_back(NativePointer.$((String)"+fp-armv8"));
            Features.push_back(NativePointer.$((String)"+neon"));
            Features.push_back(NativePointer.$((String)"+crypto"));
        } else if (llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"neon")))) {
            Features.push_back(NativePointer.$((String)"+neon"));
        } else if (llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"neon-vfpv3")))) {
            Features.push_back(NativePointer.$((String)"+vfp3"));
            Features.push_back(NativePointer.$((String)"+neon"));
        } else if (llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"neon-vfpv4")))) {
            Features.push_back(NativePointer.$((String)"+neon"));
            Features.push_back(NativePointer.$((String)"+vfp4"));
        } else if (llvm.$eq_StringRef((StringRef)new StringRef(FPU), (StringRef)new StringRef(NativePointer.$((String)"none")))) {
            Features.push_back(NativePointer.$((String)"-vfp2"));
            Features.push_back(NativePointer.$((String)"-vfp3"));
            Features.push_back(NativePointer.$((String)"-vfp4"));
            Features.push_back(NativePointer.$((String)"-fp-armv8"));
            Features.push_back(NativePointer.$((String)"-crypto"));
            Features.push_back(NativePointer.$((String)"-neon"));
        } else {
            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(309L), (StringRef)new StringRef(A.getAsString(Args))).$destroy();
        }
    }

    public static void getARMTargetFeatures(Driver D, Triple Triple2, ArgList Args, std.vectorCharPtr Features, boolean ForAS) {
        Arg A;
        StringRef FloatABI = arm.getARMFloatABI(D, Args, Triple2);
        if (!ForAS) {
            if (llvm.$eq_StringRef((StringRef)new StringRef(FloatABI), (StringRef)new StringRef(NativePointer.$((String)"soft")))) {
                Features.push_back(NativePointer.$((String)"+soft-float"));
            }
            if (llvm.$noteq_StringRef((StringRef)new StringRef(FloatABI), (StringRef)new StringRef(NativePointer.$((String)"hard")))) {
                Features.push_back(NativePointer.$((String)"+soft-float-abi"));
            }
        }
        if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mfpu_EQ.getValue()))) != null) {
            ToolsStatics.getARMFPUFeatures(D, A, Args, Features);
        }
        if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mhwdiv_EQ.getValue()))) != null) {
            ToolsStatics.getARMHWDivFeatures(D, A, Args, Features);
        }
        if (llvm.$eq_StringRef((StringRef)new StringRef(FloatABI), (StringRef)new StringRef(NativePointer.$((String)"soft")))) {
            Features.push_back(NativePointer.$((String)"-neon"));
            Features.push_back(NativePointer.$((String)"-crypto"));
        }
        if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mcrc.getValue()), new OptSpecifier((long)options.ID.OPT_mnocrc.getValue()))) != null) {
            if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mcrc.getValue()))) {
                Features.push_back(NativePointer.$((String)"+crc"));
            } else {
                Features.push_back(NativePointer.$((String)"-crc"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.string getAArch64TargetCPU(ArgList Args) {
        std.string CPU = null;
        try {
            std.string string2;
            CPU = new std.string();
            Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mtune_EQ.getValue()));
            if (A != null) {
                CPU.$assign(A.getValue());
            } else {
                A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mcpu_EQ.getValue()));
                if (A != null) {
                    StringRef Mcpu = new StringRef(A.getValue());
                    CPU.$assign(((StringRef)Mcpu.split((StringRef)new StringRef((char.ptr)NativePointer.$((String)"+"))).first).$basic_string());
                }
            }
            if (std.$eq_str_T((std.string)CPU, (char.iterator)NativePointer.$((String)"native"))) {
                string2 = sys.getHostCPUName().$basic_string();
                return string2;
            }
            if (CPU.size() != 0) {
                string2 = new std.string(CPU);
                return string2;
            }
            if (Args.getLastArg(new OptSpecifier((long)options.ID.OPT_arch.getValue())) != null) {
                string2 = new std.string(NativePointer.$((String)"cyclone"));
                return string2;
            }
            string2 = new std.string(NativePointer.$((String)"generic"));
            return string2;
        }
        finally {
            if (CPU != null) {
                CPU.$destroy();
            }
        }
    }

    public static StringRef getGnuCompatibleMipsABIName(StringRef ABI) {
        return (StringRef)new StringSwitch(new StringRef(ABI)).Case(NativePointer.$((String)"o32"), (Object)new StringRef(NativePointer.$((String)"32"))).Case(NativePointer.$((String)"n64"), (Object)new StringRef(NativePointer.$((String)"64"))).Default((Object)ABI);
    }

    public static StringRef getMipsFloatABI(Driver D, ArgList Args) {
        StringRef FloatABI = new StringRef();
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_msoft_float.getValue()), new OptSpecifier((long)options.ID.OPT_mhard_float.getValue()), new OptSpecifier((long)options.ID.OPT_mfloat_abi_EQ.getValue()));
        if (A != null) {
            if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_msoft_float.getValue()))) {
                FloatABI.$assign(new StringRef(NativePointer.$((String)"soft")));
            } else if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mhard_float.getValue()))) {
                FloatABI.$assign(new StringRef(NativePointer.$((String)"hard")));
            } else {
                FloatABI.$assign(new StringRef(A.getValue()));
                if (llvm.$noteq_StringRef((StringRef)new StringRef(FloatABI), (StringRef)new StringRef(NativePointer.$((String)"soft"))) && llvm.$noteq_StringRef((StringRef)new StringRef(FloatABI), (StringRef)new StringRef(NativePointer.$((String)"hard")))) {
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(325L), (StringRef)new StringRef(A.getAsString(Args))).$destroy();
                    FloatABI.$assign(new StringRef(NativePointer.$((String)"hard")));
                }
            }
        }
        if (FloatABI.empty()) {
            FloatABI.$assign(new StringRef(NativePointer.$((String)"hard")));
        }
        return FloatABI;
    }

    public static void AddTargetFeature(ArgList Args, std.vectorCharPtr Features, OptSpecifier OnOpt, OptSpecifier OffOpt, StringRef FeatureName) {
        Arg A = Args.getLastArg(new OptSpecifier(OnOpt), new OptSpecifier(OffOpt));
        if (A != null) {
            if (A.getOption().matches(new OptSpecifier(OnOpt))) {
                Features.push_back(Args.MakeArgString(llvm.$plus_char$ptr_StringRef((char.ptr)NativePointer.$((String)"+"), (StringRef)FeatureName)));
            } else {
                Features.push_back(Args.MakeArgString(llvm.$plus_T_StringRef((char.ptr)NativePointer.$((String)"-"), (StringRef)FeatureName)));
            }
        }
    }

    public static void getMIPSTargetFeatures(Driver D, Triple Triple2, ArgList Args, std.vectorCharPtr Features) {
        Arg A;
        StringRef CPUName = new StringRef();
        StringRef ABIName = new StringRef();
        mips.getMipsCPUAndABI(Args, Triple2, CPUName, ABIName);
        ABIName.$assign(ToolsStatics.getGnuCompatibleMipsABIName(new StringRef(ABIName)));
        std.string ABIFeature = ((StringRef)new StringSwitch(new StringRef(ABIName)).Case(NativePointer.$((String)"32"), (Object)new StringRef(NativePointer.$((String)"+o32"))).Case(NativePointer.$((String)"n32"), (Object)new StringRef(NativePointer.$((String)"+n32"))).Case(NativePointer.$((String)"64"), (Object)new StringRef(NativePointer.$((String)"+n64"))).Case(NativePointer.$((String)"eabi"), (Object)new StringRef(NativePointer.$((String)"+eabi"))).Default((Object)new StringRef(llvm.$plus_char$ptr_StringRef((char.ptr)NativePointer.$((String)"+"), (StringRef)ABIName).str()))).$basic_string();
        Features.push_back(NativePointer.$((String)"-o32"));
        Features.push_back(NativePointer.$((String)"-n64"));
        Features.push_back(Args.MakeArgString(new std.string(ABIFeature)));
        ToolsStatics.AddTargetFeature(Args, Features, new OptSpecifier((long)options.ID.OPT_mno_abicalls.getValue()), new OptSpecifier((long)options.ID.OPT_mabicalls.getValue()), new StringRef(NativePointer.$((String)"noabicalls")));
        StringRef FloatABI = ToolsStatics.getMipsFloatABI(D, Args);
        if (llvm.$eq_StringRef((StringRef)new StringRef(FloatABI), (StringRef)new StringRef(NativePointer.$((String)"soft")))) {
            Features.push_back(NativePointer.$((String)"+soft-float"));
        }
        if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mnan_EQ.getValue()))) != null) {
            StringRef Val = new StringRef(A.getValue());
            if (llvm.$eq_StringRef((StringRef)new StringRef(Val), (StringRef)new StringRef(NativePointer.$((String)"2008")))) {
                Features.push_back(NativePointer.$((String)"+nan2008"));
            } else if (llvm.$eq_StringRef((StringRef)new StringRef(Val), (StringRef)new StringRef(NativePointer.$((String)"legacy")))) {
                Features.push_back(NativePointer.$((String)"-nan2008"));
            } else {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(356L), (StringRef)A.getOption().getName()), (StringRef)new StringRef(Val)).$destroy();
            }
        }
        ToolsStatics.AddTargetFeature(Args, Features, new OptSpecifier((long)options.ID.OPT_msingle_float.getValue()), new OptSpecifier((long)options.ID.OPT_mdouble_float.getValue()), new StringRef(NativePointer.$((String)"single-float")));
        ToolsStatics.AddTargetFeature(Args, Features, new OptSpecifier((long)options.ID.OPT_mips16.getValue()), new OptSpecifier((long)options.ID.OPT_mno_mips16.getValue()), new StringRef(NativePointer.$((String)"mips16")));
        ToolsStatics.AddTargetFeature(Args, Features, new OptSpecifier((long)options.ID.OPT_mmicromips.getValue()), new OptSpecifier((long)options.ID.OPT_mno_micromips.getValue()), new StringRef(NativePointer.$((String)"micromips")));
        ToolsStatics.AddTargetFeature(Args, Features, new OptSpecifier((long)options.ID.OPT_mdsp.getValue()), new OptSpecifier((long)options.ID.OPT_mno_dsp.getValue()), new StringRef(NativePointer.$((String)"dsp")));
        ToolsStatics.AddTargetFeature(Args, Features, new OptSpecifier((long)options.ID.OPT_mdspr2.getValue()), new OptSpecifier((long)options.ID.OPT_mno_dspr2.getValue()), new StringRef(NativePointer.$((String)"dspr2")));
        ToolsStatics.AddTargetFeature(Args, Features, new OptSpecifier((long)options.ID.OPT_mmsa.getValue()), new OptSpecifier((long)options.ID.OPT_mno_msa.getValue()), new StringRef(NativePointer.$((String)"msa")));
        A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mfp32.getValue()), new OptSpecifier((long)options.ID.OPT_mfpxx.getValue()), new OptSpecifier((long)options.ID.OPT_mfp64.getValue()));
        if (A != null) {
            if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mfp32.getValue()))) {
                Features.push_back(Args.MakeArgString(NativePointer.$((String)"-fp64")));
            } else if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mfpxx.getValue()))) {
                Features.push_back(Args.MakeArgString(NativePointer.$((String)"+fpxx")));
                Features.push_back(Args.MakeArgString(NativePointer.$((String)"+nooddspreg")));
            } else {
                Features.push_back(Args.MakeArgString(NativePointer.$((String)"+fp64")));
            }
        } else if (mips.isFPXXDefault(Triple2, new StringRef(CPUName), new StringRef(ABIName))) {
            Features.push_back(Args.MakeArgString(NativePointer.$((String)"+fpxx")));
            Features.push_back(Args.MakeArgString(NativePointer.$((String)"+nooddspreg")));
        }
        ToolsStatics.AddTargetFeature(Args, Features, new OptSpecifier((long)options.ID.OPT_mno_odd_spreg.getValue()), new OptSpecifier((long)options.ID.OPT_modd_spreg.getValue()), new StringRef(NativePointer.$((String)"nooddspreg")));
    }

    public static std.string getPPCTargetCPU(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mcpu_EQ.getValue()));
        if (A != null) {
            StringRef CPUName = new StringRef(A.getValue());
            if (llvm.$eq_StringRef((StringRef)new StringRef(CPUName), (StringRef)new StringRef(NativePointer.$((String)"native")))) {
                std.string CPU = sys.getHostCPUName().$basic_string();
                if (!CPU.empty() && std.$noteq_str_T((std.string)CPU, (char.iterator)NativePointer.$((String)"generic"))) {
                    return CPU;
                }
                return new std.string(NativePointer.$((String)""));
            }
            return new std.string((char.ptr)new StringSwitch(new StringRef(CPUName)).Case(NativePointer.$((String)"common"), (Object)NativePointer.$((String)"generic")).Case(NativePointer.$((String)"440"), (Object)NativePointer.$((String)"440")).Case(NativePointer.$((String)"440fp"), (Object)NativePointer.$((String)"440")).Case(NativePointer.$((String)"450"), (Object)NativePointer.$((String)"450")).Case(NativePointer.$((String)"601"), (Object)NativePointer.$((String)"601")).Case(NativePointer.$((String)"602"), (Object)NativePointer.$((String)"602")).Case(NativePointer.$((String)"603"), (Object)NativePointer.$((String)"603")).Case(NativePointer.$((String)"603e"), (Object)NativePointer.$((String)"603e")).Case(NativePointer.$((String)"603ev"), (Object)NativePointer.$((String)"603ev")).Case(NativePointer.$((String)"604"), (Object)NativePointer.$((String)"604")).Case(NativePointer.$((String)"604e"), (Object)NativePointer.$((String)"604e")).Case(NativePointer.$((String)"620"), (Object)NativePointer.$((String)"620")).Case(NativePointer.$((String)"630"), (Object)NativePointer.$((String)"pwr3")).Case(NativePointer.$((String)"G3"), (Object)NativePointer.$((String)"g3")).Case(NativePointer.$((String)"7400"), (Object)NativePointer.$((String)"7400")).Case(NativePointer.$((String)"G4"), (Object)NativePointer.$((String)"g4")).Case(NativePointer.$((String)"7450"), (Object)NativePointer.$((String)"7450")).Case(NativePointer.$((String)"G4+"), (Object)NativePointer.$((String)"g4+")).Case(NativePointer.$((String)"750"), (Object)NativePointer.$((String)"750")).Case(NativePointer.$((String)"970"), (Object)NativePointer.$((String)"970")).Case(NativePointer.$((String)"G5"), (Object)NativePointer.$((String)"g5")).Case(NativePointer.$((String)"a2"), (Object)NativePointer.$((String)"a2")).Case(NativePointer.$((String)"a2q"), (Object)NativePointer.$((String)"a2q")).Case(NativePointer.$((String)"e500mc"), (Object)NativePointer.$((String)"e500mc")).Case(NativePointer.$((String)"e5500"), (Object)NativePointer.$((String)"e5500")).Case(NativePointer.$((String)"power3"), (Object)NativePointer.$((String)"pwr3")).Case(NativePointer.$((String)"power4"), (Object)NativePointer.$((String)"pwr4")).Case(NativePointer.$((String)"power5"), (Object)NativePointer.$((String)"pwr5")).Case(NativePointer.$((String)"power5x"), (Object)NativePointer.$((String)"pwr5x")).Case(NativePointer.$((String)"power6"), (Object)NativePointer.$((String)"pwr6")).Case(NativePointer.$((String)"power6x"), (Object)NativePointer.$((String)"pwr6x")).Case(NativePointer.$((String)"power7"), (Object)NativePointer.$((String)"pwr7")).Case(NativePointer.$((String)"power8"), (Object)NativePointer.$((String)"pwr8")).Case(NativePointer.$((String)"pwr3"), (Object)NativePointer.$((String)"pwr3")).Case(NativePointer.$((String)"pwr4"), (Object)NativePointer.$((String)"pwr4")).Case(NativePointer.$((String)"pwr5"), (Object)NativePointer.$((String)"pwr5")).Case(NativePointer.$((String)"pwr5x"), (Object)NativePointer.$((String)"pwr5x")).Case(NativePointer.$((String)"pwr6"), (Object)NativePointer.$((String)"pwr6")).Case(NativePointer.$((String)"pwr6x"), (Object)NativePointer.$((String)"pwr6x")).Case(NativePointer.$((String)"pwr7"), (Object)NativePointer.$((String)"pwr7")).Case(NativePointer.$((String)"pwr8"), (Object)NativePointer.$((String)"pwr8")).Case(NativePointer.$((String)"powerpc"), (Object)NativePointer.$((String)"ppc")).Case(NativePointer.$((String)"powerpc64"), (Object)NativePointer.$((String)"ppc64")).Case(NativePointer.$((String)"powerpc64le"), (Object)NativePointer.$((String)"ppc64le")).Default((Object)NativePointer.$((String)"")));
        }
        return new std.string(NativePointer.$((String)""));
    }

    public static void getPPCTargetFeatures(ArgList Args, std.vectorCharPtr Features) {
        arg_iterator it = Args.filtered_begin(new OptSpecifier((long)options.ID.OPT_m_ppc_Features_Group.getValue()));
        arg_iterator ie = Args.filtered_end();
        while (OptGlobals.$noteq_arg_iterator((arg_iterator)new arg_iterator(it), (arg_iterator)new arg_iterator(ie))) {
            StringRef Name = it.$star().getOption().getName();
            it.$star().claim();
            assert (Name.startswith((CharSequence)"m")) : "Invalid feature name.";
            Name.$assign(Name.substr(1));
            boolean IsNegative = Name.startswith((CharSequence)"no-");
            if (IsNegative) {
                Name.$assign(Name.substr(3));
            }
            if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"mfcrf")))) {
                Name.$assign(new StringRef(NativePointer.$((String)"mfocrf")));
            }
            Features.push_back(Args.MakeArgString(llvm.$plus_char$ptr_StringRef((char.ptr)(IsNegative ? NativePointer.$((String)"-") : NativePointer.$((String)"+")), (StringRef)Name)));
            it.$preInc();
        }
        ToolsStatics.AddTargetFeature(Args, Features, new OptSpecifier((long)options.ID.OPT_faltivec.getValue()), new OptSpecifier((long)options.ID.OPT_fno_altivec.getValue()), new StringRef(NativePointer.$((String)"altivec")));
    }

    public static std.string getR600TargetGPU(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mcpu_EQ.getValue()));
        if (A != null) {
            char.ptr GPUName = Native.$tryClone((char.ptr)A.getValue());
            return new std.string((char.ptr)new StringSwitch(new StringRef(GPUName)).Cases(NativePointer.$((String)"rv630"), NativePointer.$((String)"rv635"), (Object)NativePointer.$((String)"r600")).Cases(NativePointer.$((String)"rv610"), NativePointer.$((String)"rv620"), NativePointer.$((String)"rs780"), (Object)NativePointer.$((String)"rs880")).Case(NativePointer.$((String)"rv740"), (Object)NativePointer.$((String)"rv770")).Case(NativePointer.$((String)"palm"), (Object)NativePointer.$((String)"cedar")).Cases(NativePointer.$((String)"sumo"), NativePointer.$((String)"sumo2"), (Object)NativePointer.$((String)"sumo")).Case(NativePointer.$((String)"hemlock"), (Object)NativePointer.$((String)"cypress")).Case(NativePointer.$((String)"aruba"), (Object)NativePointer.$((String)"cayman")).Default((Object)GPUName));
        }
        return new std.string(NativePointer.$((String)""));
    }

    public static void getSparcTargetFeatures(ArgList Args, std.vectorCharPtr Features) {
        boolean SoftFloatABI = true;
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_msoft_float.getValue()), new OptSpecifier((long)options.ID.OPT_mhard_float.getValue()));
        if (A != null && A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mhard_float.getValue()))) {
            SoftFloatABI = false;
        }
        if (SoftFloatABI) {
            Features.push_back(NativePointer.$((String)"+soft-float"));
        }
    }

    public static char.ptr getSystemZTargetCPU(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_march_EQ.getValue()));
        if (A != null) {
            return A.getValue();
        }
        return NativePointer.$((String)"z10");
    }

    public static char.ptr getX86TargetCPU(ArgList Args, Triple Triple2) {
        boolean Is64Bit;
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_march_EQ.getValue()));
        if (A != null) {
            if (llvm.$noteq_StringRef((StringRef)new StringRef(A.getValue()), (StringRef)new StringRef(NativePointer.$((String)"native")))) {
                if (Triple2.isOSDarwin() && llvm.$eq_StringRef((StringRef)Triple2.getArchName(), (StringRef)new StringRef(NativePointer.$((String)"x86_64h")))) {
                    return NativePointer.$((String)"core-avx2");
                }
                return A.getValue();
            }
            std.string CPU = sys.getHostCPUName().$basic_string();
            if (!CPU.empty() && std.$noteq_str_T((std.string)CPU, (char.iterator)NativePointer.$((String)"generic"))) {
                return Args.MakeArgString(new std.string(CPU));
            }
        }
        if (Triple2.getArch() != Triple.ArchType.x86_64 && Triple2.getArch() != Triple.ArchType.x86) {
            return null;
        }
        boolean bl = Is64Bit = Triple2.getArch() == Triple.ArchType.x86_64;
        if (Triple2.isOSDarwin()) {
            if (llvm.$eq_StringRef((StringRef)Triple2.getArchName(), (StringRef)new StringRef(NativePointer.$((String)"x86_64h")))) {
                return NativePointer.$((String)"core-avx2");
            }
            return Is64Bit ? NativePointer.$((String)"core2") : NativePointer.$((String)"yonah");
        }
        if (Triple2.getEnvironment() == Triple.EnvironmentType.Android) {
            return Is64Bit ? NativePointer.$((String)"x86-64") : NativePointer.$((String)"i686");
        }
        if (Is64Bit) {
            return NativePointer.$((String)"x86-64");
        }
        switch (Triple2.getOS()) {
            case FreeBSD: 
            case NetBSD: 
            case OpenBSD: {
                return NativePointer.$((String)"i486");
            }
            case Haiku: {
                return NativePointer.$((String)"i586");
            }
            case Bitrig: {
                return NativePointer.$((String)"i686");
            }
        }
        return NativePointer.$((String)"pentium4");
    }

    public static std.string getCPUName(ArgList Args, Triple T) {
        switch (T.getArch()) {
            default: {
                return new std.string(NativePointer.$((String)""));
            }
            case aarch64: 
            case aarch64_be: {
                return ToolsStatics.getAArch64TargetCPU(Args);
            }
            case arm: 
            case armeb: 
            case thumb: 
            case thumbeb: {
                return arm.getARMTargetCPU(Args, T).$basic_string();
            }
            case mips: 
            case mipsel: 
            case mips64: 
            case mips64el: {
                StringRef CPUName = new StringRef();
                StringRef ABIName = new StringRef();
                mips.getMipsCPUAndABI(Args, T, CPUName, ABIName);
                return CPUName.$basic_string();
            }
            case ppc: 
            case ppc64: 
            case ppc64le: {
                std.string TargetCPUName = ToolsStatics.getPPCTargetCPU(Args);
                if (TargetCPUName.empty() && !T.isOSDarwin()) {
                    if (T.getArch() == Triple.ArchType.ppc64) {
                        TargetCPUName.$assign(NativePointer.$((String)"ppc64"));
                    } else if (T.getArch() == Triple.ArchType.ppc64le) {
                        TargetCPUName.$assign(NativePointer.$((String)"ppc64le"));
                    } else {
                        TargetCPUName.$assign(NativePointer.$((String)"ppc"));
                    }
                }
                return TargetCPUName;
            }
            case sparc: 
            case sparcv9: {
                Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mcpu_EQ.getValue()));
                if (A != null) {
                    return new std.string(A.getValue());
                }
                return new std.string(NativePointer.$((String)""));
            }
            case x86: 
            case x86_64: {
                return new std.string(ToolsStatics.getX86TargetCPU(Args, T));
            }
            case hexagon: {
                return std.$plus_T_str((Object)NativePointer.$((String)"hexagon"), (std.string)toolchains.Hexagon_TC.GetTargetCPU(Args).str());
            }
            case systemz: {
                return new std.string(ToolsStatics.getSystemZTargetCPU(Args));
            }
            case r600: 
            case amdgcn: 
        }
        return ToolsStatics.getR600TargetGPU(Args);
    }

    public static void AddGoldPlugin(ToolChain ToolChain2, ArgList Args, ArgStringList CmdArgs) {
        CmdArgs.push_back((Object)NativePointer.$((String)"-plugin"));
        std.string Plugin = std.$plus_str_T((std.string)ToolChain2.getDriver().Dir, (char.iterator)NativePointer.$((String)"/../lib/LLVMgold.so"));
        CmdArgs.push_back((Object)Args.MakeArgString(new std.string(Plugin)));
        std.string CPU = ToolsStatics.getCPUName(Args, ToolChain2.getTriple());
        if (!CPU.empty()) {
            CmdArgs.push_back((Object)Args.MakeArgString(llvm.$plus_Twine((Twine)new Twine(NativePointer.$((String)"-plugin-opt=mcpu=")), (Twine)new Twine(CPU))));
        }
    }

    public static void getX86TargetFeatures(Driver D, Triple Triple2, ArgList Args, std.vectorCharPtr Features) {
        Arg A;
        if (llvm.$eq_StringRef((StringRef)Triple2.getArchName(), (StringRef)new StringRef(NativePointer.$((String)"x86_64h")))) {
            Features.push_back(NativePointer.$((String)"-rdrnd"));
            Features.push_back(NativePointer.$((String)"-aes"));
            Features.push_back(NativePointer.$((String)"-pclmul"));
            Features.push_back(NativePointer.$((String)"-rtm"));
            Features.push_back(NativePointer.$((String)"-hle"));
            Features.push_back(NativePointer.$((String)"-fsgsbase"));
        }
        if (Triple2.getEnvironment() == Triple.EnvironmentType.Android) {
            if (Triple2.getArch() == Triple.ArchType.x86_64) {
                Features.push_back(NativePointer.$((String)"+sse4.2"));
                Features.push_back(NativePointer.$((String)"+popcnt"));
            } else {
                Features.push_back(NativePointer.$((String)"+ssse3"));
            }
        }
        if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT__SLASH_arch.getValue()))) != null) {
            StringRef Arch = new StringRef(A.getValue());
            boolean ArchUsed = false;
            if ((Triple2.getArch() == Triple.ArchType.x86_64 || Triple2.getArch() == Triple.ArchType.x86) && (llvm.$eq_StringRef((StringRef)new StringRef(Arch), (StringRef)new StringRef(NativePointer.$((String)"AVX"))) || llvm.$eq_StringRef((StringRef)new StringRef(Arch), (StringRef)new StringRef(NativePointer.$((String)"AVX2"))))) {
                ArchUsed = true;
                Features.push_back(Args.MakeArgString(std.$plus_T_str((Object)NativePointer.$((String)"+"), (std.string)Arch.lower())));
            }
            if (Triple2.getArch() == Triple.ArchType.x86) {
                if (llvm.$eq_StringRef((StringRef)new StringRef(Arch), (StringRef)new StringRef(NativePointer.$((String)"IA32")))) {
                    ArchUsed = true;
                } else if (llvm.$eq_StringRef((StringRef)new StringRef(Arch), (StringRef)new StringRef(NativePointer.$((String)"SSE"))) || llvm.$eq_StringRef((StringRef)new StringRef(Arch), (StringRef)new StringRef(NativePointer.$((String)"SSE2")))) {
                    ArchUsed = true;
                    Features.push_back(Args.MakeArgString(std.$plus_T_str((Object)NativePointer.$((String)"+"), (std.string)Arch.lower())));
                }
            }
            if (!ArchUsed) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(379L), (StringRef)new StringRef(A.getAsString(Args))).$destroy();
            }
        }
        arg_iterator it = Args.filtered_begin(new OptSpecifier((long)options.ID.OPT_m_x86_Features_Group.getValue()));
        arg_iterator ie = Args.filtered_end();
        while (OptGlobals.$noteq_arg_iterator((arg_iterator)new arg_iterator(it), (arg_iterator)new arg_iterator(ie))) {
            StringRef Name = it.$star().getOption().getName();
            it.$star().claim();
            assert (Name.startswith((CharSequence)"m")) : "Invalid feature name.";
            Name.$assign(Name.substr(1));
            boolean IsNegative = Name.startswith((CharSequence)"no-");
            if (IsNegative) {
                Name.$assign(Name.substr(3));
            }
            Features.push_back(Args.MakeArgString(llvm.$plus_char$ptr_StringRef((char.ptr)(IsNegative ? NativePointer.$((String)"-") : NativePointer.$((String)"+")), (StringRef)Name)));
            it.$preInc();
        }
    }

    public static boolean HasPICArg(ArgList Args) {
        return Args.hasArg(new OptSpecifier((long)options.ID.OPT_fPIC.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_fpic.getValue()));
    }

    public static Arg GetLastSmallDataThresholdArg(ArgList Args) {
        return Args.getLastArg(new OptSpecifier((long)options.ID.OPT_G.getValue()), new OptSpecifier((long)options.ID.OPT_G_EQ.getValue()), new OptSpecifier((long)options.ID.OPT_msmall_data_threshold_EQ.getValue()));
    }

    public static std.string GetHexagonSmallDataThresholdValue(ArgList Args) {
        std.string value = null;
        try {
            value = new std.string();
            if (ToolsStatics.HasPICArg(Args)) {
                value.$assign(NativePointer.$((String)"0"));
            } else {
                Arg A = ToolsStatics.GetLastSmallDataThresholdArg(Args);
                if (A != null) {
                    value.$assign(A.getValue());
                    A.claim();
                }
            }
            std.string string2 = new std.string(value);
            return string2;
        }
        finally {
            if (value != null) {
                value.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean DecodeAArch64Features(Driver D, StringRef text, std.vectorCharPtr Features) {
        SmallVector Split = null;
        try {
            Split = new SmallVector(8, (Object)new StringRef());
            text.split((SmallVectorImpl)Split, new StringRef(NativePointer.$((String)"+")), -1, false);
            long E = Split.size();
            for (long I = 0L; I != E; ++I) {
                char.ptr result = Native.$tryClone((char.ptr)((char.ptr)new StringSwitch(new StringRef((StringRef)Split.$at(I))).Case(NativePointer.$((String)"fp"), (Object)NativePointer.$((String)"+fp-armv8")).Case(NativePointer.$((String)"simd"), (Object)NativePointer.$((String)"+neon")).Case(NativePointer.$((String)"crc"), (Object)NativePointer.$((String)"+crc")).Case(NativePointer.$((String)"crypto"), (Object)NativePointer.$((String)"+crypto")).Case(NativePointer.$((String)"nofp"), (Object)NativePointer.$((String)"-fp-armv8")).Case(NativePointer.$((String)"nosimd"), (Object)NativePointer.$((String)"-neon")).Case(NativePointer.$((String)"nocrc"), (Object)NativePointer.$((String)"-crc")).Case(NativePointer.$((String)"nocrypto"), (Object)NativePointer.$((String)"-crypto")).Default(null)));
                if (result != null) {
                    Features.push_back(result);
                    continue;
                }
                if (llvm.$eq_StringRef((StringRef)new StringRef((StringRef)Split.$at(I)), (StringRef)new StringRef(NativePointer.$((String)"neon"))) || llvm.$eq_StringRef((StringRef)new StringRef((StringRef)Split.$at(I)), (StringRef)new StringRef(NativePointer.$((String)"noneon")))) {
                    D.Diag(341L).$destroy();
                    continue;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (Split != null) {
                Split.$destroy();
            }
        }
    }

    public static boolean DecodeAArch64Mcpu(Driver D, StringRef Mcpu, StringRef CPU, std.vectorCharPtr Features) {
        std.pair Split = Mcpu.split(new StringRef(NativePointer.$((String)"+")));
        CPU.$assign((StringRef)Split.first);
        if (llvm.$eq_StringRef((StringRef)new StringRef(CPU), (StringRef)new StringRef(NativePointer.$((String)"cyclone"))) || llvm.$eq_StringRef((StringRef)new StringRef(CPU), (StringRef)new StringRef(NativePointer.$((String)"cortex-a53"))) || llvm.$eq_StringRef((StringRef)new StringRef(CPU), (StringRef)new StringRef(NativePointer.$((String)"cortex-a57")))) {
            Features.push_back(NativePointer.$((String)"+neon"));
            Features.push_back(NativePointer.$((String)"+crc"));
            Features.push_back(NativePointer.$((String)"+crypto"));
        } else if (llvm.$eq_StringRef((StringRef)new StringRef(CPU), (StringRef)new StringRef(NativePointer.$((String)"generic")))) {
            Features.push_back(NativePointer.$((String)"+neon"));
        } else {
            return false;
        }
        return ((StringRef)Split.second).size() == 0 || ToolsStatics.DecodeAArch64Features(D, new StringRef((StringRef)Split.second), Features);
    }

    public static boolean getAArch64ArchFeaturesFromMarch(Driver D, StringRef March, ArgList Args, std.vectorCharPtr Features) {
        std.pair Split = March.split(new StringRef(NativePointer.$((String)"+")));
        if (llvm.$noteq_StringRef((StringRef)new StringRef((StringRef)Split.first), (StringRef)new StringRef(NativePointer.$((String)"armv8-a")))) {
            return false;
        }
        return ((StringRef)Split.second).size() == 0 || ToolsStatics.DecodeAArch64Features(D, new StringRef((StringRef)Split.second), Features);
    }

    public static boolean getAArch64ArchFeaturesFromMcpu(Driver D, StringRef Mcpu, ArgList Args, std.vectorCharPtr Features) {
        StringRef CPU = new StringRef();
        return ToolsStatics.DecodeAArch64Mcpu(D, new StringRef(Mcpu), CPU, Features);
    }

    public static boolean getAArch64MicroArchFeaturesFromMtune(Driver D, StringRef Mtune, ArgList Args, std.vectorCharPtr Features) {
        if (llvm.$eq_StringRef((StringRef)new StringRef(Mtune), (StringRef)new StringRef(NativePointer.$((String)"native")))) {
            Mtune.$assign(sys.getHostCPUName());
        }
        if (llvm.$eq_StringRef((StringRef)new StringRef(Mtune), (StringRef)new StringRef(NativePointer.$((String)"cyclone")))) {
            Features.push_back(NativePointer.$((String)"+zcm"));
            Features.push_back(NativePointer.$((String)"+zcz"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getAArch64MicroArchFeaturesFromMcpu(Driver D, StringRef Mcpu, ArgList Args, std.vectorCharPtr Features) {
        std.vectorCharPtr DecodedFeature = null;
        try {
            StringRef CPU = new StringRef();
            DecodedFeature = new std.vectorCharPtr();
            if (!ToolsStatics.DecodeAArch64Mcpu(D, new StringRef(Mcpu), CPU, DecodedFeature)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = ToolsStatics.getAArch64MicroArchFeaturesFromMtune(D, new StringRef(CPU), Args, Features);
            return bl;
        }
        finally {
            if (DecodedFeature != null) {
                DecodedFeature.$destroy();
            }
        }
    }

    public static void getAArch64TargetFeatures(Driver D, ArgList Args, std.vectorCharPtr Features) {
        boolean success = true;
        Features.push_back(NativePointer.$((String)"+neon"));
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_march_EQ.getValue()));
        if (A != null) {
            success = ToolsStatics.getAArch64ArchFeaturesFromMarch(D, new StringRef(A.getValue()), Args, Features);
        } else {
            A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mcpu_EQ.getValue()));
            if (A != null) {
                success = ToolsStatics.getAArch64ArchFeaturesFromMcpu(D, new StringRef(A.getValue()), Args, Features);
            } else if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_arch.getValue()))) {
                success = ToolsStatics.getAArch64ArchFeaturesFromMcpu(D, new StringRef(ToolsStatics.getAArch64TargetCPU(Args)), Args, Features);
            }
        }
        if (success && (A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mtune_EQ.getValue()))) != null) {
            success = ToolsStatics.getAArch64MicroArchFeaturesFromMtune(D, new StringRef(A.getValue()), Args, Features);
        } else if (success && (A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mcpu_EQ.getValue()))) != null) {
            success = ToolsStatics.getAArch64MicroArchFeaturesFromMcpu(D, new StringRef(A.getValue()), Args, Features);
        } else if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_arch.getValue()))) {
            success = ToolsStatics.getAArch64MicroArchFeaturesFromMcpu(D, new StringRef(ToolsStatics.getAArch64TargetCPU(Args)), Args, Features);
        }
        if (!success) {
            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(309L), (StringRef)new StringRef(A.getAsString(Args))).$destroy();
        }
        if (Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mgeneral_regs_only.getValue())) != null) {
            Features.push_back(NativePointer.$((String)"-fp-armv8"));
            Features.push_back(NativePointer.$((String)"-crypto"));
            Features.push_back(NativePointer.$((String)"-neon"));
        }
        if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mcrc.getValue()), new OptSpecifier((long)options.ID.OPT_mnocrc.getValue()))) != null) {
            if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mcrc.getValue()))) {
                Features.push_back(NativePointer.$((String)"+crc"));
            } else {
                Features.push_back(NativePointer.$((String)"-crc"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getTargetFeatures(Driver D, Triple Triple2, ArgList Args, ArgStringList CmdArgs, boolean ForAS) {
        std.vectorCharPtr Features = null;
        StringMapUInt LastOpt = null;
        try {
            char.ptr Name;
            long I;
            Features = new std.vectorCharPtr();
            switch (Triple2.getArch()) {
                default: {
                    break;
                }
                case mips: 
                case mipsel: 
                case mips64: 
                case mips64el: {
                    ToolsStatics.getMIPSTargetFeatures(D, Triple2, Args, Features);
                    break;
                }
                case arm: 
                case armeb: 
                case thumb: 
                case thumbeb: {
                    ToolsStatics.getARMTargetFeatures(D, Triple2, Args, Features, ForAS);
                    break;
                }
                case ppc: 
                case ppc64: 
                case ppc64le: {
                    ToolsStatics.getPPCTargetFeatures(Args, Features);
                    break;
                }
                case sparc: 
                case sparcv9: {
                    ToolsStatics.getSparcTargetFeatures(Args, Features);
                    break;
                }
                case aarch64: 
                case aarch64_be: {
                    ToolsStatics.getAArch64TargetFeatures(D, Args, Features);
                    break;
                }
                case x86: 
                case x86_64: {
                    ToolsStatics.getX86TargetFeatures(D, Triple2, Args, Features);
                }
            }
            LastOpt = new StringMapUInt(0L);
            long N = Features.size();
            for (I = 0L; I < N; ++I) {
                Name = Native.$tryClone((char.ptr)Features.$at(I));
                assert (Name.$at(0) == 45 || Name.$at(0) == 43);
                LastOpt.ref$at(new StringRef((char.ptr)Name.$add(1))).$set(I);
            }
            N = Features.size();
            for (I = 0L; I < N; ++I) {
                Name = Native.$tryClone((char.ptr)Features.$at(I));
                StringMapIteratorUInt LastI = LastOpt.find(new StringRef((char.ptr)Name.$add(1)));
                assert (LastI.$noteq((StringMapConstIteratorUInt)LastOpt.end()));
                long Last = LastI.$arrow().second;
                if (Last != I) continue;
                CmdArgs.push_back((Object)NativePointer.$((String)"-target-feature"));
                CmdArgs.push_back((Object)Name);
            }
        }
        finally {
            if (LastOpt != null) {
                LastOpt.$destroy();
            }
            if (Features != null) {
                Features.$destroy();
            }
        }
    }

    public static boolean shouldUseExceptionTablesForObjCExceptions(ObjCRuntime runtime, Triple Triple2) {
        if (runtime.isNonFragile()) {
            return true;
        }
        if (!Triple2.isMacOSX()) {
            return false;
        }
        return Triple2.isMacOSXVersionLT(10L, 5L) == 0L && (Triple2.getArch() == Triple.ArchType.x86_64 || Triple2.getArch() == Triple.ArchType.arm);
    }

    public static boolean exceptionSettings(ArgList Args, Triple Triple2) {
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fexceptions.getValue()), new OptSpecifier((long)options.ID.OPT_fno_exceptions.getValue()));
        return A != null && A.getOption().matches(new OptSpecifier((long)options.ID.OPT_fexceptions.getValue()));
    }

    public static void addExceptionArgs(ArgList Args, types.ID InputType, Triple Triple2, boolean KernelOrKext, ObjCRuntime objcRuntime, ArgStringList CmdArgs) {
        if (KernelOrKext) {
            Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_fexceptions.getValue()));
            Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_fno_exceptions.getValue()));
            Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_fobjc_exceptions.getValue()));
            Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_fno_objc_exceptions.getValue()));
            Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_fcxx_exceptions.getValue()));
            Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_fno_cxx_exceptions.getValue()));
            return;
        }
        boolean EH = ToolsStatics.exceptionSettings(Args, Triple2);
        if (types.isObjC(InputType) && Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fobjc_exceptions.getValue()), new OptSpecifier((long)options.ID.OPT_fno_objc_exceptions.getValue()), true)) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-fobjc-exceptions"));
            EH |= ToolsStatics.shouldUseExceptionTablesForObjCExceptions(objcRuntime, Triple2);
        }
        if (types.isCXX(InputType)) {
            boolean CXXExceptionsEnabled = Triple2.getArch() != Triple.ArchType.xcore;
            Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fcxx_exceptions.getValue()), new OptSpecifier((long)options.ID.OPT_fno_cxx_exceptions.getValue()), new OptSpecifier((long)options.ID.OPT_fexceptions.getValue()), new OptSpecifier((long)options.ID.OPT_fno_exceptions.getValue()));
            if (A != null) {
                boolean bl = CXXExceptionsEnabled = A.getOption().matches(new OptSpecifier((long)options.ID.OPT_fcxx_exceptions.getValue())) || A.getOption().matches(new OptSpecifier((long)options.ID.OPT_fexceptions.getValue()));
            }
            if (CXXExceptionsEnabled) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fcxx-exceptions"));
                EH = true;
            }
        }
        if (EH) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-fexceptions"));
        }
    }

    public static boolean ShouldDisableAutolink(ArgList Args, ToolChain TC) {
        boolean Default = true;
        if (TC.getTriple().isOSDarwin()) {
            Default = TC.useIntegratedAs();
        }
        return !Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fautolink.getValue()), new OptSpecifier((long)options.ID.OPT_fno_autolink.getValue()), Default);
    }

    public static boolean ShouldDisableDwarfDirectory(ArgList Args, ToolChain TC) {
        boolean UseDwarfDirectory = Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fdwarf_directory_asm.getValue()), new OptSpecifier((long)options.ID.OPT_fno_dwarf_directory_asm.getValue()), TC.useIntegratedAs());
        return !UseDwarfDirectory;
    }

    public static boolean ContainsCompileAction(Action A) {
        if (llvm.isa(CompileJobAction.class, (Object)A) || llvm.isa(BackendJobAction.class, (Object)A)) {
            return true;
        }
        for (Action Act : A) {
            if (!ToolsStatics.ContainsCompileAction(Act)) continue;
            return true;
        }
        return false;
    }

    public static boolean UseRelaxAll(Compilation C, ArgList Args) {
        boolean RelaxDefault = true;
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_O_Group.getValue()));
        if (A != null) {
            RelaxDefault = A.getOption().matches(new OptSpecifier((long)options.ID.OPT_O0.getValue()));
        }
        if (RelaxDefault) {
            RelaxDefault = false;
            for (Action Act : C.getActions()) {
                if (!ToolsStatics.ContainsCompileAction(Act)) continue;
                RelaxDefault = true;
                break;
            }
        }
        return Args.hasFlag(new OptSpecifier((long)options.ID.OPT_mrelax_all.getValue()), new OptSpecifier((long)options.ID.OPT_mno_relax_all.getValue()), RelaxDefault);
    }

    public static void CollectArgsForIntegratedAssembler(Compilation C, ArgList Args, ArgStringList CmdArgs, Driver D) {
        if (ToolsStatics.UseRelaxAll(C, Args)) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-mrelax-all"));
        }
        boolean TakeNextArg = false;
        boolean CompressDebugSections = false;
        arg_iterator it = Args.filtered_begin(new OptSpecifier((long)options.ID.OPT_Wa_COMMA.getValue()), new OptSpecifier((long)options.ID.OPT_Xassembler.getValue()));
        arg_iterator ie = Args.filtered_end();
        while (OptGlobals.$noteq_arg_iterator((arg_iterator)new arg_iterator(it), (arg_iterator)new arg_iterator(ie))) {
            Arg A = it.$star();
            A.claim();
            long e = A.getNumValues();
            for (long i = 0L; i != e; ++i) {
                StringRef Value = new StringRef(A.getValue(i));
                if (TakeNextArg) {
                    CmdArgs.push_back((Object)Value.data());
                    TakeNextArg = false;
                    continue;
                }
                if (llvm.$eq_StringRef((StringRef)new StringRef(Value), (StringRef)new StringRef(NativePointer.$((String)"-force_cpusubtype_ALL")))) continue;
                if (llvm.$eq_StringRef((StringRef)new StringRef(Value), (StringRef)new StringRef(NativePointer.$((String)"-L")))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-msave-temp-labels"));
                    continue;
                }
                if (llvm.$eq_StringRef((StringRef)new StringRef(Value), (StringRef)new StringRef(NativePointer.$((String)"--fatal-warnings")))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-massembler-fatal-warnings"));
                    continue;
                }
                if (llvm.$eq_StringRef((StringRef)new StringRef(Value), (StringRef)new StringRef(NativePointer.$((String)"--noexecstack")))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-mnoexecstack"));
                    continue;
                }
                if (llvm.$eq_StringRef((StringRef)new StringRef(Value), (StringRef)new StringRef(NativePointer.$((String)"-compress-debug-sections"))) || llvm.$eq_StringRef((StringRef)new StringRef(Value), (StringRef)new StringRef(NativePointer.$((String)"--compress-debug-sections")))) {
                    CompressDebugSections = true;
                    continue;
                }
                if (llvm.$eq_StringRef((StringRef)new StringRef(Value), (StringRef)new StringRef(NativePointer.$((String)"-nocompress-debug-sections"))) || llvm.$eq_StringRef((StringRef)new StringRef(Value), (StringRef)new StringRef(NativePointer.$((String)"--nocompress-debug-sections")))) {
                    CompressDebugSections = false;
                    continue;
                }
                if (Value.startswith((CharSequence)"-I")) {
                    CmdArgs.push_back((Object)Value.data());
                    if (!llvm.$eq_StringRef((StringRef)new StringRef(Value), (StringRef)new StringRef(NativePointer.$((String)"-I")))) continue;
                    TakeNextArg = true;
                    continue;
                }
                if (Value.startswith((CharSequence)"-gdwarf-")) {
                    CmdArgs.push_back((Object)Value.data());
                    continue;
                }
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(356L), (StringRef)A.getOption().getName()), (StringRef)new StringRef(Value)).$destroy();
            }
            it.$preInc();
        }
        if (CompressDebugSections) {
            if (ZlibGlobals.isAvailable()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-compress-debug-sections"));
            } else {
                D.Diag(366L).$destroy();
            }
        }
    }

    public static StringRef getArchNameForCompilerRTLib(ToolChain TC) {
        if (TC.getTriple().isOSWindows() && !TC.getTriple().isWindowsItaniumEnvironment()) {
            return new StringRef(NativePointer.$((String)"i386"));
        }
        if (TC.getArch() == Triple.ArchType.arm || TC.getArch() == Triple.ArchType.armeb) {
            return new StringRef(NativePointer.$((String)"arm"));
        }
        return TC.getArchName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SmallString getCompilerRTLibDir(ToolChain TC) {
        SmallString Res = null;
        try {
            Res = new SmallString(new StringRef(TC.getDriver().ResourceDir), 128);
            Triple Triple2 = TC.getTriple();
            StringRef OSLibName = Triple2.getOS() == Triple.OSType.FreeBSD ? new StringRef(NativePointer.$((String)"freebsd")) : TC.getOS();
            path.append((SmallString)Res, (Twine)new Twine(NativePointer.$((String)"lib")), (Twine)new Twine(OSLibName));
            SmallString smallString = new SmallString(Res);
            return smallString;
        }
        finally {
            if (Res != null) {
                Res.$destroy();
            }
        }
    }

    public static SmallString getCompilerRT(ToolChain TC, StringRef Component) {
        return ToolsStatics.getCompilerRT(TC, Component, false, NativePointer.$((String)""));
    }

    public static SmallString getCompilerRT(ToolChain TC, StringRef Component, boolean Shared) {
        return ToolsStatics.getCompilerRT(TC, Component, Shared, NativePointer.$((String)""));
    }

    public static SmallString getCompilerRT(ToolChain TC, StringRef Component, boolean Shared, char.ptr Env) {
        boolean IsOSWindows = TC.getTriple().isOSWindows();
        StringRef Arch = ToolsStatics.getArchNameForCompilerRTLib(TC);
        char.ptr Prefix = Native.$tryClone((char.ptr)(IsOSWindows ? NativePointer.$((String)"") : NativePointer.$((String)"lib")));
        char.ptr Suffix = Native.$tryClone((char.ptr)(Shared ? (IsOSWindows ? NativePointer.$((String)".dll") : NativePointer.$((String)".so")) : (IsOSWindows ? NativePointer.$((String)".lib") : NativePointer.$((String)".a"))));
        SmallString Path = ToolsStatics.getCompilerRTLibDir(TC);
        path.append((SmallString)Path, (Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)new Twine(Prefix), (Twine)new Twine(NativePointer.$((String)"clang_rt."))), (Twine)new Twine(Component)), (Twine)new Twine(NativePointer.$((String)"-"))), (Twine)new Twine(Arch)), (Twine)new Twine(Env)), (Twine)new Twine(Suffix)));
        return Path;
    }

    public static void addClangRT(ToolChain TC, ArgList Args, ArgStringList CmdArgs) {
        CmdArgs.push_back((Object)Args.MakeArgString(ToolsStatics.getCompilerRT(TC, new StringRef(NativePointer.$((String)"builtins"))).$StringRef()));
        if (!TC.getTriple().isOSWindows()) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_s"));
            if (TC.getDriver().CCCIsCXX()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_eh"));
            }
        }
    }

    public static void addProfileRT(ToolChain TC, ArgList Args, ArgStringList CmdArgs) {
        if (!(Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fprofile_arcs.getValue()), new OptSpecifier((long)options.ID.OPT_fno_profile_arcs.getValue()), false) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_fprofile_generate.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_fprofile_instr_generate.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_fcreate_profile.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_coverage.getValue())))) {
            return;
        }
        CmdArgs.push_back((Object)Args.MakeArgString(ToolsStatics.getCompilerRT(TC, new StringRef(NativePointer.$((String)"profile"))).$StringRef()));
    }

    public static void addSanitizerRuntime(ToolChain TC, ArgList Args, ArgStringList CmdArgs, StringRef Sanitizer, boolean IsShared) {
        char.ptr Env = Native.$tryClone((char.ptr)(TC.getTriple().getEnvironment() == Triple.EnvironmentType.Android ? NativePointer.$((String)"-android") : NativePointer.$((String)"")));
        if (!IsShared) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-whole-archive"));
        }
        CmdArgs.push_back((Object)Args.MakeArgString(ToolsStatics.getCompilerRT(TC, new StringRef(Sanitizer), IsShared, Env).$StringRef()));
        if (!IsShared) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-no-whole-archive"));
        }
    }

    public static boolean addSanitizerDynamicList(ToolChain TC, ArgList Args, ArgStringList CmdArgs, StringRef Sanitizer) {
        SmallString SanRT = ToolsStatics.getCompilerRT(TC, new StringRef(Sanitizer));
        if (fs.exists((Twine)llvm.$plus_StringRef_char$ptr((StringRef)SanRT.$StringRef(), (char.ptr)NativePointer.$((String)".syms")))) {
            CmdArgs.push_back((Object)Args.MakeArgString(llvm.$plus_Twine((Twine)llvm.$plus_char$ptr_StringRef((char.ptr)NativePointer.$((String)"--dynamic-list="), (StringRef)SanRT.$StringRef()), (Twine)new Twine(NativePointer.$((String)".syms")))));
            return true;
        }
        return false;
    }

    public static void linkSanitizerRuntimeDeps(ToolChain TC, ArgStringList CmdArgs) {
        CmdArgs.push_back((Object)NativePointer.$((String)"--no-as-needed"));
        CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread"));
        CmdArgs.push_back((Object)NativePointer.$((String)"-lrt"));
        CmdArgs.push_back((Object)NativePointer.$((String)"-lm"));
        if (TC.getTriple().getOS() != Triple.OSType.FreeBSD) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-ldl"));
        }
    }

    public static void collectSanitizerRuntimes(ToolChain TC, ArgList Args, SmallVectorImpl<StringRef> SharedRuntimes, SmallVectorImpl<StringRef> StaticRuntimes, SmallVectorImpl<StringRef> HelperStaticRuntimes) {
        SanitizerArgs SanArgs = TC.getSanitizerArgs();
        if (SanArgs.needsAsanRt() && SanArgs.needsSharedAsanRt()) {
            SharedRuntimes.push_back((Object)new StringRef(NativePointer.$((String)"asan")));
        }
        if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue())) || TC.getTriple().getEnvironment() == Triple.EnvironmentType.Android) {
            return;
        }
        if (SanArgs.needsAsanRt()) {
            if (SanArgs.needsSharedAsanRt()) {
                HelperStaticRuntimes.push_back((Object)new StringRef(NativePointer.$((String)"asan-preinit")));
            } else {
                StaticRuntimes.push_back((Object)new StringRef(NativePointer.$((String)"asan")));
                if (SanArgs.linkCXXRuntimes()) {
                    StaticRuntimes.push_back((Object)new StringRef(NativePointer.$((String)"asan_cxx")));
                }
            }
        }
        if (SanArgs.needsDfsanRt()) {
            StaticRuntimes.push_back((Object)new StringRef(NativePointer.$((String)"dfsan")));
        }
        if (SanArgs.needsLsanRt()) {
            StaticRuntimes.push_back((Object)new StringRef(NativePointer.$((String)"lsan")));
        }
        if (SanArgs.needsMsanRt()) {
            StaticRuntimes.push_back((Object)new StringRef(NativePointer.$((String)"msan")));
        }
        if (SanArgs.needsTsanRt()) {
            StaticRuntimes.push_back((Object)new StringRef(NativePointer.$((String)"tsan")));
        }
        if (SanArgs.needsUbsanRt()) {
            if (StaticRuntimes.empty()) {
                HelperStaticRuntimes.push_back((Object)new StringRef(NativePointer.$((String)"san")));
            }
            StaticRuntimes.push_back((Object)new StringRef(NativePointer.$((String)"ubsan")));
            if (SanArgs.linkCXXRuntimes()) {
                StaticRuntimes.push_back((Object)new StringRef(NativePointer.$((String)"ubsan_cxx")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addSanitizerRuntimes(ToolChain TC, ArgList Args, ArgStringList CmdArgs) {
        SmallVector SharedRuntimes = null;
        SmallVector StaticRuntimes = null;
        SmallVector HelperStaticRuntimes = null;
        try {
            SharedRuntimes = new SmallVector(4, (Object)new StringRef());
            StaticRuntimes = new SmallVector(4, (Object)new StringRef());
            HelperStaticRuntimes = new SmallVector(4, (Object)new StringRef());
            ToolsStatics.collectSanitizerRuntimes(TC, Args, (SmallVectorImpl<StringRef>)SharedRuntimes, (SmallVectorImpl<StringRef>)StaticRuntimes, (SmallVectorImpl<StringRef>)HelperStaticRuntimes);
            for (StringRef RT : SharedRuntimes) {
                ToolsStatics.addSanitizerRuntime(TC, Args, CmdArgs, new StringRef(RT), true);
            }
            for (StringRef RT : HelperStaticRuntimes) {
                ToolsStatics.addSanitizerRuntime(TC, Args, CmdArgs, new StringRef(RT), false);
            }
            boolean AddExportDynamic = false;
            for (StringRef RT : StaticRuntimes) {
                ToolsStatics.addSanitizerRuntime(TC, Args, CmdArgs, new StringRef(RT), false);
                AddExportDynamic |= !ToolsStatics.addSanitizerDynamicList(TC, Args, CmdArgs, new StringRef(RT));
            }
            if (AddExportDynamic) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-export-dynamic"));
            }
            boolean bl = !StaticRuntimes.empty();
            return bl;
        }
        finally {
            if (HelperStaticRuntimes != null) {
                HelperStaticRuntimes.$destroy();
            }
            if (StaticRuntimes != null) {
                StaticRuntimes.$destroy();
            }
            if (SharedRuntimes != null) {
                SharedRuntimes.$destroy();
            }
        }
    }

    public static boolean shouldUseFramePointerForTarget(ArgList Args, Triple Triple2) {
        switch (Triple2.getArch()) {
            case systemz: 
            case mips: 
            case mipsel: 
            case mips64: 
            case mips64el: 
            case x86: 
            case x86_64: {
                Arg A;
                return !Triple2.isOSLinux() || (A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_O_Group.getValue()))) == null || A.getOption().matches(new OptSpecifier((long)options.ID.OPT_O0.getValue()));
            }
            case xcore: {
                return false;
            }
        }
        return true;
    }

    public static boolean shouldUseFramePointer(ArgList Args, Triple Triple2) {
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fno_omit_frame_pointer.getValue()), new OptSpecifier((long)options.ID.OPT_fomit_frame_pointer.getValue()));
        if (A != null) {
            return A.getOption().matches(new OptSpecifier((long)options.ID.OPT_fno_omit_frame_pointer.getValue()));
        }
        return ToolsStatics.shouldUseFramePointerForTarget(Args, Triple2);
    }

    public static boolean shouldUseLeafFramePointer(ArgList Args, Triple Triple2) {
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mno_omit_leaf_frame_pointer.getValue()), new OptSpecifier((long)options.ID.OPT_momit_leaf_frame_pointer.getValue()));
        if (A != null) {
            return A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mno_omit_leaf_frame_pointer.getValue()));
        }
        return ToolsStatics.shouldUseFramePointerForTarget(Args, Triple2);
    }

    public static void addDebugCompDirArg(ArgList Args, ArgStringList CmdArgs) {
        SmallString cwd = null;
        try {
            cwd = new SmallString(128);
            if (!fs.current_path((SmallString)cwd).$boolean()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fdebug-compilation-dir"));
                CmdArgs.push_back((Object)Args.MakeArgString(cwd.$StringRef()));
            }
        }
        finally {
            if (cwd != null) {
                cwd.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char.ptr SplitDebugName(ArgList Args, SmallVector<InputInfo> Inputs) {
        Arg FinalOutput = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_o.getValue()));
        if (FinalOutput != null && Args.hasArg(new OptSpecifier((long)options.ID.OPT_c.getValue()))) {
            SmallString T = null;
            try {
                T = new SmallString(new StringRef(FinalOutput.getValue()), 128);
                path.replace_extension((SmallString)T, (Twine)new Twine(NativePointer.$((String)"dwo")));
                char.ptr ptr2 = Args.MakeArgString(T.$StringRef());
                return ptr2;
            }
            finally {
                if (T != null) {
                    T.$destroy();
                }
            }
        }
        SmallString T = null;
        SmallString F = null;
        try {
            T = new SmallString(Args.getLastArgValue(new OptSpecifier((long)options.ID.OPT_fdebug_compilation_dir.getValue())), 128);
            F = new SmallString(path.stem((StringRef)new StringRef(((InputInfo)Inputs.$at(0)).getBaseInput())), 128);
            path.replace_extension((SmallString)F, (Twine)new Twine(NativePointer.$((String)"dwo")));
            T.$addassign((SmallVectorImplChar)F);
            char.ptr ptr3 = Args.MakeArgString(F.$StringRef());
            return ptr3;
        }
        finally {
            if (F != null) {
                F.$destroy();
            }
            if (T != null) {
                T.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SplitDebugInfo(ToolChain TC, Compilation C, Tool T, JobAction JA, ArgList Args, InputInfo Output, char.ptr OutFile) {
        ArgStringList ExtractArgs = null;
        ArgStringList StripArgs = null;
        try {
            ExtractArgs = new ArgStringList();
            ExtractArgs.push_back((Object)NativePointer.$((String)"--extract-dwo"));
            StripArgs = new ArgStringList();
            StripArgs.push_back((Object)NativePointer.$((String)"--strip-dwo"));
            StripArgs.push_back((Object)Output.getFilename());
            ExtractArgs.push_back((Object)Output.getFilename());
            ExtractArgs.push_back((Object)OutFile);
            char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(TC.GetProgramPath(NativePointer.$((String)"objcopy"))));
            C.addCommand((std_ptr.unique_ptr<Command>)std.make_unique((Object)new Command(JA, T, Exec, ExtractArgs)));
            C.addCommand((std_ptr.unique_ptr<Command>)std.make_unique((Object)new Command(JA, T, Exec, StripArgs)));
        }
        finally {
            if (StripArgs != null) {
                StripArgs.$destroy();
            }
            if (ExtractArgs != null) {
                ExtractArgs.$destroy();
            }
        }
    }

    public static boolean shouldEnableVectorizerAtOLevel(ArgList Args, boolean isSlpVec) {
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_O_Group.getValue()));
        if (A != null) {
            if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_O4.getValue())) || A.getOption().matches(new OptSpecifier((long)options.ID.OPT_Ofast.getValue()))) {
                return true;
            }
            if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_O0.getValue()))) {
                return false;
            }
            assert (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_O.getValue()))) : "Must have a -O flag";
            StringRef S = new StringRef(A.getValue());
            if (llvm.$eq_StringRef((StringRef)new StringRef(S), (StringRef)new StringRef(NativePointer.$((String)"s")))) {
                return true;
            }
            if (llvm.$eq_StringRef((StringRef)new StringRef(S), (StringRef)new StringRef(NativePointer.$((String)"z")))) {
                return isSlpVec;
            }
            uint.ref OptLevel = NativePointer.create_uint$ref();
            if (S.getAsInteger(10, OptLevel)) {
                return false;
            }
            return OptLevel.$deref() > 1L;
        }
        return false;
    }

    public static void addDashXForInput(ArgList Args, InputInfo Input, ArgStringList CmdArgs) {
        if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_verify_pch.getValue())) && Input.getType() == types.ID.TY_PCH) {
            return;
        }
        CmdArgs.push_back((Object)NativePointer.$((String)"-x"));
        if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_rewrite_objc.getValue()))) {
            CmdArgs.push_back((Object)types.getTypeName(types.ID.TY_PP_ObjCXX));
        } else {
            CmdArgs.push_back((Object)types.getTypeName(Input.getType()));
        }
    }

    public static std.string getMSCompatibilityVersion(char.ptr VersionStr) {
        uint.ref VersionRef = NativePointer.create_uint$ref();
        if (new StringRef(VersionStr).getAsInteger(10, VersionRef)) {
            return new std.string(NativePointer.$((String)"0"));
        }
        long Version = VersionRef.$deref();
        if (Version < 100L) {
            return std.$plus_str_T((std.string)llvm.utostr_32((long)Version), (char.iterator)NativePointer.$((String)".0"));
        }
        if (Version < 10000L) {
            return std.$plus_str((std.string)std.$plus_str_T((std.string)llvm.utostr_32((long)(Version / 100L)), (char.iterator)NativePointer.$((String)".")), (std.string)llvm.utostr_32((long)(Version % 100L)));
        }
        long Build = 0L;
        long Factor = 1L;
        while (Version > 10000L) {
            Build += Version % 10L * Factor;
            Version /= 10L;
            Factor *= 10L;
        }
        return std.$plus_str((std.string)std.$plus_str_T((std.string)std.$plus_str((std.string)std.$plus_str_T((std.string)llvm.utostr_32((long)(Version / 100L)), (char.iterator)NativePointer.$((String)".")), (std.string)llvm.utostr_32((long)(Version % 100L))), (char.iterator)NativePointer.$((String)".")), (std.string)llvm.utostr_32((long)Build));
    }

    public static void claimNoWarnArgs(ArgList Args) {
        Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_flto.getValue()));
        Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_fno_lto.getValue()));
    }

    public static boolean maybeConsumeDash(std.string EH, int.ref I) {
        boolean HaveDash = I.$deref() + 1 < EH.size() && EH.$at(I.$deref() + 1) == 45;
        I.$set(I.$deref() + (HaveDash ? 1 : 0));
        return !HaveDash;
    }

    public static EHFlags parseClangCLEHFlags(Driver D, ArgList Args) {
        EHFlags EH = new EHFlags();
        std.vectorString EHArgs = Args.getAllArgValues(new OptSpecifier((long)options.ID.OPT__SLASH_EH.getValue()));
        block5: for (std.string EHVal : EHArgs) {
            int E = EHVal.size();
            block6: for (int I = 0; I != E; ++I) {
                switch (EHVal.$at(I)) {
                    case 97: {
                        int.ref IRef = NativePointer.create_int$ref((int)I);
                        EH.Asynch = ToolsStatics.maybeConsumeDash(EHVal, IRef);
                        I = IRef.$deref();
                        continue block6;
                    }
                    case 99: {
                        int.ref IRef = NativePointer.create_int$ref((int)I);
                        EH.NoExceptC = ToolsStatics.maybeConsumeDash(EHVal, IRef);
                        I = IRef.$deref();
                        continue block6;
                    }
                    case 115: {
                        int.ref IRef = NativePointer.create_int$ref((int)I);
                        EH.Synch = ToolsStatics.maybeConsumeDash(EHVal, IRef);
                        I = IRef.$deref();
                        continue block6;
                    }
                    default: {
                        ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)D.Diag(331L), (char.ptr)NativePointer.$((String)"/EH")), (StringRef)new StringRef(EHVal)).$destroy();
                        continue block5;
                    }
                }
            }
        }
        return EH;
    }

    public static void AddLibgcc(Triple Triple2, Driver D, ArgStringList CmdArgs, ArgList Args) {
        boolean StaticLibgcc;
        boolean isAndroid = Triple2.getEnvironment() == Triple.EnvironmentType.Android;
        boolean bl = StaticLibgcc = Args.hasArg(new OptSpecifier((long)options.ID.OPT_static_libgcc.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue()));
        if (!D.CCCIsCXX()) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
        }
        if (StaticLibgcc || isAndroid) {
            if (D.CCCIsCXX()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
            }
        } else {
            if (!D.CCCIsCXX()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"--as-needed"));
            }
            CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_s"));
            if (!D.CCCIsCXX()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"--no-as-needed"));
            }
        }
        if (StaticLibgcc && !isAndroid) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_eh"));
        } else if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue())) && D.CCCIsCXX()) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
        }
        if (isAndroid && !StaticLibgcc) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-ldl"));
        }
    }

    public static std.string getLinuxDynamicLinker(ArgList Args, toolchains.Linux ToolChain2) {
        if (ToolChain2.getTriple().getEnvironment() == Triple.EnvironmentType.Android) {
            if (ToolChain2.getTriple().isArch64Bit()) {
                return new std.string(NativePointer.$((String)"/system/bin/linker64"));
            }
            return new std.string(NativePointer.$((String)"/system/bin/linker"));
        }
        if (ToolChain2.getArch() == Triple.ArchType.x86 || ToolChain2.getArch() == Triple.ArchType.sparc) {
            return new std.string(NativePointer.$((String)"/lib/ld-linux.so.2"));
        }
        if (ToolChain2.getArch() == Triple.ArchType.aarch64) {
            return new std.string(NativePointer.$((String)"/lib/ld-linux-aarch64.so.1"));
        }
        if (ToolChain2.getArch() == Triple.ArchType.aarch64_be) {
            return new std.string(NativePointer.$((String)"/lib/ld-linux-aarch64_be.so.1"));
        }
        if (ToolChain2.getArch() == Triple.ArchType.arm || ToolChain2.getArch() == Triple.ArchType.thumb) {
            if (ToolChain2.getTriple().getEnvironment() == Triple.EnvironmentType.GNUEABIHF) {
                return new std.string(NativePointer.$((String)"/lib/ld-linux-armhf.so.3"));
            }
            return new std.string(NativePointer.$((String)"/lib/ld-linux.so.3"));
        }
        if (ToolChain2.getArch() == Triple.ArchType.armeb || ToolChain2.getArch() == Triple.ArchType.thumbeb) {
            if (ToolChain2.getTriple().getEnvironment() == Triple.EnvironmentType.GNUEABIHF) {
                return new std.string(NativePointer.$((String)"/lib/ld-linux-armhf.so.3"));
            }
            return new std.string(NativePointer.$((String)"/lib/ld-linux.so.3"));
        }
        if (ToolChain2.getArch() == Triple.ArchType.mips || ToolChain2.getArch() == Triple.ArchType.mipsel || ToolChain2.getArch() == Triple.ArchType.mips64 || ToolChain2.getArch() == Triple.ArchType.mips64el) {
            StringRef CPUName = new StringRef();
            StringRef ABIName = new StringRef();
            mips.getMipsCPUAndABI(Args, ToolChain2.getTriple(), CPUName, ABIName);
            boolean IsNaN2008 = mips.isNaN2008(Args, ToolChain2.getTriple());
            StringRef LibDir = (StringRef)new StringSwitch(new StringRef(ABIName)).Case(NativePointer.$((String)"o32"), (Object)new StringRef(NativePointer.$((String)"/lib"))).Case(NativePointer.$((String)"n32"), (Object)new StringRef(NativePointer.$((String)"/lib32"))).Case(NativePointer.$((String)"n64"), (Object)new StringRef(NativePointer.$((String)"/lib64"))).Default((Object)new StringRef(NativePointer.$((String)"/lib")));
            StringRef LibName = new StringRef();
            if (mips.isUCLibc(Args)) {
                LibName.$assign(new StringRef(IsNaN2008 ? NativePointer.$((String)"ld-uClibc-mipsn8.so.0") : NativePointer.$((String)"ld-uClibc.so.0")));
            } else {
                LibName.$assign(new StringRef(IsNaN2008 ? NativePointer.$((String)"ld-linux-mipsn8.so.1") : NativePointer.$((String)"ld.so.1")));
            }
            return llvm.$plus_Twine((Twine)llvm.$plus_StringRef_char$ptr((StringRef)LibDir, (char.ptr)NativePointer.$((String)"/")), (Twine)new Twine(LibName)).str();
        }
        if (ToolChain2.getArch() == Triple.ArchType.ppc) {
            return new std.string(NativePointer.$((String)"/lib/ld.so.1"));
        }
        if (ToolChain2.getArch() == Triple.ArchType.ppc64) {
            if (ppc.hasPPCAbiArg(Args, NativePointer.$((String)"elfv2"))) {
                return new std.string(NativePointer.$((String)"/lib64/ld64.so.2"));
            }
            return new std.string(NativePointer.$((String)"/lib64/ld64.so.1"));
        }
        if (ToolChain2.getArch() == Triple.ArchType.ppc64le) {
            if (ppc.hasPPCAbiArg(Args, NativePointer.$((String)"elfv1"))) {
                return new std.string(NativePointer.$((String)"/lib64/ld64.so.1"));
            }
            return new std.string(NativePointer.$((String)"/lib64/ld64.so.2"));
        }
        if (ToolChain2.getArch() == Triple.ArchType.systemz) {
            return new std.string(NativePointer.$((String)"/lib64/ld64.so.1"));
        }
        if (ToolChain2.getArch() == Triple.ArchType.sparcv9) {
            return new std.string(NativePointer.$((String)"/lib64/ld-linux.so.2"));
        }
        if (ToolChain2.getArch() == Triple.ArchType.x86_64 && ToolChain2.getTriple().getEnvironment() == Triple.EnvironmentType.GNUX32) {
            return new std.string(NativePointer.$((String)"/libx32/ld-linux-x32.so.2"));
        }
        return new std.string(NativePointer.$((String)"/lib64/ld-linux-x86-64.so.2"));
    }

    public static void AddRunTimeLibs(ToolChain TC, Driver D, ArgStringList CmdArgs, ArgList Args) {
        ToolChain.RuntimeLibType RLT = TC.GetRuntimeLibType(Args);
        switch (RLT) {
            case RLT_CompilerRT: {
                switch (TC.getTriple().getOS()) {
                    default: {
                        throw new llvm_unreachable((CharSequence)"unsupported OS");
                    }
                    case Win32: 
                    case Linux: 
                }
                ToolsStatics.addClangRT(TC, Args, CmdArgs);
                break;
            }
            case RLT_Libgcc: {
                ToolsStatics.AddLibgcc(TC.getTriple(), D, CmdArgs, Args);
            }
        }
    }

    public static char.ptr getLDMOption(Triple T, ArgList Args) {
        switch (T.getArch()) {
            case x86: {
                return NativePointer.$((String)"elf_i386");
            }
            case aarch64: {
                return NativePointer.$((String)"aarch64linux");
            }
            case aarch64_be: {
                return NativePointer.$((String)"aarch64_be_linux");
            }
            case arm: 
            case thumb: {
                return NativePointer.$((String)"armelf_linux_eabi");
            }
            case armeb: 
            case thumbeb: {
                return NativePointer.$((String)"armebelf_linux_eabi");
            }
            case ppc: {
                return NativePointer.$((String)"elf32ppclinux");
            }
            case ppc64: {
                return NativePointer.$((String)"elf64ppc");
            }
            case ppc64le: {
                return NativePointer.$((String)"elf64lppc");
            }
            case sparc: {
                return NativePointer.$((String)"elf32_sparc");
            }
            case sparcv9: {
                return NativePointer.$((String)"elf64_sparc");
            }
            case mips: {
                return NativePointer.$((String)"elf32btsmip");
            }
            case mipsel: {
                return NativePointer.$((String)"elf32ltsmip");
            }
            case mips64: {
                if (mips.hasMipsAbiArg(Args, NativePointer.$((String)"n32"))) {
                    return NativePointer.$((String)"elf32btsmipn32");
                }
                return NativePointer.$((String)"elf64btsmip");
            }
            case mips64el: {
                if (mips.hasMipsAbiArg(Args, NativePointer.$((String)"n32"))) {
                    return NativePointer.$((String)"elf32ltsmipn32");
                }
                return NativePointer.$((String)"elf64ltsmip");
            }
            case systemz: {
                return NativePointer.$((String)"elf64_s390");
            }
            case x86_64: {
                if (T.getEnvironment() == Triple.EnvironmentType.GNUX32) {
                    return NativePointer.$((String)"elf32_x86_64");
                }
                return NativePointer.$((String)"elf_x86_64");
            }
        }
        throw new llvm_unreachable((CharSequence)"Unexpected arch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.string FindVisualStudioExecutable(ToolChain TC, char.ptr Exe, char.ptr ClangProgramPath) {
        std.string visualStudioBinDir = null;
        try {
            toolchains.MSVCToolChain MSVC = (toolchains.MSVCToolChain)TC;
            visualStudioBinDir = new std.string();
            if (MSVC.getVisualStudioBinariesFolder(ClangProgramPath, visualStudioBinDir)) {
                SmallString FilePath = null;
                try {
                    FilePath = new SmallString(new StringRef(visualStudioBinDir), 128);
                    path.append((SmallString)FilePath, (char.ptr)Exe);
                    if (fs.can_execute((Twine)new Twine(FilePath.c_str()))) {
                        std.string string2 = FilePath.str().$basic_string();
                        return string2;
                    }
                }
                finally {
                    if (FilePath != null) {
                        FilePath.$destroy();
                    }
                }
            }
            std.string string3 = new std.string(Exe);
            return string3;
        }
        finally {
            if (visualStudioBinDir != null) {
                visualStudioBinDir.$destroy();
            }
        }
    }
}

