/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.tools.impl;

import java.util.Iterator;
import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.driver.Command;
import org.clang.driver.Compilation;
import org.clang.driver.Driver;
import org.clang.driver.JobAction;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.InputInfo;
import org.clang.driver.impl.LibOpenMP;
import org.clang.driver.impl.ToolsStatics;
import org.clang.driver.impl.toolchains;
import org.clang.driver.options;
import org.clang.driver.tools.impl.GnuTool;
import org.clang.driver.tools.impl.arm;
import org.clang.driver.tools.impl.mips;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;

public final class gnutools {

    public static class Link
    extends GnuTool {
        public Link(ToolChain TC) {
            super(NativePointer.$((String)"GNU::Link"), NativePointer.$((String)"linker"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        @Override
        public boolean isLinkJob() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            ArgStringList CmdArgs = null;
            try {
                toolchains.Linux ToolChain2 = (toolchains.Linux)this.getToolChain();
                Driver D = ToolChain2.getDriver();
                boolean isAndroid = ToolChain2.getTriple().getEnvironment() == Triple.EnvironmentType.Android;
                boolean IsPIE = !Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue())) && (Args.hasArg(new OptSpecifier((long)options.ID.OPT_pie.getValue())) || ToolChain2.isPIEDefault() || isAndroid);
                CmdArgs = new ArgStringList();
                Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_g_Group.getValue()));
                Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_emit_llvm.getValue()));
                Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_w.getValue()));
                if (!D.SysRoot.empty()) {
                    CmdArgs.push_back((Object)Args.MakeArgString(std.$plus_T_str((Object)NativePointer.$((String)"--sysroot="), (std.string)D.SysRoot)));
                }
                if (IsPIE) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-pie"));
                }
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_rdynamic.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-export-dynamic"));
                }
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_s.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-s"));
                }
                if (ToolChain2.getArch() == Triple.ArchType.armeb || ToolChain2.getArch() == Triple.ArchType.thumbeb) {
                    arm.appendEBLinkFlags(Args, CmdArgs, this.getToolChain().getTriple());
                }
                for (Object Opt : ToolChain2.ExtraOpts) {
                    CmdArgs.push_back((Object)Opt.c_str());
                }
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"--eh-frame-hdr"));
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                CmdArgs.push_back((Object)ToolsStatics.getLDMOption(ToolChain2.getTriple(), Args));
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue()))) {
                    if (ToolChain2.getArch() == Triple.ArchType.arm || ToolChain2.getArch() == Triple.ArchType.armeb || ToolChain2.getArch() == Triple.ArchType.thumb || ToolChain2.getArch() == Triple.ArchType.thumbeb) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-Bstatic"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-static"));
                    }
                } else if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-shared"));
                }
                if (ToolChain2.getArch() == Triple.ArchType.arm || ToolChain2.getArch() == Triple.ArchType.armeb || ToolChain2.getArch() == Triple.ArchType.thumb || ToolChain2.getArch() == Triple.ArchType.thumbeb || !Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-dynamic-linker"));
                    CmdArgs.push_back((Object)Args.MakeArgString(std.$plus_str((std.string)D.DyldPrefix, (std.string)ToolsStatics.getLinuxDynamicLinker(Args, ToolChain2))));
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostartfiles.getValue()))) {
                    if (!isAndroid) {
                        char.ptr crt1 = null;
                        if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue()))) {
                            crt1 = Args.hasArg(new OptSpecifier((long)options.ID.OPT_pg.getValue())) ? NativePointer.$((String)"gcrt1.o") : (IsPIE ? NativePointer.$((String)"Scrt1.o") : NativePointer.$((String)"crt1.o"));
                        }
                        if (crt1 != null) {
                            CmdArgs.push_back((Object)Args.MakeArgString(ToolChain2.GetFilePath(crt1)));
                        }
                        CmdArgs.push_back((Object)Args.MakeArgString(ToolChain2.GetFilePath(NativePointer.$((String)"crti.o"))));
                    }
                    char.ptr crtbegin = Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue())) ? Native.$tryClone((char.ptr)(isAndroid ? NativePointer.$((String)"crtbegin_static.o") : NativePointer.$((String)"crtbeginT.o"))) : (Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue())) ? Native.$tryClone((char.ptr)(isAndroid ? NativePointer.$((String)"crtbegin_so.o") : NativePointer.$((String)"crtbeginS.o"))) : (IsPIE ? Native.$tryClone((char.ptr)(isAndroid ? NativePointer.$((String)"crtbegin_dynamic.o") : NativePointer.$((String)"crtbeginS.o"))) : Native.$tryClone((char.ptr)(isAndroid ? NativePointer.$((String)"crtbegin_dynamic.o") : NativePointer.$((String)"crtbegin.o")))));
                    CmdArgs.push_back((Object)Args.MakeArgString(ToolChain2.GetFilePath(crtbegin)));
                    ToolChain2.AddFastMathRuntimeIfAvailable(Args, CmdArgs);
                }
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_L.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_u.getValue()));
                SmallVector<std.string> Paths = ToolChain2.getFilePaths();
                for (std.string Path : Paths) {
                    CmdArgs.push_back((Object)Args.MakeArgString(llvm.$plus_Twine((Twine)new Twine(new StringRef(NativePointer.$((String)"-L"))), (Twine)new Twine(Path))));
                }
                if (D.IsUsingLTO(Args)) {
                    ToolsStatics.AddGoldPlugin(ToolChain2, Args, CmdArgs);
                }
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_Z_Xlinker__no_demangle.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"--no-demangle"));
                }
                boolean NeedsSanitizerDeps = ToolsStatics.addSanitizerRuntimes(ToolChain2, Args, CmdArgs);
                ToolsStatics.AddLinkerInputs(ToolChain2, Inputs, Args, CmdArgs);
                ToolsStatics.addProfileRT(this.getToolChain(), Args, CmdArgs);
                if (D.CCCIsCXX() && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nodefaultlibs.getValue()))) {
                    boolean OnlyLibstdcxxStatic;
                    boolean bl = OnlyLibstdcxxStatic = Args.hasArg(new OptSpecifier((long)options.ID.OPT_static_libstdcxx.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue()));
                    if (OnlyLibstdcxxStatic) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-Bstatic"));
                    }
                    ToolChain2.AddCXXStdlibLibArgs(Args, CmdArgs);
                    if (OnlyLibstdcxxStatic) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-Bdynamic"));
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lm"));
                }
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue()))) {
                    if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_nodefaultlibs.getValue()))) {
                        if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"--start-group"));
                        }
                        if (NeedsSanitizerDeps) {
                            ToolsStatics.linkSanitizerRuntimeDeps(ToolChain2, CmdArgs);
                        }
                        LibOpenMP UsedOpenMPLib = LibOpenMP.LibUnknown;
                        if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_fopenmp.getValue()))) {
                            UsedOpenMPLib = LibOpenMP.LibGOMP;
                        } else {
                            Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fopenmp_EQ.getValue()));
                            if (A != null && (UsedOpenMPLib = (LibOpenMP)((Object)new StringSwitch(new StringRef(A.getValue())).Case(NativePointer.$((String)"libgomp"), (Object)LibOpenMP.LibGOMP).Case(NativePointer.$((String)"libiomp5"), (Object)LibOpenMP.LibIOMP5).Default((Object)LibOpenMP.LibUnknown))) == LibOpenMP.LibUnknown) {
                                ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(356L), (StringRef)A.getOption().getName()), (char.ptr)A.getValue()).$destroy();
                            }
                        }
                        switch (UsedOpenMPLib) {
                            case LibGOMP: {
                                CmdArgs.push_back((Object)NativePointer.$((String)"-lgomp"));
                                CmdArgs.push_back((Object)NativePointer.$((String)"-lrt"));
                                break;
                            }
                            case LibIOMP5: {
                                CmdArgs.push_back((Object)NativePointer.$((String)"-liomp5"));
                                break;
                            }
                        }
                        ToolsStatics.AddRunTimeLibs(ToolChain2, D, CmdArgs, Args);
                        if ((Args.hasArg(new OptSpecifier((long)options.ID.OPT_pthread.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_pthreads.getValue())) || UsedOpenMPLib != LibOpenMP.LibUnknown) && !isAndroid) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread"));
                        }
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lc"));
                        if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"--end-group"));
                        } else {
                            ToolsStatics.AddRunTimeLibs(ToolChain2, D, CmdArgs, Args);
                        }
                    }
                    if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostartfiles.getValue()))) {
                        char.ptr crtend = Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue())) ? Native.$tryClone((char.ptr)(isAndroid ? NativePointer.$((String)"crtend_so.o") : NativePointer.$((String)"crtendS.o"))) : (IsPIE ? Native.$tryClone((char.ptr)(isAndroid ? NativePointer.$((String)"crtend_android.o") : NativePointer.$((String)"crtendS.o"))) : Native.$tryClone((char.ptr)(isAndroid ? NativePointer.$((String)"crtend_android.o") : NativePointer.$((String)"crtend.o"))));
                        CmdArgs.push_back((Object)Args.MakeArgString(ToolChain2.GetFilePath(crtend)));
                        if (!isAndroid) {
                            CmdArgs.push_back((Object)Args.MakeArgString(ToolChain2.GetFilePath(NativePointer.$((String)"crtn.o"))));
                        }
                    }
                }
                C.addCommand((std_ptr.unique_ptr<Command>)llvm.make_unique((Object)new Command(JA, this, ToolChain2.Linker.c_str(), CmdArgs)));
            }
            finally {
                if (CmdArgs != null) {
                    CmdArgs.$destroy();
                }
            }
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Assemble
    extends GnuTool {
        public Assemble(ToolChain TC) {
            super(NativePointer.$((String)"GNU::Assemble"), NativePointer.$((String)"assembler"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            ArgStringList CmdArgs = null;
            try {
                Iterator CPUName;
                ToolsStatics.claimNoWarnArgs(Args);
                CmdArgs = new ArgStringList();
                boolean NeedsKPIC = false;
                if (this.getToolChain().getArch() == Triple.ArchType.x86) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"--32"));
                } else if (this.getToolChain().getArch() == Triple.ArchType.x86_64) {
                    if (this.getToolChain().getTriple().getEnvironment() == Triple.EnvironmentType.GNUX32) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--x32"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--64"));
                    }
                } else if (this.getToolChain().getArch() == Triple.ArchType.ppc) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-a32"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-mppc"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-many"));
                } else if (this.getToolChain().getArch() == Triple.ArchType.ppc64) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-a64"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-mppc64"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-many"));
                } else if (this.getToolChain().getArch() == Triple.ArchType.ppc64le) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-a64"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-mppc64"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-many"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-mlittle-endian"));
                } else if (this.getToolChain().getArch() == Triple.ArchType.sparc) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-32"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-Av8plusa"));
                    NeedsKPIC = true;
                } else if (this.getToolChain().getArch() == Triple.ArchType.sparcv9) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-64"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-Av9a"));
                    NeedsKPIC = true;
                } else if (this.getToolChain().getArch() == Triple.ArchType.arm || this.getToolChain().getArch() == Triple.ArchType.armeb) {
                    StringRef MArch = this.getToolChain().getArchName();
                    if (llvm.$eq_StringRef((StringRef)new StringRef(MArch), (StringRef)new StringRef(NativePointer.$((String)"armv7"))) || llvm.$eq_StringRef((StringRef)new StringRef(MArch), (StringRef)new StringRef(NativePointer.$((String)"armv7a"))) || llvm.$eq_StringRef((StringRef)new StringRef(MArch), (StringRef)new StringRef(NativePointer.$((String)"armv7-a")))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-mfpu=neon"));
                    }
                    if (llvm.$eq_StringRef((StringRef)new StringRef(MArch), (StringRef)new StringRef(NativePointer.$((String)"armv8"))) || llvm.$eq_StringRef((StringRef)new StringRef(MArch), (StringRef)new StringRef(NativePointer.$((String)"armv8a"))) || llvm.$eq_StringRef((StringRef)new StringRef(MArch), (StringRef)new StringRef(NativePointer.$((String)"armv8-a"))) || llvm.$eq_StringRef((StringRef)new StringRef(MArch), (StringRef)new StringRef(NativePointer.$((String)"armebv8"))) || llvm.$eq_StringRef((StringRef)new StringRef(MArch), (StringRef)new StringRef(NativePointer.$((String)"armebv8a"))) || llvm.$eq_StringRef((StringRef)new StringRef(MArch), (StringRef)new StringRef(NativePointer.$((String)"armebv8-a")))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-mfpu=crypto-neon-fp-armv8"));
                    }
                    StringRef ARMFloatABI = arm.getARMFloatABI(this.getToolChain().getDriver(), Args, this.getToolChain().getTriple());
                    CmdArgs.push_back((Object)Args.MakeArgString(llvm.$plus_char$ptr_StringRef((char.ptr)NativePointer.$((String)"-mfloat-abi="), (StringRef)ARMFloatABI)));
                    Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_march_EQ.getValue()));
                    Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mcpu_EQ.getValue()));
                    if (A != null && llvm.$eq_StringRef((StringRef)new StringRef(A.getValue()), (StringRef)new StringRef(NativePointer.$((String)"krait")))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-march=armv7-a"));
                    } else {
                        Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_mcpu_EQ.getValue()));
                    }
                    Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_mfpu_EQ.getValue()));
                } else if (this.getToolChain().getArch() == Triple.ArchType.mips || this.getToolChain().getArch() == Triple.ArchType.mipsel || this.getToolChain().getArch() == Triple.ArchType.mips64 || this.getToolChain().getArch() == Triple.ArchType.mips64el) {
                    CPUName = new StringRef();
                    StringRef ABIName = new StringRef();
                    mips.getMipsCPUAndABI(Args, this.getToolChain().getTriple(), (StringRef)CPUName, ABIName);
                    ABIName.$assign(ToolsStatics.getGnuCompatibleMipsABIName(new StringRef(ABIName)));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-march"));
                    CmdArgs.push_back((Object)CPUName.data());
                    CmdArgs.push_back((Object)NativePointer.$((String)"-mabi"));
                    CmdArgs.push_back((Object)ABIName.data());
                    boolean IsPicOrPie = false;
                    Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fPIC.getValue()), new OptSpecifier((long)options.ID.OPT_fno_PIC.getValue()), new OptSpecifier((long)options.ID.OPT_fpic.getValue()), new OptSpecifier((long)options.ID.OPT_fno_pic.getValue()), new OptSpecifier((long)options.ID.OPT_fPIE.getValue()), new OptSpecifier((long)options.ID.OPT_fno_PIE.getValue()), new OptSpecifier((long)options.ID.OPT_fpie.getValue()), new OptSpecifier((long)options.ID.OPT_fno_pie.getValue()));
                    if (A != null && (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_fPIC.getValue())) || A.getOption().matches(new OptSpecifier((long)options.ID.OPT_fpic.getValue())) || A.getOption().matches(new OptSpecifier((long)options.ID.OPT_fPIE.getValue())) || A.getOption().matches(new OptSpecifier((long)options.ID.OPT_fpie.getValue())))) {
                        IsPicOrPie = true;
                    }
                    if (!IsPicOrPie) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-mno-shared"));
                    }
                    CmdArgs.push_back((Object)(llvm.$eq_StringRef((StringRef)new StringRef(ABIName), (StringRef)new StringRef(NativePointer.$((String)"64"))) ? NativePointer.$((String)"-KPIC") : NativePointer.$((String)"-call_nonpic")));
                    if (this.getToolChain().getArch() == Triple.ArchType.mips || this.getToolChain().getArch() == Triple.ArchType.mips64) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-EB"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-EL"));
                    }
                    A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mnan_EQ.getValue()));
                    if (A != null && llvm.$eq_StringRef((StringRef)new StringRef(A.getValue()), (StringRef)new StringRef(NativePointer.$((String)"2008")))) {
                        CmdArgs.push_back((Object)Args.MakeArgString(NativePointer.$((String)"-mnan=2008")));
                    }
                    if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mfp32.getValue()), new OptSpecifier((long)options.ID.OPT_mfpxx.getValue()), new OptSpecifier((long)options.ID.OPT_mfp64.getValue()))) != null) {
                        A.claim();
                        A.render(Args, (SmallVector)CmdArgs);
                    } else if (mips.isFPXXDefault(this.getToolChain().getTriple(), new StringRef((StringRef)CPUName), new StringRef(ABIName))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-mfpxx"));
                    }
                    A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mips16.getValue()), new OptSpecifier((long)options.ID.OPT_mno_mips16.getValue()));
                    if (A != null) {
                        if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mips16.getValue()))) {
                            A.claim();
                            A.render(Args, (SmallVector)CmdArgs);
                        } else {
                            A.claim();
                            CmdArgs.push_back((Object)NativePointer.$((String)"-no-mips16"));
                        }
                    }
                    Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_mmicromips.getValue()), new OptSpecifier((long)options.ID.OPT_mno_micromips.getValue()));
                    Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_mdsp.getValue()), new OptSpecifier((long)options.ID.OPT_mno_dsp.getValue()));
                    Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_mdspr2.getValue()), new OptSpecifier((long)options.ID.OPT_mno_dspr2.getValue()));
                    A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mmsa.getValue()), new OptSpecifier((long)options.ID.OPT_mno_msa.getValue()));
                    if (A != null && A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mmsa.getValue()))) {
                        CmdArgs.push_back((Object)Args.MakeArgString(NativePointer.$((String)"-mmsa")));
                    }
                    Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_mhard_float.getValue()), new OptSpecifier((long)options.ID.OPT_msoft_float.getValue()));
                    Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_modd_spreg.getValue()), new OptSpecifier((long)options.ID.OPT_mno_odd_spreg.getValue()));
                    NeedsKPIC = true;
                } else if (this.getToolChain().getArch() == Triple.ArchType.systemz) {
                    CPUName = new StringRef(ToolsStatics.getSystemZTargetCPU(Args));
                    CmdArgs.push_back((Object)Args.MakeArgString(llvm.$plus_char$ptr_StringRef((char.ptr)NativePointer.$((String)"-march="), (StringRef)CPUName)));
                }
                if (NeedsKPIC) {
                    ToolsStatics.addAssemblerKPIC(Args, CmdArgs);
                }
                Args.AddAllArgValues((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_Wa_COMMA.getValue()), new OptSpecifier((long)options.ID.OPT_Xassembler.getValue()));
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                for (InputInfo II : Inputs) {
                    CmdArgs.push_back((Object)II.getFilename());
                }
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(this.getToolChain().GetProgramPath(NativePointer.$((String)"as"))));
                C.addCommand((std_ptr.unique_ptr<Command>)llvm.make_unique((Object)new Command(JA, this, Exec, CmdArgs)));
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_gsplit_dwarf.getValue())) && this.getToolChain().getTriple().isOSLinux()) {
                    ToolsStatics.SplitDebugInfo(this.getToolChain(), C, this, JA, Args, Output, ToolsStatics.SplitDebugName(Args, Inputs));
                }
            }
            finally {
                if (CmdArgs != null) {
                    CmdArgs.$destroy();
                }
            }
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }
}

