/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.search.SearchRoot;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectRegistry;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.utils.CndFileVisibilityQuery;
import org.netbeans.modules.cnd.debug.DebugUtils;
import org.netbeans.modules.cnd.makeproject.BrokenReferencesSupport;
import org.netbeans.modules.cnd.makeproject.ConfigurationDescriptorProviderImpl;
import org.netbeans.modules.cnd.makeproject.ConfirmExtensions;
import org.netbeans.modules.cnd.makeproject.ConnectionHelper;
import org.netbeans.modules.cnd.makeproject.MakeActionProvider;
import org.netbeans.modules.cnd.makeproject.MakeBasedProjectFactorySingleton;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.MakeProjectClassPathProvider;
import org.netbeans.modules.cnd.makeproject.MakeProjectConfigurationProvider;
import org.netbeans.modules.cnd.makeproject.MakeProjectEncodingQueryImpl;
import org.netbeans.modules.cnd.makeproject.MakeProjectFileProviderFactory;
import org.netbeans.modules.cnd.makeproject.MakeProjectOperations;
import org.netbeans.modules.cnd.makeproject.MakeProjectTypeImpl;
import org.netbeans.modules.cnd.makeproject.MakeSharabilityQuery;
import org.netbeans.modules.cnd.makeproject.MakeSources;
import org.netbeans.modules.cnd.makeproject.MakeTemplateListener;
import org.netbeans.modules.cnd.makeproject.NativeProjectProvider;
import org.netbeans.modules.cnd.makeproject.NativeProjectSettingsImpl;
import org.netbeans.modules.cnd.makeproject.TemplateAttributesProviderImpl;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifactProvider;
import org.netbeans.modules.cnd.makeproject.api.MakeCustomizerProvider;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectCustomizer;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectEvent;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectHelper;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectLife;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectListener;
import org.netbeans.modules.cnd.makeproject.ui.FolderSearchInfo;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.source.spi.CndDocumentCodeStyleProvider;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.spi.toolchain.ToolchainProject;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.CacheDirectoryProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.LookupProviderSupport;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.netbeans.spi.project.ui.support.UILookupMergerSupport;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.Places;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class MakeProject
implements Project,
MakeProjectListener {
    private static final boolean UNIT_TEST_MODE = CndUtils.isUnitTestMode();
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.cnd.makeproject");
    private static final String HEADER_EXTENSIONS = "header-extensions";
    private static final String C_EXTENSIONS = "c-extensions";
    private static final String CPP_EXTENSIONS = "cpp-extensions";
    private final RequestProcessor RP;
    private static MakeTemplateListener templateListener = null;
    private final MakeProjectTypeImpl kind;
    private final MakeProjectHelper helper;
    private final NativeProject nativeProject;
    private final Lookup lookup;
    private final ConfigurationDescriptorProviderImpl projectDescriptorProvider;
    private final Set<String> headerExtensions = MakeProject.createExtensionSet();
    private final Set<String> cExtensions = MakeProject.createExtensionSet();
    private final Set<String> cppExtensions = MakeProject.createExtensionSet();
    private String sourceEncoding = null;
    private AtomicBoolean projectFormattingStyle;
    private CodeStyleWrapper cFormattingSytle;
    private CodeStyleWrapper cppFormattingSytle;
    private CodeStyleWrapper headerFormattingSytle;
    private final AtomicBoolean openStateAndLock = new AtomicBoolean(false);
    private final AtomicBoolean isDeleted = new AtomicBoolean(false);
    private final AtomicBoolean isDeleting = new AtomicBoolean(false);
    private final MakeSources sources;
    private final MutableCP sourcepath;
    private final PropertyChangeListener indexerListener;
    private String configurationXMLComment;
    private final Set<MyInterrupter> interrupters = new WeakSet();
    private static final Pattern VALID_PROPERTY_NAME = Pattern.compile("[-._a-zA-Z0-9]+");
    private static final String PROJECT_NAME_WITH_HIDDEN_PATHS = System.getProperty("cnd.project.name.hidden.paths");
    private static final int PROJECT_NAME_NUM_SHOWN_FOLDERS = Integer.getInteger("cnd.project.name.folders.num", 1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MakeProject(MakeProjectHelper helper) throws IOException {
        LOGGER.log(Level.FINE, "Start of creation MakeProject@{0} {1}", new Object[]{System.identityHashCode(this), helper.getProjectDirectory()});
        this.kind = MakeBasedProjectFactorySingleton.TYPE_INSTANCE;
        this.helper = helper;
        this.RP = new RequestProcessor("Open/Close project " + helper.getProjectDirectory(), 1);
        AuxiliaryConfiguration aux = helper.createAuxiliaryConfiguration();
        this.projectDescriptorProvider = new ConfigurationDescriptorProviderImpl(this, helper.getProjectDirectory());
        LOGGER.log(Level.FINE, "Create ConfigurationDescriptorProvider@{0} for MakeProject@{1} {2}", new Object[]{System.identityHashCode(this.projectDescriptorProvider), System.identityHashCode(this), helper.getProjectDirectory()});
        this.sources = new MakeSources(this, helper);
        this.sourcepath = new MutableCP(this.sources);
        this.indexerListener = new IndexerOptionsListener(this);
        this.lookup = this.createLookup(aux);
        this.nativeProject = (NativeProject)this.lookup.lookup(NativeProject.class);
        Element data = helper.getPrimaryConfigurationData(true);
        this.readProjectExtension(data, HEADER_EXTENSIONS, this.headerExtensions);
        this.readProjectExtension(data, C_EXTENSIONS, this.cExtensions);
        this.readProjectExtension(data, CPP_EXTENSIONS, this.cppExtensions);
        this.sourceEncoding = this.getSourceEncodingFromProjectXml();
        Class<MakeProject> clazz = MakeProject.class;
        synchronized (MakeProject.class) {
            if (templateListener == null) {
                templateListener = MakeTemplateListener.createInstance();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            LOGGER.log(Level.FINE, "End of creation MakeProject@{0} {1}", new Object[]{System.identityHashCode(this), helper.getProjectDirectory()});
            return;
        }
    }

    private void readProjectExtension(Element data, String key, Set<String> set) {
        NodeList nl = data.getElementsByTagName(key);
        if (nl.getLength() == 1 && (nl = nl.item(0).getChildNodes()).getLength() == 1) {
            String extensions = nl.item(0).getNodeValue();
            set.addAll(Arrays.asList(extensions.split(",")));
        }
    }

    public ExecutionEnvironment getFileSystemHost() {
        return FileSystemProvider.getExecutionEnvironment((FileObject)this.helper.getProjectDirectory());
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public String toString() {
        return "MakeProject[" + this.getProjectDirectory() + "]";
    }

    public void setConfigurationXMLComment(String configurationXMLComment) {
        this.configurationXMLComment = configurationXMLComment;
    }

    public String getConfigurationXMLComment() {
        return this.configurationXMLComment;
    }

    public MakeProjectHelper getMakeProjectHelper() {
        return this.helper;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private Lookup createLookup(AuxiliaryConfiguration aux) {
        MakeSubprojectProvider spp = new MakeSubprojectProvider(this);
        Info info = new Info(this);
        MakeProjectConfigurationProvider makeProjectConfigurationProvider = new MakeProjectConfigurationProvider(this, this.projectDescriptorProvider, info);
        RemoteProjectImpl remoteProject = new RemoteProjectImpl(this);
        MakeProjectEncodingQueryImpl encodingQuery = new MakeProjectEncodingQueryImpl(this);
        Object[] lookups = new Object[]{info, aux, spp, new MakeActionProvider(this), new MakeLogicalViewProvider(this), new MakeCustomizerProvider(this, this.projectDescriptorProvider), new MakeArtifactProviderImpl(this), UILookupMergerSupport.createProjectOpenHookMerger((ProjectOpenedHook)new ProjectOpenedHookImpl(this)), new MakeSharabilityQuery(this.projectDescriptorProvider, this.getProjectDirectory()), this.sources, this.helper, this.projectDescriptorProvider, makeProjectConfigurationProvider, new NativeProjectSettingsImpl(this, this.kind.getPrimaryConfigurationDataElementNamespace(false), false), new RecommendedTemplatesImpl(this.projectDescriptorProvider), new MakeProjectOperations(this), new MakeProjectSearchInfo(this.projectDescriptorProvider), this.kind, encodingQuery, remoteProject, new ToolchainProjectImpl(this), new CacheDirectoryProviderImpl(this.helper.getProjectDirectory()), BrokenReferencesSupport.createPlatformVersionProblemProvider(this, this.helper, this.projectDescriptorProvider, makeProjectConfigurationProvider), new CndDocumentCodeStyleProviderImpl(), new TemplateAttributesProviderImpl(this, encodingQuery), this};
        MakeProjectCustomizer makeProjectCustomizer = this.getProjectCustomizer(this.getProjectCustomizerId());
        if (makeProjectCustomizer != null) {
            lookups = makeProjectCustomizer.getLookup(this.getProjectDirectory(), lookups);
        }
        boolean containsNativeProject = false;
        for (Object object : lookups) {
            if (!(object instanceof NativeProject)) continue;
            containsNativeProject = true;
            break;
        }
        if (!containsNativeProject) {
            lookups = MakeProject.augment(lookups, new NativeProjectProvider(this, remoteProject, this.projectDescriptorProvider));
        }
        Lookup lkp = Lookups.fixed((Object[])lookups);
        return LookupProviderSupport.createCompositeLookup((Lookup)lkp, (String)this.kind.getLookupMergerPath());
    }

    private static <T> T[] augment(T[] array, T value) {
        ArrayList<T> newLookups = new ArrayList<T>();
        newLookups.addAll(Arrays.asList(array));
        newLookups.add(value);
        return newLookups.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProjectProperties(boolean shared) {
        Properties props = new Properties();
        FileObject propsFO = shared ? this.helper.getProjectDirectory().getFileObject("nbproject/project.properties") : this.helper.getProjectDirectory().getFileObject("nbproject/private/private.properties");
        if (propsFO != null && propsFO.isValid()) {
            InputStream is = null;
            try {
                is = propsFO.getInputStream();
                props.load(is);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getCacheLocation(FileObject projectDirectory) {
        String[] propertyPaths = new String[]{"nbproject/private/private.properties", "nbproject/project.properties"};
        for (int i = 0; i < propertyPaths.length; ++i) {
            FileObject propsFO = projectDirectory.getFileObject(propertyPaths[i]);
            if (propsFO == null || !propsFO.isValid()) continue;
            Properties props = new Properties();
            InputStream is = null;
            try {
                is = propsFO.getInputStream();
                props.load(is);
                String path = props.getProperty("cache.location");
                if (path == null) continue;
                if (CndPathUtilities.isPathAbsolute((CharSequence)path)) {
                    File file = new File(path);
                    return file;
                }
                File file = new File(projectDirectory.getPath() + '/' + path);
                return file;
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                continue;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.INFO, "Error closing " + propsFO.getPath(), ex);
                    }
                }
            }
        }
        if (DebugUtils.getBoolean((String)"cnd.cache.in.project", (boolean)false) && CndFileUtils.isLocalFileSystem((FileObject)projectDirectory)) {
            File cache = new File(projectDirectory.getPath() + "/nbproject/private/cache/model");
            cache.mkdirs();
            if (cache.exists()) {
                return cache;
            }
        }
        return null;
    }

    @Override
    public void configurationXmlChanged(MakeProjectEvent ev) {
        if (ev.getPath().equals("nbproject/project.xml")) {
            Info info = (Info)this.getLookup().lookup(ProjectInformation.class);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    @Override
    public void propertiesChanged(MakeProjectEvent ev) {
    }

    public boolean addAdditionalHeaderExtensions(Collection<String> needAdd) {
        Set<String> headerExtension = MakeProject.getHeaderSuffixes();
        Set<String> sourceExtension = MakeProject.getSourceSuffixes();
        Set<String> usedExtension = MakeProject.createExtensionSet();
        for (String extension : needAdd) {
            if (extension.length() <= 0 || headerExtension.contains(extension) || sourceExtension.contains(extension)) continue;
            usedExtension.add(extension);
        }
        if (usedExtension.size() > 0) {
            this.addMIMETypeExtensions(usedExtension, "text/x-h");
            this.headerExtensions.addAll(usedExtension);
            this.saveAdditionalExtensions();
            return true;
        }
        return false;
    }

    private void addMIMETypeExtensions(Collection<String> extensions, String mime) {
        MIMEExtensions exts = MIMEExtensions.get((String)mime);
        for (String ext : extensions) {
            exts.addExtension(ext);
        }
        CndFileVisibilityQuery.getDefault().stateChanged(null);
    }

    private Set<String> getUnknownExtensions(Set<String> inLoader, Set<String> inProject) {
        Set<String> unknown = MakeProject.createExtensionSet();
        for (String extension : inProject) {
            if (extension.length() <= 0 || inLoader.contains(extension)) continue;
            unknown.add(extension);
        }
        return unknown;
    }

    private void checkNeededExtensions() {
        if (UNIT_TEST_MODE || CndUtils.isStandalone()) {
            return;
        }
        Set<String> unknownC = this.getUnknownExtensions(MakeProject.getCSuffixes(), this.cExtensions);
        Set<String> unknownCpp = this.getUnknownExtensions(MakeProject.getCppSuffixes(), this.cppExtensions);
        Set<String> unknownH = this.getUnknownExtensions(MakeProject.getHeaderSuffixes(), this.headerExtensions);
        if (!unknownC.isEmpty() && unknownCpp.isEmpty() && unknownH.isEmpty()) {
            if (unknownC.size() > 0 && this.addNewExtensionDialog(unknownC, "C")) {
                this.addMIMETypeExtensions(unknownC, "text/x-c");
            }
        } else if (unknownC.isEmpty() && !unknownCpp.isEmpty() && unknownH.isEmpty()) {
            if (this.addNewExtensionDialog(unknownCpp, "CPP")) {
                this.addMIMETypeExtensions(unknownCpp, "text/x-c++");
            }
        } else if (unknownC.isEmpty() && unknownCpp.isEmpty() && !unknownH.isEmpty()) {
            if (this.addNewExtensionDialog(unknownH, "H")) {
                this.addMIMETypeExtensions(unknownH, "text/x-h");
            }
        } else if (!(unknownC.isEmpty() && unknownCpp.isEmpty() && unknownH.isEmpty())) {
            ConfirmExtensions panel = new ConfirmExtensions(unknownC, unknownCpp, unknownH);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, MakeProject.getString("ConfirmExtensions.dialog.title"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                if (panel.isC()) {
                    this.addMIMETypeExtensions(unknownC, "text/x-c");
                }
                if (panel.isCpp()) {
                    this.addMIMETypeExtensions(unknownCpp, "text/x-c++");
                }
                if (panel.isHeader()) {
                    this.addMIMETypeExtensions(unknownH, "text/x-h");
                }
            }
        }
    }

    public void updateExtensions(Set<String> cSet, Set<String> cppSet, Set<String> hSet) {
        this.cExtensions.clear();
        this.cExtensions.addAll(cSet);
        this.cppExtensions.clear();
        this.cppExtensions.addAll(cppSet);
        this.headerExtensions.clear();
        this.headerExtensions.addAll(hSet);
        this.saveAdditionalExtensions();
    }

    private synchronized void registerClassPath(boolean register) {
        if (register) {
            MakeProjectClassPathProvider.addProjectCP(this.sourcepath.getClassPath());
            if (MakeOptions.getInstance().isFullFileIndexer()) {
                GlobalPathRegistry.getDefault().register("org.netbeans.modules.cnd.makeproject/SOURCES", this.sourcepath.getClassPath());
            }
        } else {
            MakeProjectClassPathProvider.removeProjectCP(this.sourcepath.getClassPath());
            try {
                GlobalPathRegistry.getDefault().unregister("org.netbeans.modules.cnd.makeproject/SOURCES", this.sourcepath.getClassPath());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void saveAdditionalExtensions() {
        Element data = this.helper.getPrimaryConfigurationData(true);
        boolean changed = false;
        changed |= this.saveAdditionalHeaderExtensions(data, C_EXTENSIONS, this.cExtensions);
        changed |= this.saveAdditionalHeaderExtensions(data, CPP_EXTENSIONS, this.cppExtensions);
        if (changed |= this.saveAdditionalHeaderExtensions(data, HEADER_EXTENSIONS, this.headerExtensions)) {
            this.helper.putPrimaryConfigurationData(data, true);
        }
    }

    private boolean saveAdditionalHeaderExtensions(Element data, String key, Set<String> set) {
        Element element;
        StringBuilder buf = new StringBuilder();
        for (String e : set) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(e);
        }
        String newText = buf.toString();
        NodeList nodeList = data.getElementsByTagName(key);
        if (nodeList.getLength() == 1) {
            String text;
            element = (Element)nodeList.item(0);
            NodeList deadKids = element.getChildNodes();
            if (deadKids.getLength() == 1 ? (text = deadKids.item(0).getTextContent()).equals(newText) : deadKids.getLength() == 0 && newText.isEmpty()) {
                return false;
            }
            while (deadKids.getLength() > 0) {
                element.removeChild(deadKids.item(0));
            }
        } else {
            element = data.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/make-project/1", key);
            data.appendChild(element);
        }
        element.appendChild(data.getOwnerDocument().createTextNode(buf.toString()));
        return true;
    }

    private boolean addNewExtensionDialog(Set<String> usedExtension, String type) {
        if (UNIT_TEST_MODE || CndUtils.isStandalone()) {
            return true;
        }
        String message = MakeProject.getString("ADD_EXTENSION_QUESTION" + type + (usedExtension.size() == 1 ? "" : "S"));
        StringBuilder extensions = new StringBuilder();
        for (String ext : usedExtension) {
            if (extensions.length() > 0) {
                extensions.append(',');
            }
            extensions.append(ext);
        }
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(message, extensions.toString()), MakeProject.getString("ADD_EXTENSION_DIALOG_TITLE" + type + (usedExtension.size() == 1 ? "" : "S")), 0);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION;
    }

    public static Set<String> createExtensionSet() {
        if (CndFileUtils.isSystemCaseSensitive()) {
            return new TreeSet<String>();
        }
        return new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    }

    private static Set<String> getSourceSuffixes() {
        Set<String> suffixes = MakeProject.createExtensionSet();
        suffixes.addAll(MIMEExtensions.get((String)"text/x-c++").getValues());
        suffixes.addAll(MIMEExtensions.get((String)"text/x-c").getValues());
        return suffixes;
    }

    private static Set<String> getCSuffixes() {
        Set<String> suffixes = MakeProject.createExtensionSet();
        suffixes.addAll(MIMEExtensions.get((String)"text/x-c").getValues());
        return suffixes;
    }

    private static Set<String> getCppSuffixes() {
        Set<String> suffixes = MakeProject.createExtensionSet();
        suffixes.addAll(MIMEExtensions.get((String)"text/x-c++").getValues());
        return suffixes;
    }

    private static Set<String> getHeaderSuffixes() {
        Set<String> suffixes = MakeProject.createExtensionSet();
        suffixes.addAll(MIMEExtensions.get((String)"text/x-h").getValues());
        return suffixes;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(MakeProject.class, (String)s);
    }

    public String getSourceEncodingFromProjectXml() {
        int i;
        Element data = this.helper.getPrimaryConfigurationData(true);
        NodeList nodeList = data.getElementsByTagName("sourceEncoding");
        if (nodeList != null && nodeList.getLength() > 0 && (i = 0) < nodeList.getLength()) {
            Node node = nodeList.item(i);
            return node.getTextContent();
        }
        return null;
    }

    public boolean isProjectFormattingStyle() {
        if (this.projectFormattingStyle == null) {
            int i;
            Element data = this.helper.getPrimaryConfigurationData(true);
            NodeList nodeList = data.getElementsByTagName("project-formatting-style");
            if (nodeList != null && nodeList.getLength() > 0 && (i = 0) < nodeList.getLength()) {
                Node node = nodeList.item(i);
                this.projectFormattingStyle = new AtomicBoolean("true".equals(node.getTextContent()));
            }
            if (this.projectFormattingStyle == null) {
                this.projectFormattingStyle = new AtomicBoolean(false);
            }
        } else {
            return this.projectFormattingStyle.get();
        }
        return false;
    }

    public void setProjectFormattingStyle(boolean isProject) {
        if (this.projectFormattingStyle != null) {
            this.projectFormattingStyle.set(isProject);
        } else {
            this.projectFormattingStyle = new AtomicBoolean(isProject);
        }
    }

    public CodeStyleWrapper getProjectFormattingStyle(String mime) {
        int i;
        NodeList nodeList = null;
        if ("text/x-c".equals(mime)) {
            if (this.cFormattingSytle != null) {
                return this.cFormattingSytle;
            }
            nodeList = this.helper.getPrimaryConfigurationData(true).getElementsByTagName("c-style");
        } else if ("text/x-c++".equals(mime)) {
            if (this.cppFormattingSytle != null) {
                return this.cppFormattingSytle;
            }
            nodeList = this.helper.getPrimaryConfigurationData(true).getElementsByTagName("cpp-style");
        } else if ("text/x-h".equals(mime)) {
            if (this.headerFormattingSytle != null) {
                return this.headerFormattingSytle;
            }
            nodeList = this.helper.getPrimaryConfigurationData(true).getElementsByTagName("header-style");
        }
        String res = null;
        if (nodeList != null && nodeList.getLength() > 0 && (i = 0) < nodeList.getLength()) {
            Node node = nodeList.item(i);
            res = node.getTextContent();
        }
        if (res != null) {
            if ("text/x-c".equals(mime)) {
                this.cFormattingSytle = new CodeStyleWrapper(res);
                return this.cFormattingSytle;
            }
            if ("text/x-c++".equals(mime)) {
                this.cppFormattingSytle = new CodeStyleWrapper(res);
                return this.cppFormattingSytle;
            }
            if ("text/x-h".equals(mime)) {
                this.headerFormattingSytle = new CodeStyleWrapper(res);
                return this.headerFormattingSytle;
            }
        }
        return null;
    }

    public void setProjectFormattingStyle(String mime, CodeStyleWrapper style) {
        if ("text/x-c".equals(mime)) {
            this.cFormattingSytle = style;
        } else if ("text/x-c++".equals(mime)) {
            this.cppFormattingSytle = style;
        } else if ("text/x-h".equals(mime)) {
            this.headerFormattingSytle = style;
        }
    }

    public String getSourceEncoding() {
        if (this.sourceEncoding == null && !this.projectDescriptorProvider.gotDescriptor()) {
            return FileEncodingQuery.getDefaultEncoding().name();
        }
        if (this.sourceEncoding == null) {
            this.sourceEncoding = FileEncodingQuery.getDefaultEncoding().name();
        }
        return this.sourceEncoding;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    private MakeProjectCustomizer getProjectCustomizer(String customizerId) {
        if (customizerId == null) {
            return null;
        }
        MakeProjectCustomizer makeProjectCustomizer = null;
        Collection mwc = Lookup.getDefault().lookupAll(MakeProjectCustomizer.class);
        for (MakeProjectCustomizer instance : mwc) {
            if (!customizerId.equals(instance.getCustomizerId())) continue;
            makeProjectCustomizer = instance;
            break;
        }
        return makeProjectCustomizer;
    }

    private String getProjectCustomizerId() {
        String id = this.getCustomizerIdFromProjectXML();
        if (id == null) {
            FileObject[] children;
            for (FileObject c : children = this.getProjectDirectory().getChildren()) {
                String name = c.getName();
                String ext = c.getExt();
                if (!name.equals("cndcustomizerid")) continue;
                id = ext;
                break;
            }
        }
        return id;
    }

    private String getCustomizerIdFromProjectXML() {
        Node typeNode;
        Element data = this.helper.getPrimaryConfigurationData(true);
        NodeList nodeList = data.getElementsByTagName("customizerid");
        if (nodeList != null && nodeList.getLength() > 0 && (typeNode = nodeList.item(0).getFirstChild()) != null) {
            String type = typeNode.getNodeValue();
            return type;
        }
        return null;
    }

    private int getActiveConfigurationType() {
        MakeConfiguration makeConfiguration = this.getActiveConfiguration();
        if (makeConfiguration != null) {
            return makeConfiguration.getConfigurationType().getValue();
        }
        int type = this.getActiveConfigurationTypeFromPrivateXML();
        if (type >= 0) {
            return type;
        }
        type = this.getActiveConfigurationTypeFromProjectXML();
        if (type >= 0) {
            return type;
        }
        return type;
    }

    private int getActiveConfigurationTypeFromProjectXML() {
        Node typeNode;
        Element data = this.helper.getPrimaryConfigurationData(true);
        NodeList nodeList = data.getElementsByTagName("type");
        if (nodeList != null && nodeList.getLength() > 0 && (typeNode = nodeList.item(0).getFirstChild()) != null) {
            String type = typeNode.getNodeValue();
            try {
                return Integer.parseInt(type);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return -1;
    }

    private int getActiveConfigurationTypeFromPrivateXML() {
        Element data = this.helper.getPrimaryConfigurationData(false);
        NodeList nodeList = data.getElementsByTagName("activeConfTypeElem");
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                try {
                    return Integer.parseInt(node.getTextContent());
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
            }
        }
        return -1;
    }

    public int getActiveConfigurationIndexFromPrivateXML() {
        Element data = this.helper.getPrimaryConfigurationData(false);
        NodeList nodeList = data.getElementsByTagName("activeConfIndexElem");
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                try {
                    return Integer.parseInt(node.getTextContent());
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
            }
        }
        return -1;
    }

    public MakeConfiguration getActiveConfiguration() {
        MakeConfigurationDescriptor projectDescriptor;
        if (this.projectDescriptorProvider.gotDescriptor() && (projectDescriptor = this.projectDescriptorProvider.getConfigurationDescriptor()) != null) {
            return projectDescriptor.getActiveConfiguration();
        }
        return null;
    }

    private static boolean isUsablePropertyName(String name) {
        return VALID_PROPERTY_NAME.matcher(name).matches();
    }

    private static String getUsablePropertyName(String name) {
        if (MakeProject.isUsablePropertyName(name)) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name);
        for (int i = 0; i < sb.length(); ++i) {
            if (MakeProject.isUsablePropertyName(sb.substring(i, i + 1))) continue;
            sb.replace(i, i + 1, "_");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onProjectOpened() {
        AtomicBoolean atomicBoolean = this.openStateAndLock;
        synchronized (atomicBoolean) {
            if (this.openStateAndLock.get()) {
                return;
            }
            this.notifyProjectStartActivity();
            MyInterrupter interrupter = new MyInterrupter();
            this.interrupters.add(interrupter);
            final FileObject dir = this.getProjectDirectory();
            if (dir != null) {
                ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileObject)dir);
                ConnectionHelper.INSTANCE.ensureConnection(env);
            }
            this.helper.removeMakeProjectListener(this);
            this.projectDescriptorProvider.opening(interrupter);
            this.helper.addMakeProjectListener(this);
            this.checkNeededExtensions();
            MakeOptions.getInstance().addPropertyChangeListener(this.indexerListener);
            this.openStateAndLock.set(true);
            this.RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AtomicBoolean atomicBoolean = MakeProject.this.openStateAndLock;
                    synchronized (atomicBoolean) {
                        if (!MakeProject.this.openStateAndLock.get()) {
                            return;
                        }
                    }
                    MakeProject.this.projectDescriptorProvider.opened();
                    MakeProject.this.createLaunchersFileIfNeeded(dir);
                    atomicBoolean = MakeProject.this.openStateAndLock;
                    synchronized (atomicBoolean) {
                        if (MakeProject.this.openStateAndLock.get()) {
                            if (MakeProject.this.nativeProject instanceof NativeProjectProvider) {
                                MakeProject.this.warmupNativeProject();
                                NativeProjectRegistry.getDefault().register(MakeProject.this.nativeProject);
                            }
                            MakeProject.this.registerClassPath(true);
                        }
                    }
                }
            });
        }
    }

    private void warmupNativeProject() {
        FileSystemProvider.warmup((FileSystemProvider.WarmupMode)FileSystemProvider.WarmupMode.RECURSIVE_LS, (ExecutionEnvironment)FileSystemProvider.getExecutionEnvironment((FileObject)this.helper.getProjectDirectory()), (Collection)this.nativeProject.getSourceRoots(), null);
        HashSet<String> extensions = new HashSet<String>();
        extensions.addAll(this.cExtensions);
        extensions.addAll(this.cppExtensions);
        extensions.addAll(this.headerExtensions);
        FileSystemProvider.warmup((FileSystemProvider.WarmupMode)FileSystemProvider.WarmupMode.FILES_CONTENT, (ExecutionEnvironment)FileSystemProvider.getExecutionEnvironment((FileObject)this.helper.getProjectDirectory()), (Collection)this.nativeProject.getSourceRoots(), extensions);
        List sysIncPaths = this.nativeProject.getSystemIncludePaths();
        if (sysIncPaths != null && !sysIncPaths.isEmpty()) {
            ExecutionEnvironment env = null;
            ArrayList<String> paths = new ArrayList<String>(sysIncPaths.size());
            for (FSPath fsp : sysIncPaths) {
                if (env == null) {
                    env = FileSystemProvider.getExecutionEnvironment((FileSystem)fsp.getFileSystem());
                } else {
                    CndUtils.assertTrue((boolean)env.equals((Object)FileSystemProvider.getExecutionEnvironment((FileSystem)fsp.getFileSystem())));
                }
                paths.add(fsp.getPath());
            }
            FileSystemProvider.warmup((FileSystemProvider.WarmupMode)FileSystemProvider.WarmupMode.FILES_CONTENT, env, paths, null);
        }
    }

    private void createLaunchersFileIfNeeded(FileObject projectDir) {
        CndUtils.assertNonUiThread();
        if (projectDir == null) {
            return;
        }
        try {
            FileObject projectPrivateFolder = projectDir.getFileObject("nbproject/private");
            if (projectPrivateFolder == null) {
                FileObject projectFolder = projectDir.getFileObject("nbproject");
                if (projectFolder == null || !projectFolder.canWrite()) {
                    return;
                }
                projectPrivateFolder = projectFolder.createFolder("private");
            }
            FileObject launchers = projectPrivateFolder.getFileObject("launcher.properties");
            if (!projectPrivateFolder.canWrite() || launchers != null && launchers.isValid()) {
                return;
            }
            String resource = "/org/netbeans/modules/cnd/makeproject/launchers/resources/simple-launcher.template";
            URL url = MakeConfiguration.class.getResource(resource);
            FileObject fo = URLMapper.findFileObject((URL)url);
            fo.copy(projectPrivateFolder, "launcher", "properties");
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, "error on creating launchers file ", ex);
        }
    }

    private void notifyProjectStartActivity() {
        for (MakeProjectLife service : Lookup.getDefault().lookupAll(MakeProjectLife.class)) {
            service.start(this);
        }
    }

    public boolean isDeleted() {
        return this.isDeleted.get() || this.isDeleting.get();
    }

    void setDeleted() {
        LOGGER.log(Level.FINE, "set deleted MakeProject@{0} {1}", new Object[]{System.identityHashCode(this), this.helper.getProjectDirectory()});
        this.isDeleted.set(true);
    }

    void setDeleting(boolean value) {
        LOGGER.log(Level.FINE, "set deleting MakeProject@{0} {1}", new Object[]{System.identityHashCode(this), this.helper.getProjectDirectory()});
        this.isDeleting.set(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onProjectClosed() {
        AtomicBoolean atomicBoolean = this.openStateAndLock;
        synchronized (atomicBoolean) {
            if (!this.openStateAndLock.get()) {
                LOGGER.log(Level.WARNING, "on project close for not opened MakeProject@{0} {1}", new Object[]{System.identityHashCode(this), this.helper.getProjectDirectory()});
                return;
            }
            Iterator<MyInterrupter> iterator = this.interrupters.iterator();
            while (iterator.hasNext()) {
                iterator.next().cancel();
            }
            LOGGER.log(Level.FINE, "on project close MakeProject@{0} {1}", new Object[]{System.identityHashCode(this), this.helper.getProjectDirectory()});
            this.helper.removeMakeProjectListener(this);
            this.save();
            MakeOptions.getInstance().removePropertyChangeListener(this.indexerListener);
            MakeProjectFileProviderFactory.removeSearchBase(this);
            this.openStateAndLock.set(false);
            this.RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AtomicBoolean atomicBoolean = MakeProject.this.openStateAndLock;
                    synchronized (atomicBoolean) {
                        if (MakeProject.this.openStateAndLock.get()) {
                            return;
                        }
                    }
                    atomicBoolean = MakeProject.this.openStateAndLock;
                    synchronized (atomicBoolean) {
                        if (!MakeProject.this.openStateAndLock.get()) {
                            if (MakeProject.this.nativeProject instanceof NativeProjectProvider) {
                                NativeProjectRegistry.getDefault().unregister(MakeProject.this.nativeProject, MakeProject.this.isDeleted());
                            }
                            MakeProject.this.registerClassPath(false);
                            MakeProject.this.projectDescriptorProvider.closed();
                            MakeProject.this.notifyProjectStopActivity();
                        }
                    }
                }
            });
        }
    }

    private void notifyProjectStopActivity() {
        for (MakeProjectLife service : Lookup.getDefault().lookupAll(MakeProjectLife.class)) {
            service.stop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        AtomicBoolean atomicBoolean = this.openStateAndLock;
        synchronized (atomicBoolean) {
            if (!this.isDeleted.get() && !this.isDeleting.get() && this.projectDescriptorProvider.gotDescriptor()) {
                this.projectDescriptorProvider.getConfigurationDescriptor().save();
            }
        }
    }

    public DevelopmentHostConfiguration getDevelopmentHostConfiguration() {
        MakeConfiguration conf = this.getActiveConfiguration();
        if (conf != null) {
            return conf.getDevelopmentHost();
        }
        return null;
    }

    public ExecutionEnvironment getDevelopmentHostExecutionEnvironment() {
        DevelopmentHostConfiguration dc = this.getDevelopmentHostConfiguration();
        return dc == null ? null : dc.getExecutionEnvironment();
    }

    public static final class CodeStyleWrapper {
        private final String styleId;
        private final String displayName;

        public CodeStyleWrapper(String styleId, String displayName) {
            this.styleId = styleId;
            this.displayName = displayName;
        }

        private CodeStyleWrapper(String styleIdAndDisplayName) {
            int i = styleIdAndDisplayName.indexOf(124);
            if (i > 0) {
                this.styleId = styleIdAndDisplayName.substring(0, i);
                this.displayName = styleIdAndDisplayName.substring(i + 1);
            } else {
                this.styleId = styleIdAndDisplayName;
                this.displayName = styleIdAndDisplayName;
            }
        }

        public String getStyleId() {
            return this.styleId;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String toExternal() {
            return this.styleId + '|' + this.displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }

    private final class CndDocumentCodeStyleProviderImpl
    implements CndDocumentCodeStyleProvider {
        private CndDocumentCodeStyleProviderImpl() {
        }

        public String getCurrentCodeStyle(String mimeType, Document doc) {
            CodeStyleWrapper style;
            if (MakeProject.this.isProjectFormattingStyle() && (style = MakeProject.this.getProjectFormattingStyle(mimeType)) != null) {
                return style.styleId;
            }
            return null;
        }
    }

    private static final class MyInterrupter
    implements Interrupter,
    Cancellable {
        private final AtomicBoolean cancelled = new AtomicBoolean(false);

        private MyInterrupter() {
        }

        public boolean cancelled() {
            return this.cancelled.get();
        }

        public boolean cancel() {
            this.cancelled.set(true);
            return true;
        }
    }

    private static final class IndexerOptionsListener
    implements PropertyChangeListener {
        private final MakeProject project;

        private IndexerOptionsListener(MakeProject prj) {
            this.project = prj;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("fullFileIndexer".equals(evt.getPropertyName())) {
                this.project.registerClassPath(Boolean.TRUE.equals(evt.getNewValue()));
            }
        }
    }

    static final class PathResourceImpl
    implements FilteringPathResourceImplementation,
    PropertyChangeListener {
        private final PathResourceImplementation delegate;
        private static final String IGNORE_PATTERN = ".*\\.(html|js|xhtml|css|xml|png|svg|json|java)$";
        private static final Pattern ignoredFilesPattern = Pattern.compile(".*\\.(html|js|xhtml|css|xml|png|svg|json|java)$");
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        public PathResourceImpl(PathResourceImplementation delegate) {
            this.delegate = delegate;
            this.delegate.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public boolean includes(URL root, String resource) {
            if (ignoredFilesPattern.matcher(resource).find()) {
                return false;
            }
            return !CndFileVisibilityQuery.getDefault().isIgnored(resource);
        }

        public URL[] getRoots() {
            return this.delegate.getRoots();
        }

        public ClassPathImplementation getContent() {
            return this.delegate.getContent();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.pcs.firePropertyChange(new PropertyChangeEvent(this, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()));
        }
    }

    private static final class MutableCP
    implements ClassPathImplementation,
    ChangeListener {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final MakeSources sources;
        private List<PathResourceImplementation> resources = null;
        private long eventId = 0L;
        private ClassPath[] classpath = null;

        public MutableCP(MakeSources sources) {
            this.sources = sources;
            this.sources.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.sources));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends PathResourceImplementation> getResources() {
            SourceGroup[] groups;
            long currentEventId;
            MutableCP mutableCP = this;
            synchronized (mutableCP) {
                if (this.resources != null) {
                    return this.resources;
                }
                currentEventId = this.eventId;
            }
            LinkedList<PathResourceImplementation> list = new LinkedList<PathResourceImplementation>();
            for (SourceGroup g : groups = this.sources.getSourceGroups("generic")) {
                FileObject rootFolder = g.getRootFolder();
                if (!rootFolder.isValid()) continue;
                URL url = rootFolder.toURL();
                if (rootFolder.isFolder() && !url.toExternalForm().endsWith("/")) {
                    try {
                        URL url2 = new URL(url.toExternalForm() + '/');
                        FileObject fo = URLMapper.findFileObject((URL)url2);
                        if (fo != null && fo.equals(rootFolder)) {
                            url = url2;
                        }
                    }
                    catch (MalformedURLException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                list.add((PathResourceImplementation)new PathResourceImpl(ClassPathSupport.createResource((URL)url)));
            }
            MutableCP mutableCP2 = this;
            synchronized (mutableCP2) {
                if (currentEventId == this.eventId) {
                    this.resources = list;
                }
            }
            return list;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            MutableCP mutableCP = this;
            synchronized (mutableCP) {
                this.resources = null;
                ++this.eventId;
            }
            this.pcs.firePropertyChange("resources", null, null);
        }

        public synchronized ClassPath[] getClassPath() {
            if (this.classpath == null) {
                this.classpath = new ClassPath[]{ClassPathFactory.createClassPath((ClassPathImplementation)this)};
            }
            return this.classpath;
        }
    }

    private static final class ToolchainProjectImpl
    implements ToolchainProject {
        private final MakeProject project;

        private ToolchainProjectImpl(MakeProject prj) {
            this.project = prj;
        }

        public CompilerSet getCompilerSet() {
            MakeConfiguration conf = this.project.getActiveConfiguration();
            if (conf != null) {
                return conf.getCompilerSet().getCompilerSet();
            }
            return null;
        }
    }

    private static final class RemoteProjectImpl
    implements RemoteProject {
        private final MakeProject project;

        private RemoteProjectImpl(MakeProject prj) {
            this.project = prj;
        }

        public ExecutionEnvironment getDevelopmentHost() {
            DevelopmentHostConfiguration devHost = this.project.getDevelopmentHostConfiguration();
            return devHost == null ? null : devHost.getExecutionEnvironment();
        }

        public ExecutionEnvironment getSourceFileSystemHost() {
            return FileSystemProvider.getExecutionEnvironment((FileObject)this.project.helper.getProjectDirectory());
        }

        public FileSystem getSourceFileSystem() {
            try {
                return this.project.getProjectDirectory().getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public RemoteSyncFactory getSyncFactory() {
            MakeConfiguration activeConfiguration = this.project.getActiveConfiguration();
            if (activeConfiguration != null) {
                if (CndFileUtils.isLocalFileSystem((FileSystem)activeConfiguration.getBaseFSPath().getFileSystem())) {
                    return activeConfiguration.getRemoteSyncFactory();
                }
                return RemoteSyncFactory.fromID((String)"full");
            }
            return null;
        }

        public String getSourceBaseDir() {
            return this.project.helper.getProjectDirectory().getPath();
        }

        public FileObject getSourceBaseDirFileObject() {
            return this.project.getProjectDirectory();
        }
    }

    private static final class MakeProjectSearchInfo
    extends SearchInfoDefinition {
        private ConfigurationDescriptorProvider projectDescriptorProvider;

        MakeProjectSearchInfo(ConfigurationDescriptorProvider projectDescriptorProvider) {
            this.projectDescriptorProvider = projectDescriptorProvider;
        }

        public boolean canSearch() {
            return true;
        }

        public List<SearchRoot> getSearchRoots() {
            MakeConfigurationDescriptor configurationDescriptor;
            ArrayList<SearchRoot> roots = new ArrayList<SearchRoot>();
            if (this.projectDescriptorProvider.gotDescriptor() && (configurationDescriptor = this.projectDescriptorProvider.getConfigurationDescriptor()) != null) {
                FileObject baseDirFileObject = configurationDescriptor.getBaseDirFileObject();
                roots.add(new SearchRoot(baseDirFileObject, null));
                for (String root : configurationDescriptor.getAbsoluteSourceRoots()) {
                    try {
                        FileObject fo = new FSPath(baseDirFileObject.getFileSystem(), root).getFileObject();
                        if (fo == null) continue;
                        roots.add(new SearchRoot(fo, null));
                    }
                    catch (FileStateInvalidException ex) {}
                }
            }
            return roots;
        }

        public Iterator<FileObject> filesToSearch(SearchScopeOptions options, SearchListener listener, AtomicBoolean terminated) {
            MakeConfigurationDescriptor configurationDescriptor;
            FolderSearchInfo.FileObjectNameMatcherImpl matcher = new FolderSearchInfo.FileObjectNameMatcherImpl(options, terminated);
            if (this.projectDescriptorProvider.gotDescriptor() && (configurationDescriptor = this.projectDescriptorProvider.getConfigurationDescriptor()) != null) {
                Item[] projectItems;
                Folder rootFolder = configurationDescriptor.getLogicalFolders();
                Set<FileObject> res = rootFolder.getAllItemsAsFileObjectSet(false, matcher);
                FileObject baseDirFileObject = this.projectDescriptorProvider.getConfigurationDescriptor().getBaseDirFileObject();
                for (Item item : projectItems = this.projectDescriptorProvider.getConfigurationDescriptor().getProjectItems()) {
                    FileObject fo = item.getFileObject();
                    if (fo == null || matcher != null && !matcher.pathMatches(fo)) continue;
                    res.add(fo);
                }
                this.addFolder(res, baseDirFileObject.getFileObject("nbproject"), matcher);
                this.addFolder(res, baseDirFileObject.getFileObject("nbproject/private"), matcher);
                return res.iterator();
            }
            return new ArrayList().iterator();
        }

        private void addFolder(Set<FileObject> res, FileObject fo, Folder.FileObjectNameMatcher matcher) {
            if (fo != null && fo.isFolder() && fo.isValid()) {
                if (matcher.isTerminated()) {
                    return;
                }
                for (FileObject f : fo.getChildren()) {
                    if (matcher.isTerminated()) {
                        return;
                    }
                    if (!f.isData() || !matcher.pathMatches(f)) continue;
                    res.add(f);
                }
            }
        }
    }

    private static final class MakeArtifactProviderImpl
    implements MakeArtifactProvider {
        private final MakeProject project;

        private MakeArtifactProviderImpl(MakeProject prj) {
            this.project = prj;
        }

        @Override
        public MakeArtifact[] getBuildArtifacts() {
            ArrayList<MakeArtifact> artifacts = new ArrayList<MakeArtifact>();
            MakeConfigurationDescriptor projectDescriptor = this.project.projectDescriptorProvider.getConfigurationDescriptor();
            if (projectDescriptor != null) {
                Configuration[] confs = projectDescriptor.getConfs().toArray();
                for (int i = 0; i < confs.length; ++i) {
                    MakeConfiguration makeConfiguration = (MakeConfiguration)confs[i];
                    artifacts.add(new MakeArtifact(projectDescriptor, makeConfiguration));
                }
            }
            return artifacts.toArray(new MakeArtifact[artifacts.size()]);
        }
    }

    private static final class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        private final MakeProject project;

        ProjectOpenedHookImpl(MakeProject prj) {
            this.project = prj;
        }

        protected void projectOpened() {
            this.project.onProjectOpened();
        }

        protected void projectClosed() {
            this.project.onProjectClosed();
        }
    }

    private static final class Info
    implements InfoInterface {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private String name;
        private final MakeProject project;

        Info(MakeProject prj) {
            this.project = prj;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("activeConfiguration".equals(evt.getPropertyName())) {
                this.firePropertyChange("icon");
            }
        }

        @Override
        public void firePropertyChange(String prop) {
            if ("name".equals(prop)) {
                this.name = null;
            }
            this.pcs.firePropertyChange(prop, null, null);
        }

        public String getName() {
            return MakeProject.getUsablePropertyName(this._getName());
        }

        private String _getName() {
            String res = this.name;
            if (res == null) {
                this.name = res = this.getNameImpl();
            }
            return res;
        }

        private String getNameImpl() {
            return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

                public String run() {
                    NodeList nl;
                    Element data = Info.this.project.helper.getPrimaryConfigurationData(true);
                    Element nameEl = Info.this.getNameElement(data);
                    if (nameEl != null && (nl = nameEl.getChildNodes()).getLength() == 1 && nl.item(0).getNodeType() == 3) {
                        return ((Text)nl.item(0)).getNodeValue();
                    }
                    FileObject fo = Info.this.project.getProjectDirectory();
                    if (fo != null && fo.isValid()) {
                        return fo.getNameExt();
                    }
                    return "???";
                }
            });
        }

        @Override
        public void setName(final String name) {
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    Element data = Info.this.project.helper.getPrimaryConfigurationData(true);
                    Element nameEl = Info.this.getNameElement(data);
                    if (nameEl != null) {
                        NodeList deadKids = nameEl.getChildNodes();
                        while (deadKids.getLength() > 0) {
                            nameEl.removeChild(deadKids.item(0));
                        }
                    } else {
                        nameEl = data.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/make-project/1", "name");
                        data.insertBefore(nameEl, data.getChildNodes().item(0));
                    }
                    nameEl.appendChild(data.getOwnerDocument().createTextNode(name));
                    Info.this.project.helper.putPrimaryConfigurationData(data, true);
                    return null;
                }
            });
            this._getName();
        }

        private Element getNameElement(Element data) {
            NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/make-project/1", "name");
            if (nl.getLength() > 0) {
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element e;
                    Node parentNode;
                    if (!(nl.item(i) instanceof Element) || (parentNode = (e = (Element)nl.item(i)).getParentNode()) == null || !parentNode.getLocalName().equals("data")) continue;
                    return e;
                }
            }
            return null;
        }

        public String getDisplayName() {
            FileObject fo;
            String aName = this._getName();
            if (PROJECT_NAME_WITH_HIDDEN_PATHS != null && (fo = this.project.getProjectDirectory()) != null && fo.isValid()) {
                String[] split;
                String prjDirDispName = FileUtil.getFileDisplayName((FileObject)fo);
                for (String skipPath : split = PROJECT_NAME_WITH_HIDDEN_PATHS.split(":")) {
                    if (!prjDirDispName.startsWith(skipPath)) continue;
                    prjDirDispName = prjDirDispName.substring(skipPath.length());
                    break;
                }
                if (prjDirDispName.startsWith("/") || prjDirDispName.startsWith("\\")) {
                    prjDirDispName = prjDirDispName.substring(1);
                }
                int sep = 0;
                for (int i = 0; i < PROJECT_NAME_NUM_SHOWN_FOLDERS; ++i) {
                    int nextSep = prjDirDispName.indexOf(92, sep);
                    int n = nextSep = nextSep == -1 ? prjDirDispName.indexOf(47, sep) : nextSep;
                    if (nextSep <= 0) {
                        sep = prjDirDispName.length();
                        break;
                    }
                    sep = nextSep + 1;
                }
                if (sep > 0) {
                    prjDirDispName = prjDirDispName.substring(0, sep);
                }
                if (prjDirDispName.length() > 0) {
                    if (prjDirDispName.endsWith("/") || prjDirDispName.endsWith("\\")) {
                        prjDirDispName = prjDirDispName.substring(0, prjDirDispName.length() - 1);
                    }
                    aName = NbBundle.getMessage(this.getClass(), (String)"PRJ_DISPLAY_NAME_WITH_FOLDER", (Object)aName, (Object)prjDirDispName);
                }
            }
            return aName;
        }

        private int getProjectType() {
            int aProjectType = this.project.getActiveConfigurationType();
            if (aProjectType != -1) {
                return aProjectType;
            }
            return -1;
        }

        public Icon getIcon() {
            int type = this.getProjectType();
            Icon icon = MakeConfigurationDescriptor.MAKEFILE_ICON;
            switch (type) {
                case 0: {
                    MakeConfiguration activeConfiguration = this.project.getActiveConfiguration();
                    if (activeConfiguration == null) break;
                    String outputValue = activeConfiguration.getOutputValue();
                    if (outputValue != null) {
                        if (outputValue.endsWith(".so") || outputValue.endsWith(".dll") || outputValue.endsWith(".dylib")) {
                            icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-unmanaged-dynamic.png", (boolean)false);
                            break;
                        }
                        if (outputValue.endsWith(".a")) {
                            icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-unmanaged-static.png", (boolean)false);
                            break;
                        }
                        icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-unmanaged.png", (boolean)false);
                        break;
                    }
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-unmanaged.png", (boolean)false);
                    break;
                }
                case 1: {
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-managed.png", (boolean)false);
                    break;
                }
                case 7: {
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-database.png", (boolean)false);
                    break;
                }
                case 2: {
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-managed-dynamic.png", (boolean)false);
                    break;
                }
                case 3: {
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-managed-static.png", (boolean)false);
                    break;
                }
                case 4: {
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-Qt.png", (boolean)false);
                    break;
                }
                case 5: {
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-Qt-dynamic.png", (boolean)false);
                    break;
                }
                case 6: {
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-Qt-static.png", (boolean)false);
                    break;
                }
                case 10: {
                    MakeProjectCustomizer makeProjectCustomizer = this.project.getProjectCustomizer(this.project.getProjectCustomizerId());
                    if (makeProjectCustomizer == null) break;
                    icon = ImageUtilities.loadImageIcon((String)makeProjectCustomizer.getIconPath(), (boolean)false);
                }
            }
            return icon;
        }

        public Project getProject() {
            return this.project;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    static interface InfoInterface
    extends ProjectInformation,
    PropertyChangeListener {
        public void firePropertyChange(String var1);

        public void setName(String var1);
    }

    private static final class MakeSubprojectProvider
    implements SubprojectProvider {
        private final MakeProject project;

        public MakeSubprojectProvider(MakeProject prj) {
            this.project = prj;
        }

        public void addChangeListener(ChangeListener listener) {
        }

        public Set<Project> getSubprojects() {
            HashSet<Project> subProjects = new HashSet<Project>();
            Set<Object> subProjectLocations = new HashSet();
            Element data = this.project.helper.getPrimaryConfigurationData(true);
            if (!this.project.projectDescriptorProvider.gotDescriptor() && data.getElementsByTagName("make-dep-projects").getLength() > 0) {
                NodeList nl4 = data.getElementsByTagName("make-dep-project");
                if (nl4.getLength() > 0) {
                    for (int i = 0; i < nl4.getLength(); ++i) {
                        Node node = nl4.item(i);
                        NodeList nl2 = node.getChildNodes();
                        for (int j = 0; j < nl2.getLength(); ++j) {
                            String typeTxt = nl2.item(j).getNodeValue();
                            subProjectLocations.add(typeTxt);
                        }
                    }
                }
            } else {
                MakeConfigurationDescriptor projectDescriptor = this.project.projectDescriptorProvider.getConfigurationDescriptor();
                if (projectDescriptor == null) {
                    return subProjects;
                }
                subProjectLocations = projectDescriptor.getSubprojectLocations();
            }
            FileObject baseDir = this.project.getProjectDirectory();
            for (String string : subProjectLocations) {
                String location = CndPathUtilities.toAbsolutePath((FileObject)baseDir, (String)string);
                try {
                    Project subProject;
                    FileObject fo = RemoteFileUtil.getFileObject((FileObject)baseDir, (String)location);
                    if (fo != null && fo.isValid()) {
                        fo = CndFileUtils.getCanonicalFileObject((FileObject)fo);
                    }
                    if (fo == null || !fo.isValid() || (subProject = ProjectManager.getDefault().findProject(fo)) == null) continue;
                    subProjects.add(subProject);
                }
                catch (Exception e) {
                    System.err.println("Cannot find subproject in '" + location + "' " + e);
                }
            }
            return subProjects;
        }

        public void removeChangeListener(ChangeListener listener) {
        }
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private static final String[] RECOMMENDED_TYPES = new String[]{"c-types", "cpp-types", "shell-types", "makefile-types", "simple-files", "fortran-types", "asm-types", "qt-types", "cncpp-test-types"};
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/cFiles/main.c", "Templates/cFiles/file.c", "Templates/cFiles/file.h", "Templates/cppFiles/class.cc", "Templates/cppFiles/main.cc", "Templates/cppFiles/file.cc", "Templates/cppFiles/file.h", "Templates/fortranFiles/fortranFreeFormatFile.f90", "Templates/MakeTemplates/ComplexMakefile", "Templates/MakeTemplates/SimpleMakefile/ExecutableMakefile", "Templates/MakeTemplates/SimpleMakefile/SharedLibMakefile", "Templates/MakeTemplates/SimpleMakefile/StaticLibMakefile"};
        private static final String[] PRIVILEGED_NAMES_QT = new String[]{"Templates/qtFiles/main.cc", "Templates/qtFiles/form.ui", "Templates/qtFiles/resource.qrc", "Templates/qtFiles/translation.ts", "Templates/cFiles/main.c", "Templates/cFiles/file.c", "Templates/cFiles/file.h", "Templates/cppFiles/class.cc", "Templates/cppFiles/main.cc", "Templates/cppFiles/file.cc", "Templates/cppFiles/file.h", "Templates/fortranFiles/fortranFreeFormatFile.f90", "Templates/MakeTemplates/ComplexMakefile", "Templates/MakeTemplates/SimpleMakefile/ExecutableMakefile", "Templates/MakeTemplates/SimpleMakefile/SharedLibMakefile", "Templates/MakeTemplates/SimpleMakefile/StaticLibMakefile"};
        private final ConfigurationDescriptorProvider configurationProvider;

        public RecommendedTemplatesImpl(ConfigurationDescriptorProvider configurationProvider) {
            this.configurationProvider = configurationProvider;
        }

        public String[] getRecommendedTypes() {
            return RECOMMENDED_TYPES;
        }

        public String[] getPrivilegedTemplates() {
            MakeConfiguration conf;
            MakeConfigurationDescriptor configurationDescriptor;
            if (this.configurationProvider.gotDescriptor() && (configurationDescriptor = this.configurationProvider.getConfigurationDescriptor()) != null && (conf = configurationDescriptor.getActiveConfiguration()) != null && conf.isQmakeConfiguration()) {
                return PRIVILEGED_NAMES_QT;
            }
            return PRIVILEGED_NAMES;
        }
    }

    private static final class CacheDirectoryProviderImpl
    extends ProjectOpenedHook
    implements CacheDirectoryProvider {
        private final FileObject projectDirectory;
        private FileObject cacheDirectory;
        private final Object lock = new Object();

        public CacheDirectoryProviderImpl(FileObject projectDirectory) {
            this.projectDirectory = projectDirectory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject getCacheDirectory() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.cacheDirectory == null) {
                    File cacheFile = MakeProject.getCacheLocation(this.projectDirectory);
                    if (cacheFile == null) {
                        String path = System.getProperty("cnd.repository.cache.path");
                        cacheFile = path == null ? Places.getCacheDirectory() : new File(path);
                    }
                    this.cacheDirectory = FileUtil.createFolder((File)cacheFile);
                }
                return this.cacheDirectory;
            }
        }

        protected void projectOpened() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void projectClosed() {
            Object object = this.lock;
            synchronized (object) {
                this.cacheDirectory = null;
            }
        }
    }
}

