/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.ResourceBundle;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObjectWithDictionary;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.LinkerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.FolderXMLCodec;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class FolderConfiguration
implements ConfigurationAuxObject,
ConfigurationAuxObjectWithDictionary {
    private boolean needSave = false;
    private Configuration configuration;
    private Folder folder;
    private CCompilerConfiguration cCompilerConfiguration;
    private CCCompilerConfiguration ccCompilerConfiguration;
    private LinkerConfiguration linkerConfiguration = null;
    private static ResourceBundle bundle = null;

    public FolderConfiguration(Configuration configuration, CCompilerConfiguration parentCCompilerConfiguration, CCCompilerConfiguration parentCCCompilerConfiguration, Folder folder) {
        this.configuration = configuration;
        this.setFolder(folder);
        this.cCompilerConfiguration = new CCompilerConfiguration(((MakeConfiguration)configuration).getBaseDir(), parentCCompilerConfiguration, (MakeConfiguration)configuration);
        this.ccCompilerConfiguration = new CCCompilerConfiguration(((MakeConfiguration)configuration).getBaseDir(), parentCCCompilerConfiguration, (MakeConfiguration)configuration);
        if (folder.isTest() || folder.isTestLogicalFolder() || folder.isTestRootFolder()) {
            this.linkerConfiguration = new LinkerConfiguration((MakeConfiguration)configuration);
        }
        this.clearChanged();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Folder getFolder() {
        return this.folder;
    }

    private void setFolder(Folder folder) {
        this.folder = folder;
        this.needSave = true;
    }

    public void setCCompilerConfiguration(CCompilerConfiguration cCompilerConfiguration) {
        this.cCompilerConfiguration = cCompilerConfiguration;
    }

    public CCompilerConfiguration getCCompilerConfiguration() {
        return this.cCompilerConfiguration;
    }

    public void setCCCompilerConfiguration(CCCompilerConfiguration ccCompilerConfiguration) {
        this.ccCompilerConfiguration = ccCompilerConfiguration;
    }

    public CCCompilerConfiguration getCCCompilerConfiguration() {
        return this.ccCompilerConfiguration;
    }

    public void setLinkerConfiguration(LinkerConfiguration linkerConfiguration) {
        this.linkerConfiguration = linkerConfiguration;
    }

    public LinkerConfiguration getLinkerConfiguration() {
        return this.linkerConfiguration;
    }

    @Override
    public boolean shared() {
        return true;
    }

    public boolean isVCSVisible() {
        if (this.folder != null) {
            return this.folder.hasAttributedItems();
        }
        return this.shared();
    }

    @Override
    public boolean hasChanged() {
        return this.needSave;
    }

    @Override
    public final void clearChanged() {
        this.needSave = false;
    }

    @Override
    public String getId() {
        return this.folder.getId();
    }

    public void assignValues(FolderConfiguration folderConfiguration) {
        this.getCCompilerConfiguration().assign(folderConfiguration.getCCompilerConfiguration());
        this.getCCCompilerConfiguration().assign(folderConfiguration.getCCCompilerConfiguration());
        if (this.getLinkerConfiguration() != null && folderConfiguration.getLinkerConfiguration() != null) {
            this.getLinkerConfiguration().assign(folderConfiguration.getLinkerConfiguration());
        }
    }

    @Override
    public void assign(ConfigurationAuxObject profileAuxObject) {
        if (!(profileAuxObject instanceof FolderConfiguration)) {
            System.err.println("Folder - assign: Profile object type expected - got " + profileAuxObject);
            return;
        }
        FolderConfiguration i = (FolderConfiguration)profileAuxObject;
        if (!this.getId().equals(i.getFolder().getId())) {
            System.err.println("Item - assign: Item ID " + this.getId() + " expected - got " + i.getFolder().getId());
            return;
        }
        this.setConfiguration(i.getConfiguration());
        this.setFolder(i.getFolder());
        this.getCCompilerConfiguration().assign(i.getCCompilerConfiguration());
        this.getCCCompilerConfiguration().assign(i.getCCCompilerConfiguration());
        if (this.getLinkerConfiguration() != null && i.getLinkerConfiguration() != null) {
            this.getLinkerConfiguration().assign(i.getLinkerConfiguration());
        }
    }

    public FolderConfiguration copy(MakeConfiguration makeConfiguration) {
        FolderConfiguration copy = new FolderConfiguration(makeConfiguration, (CCompilerConfiguration)this.getCCompilerConfiguration().getMaster(), (CCCompilerConfiguration)this.getCCCompilerConfiguration().getMaster(), this.getFolder());
        copy.assign(this);
        return copy;
    }

    @Override
    public FolderConfiguration clone(Configuration conf) {
        FolderConfiguration i = new FolderConfiguration(this.getConfiguration(), (CCompilerConfiguration)this.getCCompilerConfiguration().getMaster(), (CCCompilerConfiguration)this.getCCCompilerConfiguration().getMaster(), this.getFolder());
        i.setCCompilerConfiguration(this.getCCompilerConfiguration().clone());
        i.setCCCompilerConfiguration(this.getCCCompilerConfiguration().clone());
        if (this.getLinkerConfiguration() != null) {
            i.setLinkerConfiguration(this.getLinkerConfiguration().clone());
        }
        return i;
    }

    @Override
    public XMLDecoder getXMLDecoder() {
        return new FolderXMLCodec(this);
    }

    @Override
    public XMLEncoder getXMLEncoder() {
        return new FolderXMLCodec(this);
    }

    @Override
    public XMLEncoder getXMLEncoder(ConfigurationAuxObjectWithDictionary.Dictionaries dictionaries) {
        return new FolderXMLCodec(this, dictionaries);
    }

    @Override
    public void initialize() {
    }

    public Sheet getGeneralSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("FolderConfiguration");
        set.setDisplayName(FolderConfiguration.getString("FolderConfigurationTxt"));
        set.setShortDescription(FolderConfiguration.getString("FolderConfigurationHint"));
        set.put((Node.Property)new StringRONodeProp(FolderConfiguration.getString("NameTxt"), this.folder.getDisplayName()));
        sheet.put(set);
        return sheet;
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(FolderConfiguration.class);
        }
        return bundle.getString(s);
    }

    private static class StringRONodeProp
    extends PropertySupport<String> {
        private final String value;

        public StringRONodeProp(String name, String value) {
            super(name, String.class, name, name, true, false);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String v) {
        }
    }
}

