/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringListNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.platform.Platforms;
import org.netbeans.modules.cnd.makeproject.ui.utils.TokenizerFactory;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class QmakeConfiguration
implements Cloneable {
    public static final int DEBUG_MODE = 0;
    public static final int RELEASE_MODE = 1;
    private final String[] BUILD_MODE_NAMES = new String[]{"Debug", "Release"};
    private final String[] BUILD_MODE_OPTIONS = new String[]{"debug", "release"};
    private static final String CORE = "core";
    private static final String GUI = "gui";
    private static final String WIDGETS = "widgets";
    private static final String NETWORK = "network";
    private static final String OPENGL = "opengl";
    private static final String PHONON = "phonon";
    private static final String QT3SUPPORT = "qt3support";
    private static final String PRINTSUPPORT = "printsupport";
    private static final String SQL = "sql";
    private static final String SVG = "svg";
    private static final String WEBKIT = "webkit";
    private static final String XML = "xml";
    private final MakeConfiguration makeConfiguration;
    private StringConfiguration destdir;
    private StringConfiguration target;
    private StringConfiguration version;
    private IntConfiguration buildMode;
    private BooleanConfiguration coreEnabled;
    private BooleanConfiguration guiEnabled;
    private BooleanConfiguration widgetsEnabled;
    private BooleanConfiguration networkEnabled;
    private BooleanConfiguration openglEnabled;
    private BooleanConfiguration phononEnabled;
    private BooleanConfiguration qt3SupportEnabled;
    private BooleanConfiguration printSupportEnabled;
    private BooleanConfiguration sqlEnabled;
    private BooleanConfiguration svgEnabled;
    private BooleanConfiguration webkitEnabled;
    private BooleanConfiguration xmlEnabled;
    private StringConfiguration mocDir;
    private StringConfiguration rccDir;
    private StringConfiguration uiDir;
    private StringConfiguration qmakespec;
    private VectorConfiguration<String> customDefs;

    public QmakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
        this.destdir = new StringConfiguration(null, "");
        this.target = new StringConfiguration(null, "");
        this.version = new StringConfiguration(null, "1.0.0");
        this.buildMode = new IntConfiguration(null, 0, this.BUILD_MODE_NAMES, this.BUILD_MODE_OPTIONS);
        this.coreEnabled = new BooleanConfiguration(true);
        this.guiEnabled = new BooleanConfiguration(true);
        this.widgetsEnabled = new BooleanConfiguration(true);
        this.networkEnabled = new BooleanConfiguration(false);
        this.openglEnabled = new BooleanConfiguration(false);
        this.phononEnabled = new BooleanConfiguration(false);
        this.qt3SupportEnabled = new BooleanConfiguration(false);
        this.printSupportEnabled = new BooleanConfiguration(false);
        this.sqlEnabled = new BooleanConfiguration(false);
        this.svgEnabled = new BooleanConfiguration(false);
        this.xmlEnabled = new BooleanConfiguration(false);
        this.webkitEnabled = new BooleanConfiguration(false);
        this.mocDir = new StringConfiguration(null, "");
        this.rccDir = new StringConfiguration(null, "");
        this.uiDir = new StringConfiguration(null, "");
        this.customDefs = new VectorConfiguration(null);
        this.qmakespec = new StringConfiguration(null, "");
    }

    public Sheet getGeneralSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set basic = new Sheet.Set();
        basic.setName("QtGeneral");
        basic.setDisplayName(QmakeConfiguration.getString("QtGeneralTxt"));
        basic.setShortDescription(QmakeConfiguration.getString("QtGeneralHint"));
        basic.put((Node.Property)new StringNodeProp(this.destdir, this.getDestdirDefault(), "QtDestdir", QmakeConfiguration.getString("QtDestdirTxt"), QmakeConfiguration.getString("QtDestdirHint")));
        basic.put((Node.Property)new StringNodeProp(this.target, this.getTargetDefault(), "QtTarget", QmakeConfiguration.getString("QtTargetTxt"), QmakeConfiguration.getString("QtTargetHint")));
        basic.put((Node.Property)new StringNodeProp(this.version, "QtVersion", QmakeConfiguration.getString("QtVersionTxt"), QmakeConfiguration.getString("QtVersionHint")));
        basic.put((Node.Property)new IntNodeProp(this.buildMode, true, "QtBuildMode", QmakeConfiguration.getString("QtBuildModeTxt"), QmakeConfiguration.getString("QtBuildModeHint")));
        sheet.put(basic);
        Sheet.Set modules = new Sheet.Set();
        modules.setName("QtModules");
        modules.setDisplayName(QmakeConfiguration.getString("QtModulesTxt"));
        modules.setShortDescription(QmakeConfiguration.getString("QtModulesHint"));
        modules.put((Node.Property)new BooleanNodeProp(this.coreEnabled, true, "QtCore", QmakeConfiguration.getString("QtCoreTxt"), QmakeConfiguration.getString("QtCoreHint")));
        modules.put((Node.Property)new BooleanNodeProp(this.guiEnabled, true, "QtGui", QmakeConfiguration.getString("QtGuiTxt"), QmakeConfiguration.getString("QtGuiHint")));
        modules.put((Node.Property)new BooleanNodeProp(this.widgetsEnabled, true, "QtWidgets", QmakeConfiguration.getString("QtWidgetsTxt"), QmakeConfiguration.getString("QtWidgetsHint")));
        modules.put((Node.Property)new BooleanNodeProp(this.networkEnabled, true, "QtNetwork", QmakeConfiguration.getString("QtNetworkTxt"), QmakeConfiguration.getString("QtNetworkHint")));
        modules.put((Node.Property)new BooleanNodeProp(this.openglEnabled, true, "QtOpengl", QmakeConfiguration.getString("QtOpenglTxt"), QmakeConfiguration.getString("QtOpenglHint")));
        modules.put((Node.Property)new BooleanNodeProp(this.phononEnabled, true, "QtPhonon", QmakeConfiguration.getString("QtPhononTxt"), QmakeConfiguration.getString("QtPhononHint")));
        modules.put((Node.Property)new BooleanNodeProp(this.qt3SupportEnabled, true, "Qt3Support", QmakeConfiguration.getString("Qt3SupportTxt"), QmakeConfiguration.getString("Qt3SupportHint")));
        modules.put((Node.Property)new BooleanNodeProp(this.printSupportEnabled, true, "QtPrintSupport", QmakeConfiguration.getString("QtPrintSupportTxt"), QmakeConfiguration.getString("QtPrintSupportHint")));
        modules.put((Node.Property)new BooleanNodeProp(this.sqlEnabled, true, "QtSql", QmakeConfiguration.getString("QtSqlTxt"), QmakeConfiguration.getString("QtSqlHint")));
        modules.put((Node.Property)new BooleanNodeProp(this.svgEnabled, true, "QtSvg", QmakeConfiguration.getString("QtSvgTxt"), QmakeConfiguration.getString("QtSvgHint")));
        modules.put((Node.Property)new BooleanNodeProp(this.xmlEnabled, true, "QtXml", QmakeConfiguration.getString("QtXmlTxt"), QmakeConfiguration.getString("QtXmlHint")));
        modules.put((Node.Property)new BooleanNodeProp(this.webkitEnabled, true, "QtWebkit", QmakeConfiguration.getString("QtWebkitTxt"), QmakeConfiguration.getString("QtWebkitHint")));
        sheet.put(modules);
        Sheet.Set generatedFiles = new Sheet.Set();
        generatedFiles.setName("QtIntermediateFiles");
        generatedFiles.setDisplayName(QmakeConfiguration.getString("QtIntermediateFilesTxt"));
        generatedFiles.setShortDescription(QmakeConfiguration.getString("QtIntermediateFilesHint"));
        generatedFiles.put((Node.Property)new StringNodeProp(this.mocDir, "QtMocDir", QmakeConfiguration.getString("QtMocDirTxt"), QmakeConfiguration.getString("QtMocDirHint")));
        generatedFiles.put((Node.Property)new StringNodeProp(this.rccDir, "QtRccDir", QmakeConfiguration.getString("QtRccDirTxt"), QmakeConfiguration.getString("QtRccDirHint")));
        generatedFiles.put((Node.Property)new StringNodeProp(this.uiDir, "QtUiDir", QmakeConfiguration.getString("QtUiDirTxt"), QmakeConfiguration.getString("QtUiDirHint")));
        sheet.put(generatedFiles);
        Sheet.Set expert = new Sheet.Set();
        expert.setName("QtExpert");
        expert.setDisplayName(QmakeConfiguration.getString("QtExpertTxt"));
        expert.setShortDescription(QmakeConfiguration.getString("QtExpertHint"));
        expert.put((Node.Property)new StringNodeProp(this.qmakespec, "QtQmakeSpec", QmakeConfiguration.getString("QtQmakeSpecTxt"), QmakeConfiguration.getString("QtQmakeSpecHint")));
        expert.put((Node.Property)new StringListNodeProp(this.customDefs, null, new String[]{"QtCustomDefs", QmakeConfiguration.getString("QtCustomDefsTxt"), QmakeConfiguration.getString("QtCustomDefsHint"), QmakeConfiguration.getString("QtCustomDefsLbl")}, false, HelpCtx.DEFAULT_HELP){

            @Override
            protected List<String> convertToList(String text) {
                return TokenizerFactory.MACRO_CONVERTER.convertToList(text);
            }

            @Override
            protected String convertToString(List<String> list) {
                return TokenizerFactory.MACRO_CONVERTER.convertToString(list);
            }
        });
        sheet.put(expert);
        return sheet;
    }

    public String getDestdirValue() {
        if (this.destdir.getModified()) {
            return this.destdir.getValue();
        }
        return this.getDestdirDefault();
    }

    private String getDestdirDefault() {
        return "${CND_DISTDIR}/${CND_CONF}/${CND_PLATFORM}";
    }

    public StringConfiguration getDestdir() {
        return this.destdir;
    }

    private void setDestdir(StringConfiguration destdir) {
        this.destdir = destdir;
    }

    public String getTargetValue() {
        if (this.target.getModified()) {
            return this.target.getValue();
        }
        return this.getTargetDefault();
    }

    private String getTargetDefault() {
        return ConfigurationSupport.makeNameLegal(CndPathUtilities.getBaseName((String)this.makeConfiguration.getBaseDir()));
    }

    public StringConfiguration getTarget() {
        return this.target;
    }

    private void setTarget(StringConfiguration target) {
        this.target = target;
    }

    public StringConfiguration getVersion() {
        return this.version;
    }

    private void setVersion(StringConfiguration version) {
        this.version = version;
    }

    public String getOutputValue() {
        String dir = this.getDestdirValue();
        String file = this.getTargetValue();
        switch (this.makeConfiguration.getConfigurationType().getValue()) {
            case 5: {
                file = Platforms.getPlatform(this.makeConfiguration.getDevelopmentHost().getBuildPlatform()).getQtLibraryName(file, this.getVersion().getValue());
                break;
            }
            case 6: {
                file = "lib" + file + ".a";
            }
        }
        return 0 < dir.length() ? dir + "/" + file : file;
    }

    public IntConfiguration getBuildMode() {
        return this.buildMode;
    }

    private void setBuildMode(IntConfiguration buildMode) {
        this.buildMode = buildMode;
    }

    public String getEnabledModules() {
        StringBuilder buf = new StringBuilder();
        if (this.isCoreEnabled().getValue()) {
            QmakeConfiguration.append(buf, CORE);
        }
        if (this.isGuiEnabled().getValue()) {
            QmakeConfiguration.append(buf, GUI);
        }
        if (this.isWidgetsEnabled().getValue()) {
            QmakeConfiguration.append(buf, WIDGETS);
        }
        if (this.isNetworkEnabled().getValue()) {
            QmakeConfiguration.append(buf, NETWORK);
        }
        if (this.isOpenglEnabled().getValue()) {
            QmakeConfiguration.append(buf, OPENGL);
        }
        if (this.isPhononEnabled().getValue()) {
            QmakeConfiguration.append(buf, PHONON);
        }
        if (this.isQt3SupportEnabled().getValue()) {
            QmakeConfiguration.append(buf, QT3SUPPORT);
        }
        if (this.isPrintSupportEnabled().getValue()) {
            QmakeConfiguration.append(buf, PRINTSUPPORT);
        }
        if (this.isSqlEnabled().getValue()) {
            QmakeConfiguration.append(buf, SQL);
        }
        if (this.isSvgEnabled().getValue()) {
            QmakeConfiguration.append(buf, SVG);
        }
        if (this.isXmlEnabled().getValue()) {
            QmakeConfiguration.append(buf, XML);
        }
        if (this.isWebkitEnabled().getValue()) {
            QmakeConfiguration.append(buf, WEBKIT);
        }
        return buf.toString();
    }

    public void setEnabledModules(String modules) {
        this.isCoreEnabled().setValue(false);
        this.isGuiEnabled().setValue(false);
        this.isWidgetsEnabled().setValue(false);
        this.isNetworkEnabled().setValue(false);
        this.isOpenglEnabled().setValue(false);
        this.isPhononEnabled().setValue(false);
        this.isQt3SupportEnabled().setValue(false);
        this.isPrintSupportEnabled().setValue(false);
        this.isSqlEnabled().setValue(false);
        this.isSvgEnabled().setValue(false);
        this.isXmlEnabled().setValue(false);
        this.isWebkitEnabled().setValue(false);
        StringTokenizer st = new StringTokenizer(modules);
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.equals(CORE)) {
                this.isCoreEnabled().setValue(true);
                continue;
            }
            if (t.equals(GUI)) {
                this.isGuiEnabled().setValue(true);
                continue;
            }
            if (t.equals(WIDGETS)) {
                this.isWidgetsEnabled().setValue(true);
                continue;
            }
            if (t.equals(NETWORK)) {
                this.isNetworkEnabled().setValue(true);
                continue;
            }
            if (t.equals(OPENGL)) {
                this.isOpenglEnabled().setValue(true);
                continue;
            }
            if (t.equals(PHONON)) {
                this.isPhononEnabled().setValue(true);
                continue;
            }
            if (t.equals(QT3SUPPORT)) {
                this.isQt3SupportEnabled().setValue(true);
                continue;
            }
            if (t.equals(PRINTSUPPORT)) {
                this.isPrintSupportEnabled().setValue(true);
                continue;
            }
            if (t.equals(SQL)) {
                this.isSqlEnabled().setValue(true);
                continue;
            }
            if (t.equals(SVG)) {
                this.isSvgEnabled().setValue(true);
                continue;
            }
            if (t.equals(XML)) {
                this.isXmlEnabled().setValue(true);
                continue;
            }
            if (!t.equals(WEBKIT)) continue;
            this.isWebkitEnabled().setValue(true);
        }
    }

    public BooleanConfiguration isCoreEnabled() {
        return this.coreEnabled;
    }

    private void setCoreEnabled(BooleanConfiguration val) {
        this.coreEnabled = val;
    }

    public BooleanConfiguration isGuiEnabled() {
        return this.guiEnabled;
    }

    private void setGuiEnabled(BooleanConfiguration val) {
        this.guiEnabled = val;
    }

    public BooleanConfiguration isWidgetsEnabled() {
        return this.widgetsEnabled;
    }

    private void setWidgetsEnabled(BooleanConfiguration val) {
        this.widgetsEnabled = val;
    }

    public BooleanConfiguration isNetworkEnabled() {
        return this.networkEnabled;
    }

    private void setNetworkEnabled(BooleanConfiguration val) {
        this.networkEnabled = val;
    }

    public BooleanConfiguration isOpenglEnabled() {
        return this.openglEnabled;
    }

    private void setOpenglEnabled(BooleanConfiguration val) {
        this.openglEnabled = val;
    }

    public BooleanConfiguration isPhononEnabled() {
        return this.phononEnabled;
    }

    private void setPhononEnabled(BooleanConfiguration val) {
        this.phononEnabled = val;
    }

    public BooleanConfiguration isQt3SupportEnabled() {
        return this.qt3SupportEnabled;
    }

    private void setQt3SupportEnabled(BooleanConfiguration val) {
        this.qt3SupportEnabled = val;
    }

    public BooleanConfiguration isPrintSupportEnabled() {
        return this.printSupportEnabled;
    }

    private void setPrintSupportEnabled(BooleanConfiguration val) {
        this.printSupportEnabled = val;
    }

    public BooleanConfiguration isSqlEnabled() {
        return this.sqlEnabled;
    }

    private void setSqlEnabled(BooleanConfiguration val) {
        this.sqlEnabled = val;
    }

    public BooleanConfiguration isSvgEnabled() {
        return this.svgEnabled;
    }

    private void setSvgEnabled(BooleanConfiguration val) {
        this.svgEnabled = val;
    }

    public BooleanConfiguration isXmlEnabled() {
        return this.xmlEnabled;
    }

    private void setXmlEnabled(BooleanConfiguration val) {
        this.xmlEnabled = val;
    }

    public BooleanConfiguration isWebkitEnabled() {
        return this.webkitEnabled;
    }

    private void setWebkitEnabled(BooleanConfiguration val) {
        this.webkitEnabled = val;
    }

    public StringConfiguration getMocDir() {
        return this.mocDir;
    }

    private void setMocDir(StringConfiguration mocDir) {
        this.mocDir = mocDir;
    }

    public StringConfiguration getRccDir() {
        return this.rccDir;
    }

    private void setRccDir(StringConfiguration rccDir) {
        this.rccDir = rccDir;
    }

    public StringConfiguration getUiDir() {
        return this.uiDir;
    }

    private void setUiDir(StringConfiguration uicDir) {
        this.uiDir = uicDir;
    }

    public VectorConfiguration<String> getCustomDefs() {
        return this.customDefs;
    }

    private void setCustomDefs(VectorConfiguration<String> customDefs) {
        this.customDefs = customDefs;
    }

    public StringConfiguration getQmakeSpec() {
        return this.qmakespec;
    }

    private void setQmakespec(StringConfiguration qmakespec) {
        this.qmakespec = qmakespec;
    }

    public void assign(QmakeConfiguration other) {
        this.getDestdir().assign(other.getDestdir());
        this.getTarget().assign(other.getTarget());
        this.getVersion().assign(other.getVersion());
        this.getBuildMode().assign(other.getBuildMode());
        this.isCoreEnabled().assign(other.isCoreEnabled());
        this.isGuiEnabled().assign(other.isGuiEnabled());
        this.isWidgetsEnabled().assign(other.isWidgetsEnabled());
        this.isNetworkEnabled().assign(other.isNetworkEnabled());
        this.isOpenglEnabled().assign(other.isOpenglEnabled());
        this.isPhononEnabled().assign(other.isPhononEnabled());
        this.isQt3SupportEnabled().assign(other.isQt3SupportEnabled());
        this.isPrintSupportEnabled().assign(other.isPrintSupportEnabled());
        this.isSqlEnabled().assign(other.isSqlEnabled());
        this.isSvgEnabled().assign(other.isSvgEnabled());
        this.isXmlEnabled().assign(other.isXmlEnabled());
        this.isWebkitEnabled().assign(other.isWebkitEnabled());
        this.getMocDir().assign(other.getMocDir());
        this.getRccDir().assign(other.getRccDir());
        this.getUiDir().assign(other.getUiDir());
        this.getCustomDefs().assign(other.getCustomDefs());
        this.getQmakeSpec().assign(other.getQmakeSpec());
    }

    public QmakeConfiguration clone() {
        try {
            QmakeConfiguration clone = (QmakeConfiguration)super.clone();
            clone.setDestdir(this.getDestdir().clone());
            clone.setTarget(this.getTarget().clone());
            clone.setVersion(this.getVersion().clone());
            clone.setBuildMode(this.getBuildMode().clone());
            clone.setCoreEnabled(this.isCoreEnabled().clone());
            clone.setGuiEnabled(this.isGuiEnabled().clone());
            clone.setWidgetsEnabled(this.isWidgetsEnabled().clone());
            clone.setNetworkEnabled(this.isNetworkEnabled().clone());
            clone.setOpenglEnabled(this.isOpenglEnabled().clone());
            clone.setPhononEnabled(this.isPhononEnabled().clone());
            clone.setPrintSupportEnabled(this.isPrintSupportEnabled().clone());
            clone.setQt3SupportEnabled(this.isQt3SupportEnabled().clone());
            clone.setSqlEnabled(this.isSqlEnabled().clone());
            clone.setSvgEnabled(this.isSvgEnabled().clone());
            clone.setXmlEnabled(this.isXmlEnabled().clone());
            clone.setWebkitEnabled(this.isWebkitEnabled().clone());
            clone.setMocDir(this.getMocDir().clone());
            clone.setRccDir(this.getRccDir().clone());
            clone.setUiDir(this.getUiDir().clone());
            clone.setCustomDefs((VectorConfiguration<String>)this.getCustomDefs().clone());
            clone.setQmakespec(this.getQmakeSpec().clone());
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    private static String getString(String s) {
        return NbBundle.getMessage(QmakeConfiguration.class, (String)s);
    }

    private static void append(StringBuilder buf, String val) {
        if (0 < buf.length() && buf.charAt(buf.length() - 1) != ' ') {
            buf.append(' ');
        }
        buf.append(val);
    }
}

