/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.makeproject.MakeBasedProjectFactorySingleton;
import org.netbeans.modules.cnd.makeproject.MakeProjectHelperImpl;
import org.netbeans.modules.cnd.makeproject.MakeProjectTypeImpl;
import org.netbeans.modules.cnd.makeproject.SmartOutputStream;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class MakeProjectGenerator {
    public static MakeProjectHelper createProject(final FileObject directory, final String type) throws IOException, IllegalArgumentException {
        try {
            return (MakeProjectHelper)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<MakeProjectHelper>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public MakeProjectHelper run() throws IOException {
                    Project p;
                    MakeProjectHelperImpl h;
                    directory.refresh();
                    FileObject projectXml = directory.getFileObject("nbproject/project.xml");
                    if (projectXml != null) {
                        throw new IllegalArgumentException("Already a " + projectXml);
                    }
                    Project prj = ProjectManager.getDefault().findProject(directory);
                    if (prj != null && prj.getProjectDirectory().getChildren().length == 0 && (h = MakeBasedProjectFactorySingleton.getHelperFor(prj)) != null) {
                        h.notifyDeleted();
                        prj = ProjectManager.getDefault().findProject(directory);
                    }
                    if (prj != null) {
                        throw new IllegalArgumentException("Already a " + prj.getClass().getName() + " in " + directory);
                    }
                    projectXml = FileUtil.createData((FileObject)directory, (String)"nbproject/project.xml");
                    Document doc = XMLUtil.createDocument((String)"project", (String)"http://www.netbeans.org/ns/project/1", null, null);
                    Element el = doc.createElementNS("http://www.netbeans.org/ns/project/1", "type");
                    el.appendChild(doc.createTextNode(type));
                    doc.getDocumentElement().appendChild(el);
                    el = doc.createElementNS("http://www.netbeans.org/ns/project/1", "configuration");
                    doc.getDocumentElement().appendChild(el);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    XMLUtil.write((Document)doc, (OutputStream)baos, (String)"UTF-8");
                    byte[] data = MakeProjectHelperImpl.convertLineSeparator(baos, projectXml, projectXml.getParent());
                    try (OutputStream os = SmartOutputStream.getSmartOutputStream(projectXml);){
                        os.write(data);
                    }
                    ProjectManager.getDefault().clearNonProjectCache();
                    ByteArrayOutputStream diagStream = new ByteArrayOutputStream();
                    if (System.getProperty("java.class.path").contains("junit")) {
                        diagStream.write(58);
                        diagStream.write(10);
                        StreamHandler diagHandler = new StreamHandler(diagStream, new SimpleFormatter());
                        diagHandler.setLevel(Level.ALL);
                        Level oldLevel = MakeBasedProjectFactorySingleton.LOG.getLevel();
                        MakeBasedProjectFactorySingleton.LOG.setLevel(Level.ALL);
                        MakeBasedProjectFactorySingleton.LOG.addHandler(diagHandler);
                        try {
                            p = ProjectManager.getDefault().findProject(directory);
                        }
                        finally {
                            MakeBasedProjectFactorySingleton.LOG.removeHandler(diagHandler);
                            MakeBasedProjectFactorySingleton.LOG.setLevel(oldLevel);
                            ((Handler)diagHandler).close();
                        }
                    } else {
                        p = ProjectManager.getDefault().findProject(directory);
                    }
                    if (p == null) {
                        for (MakeProjectTypeImpl abpt : Lookup.getDefault().lookupAll(MakeProjectTypeImpl.class)) {
                            if (!abpt.getType().equals(type)) continue;
                            throw new IllegalArgumentException("For some reason the folder " + directory + " with a new project of type " + type + " is still not recognized" + diagStream);
                        }
                        throw new IllegalArgumentException("No Ant-based project factory for type " + type);
                    }
                    MakeProjectHelperImpl helper = MakeBasedProjectFactorySingleton.getHelperFor(p);
                    if (helper == null) {
                        throw new IllegalArgumentException("Project " + p + " was not recognized as an Ant-based project");
                    }
                    helper.markModified();
                    return helper;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }
}

