/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.launchers.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.makeproject.LaunchersRegistryAccessor;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.launchers.Launcher;
import org.netbeans.modules.cnd.makeproject.launchers.LauncherExecutor;
import org.netbeans.modules.cnd.makeproject.launchers.LaunchersRegistryFactory;
import org.netbeans.modules.cnd.makeproject.ui.actions.MakeProjectActionsSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.spi.project.ui.support.BuildExecutionSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class LauncherAction
extends AbstractAction
implements ContextAwareAction,
Presenter.Menu,
Presenter.Popup {
    private Project project;
    private JMenu subMenu = null;
    private boolean isSubmenu;
    private final ProjectActionEvent.PredefinedType actionType;
    private final String displayName;
    private Action delegate;
    private static final String DEFAULT_ACTION_NAME = NbBundle.getMessage(LauncherAction.class, (String)"LBL_DefaultAction_Name");

    public LauncherAction(ProjectActionEvent.PredefinedType actionType, String displayName) {
        this.actionType = actionType;
        this.displayName = displayName;
        this.putValue("hideWhenDisabled", Boolean.TRUE);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isSubmenu) {
            this.delegate.actionPerformed(e);
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        this.project = (Project)actionContext.lookup(Project.class);
        this.isSubmenu = true;
        if (this.project == null) {
            this.isSubmenu = false;
        }
        this.isSubmenu = this.isSubmenu && ConfigurationSupport.getProjectActiveConfiguration((Lookup.Provider)this.project) != null && LaunchersRegistryFactory.getInstance(this.project.getProjectDirectory()).hasLaunchers();
        switch (this.actionType) {
            // Empty switch
        }
        return this;
    }

    public JMenuItem getPopupPresenter() {
        return this.createMenuItem();
    }

    public JMenuItem getMenuPresenter() {
        return this.createMenuItem();
    }

    private JMenuItem createMenuItem() {
        if (this.isSubmenu) {
            this.createSubMenu();
            return this.subMenu;
        }
        switch (this.actionType) {
            case BUILD: {
                this.delegate = MakeProjectActionsSupport.buildAction();
                break;
            }
            case RUN: {
                this.delegate = MakeProjectActionsSupport.runAction();
                break;
            }
            case DEBUG: {
                this.delegate = MakeProjectActionsSupport.debugAction();
                break;
            }
            case DEBUG_STEPINTO: {
                this.delegate = MakeProjectActionsSupport.stepIntoAction();
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        JMenuItem item = new JMenuItem(this.delegate);
        return item;
    }

    private void createSubMenu() {
        JMenuItem add;
        this.subMenu = new JMenu(this.displayName);
        this.subMenu.setEnabled(this.isSubmenu);
        this.subMenu.putClientProperty("hideWhenDisabled", this.getValue("hideWhenDisabled"));
        LaunchersRegistryAccessor.getDefault().assertPrivateListenerNotNull(this.project.getProjectDirectory());
        for (Launcher launcher : LaunchersRegistryFactory.getInstance(this.project.getProjectDirectory()).getLaunchers()) {
            this.subMenu.add(new LauncherExecutableAction(launcher));
        }
        this.subMenu.add(new JPopupMenu.Separator());
        switch (this.actionType) {
            case BUILD: {
                add = this.subMenu.add(MakeProjectActionsSupport.buildAction());
                break;
            }
            case RUN: {
                add = this.subMenu.add(MakeProjectActionsSupport.runAction());
                break;
            }
            case DEBUG: {
                add = this.subMenu.add(MakeProjectActionsSupport.debugAction());
                break;
            }
            case DEBUG_STEPINTO: {
                add = this.subMenu.add(MakeProjectActionsSupport.stepIntoAction());
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        add.setText(DEFAULT_ACTION_NAME);
    }

    public static LauncherAction buildAsAction() {
        return new LauncherAction(ProjectActionEvent.PredefinedType.BUILD, NbBundle.getMessage(LauncherAction.class, (String)"LBL_BuildAsAction_Name"));
    }

    public static LauncherAction runAsAction() {
        return new LauncherAction(ProjectActionEvent.PredefinedType.RUN, NbBundle.getMessage(LauncherAction.class, (String)"LBL_RunAsAction_Name"));
    }

    public static LauncherAction debugAsAction() {
        return new LauncherAction(ProjectActionEvent.PredefinedType.DEBUG, NbBundle.getMessage(LauncherAction.class, (String)"LBL_DebugAsAction_Name"));
    }

    public static LauncherAction stepIntoAction() {
        return new LauncherAction(ProjectActionEvent.PredefinedType.DEBUG_STEPINTO, NbBundle.getMessage(LauncherAction.class, (String)"LBL_StepIntoAction_Name"));
    }

    public class LauncherExecutableAction
    extends AbstractAction {
        private LauncherExecutor executor;
        private final Launcher launcher;
        private final RunActionItem runActionItem;

        public LauncherExecutableAction(Launcher launcher) {
            super(launcher.getDisplayedName());
            this.runActionItem = new RunActionItem();
            this.executor = LauncherExecutor.createExecutor(launcher, LauncherAction.this.actionType, new ExecutionListenerImpl());
            this.launcher = launcher;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.executor.execute(LauncherAction.this.project);
        }

        private class RunActionItem
        implements BuildExecutionSupport.ActionItem {
            private RunActionItem() {
            }

            public String getAction() {
                switch (LauncherAction.this.actionType) {
                    case BUILD: {
                        return "build";
                    }
                    case RUN: {
                        return "run";
                    }
                    case DEBUG: {
                        return "debug";
                    }
                    case DEBUG_STEPINTO: {
                        return "debug.stepinto";
                    }
                }
                assert (false);
                return null;
            }

            public FileObject getProjectDirectory() {
                return LauncherAction.this.project.getProjectDirectory();
            }

            public String getDisplayName() {
                return ProjectUtils.getInformation((Project)LauncherAction.this.project).getDisplayName() + ": " + LauncherExecutableAction.this.launcher.getDisplayedName();
            }

            public void repeatExecution() {
                for (Launcher l : LaunchersRegistryFactory.getInstance(LauncherAction.this.project.getProjectDirectory()).getLaunchers()) {
                    if (!l.equals(LauncherExecutableAction.this.launcher)) continue;
                    LauncherExecutableAction.this.executor = LauncherExecutor.createExecutor(l, LauncherAction.this.actionType, new ExecutionListenerImpl());
                    break;
                }
                LauncherExecutableAction.this.executor.execute(LauncherAction.this.project);
            }

            public boolean isRunning() {
                return LauncherExecutableAction.this.executor.isRunning();
            }

            public void stopRunning() {
            }

            public boolean equals(Object obj) {
                if (obj instanceof RunActionItem) {
                    return ((RunActionItem)obj).getDisplayName().equals(this.getDisplayName());
                }
                return false;
            }

            public int hashCode() {
                return this.getDisplayName().hashCode();
            }
        }

        private class ExecutionListenerImpl
        implements ExecutionListener {
            private ExecutionListenerImpl() {
            }

            public void executionStarted(int pid) {
                BuildExecutionSupport.registerRunningItem((BuildExecutionSupport.Item)LauncherExecutableAction.this.runActionItem);
            }

            public void executionFinished(int rc) {
                BuildExecutionSupport.registerFinishedItem((BuildExecutionSupport.Item)LauncherExecutableAction.this.runActionItem);
            }
        }
    }
}

