/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.packaging;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerFileElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerInfoElement;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class DebianPackager
implements PackagerDescriptor {
    public static final String PACKAGER_NAME = "Debian";

    @Override
    public String getName() {
        return PACKAGER_NAME;
    }

    @Override
    public String getDisplayName() {
        return DebianPackager.getString(PACKAGER_NAME);
    }

    @Override
    public boolean hasInfoList() {
        return true;
    }

    @Override
    public List<PackagerInfoElement> getDefaultInfoList(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        String defArch;
        if (makeConfiguration.getDevelopmentHost().getBuildPlatform() == 1) {
            defArch = "i386";
        } else if (makeConfiguration.getDevelopmentHost().getBuildPlatform() == 0) {
            defArch = "sparc";
        } else if (makeConfiguration.getDevelopmentHost().getBuildPlatform() == 3) {
            defArch = "i386";
        } else {
            defArch = "i386";
            HostInfo hostInfo = null;
            try {
                ExecutionEnvironment env = makeConfiguration.getDevelopmentHost().getExecutionEnvironment();
                if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env)) {
                    hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ConnectionManager.CancellationException ex) {
                // empty catch block
            }
            if (hostInfo != null && hostInfo.getOS().getBitness().equals((Object)HostInfo.Bitness._64)) {
                defArch = "amd64";
            }
        }
        ArrayList<PackagerInfoElement> infoList = new ArrayList<PackagerInfoElement>();
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "Package", packagingConfiguration.getOutputName(), true, true));
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "Version", "1.0", true, true));
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "Architecture", defArch, false, true));
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "Maintainer", System.getProperty("user.name"), false, true));
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "Description", "...", false, true));
        return infoList;
    }

    @Override
    public List<String> getOptionalInfoList() {
        ArrayList<String> entryComboBox = new ArrayList<String>();
        entryComboBox.add("Section");
        entryComboBox.add("Priority");
        entryComboBox.add("Architecture");
        entryComboBox.add("Depends");
        entryComboBox.add("Maintainer");
        entryComboBox.add("Description");
        return entryComboBox;
    }

    @Override
    public String getDefaultOptions() {
        return "";
    }

    @Override
    public String getDefaultTool() {
        return "dpkg-deb";
    }

    @Override
    public boolean isOutputAFolder() {
        return false;
    }

    @Override
    public String getOutputFileName(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        return packagingConfiguration.getOutputName();
    }

    @Override
    public String getOutputFileSuffix() {
        return "deb";
    }

    @Override
    public String getTopDir(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        return "/usr";
    }

    @Override
    public boolean supportsGroupAndOwner() {
        return true;
    }

    @Override
    public PackagerDescriptor.ShellSciptWriter getShellFileWriter() {
        return new ScriptWriter();
    }

    private static String getString(String s) {
        return NbBundle.getMessage(DebianPackager.class, (String)s);
    }

    public static class ScriptWriter
    implements PackagerDescriptor.ShellSciptWriter {
        @Override
        public void writeShellScript(BufferedWriter bw, MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) throws IOException {
            this.writePackagingScriptBodyDebian(bw, makeConfiguration);
        }

        private void writePackagingScriptBodyDebian(BufferedWriter bw, MakeConfiguration conf) throws IOException {
            PackagingConfiguration packagingConfiguration = conf.getPackagingConfiguration();
            List<PackagerFileElement> fileList = packagingConfiguration.getFiles().getValue();
            bw.write("# Copy files and create directories and links\n");
            for (PackagerFileElement elem : fileList) {
                String toDir;
                bw.write("cd \"${TOP}\"\n");
                if (elem.getType() == PackagerFileElement.FileType.FILE) {
                    toDir = CndPathUtilities.getDirName((String)conf.getPackagingConfiguration().expandMacros(elem.getTo()));
                    if (toDir != null && toDir.length() >= 0) {
                        bw.write("makeDirectory \"${NBTMPDIR}/" + toDir + "\"\n");
                    }
                    bw.write("copyFileToTmpDir \"" + elem.getFrom() + "\" \"${NBTMPDIR}/" + elem.getTo() + "\" 0" + elem.getPermission() + "\n");
                } else if (elem.getType() == PackagerFileElement.FileType.DIRECTORY) {
                    bw.write("makeDirectory  \"${NBTMPDIR}/" + elem.getTo() + "\"" + " 0" + elem.getPermission() + "\n");
                } else if (elem.getType() == PackagerFileElement.FileType.SOFTLINK) {
                    toDir = CndPathUtilities.getDirName((String)elem.getTo());
                    String toName = CndPathUtilities.getBaseName((String)elem.getTo());
                    if (toDir != null && toDir.length() >= 0) {
                        bw.write("makeDirectory \"${NBTMPDIR}/" + toDir + "\"" + "\n");
                    }
                    bw.write("cd \"${NBTMPDIR}/" + toDir + "\"" + "\n");
                    bw.write("ln -s \"" + elem.getFrom() + "\"" + " " + "\"" + toName + "\"" + "\n");
                } else if (elem.getType() != PackagerFileElement.FileType.UNKNOWN) assert (false);
                bw.write("\n");
            }
            bw.write("\n");
            bw.write("# Create control file\n");
            bw.write("cd \"${TOP}\"\n");
            bw.write("CONTROL_FILE=${NBTMPDIR}/DEBIAN/control\n");
            bw.write("rm -f ${CONTROL_FILE}\n");
            bw.write("mkdir -p ${NBTMPDIR}/DEBIAN\n");
            bw.write("\n");
            bw.write("cd \"${TOP}\"\n");
            List<PackagerInfoElement> infoList = packagingConfiguration.getHeaderSubList(DebianPackager.PACKAGER_NAME);
            for (PackagerInfoElement elem : infoList) {
                String value = elem.getValue();
                int i = 0;
                int j = value.indexOf("\\n");
                while (j >= 0) {
                    if (i == 0) {
                        bw.write("echo '" + elem.getName() + ": " + value.substring(i, j) + "' >> ${CONTROL_FILE}\n");
                    } else {
                        bw.write("echo '" + value.substring(i, j) + "' >> ${CONTROL_FILE}\n");
                    }
                    i = j + 2;
                    j = value.indexOf("\\n", i);
                }
                if (i >= value.length()) continue;
                if (i == 0) {
                    bw.write("echo '" + elem.getName() + ": " + value.substring(i) + "' >> ${CONTROL_FILE}\n");
                    continue;
                }
                bw.write("echo '" + value.substring(i) + "' >> ${CONTROL_FILE}\n");
            }
            bw.write("\n");
            bw.write("# Create Debian Package\n");
            bw.write("cd \"${TOP}\"\n");
            bw.write("cd \"${NBTMPDIR}/..\"\n");
            bw.write(packagingConfiguration.getToolValue() + " " + packagingConfiguration.getOptionsValue() + " --build ${TMPDIRNAME}\n");
            bw.write("checkReturnCode\n");
            bw.write("cd \"${TOP}\"\n");
            bw.write("mkdir -p  " + CndPathUtilities.getDirName((String)packagingConfiguration.getOutputValue()) + "\n");
            bw.write("mv ${NBTMPDIR}.deb " + packagingConfiguration.getOutputValue() + "\n");
            bw.write("checkReturnCode\n");
            bw.write("echo Debian: " + packagingConfiguration.getOutputValue() + "\n");
            bw.write("\n");
        }
    }
}

