/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

class RemoteSyncActions {
    private static UploadAction uploadAction;
    private static DownloadAction downloadAction;
    private static final AtomicReference<Node[]> activatedNodesCache;
    private static final RequestProcessor RP;
    private static final RequestProcessor.Task clearCacheTask;

    private RemoteSyncActions() {
    }

    public static Action createUploadAction() {
        if (uploadAction == null) {
            uploadAction = new UploadAction();
        }
        return uploadAction;
    }

    public static Action createDownloadAction() {
        if (downloadAction == null) {
            downloadAction = new DownloadAction();
        }
        return downloadAction;
    }

    private static void cacheActiveNodes(Node[] activatedNodes) {
        activatedNodesCache.set(activatedNodes);
        clearCacheTask.schedule(5000);
    }

    private static Pair<ExecutionEnvironment, RemoteSyncFactory> getEnv(Node[] activatedNodes) {
        Pair<ExecutionEnvironment, RemoteSyncFactory> result = null;
        for (Node node : activatedNodes) {
            Project project = RemoteSyncActions.getNodeProject(node);
            Pair<ExecutionEnvironment, RemoteSyncFactory> curr = RemoteSyncActions.getEnv(project);
            if (curr == null) continue;
            if (result == null) {
                result = curr;
                continue;
            }
            if (result.equals(curr)) continue;
            return null;
        }
        return result;
    }

    private static Pair<ExecutionEnvironment, RemoteSyncFactory> getEnv(Project project) {
        ExecutionEnvironment dh;
        RemoteProject info;
        if (project != null && (info = (RemoteProject)project.getLookup().lookup(RemoteProject.class)) != null && (dh = info.getDevelopmentHost()) != null) {
            return Pair.of((Object)dh, (Object)info.getSyncFactory());
        }
        ServerRecord rec = ServerList.getDefaultRecord();
        return Pair.of((Object)rec.getExecutionEnvironment(), (Object)rec.getSyncFactory());
    }

    private static Project getNodeProject(Node node) {
        if (node == null) {
            return null;
        }
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project != null) {
            return project;
        }
        return RemoteSyncActions.getNodeProject(node.getParentNode());
    }

    private static InputOutput getTab(String name, boolean reuse) {
        InputOutput tab;
        if (reuse) {
            tab = IOProvider.getDefault().getIO(name, false);
            tab.closeInputOutput();
        }
        tab = IOProvider.getDefault().getIO(name, true);
        try {
            tab.getOut().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        tab.select();
        return tab;
    }

    private static void upload(ExecutionEnvironment execEnv, Node[] nodes) {
        InputOutput tab = RemoteSyncActions.getTab(NbBundle.getMessage(RemoteSyncActions.class, (String)"LBL_UploadTab_Name", (Object)execEnv), true);
        Uploader worker = new Uploader(execEnv, nodes, tab);
        worker.work();
    }

    private static void download(ExecutionEnvironment execEnv, Node[] nodes) {
        InputOutput tab = RemoteSyncActions.getTab(NbBundle.getMessage(RemoteSyncActions.class, (String)"LBL_DownloadTab_Name", (Object)execEnv), true);
        Downloader worker = new Downloader(execEnv, nodes, tab);
        worker.work();
    }

    private static Map<Project, Set<File>> gatherFiles(Node[] nodes) {
        HashMap<Project, Set<File>> result = new HashMap<Project, Set<File>>();
        for (Node node : nodes) {
            Project project = RemoteSyncActions.getNodeProject(node);
            HashSet files = (HashSet)result.get(project);
            if (files == null) {
                files = new HashSet();
                result.put(project, files);
            }
            RemoteSyncActions.gatherFiles((Set<File>)files, node);
        }
        return result;
    }

    private static void gatherFiles(Set<File> files, Node node) {
        File file;
        FileObject fo;
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        if (dataObject != null && (fo = dataObject.getPrimaryFile()) != null && (file = FileUtil.toFile((FileObject)fo)) != null && !file.isDirectory()) {
            files.add(file);
            return;
        }
        Folder folder = (Folder)node.getLookup().lookup(Folder.class);
        if (folder != null) {
            RemoteSyncActions.gatherFiles(files, folder);
            return;
        }
        SearchInfoDefinition searchInfo = (SearchInfoDefinition)node.getLookup().lookup(SearchInfoDefinition.class);
        if (searchInfo != null && searchInfo.canSearch()) {
            Iterator filesToSearch = searchInfo.filesToSearch(SearchScopeOptions.create(), new SearchListener(){}, new AtomicBoolean());
            while (filesToSearch.hasNext()) {
                FileObject fo2 = (FileObject)filesToSearch.next();
                File file2 = FileUtil.toFile((FileObject)fo2);
                if (file2 == null || file2.isDirectory()) continue;
                files.add(file2);
            }
        }
    }

    private static void gatherFiles(Set<File> files, Folder folder) {
        for (Item item : folder.getItemsAsArray()) {
            FileObject fo = item.getFileObject();
            File file = FileUtil.toFile((FileObject)fo);
            if (file == null || file.isDirectory()) continue;
            files.add(file);
        }
        for (Folder subfolder : folder.getFolders()) {
            RemoteSyncActions.gatherFiles(files, subfolder);
        }
    }

    private static boolean hasRootNode(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            Folder folder = (Folder)node.getLookup().lookup(Folder.class);
            if (folder == null || folder.getKind() != Folder.Kind.ROOT) continue;
            return true;
        }
        return false;
    }

    static {
        activatedNodesCache = new AtomicReference();
        RP = new RequestProcessor("RemoteSyncActions", 1);
        clearCacheTask = RP.create(new Runnable(){

            @Override
            public void run() {
                activatedNodesCache.set(null);
            }
        });
    }

    private static class DownloadAction
    extends BaseAction {
        private DownloadAction() {
        }

        @Override
        protected String getDummyItemText() {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"LBL_DownloadAction_Name_0");
        }

        @Override
        protected String getItemText(String hostName) {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"LBL_DownloadAction_Name_1", (Object)hostName);
        }

        @Override
        protected void performAction(final ExecutionEnvironment execEnv, final Node[] activatedNodes) {
            RP.post((Runnable)new NamedRunnable("Uploading to " + ServerList.get((ExecutionEnvironment)execEnv).getDisplayName()){

                protected void runImpl() {
                    RemoteSyncActions.download(execEnv, activatedNodes);
                }
            });
        }

        @Override
        protected boolean enable(Node[] activatedNodes) {
            boolean isEnabled = super.enable(activatedNodes);
            if (isEnabled) {
                return Boolean.getBoolean("cnd.remote.download.project.action");
            }
            return isEnabled;
        }
    }

    private static class UploadAction
    extends BaseAction {
        private UploadAction() {
        }

        @Override
        protected String getDummyItemText() {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"LBL_UploadAction_Name_0");
        }

        @Override
        protected String getItemText(String hostName) {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"LBL_UploadAction_Name_1", (Object)hostName);
        }

        @Override
        protected void performAction(final ExecutionEnvironment execEnv, final Node[] activatedNodes) {
            RP.post((Runnable)new NamedRunnable("Uploading to " + ServerList.get((ExecutionEnvironment)execEnv).getDisplayName()){

                protected void runImpl() {
                    RemoteSyncActions.upload(execEnv, activatedNodes);
                }
            });
        }
    }

    private static abstract class BaseAction
    extends NodeAction {
        private boolean enabled;

        protected abstract void performAction(ExecutionEnvironment var1, Node[] var2);

        protected abstract String getDummyItemText();

        protected abstract String getItemText(String var1);

        public BaseAction() {
            this.putValue("hideWhenDisabled", Boolean.TRUE);
        }

        protected boolean enable(Node[] activatedNodes) {
            boolean isSyncActionsEnabled = true;
            if (RemoteSyncActions.hasRootNode(activatedNodes)) {
                isSyncActionsEnabled = Boolean.getBoolean("cnd.remote.sync.project.action");
            }
            if (!isSyncActionsEnabled) {
                return false;
            }
            RemoteSyncActions.cacheActiveNodes(activatedNodes);
            Pair p = RemoteSyncActions.getEnv(activatedNodes);
            if (p != null && p.first() != null && ((ExecutionEnvironment)p.first()).isRemote()) {
                RemoteSyncFactory sync = (RemoteSyncFactory)p.second();
                if (sync == null) {
                    sync = ServerList.get((ExecutionEnvironment)((ExecutionEnvironment)p.first())).getSyncFactory();
                }
                this.enabled = sync == null ? false : sync.isCopying();
            } else {
                this.enabled = false;
            }
            return this.enabled;
        }

        protected boolean wasEnabled() {
            return this.enabled;
        }

        protected void performAction(Node[] activatedNodes) {
            ExecutionEnvironment execEnv;
            Pair p = RemoteSyncActions.getEnv(activatedNodes);
            ExecutionEnvironment executionEnvironment = execEnv = p == null ? null : (ExecutionEnvironment)p.first();
            if (execEnv != null && execEnv.isRemote()) {
                this.performAction(execEnv, activatedNodes);
            }
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        public String getName() {
            ExecutionEnvironment execEnv;
            if (!this.wasEnabled()) {
                return this.getDummyItemText();
            }
            Node[] activatedNodes = (Node[])activatedNodesCache.get();
            if (activatedNodes == null || activatedNodes.length == 0) {
                return this.getDummyItemText();
            }
            Pair p = RemoteSyncActions.getEnv(activatedNodes);
            ExecutionEnvironment executionEnvironment = execEnv = p == null ? null : (ExecutionEnvironment)p.first();
            if (execEnv == null || execEnv.isLocal()) {
                return this.getDummyItemText();
            }
            String hostName = ServerList.get((ExecutionEnvironment)execEnv).getDisplayName();
            return this.getItemText(hostName);
        }
    }

    private static class Downloader
    extends UpDownLoader {
        public Downloader(ExecutionEnvironment execEnv, Node[] nodes, InputOutput tab) {
            super(execEnv, nodes, tab);
        }

        @Override
        protected String getFileProgressMessage(File file) {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"MSG_DOWNLOAD_FILE", (Object)file.getAbsolutePath());
        }

        @Override
        protected String getProgressTitle() {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"PROGRESS_TITLE_DOWNLOAD", (Object)this.envName);
        }

        @Override
        protected RemoteSyncSupport.Worker createWorker(final Project project, final ExecutionEnvironment execEnv) {
            return new RemoteSyncSupport.Worker(){
                private final PathMap pathMap;
                {
                    this.pathMap = RemoteSyncSupport.getPathMap((ExecutionEnvironment)execEnv, (Lookup.Provider)project);
                }

                public void process(File file, Writer err) throws RemoteSyncSupport.PathMapperException, InterruptedException, ExecutionException, IOException {
                    String remotePath = this.pathMap.getRemotePath(file.getAbsolutePath(), false);
                    if (remotePath == null) {
                        throw new RemoteSyncSupport.PathMapperException(file);
                    }
                    Future task = CommonTasksSupport.downloadFile((String)remotePath, (ExecutionEnvironment)execEnv, (String)file.getAbsolutePath(), (Writer)err);
                    int rc = (Integer)task.get();
                    if (rc != 0) {
                        throw new IOException(NbBundle.getMessage(RemoteSyncActions.class, (String)"ERR_RC", (Object)rc));
                    }
                }

                public void close() {
                }
            };
        }
    }

    private static class Uploader
    extends UpDownLoader {
        public Uploader(ExecutionEnvironment execEnv, Node[] nodes, InputOutput tab) {
            super(execEnv, nodes, tab);
        }

        @Override
        protected String getFileProgressMessage(File file) {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"MSG_UPLOAD_FILE", (Object)file.getAbsolutePath());
        }

        @Override
        protected String getProgressTitle() {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"PROGRESS_TITLE_UPLOAD", (Object)this.envName);
        }

        @Override
        protected RemoteSyncSupport.Worker createWorker(Project project, ExecutionEnvironment execEnv) throws IOException {
            return RemoteSyncSupport.createUploader((Lookup.Provider)project, (ExecutionEnvironment)execEnv);
        }
    }

    private static abstract class UpDownLoader
    implements Cancellable {
        protected final ExecutionEnvironment execEnv;
        protected final String envName;
        protected final InputOutput tab;
        private boolean cancelled = false;
        private final Node[] nodes;
        private volatile Thread workingThread;

        public UpDownLoader(ExecutionEnvironment execEnv, Node[] nodes, InputOutput tab) {
            this.execEnv = execEnv;
            this.nodes = nodes;
            this.tab = tab;
            this.envName = ServerList.get((ExecutionEnvironment)execEnv).getDisplayName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void work() {
            this.workingThread = Thread.currentThread();
            String title = this.getProgressTitle();
            this.tab.getOut().println(title);
            int errCnt = 0;
            int okCnt = 0;
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)title, (Cancellable)this);
            progressHandle.start();
            try {
                if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
                    ConnectionManager.getInstance().connectTo(this.execEnv);
                }
                Map filesMap = RemoteSyncActions.gatherFiles(this.nodes);
                int cnt = 0;
                int total = 0;
                for (Set set : filesMap.values()) {
                    total += set.size();
                }
                progressHandle.switchToDeterminate(total);
                block19: for (Map.Entry entry : filesMap.entrySet()) {
                    try (RemoteSyncSupport.Worker worker = this.createWorker((Project)entry.getKey(), this.execEnv);){
                        for (File file : (Set)entry.getValue()) {
                            if (this.cancelled) continue block19;
                            String progressMessage = this.getFileProgressMessage(file);
                            this.tab.getOut().println(progressMessage);
                            try {
                                worker.process(file, (Writer)this.tab.getErr());
                                ++okCnt;
                            }
                            catch (InterruptedException ex) {
                                continue block19;
                            }
                            catch (ExecutionException ex) {
                                this.tab.getErr().println(NbBundle.getMessage(RemoteSyncActions.class, (String)"ERR_FILE", (Object)file.getAbsolutePath(), (Object)ex.getMessage()));
                                ++errCnt;
                            }
                            catch (IOException ex) {
                                this.tab.getErr().println(NbBundle.getMessage(RemoteSyncActions.class, (String)"ERR_FILE", (Object)file.getAbsolutePath(), (Object)ex.getMessage()));
                                ++errCnt;
                            }
                            progressHandle.progress(progressMessage, cnt++);
                        }
                    }
                }
            }
            catch (RemoteSyncSupport.PathMapperException ex) {
                this.tab.getErr().println(NbBundle.getMessage(RemoteSyncActions.class, (String)"ERR_MAPPING", (Object)ex.getFile().getAbsolutePath()));
                ++errCnt;
            }
            catch (ConnectionManager.CancellationException ex) {
                this.cancelled = true;
            }
            catch (InterruptedIOException ex) {
                this.cancelled = true;
            }
            catch (IOException ex) {
                this.tab.getErr().println(NbBundle.getMessage(RemoteSyncActions.class, (String)"ERR_CONNECT", (Object)this.envName));
                ++errCnt;
            }
            finally {
                progressHandle.finish();
            }
            this.workingThread = null;
            if (errCnt == 0) {
                this.tab.getOut().println(NbBundle.getMessage(RemoteSyncActions.class, (String)"SUMMARY_SUCCESS", (Object)okCnt));
            } else if (this.cancelled) {
                this.tab.getOut().println(NbBundle.getMessage(RemoteSyncActions.class, (String)"SUMMARY_CANCELED", (Object)okCnt));
            } else {
                this.tab.getErr().println(NbBundle.getMessage(RemoteSyncActions.class, (String)"SUMMARY_ERROR", (Object)okCnt));
            }
        }

        public boolean cancel() {
            this.cancelled = true;
            Thread thread = this.workingThread;
            if (thread != null) {
                thread.interrupt();
            }
            return true;
        }

        protected abstract String getProgressTitle();

        protected abstract String getFileProgressMessage(File var1);

        protected abstract RemoteSyncSupport.Worker createWorker(Project var1, ExecutionEnvironment var2) throws IOException;
    }
}

