/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.execution.ShellExecSupport;
import org.netbeans.modules.cnd.makeproject.api.wizards.PreBuildSupport;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public final class ConfigureScriptSupport
implements PreBuildSupport.PreBuildArtifactProvider {
    private static final String PREDEFINED_FLAGS_GNU = "\"-g3 -gdwarf-2\"";
    private static final String PREDEFINED_FLAGS_SUN = "-g";
    private static final String[] pattern = new String[]{"configure"};

    @Override
    public PreBuildSupport.PreBuildArtifact findScriptInFolder(FileObject folder, ExecutionEnvironment ee, CompilerSet compilerSet) {
        if (folder == null) {
            return null;
        }
        folder.refresh();
        if (!folder.isFolder() || !folder.canRead()) {
            return null;
        }
        for (String name : pattern) {
            ConfigureScriptArtifact res;
            FileObject child = folder.getFileObject(name);
            if (child == null || !child.isValid() || (res = new ConfigureScriptArtifact(child)).validate(null, null) != null) continue;
            return res;
        }
        return null;
    }

    @Override
    public PreBuildSupport.PreBuildArtifact scriptToArtifact(FileObject script) {
        for (String name : pattern) {
            if (!name.equals(script.getNameExt())) continue;
            return new ConfigureScriptArtifact(script);
        }
        return null;
    }

    @Override
    public String getToolName() {
        return "configure";
    }

    @Override
    public boolean isSupported(PreBuildSupport.PreBuildArtifact script) {
        return script instanceof ConfigureScriptArtifact;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(ConfigureScriptSupport.class, (String)"ScriptTypeDisplayName_configure");
    }

    @Override
    public String getHint() {
        return NbBundle.getMessage(ConfigureScriptSupport.class, (String)"SelectModeSimpleInstructionExtraText_Configure");
    }

    @Override
    public String getFileChooserTitle() {
        return NbBundle.getMessage(ConfigureScriptSupport.class, (String)"ScriptTypeFileChooser_configure");
    }

    @Override
    public FileFilter[] getFileFilter() {
        return new FileFilter[]{FileFilterFactory.getConfigureFileFilter()};
    }

    static String getCompilerFlags(CompilerSet def) {
        CompilerFlavor flavor;
        if (def != null && (flavor = def.getCompilerFlavor()).isSunStudioCompiler()) {
            return PREDEFINED_FLAGS_SUN;
        }
        return PREDEFINED_FLAGS_GNU;
    }

    static void appendIfNeed(String key, String flags, StringBuilder buf, String flag) {
        if (!flags.contains(key)) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(key).append(flag);
        }
    }

    private static final class ConfigureScriptArtifact
    implements PreBuildSupport.PreBuildArtifact {
        private final FileObject script;

        ConfigureScriptArtifact(FileObject script) {
            this.script = script;
        }

        @Override
        public FileObject getScript() {
            return this.script;
        }

        @Override
        public String getArguments(ExecutionEnvironment ee, CompilerSet def, String flags) {
            ee = ee != null ? ee : ServerList.getDefaultRecord().getExecutionEnvironment();
            def = def != null ? def : CompilerSetManager.get((ExecutionEnvironment)ee).getDefaultCompilerSet();
            StringBuilder buf = new StringBuilder(flags);
            String cCompilerFlags = ConfigureScriptSupport.getCompilerFlags(def);
            String cppCompilerFlags = ConfigureScriptSupport.getCompilerFlags(def);
            ConfigureScriptSupport.appendIfNeed("CC=", flags, buf, "${IDE_CC}");
            ConfigureScriptSupport.appendIfNeed("CXX=", flags, buf, "${IDE_CXX}");
            ConfigureScriptSupport.appendIfNeed("CFLAGS=", flags, buf, cCompilerFlags);
            ConfigureScriptSupport.appendIfNeed("CXXFLAGS=", flags, buf, cppCompilerFlags);
            return buf.toString();
        }

        @Override
        public String getCommandLine(String arguments, String workingDir) {
            StringBuilder buf = new StringBuilder();
            String toRelativePath = CndPathUtilities.toRelativePath((String)workingDir, (String)this.script.getPath());
            if (toRelativePath.equals(this.script.getNameExt())) {
                buf.append("./");
            }
            buf.append(toRelativePath);
            buf.append(' ');
            buf.append(arguments);
            return buf.toString();
        }

        @Override
        public String validate(ExecutionEnvironment ee, CompilerSet compilerSet) {
            if (this.script.isValid() && this.script.isData() && (this.script.canRead() || FileSystemProvider.canExecute((FileObject)this.script))) {
                DataObject dObj;
                try {
                    dObj = DataObject.find((FileObject)this.script);
                }
                catch (DataObjectNotFoundException ex) {
                    return NbBundle.getMessage(ConfigureScriptSupport.class, (String)"CONFIGUREFILEISNOTEXECUTABLE");
                }
                if (dObj == null) {
                    return NbBundle.getMessage(ConfigureScriptSupport.class, (String)"CONFIGUREFILEISNOTEXECUTABLE");
                }
                Node node = dObj.getNodeDelegate();
                if (node == null) {
                    return NbBundle.getMessage(ConfigureScriptSupport.class, (String)"CONFIGUREFILEISNOTEXECUTABLE");
                }
                ShellExecSupport ses = (ShellExecSupport)node.getLookup().lookup(ShellExecSupport.class);
                if (ses == null) {
                    return NbBundle.getMessage(ConfigureScriptSupport.class, (String)"CONFIGUREFILEISNOTEXECUTABLE");
                }
                return null;
            }
            return NbBundle.getMessage(ConfigureScriptSupport.class, (String)"CONFIGUREFILEISNOTEXECUTABLE");
        }
    }
}

