/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.angular;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.html.angular.Bundle;
import org.netbeans.modules.html.angular.Utils;
import org.netbeans.modules.html.angular.model.Directive;
import org.openide.modules.Places;
import org.openide.util.Enumerations;
import org.openide.util.RequestProcessor;

public class AngularDoc {
    private static final Logger LOG = Logger.getLogger(AngularDoc.class.getSimpleName());
    private static RequestProcessor RP = new RequestProcessor(AngularDoc.class);
    private static AngularDoc INSTANCE;
    private boolean loadingStarted;
    private static final String CACHE_FOLDER_NAME = "ajs-doc";
    public static final String DOC_VERSION;
    private Directive directive;
    private Enumeration<Directive> directives;
    private ProgressHandle progress;
    private int loaded = 0;

    public static synchronized AngularDoc getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new AngularDoc();
        }
        return INSTANCE;
    }

    public String getDirectiveDocumentation(Directive directive) {
        return this.getDoc(directive);
    }

    public String getFunctionDocumentation(FunctionDocUrl functionDocUrl) {
        return this.getDoc(functionDocUrl);
    }

    private void startLoading() {
        LOG.fine("start loading doc");
        Directive[] dirs = Directive.values();
        this.directives = Enumerations.array((Object[])dirs);
        this.progress = ProgressHandleFactory.createHandle((String)Bundle.doc_building());
        this.progress.start(dirs.length);
        this.buildDoc();
    }

    private File getCacheFile(String name) {
        return Places.getCacheSubfile((String)(CACHE_FOLDER_NAME + '/' + DOC_VERSION + '/' + name));
    }

    private String getDoc(Directive directive) {
        try {
            File cacheFile = this.getCacheFile(directive.name());
            if (!cacheFile.exists()) {
                this.loadDoc(directive, cacheFile);
                if (!this.loadingStarted) {
                    this.loadingStarted = true;
                    this.startLoading();
                }
            }
            return Utils.getFileContent(cacheFile);
        }
        catch (IOException | URISyntaxException ex) {
            LOG.log(Level.INFO, "Cannot load AngularJS documentation from \"{0}\".", new Object[]{directive.getExternalDocumentationURL_partial()});
            return Bundle.doc_cannotGet(directive.getExternalDocumentationURL_partial());
        }
    }

    private String getDoc(FunctionDocUrl functionDocUrl) {
        try {
            File cacheFile = this.getCacheFile(functionDocUrl.getFunctionName());
            if (!cacheFile.exists()) {
                this.loadDoc(new URL(functionDocUrl.getDocumentationPartialUrl()), cacheFile);
            }
            return Utils.getFileContent(cacheFile);
        }
        catch (IOException | URISyntaxException ex) {
            LOG.log(Level.INFO, "Cannot load AngularJS documentation from \"{0}\".", new Object[]{functionDocUrl.getDocumentationPartialUrl()});
            return null;
        }
    }

    private void loadDoc(Directive directive, File cacheFile) throws URISyntaxException, MalformedURLException, IOException {
        String docURL = directive.getExternalDocumentationURL_partial();
        URL url = new URI(docURL).toURL();
        this.loadDoc(url, cacheFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDoc(URL url, File cacheFile) throws URISyntaxException, MalformedURLException, IOException {
        LOG.fine("start loading doc");
        File file = cacheFile;
        synchronized (file) {
            String tmpFileName = cacheFile.getAbsolutePath() + ".tmp";
            File tmpFile = new File(tmpFileName);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), "UTF-8");){
                ((Writer)writer).append("<!doctype html><html><head><title>AngularJS documentation</title></head><body>");
                Utils.loadURL(url, writer, Charset.forName("UTF-8"));
                ((Writer)writer).append("</body></html>");
                ((Writer)writer).close();
                tmpFile.renameTo(cacheFile);
            }
            finally {
                if (tmpFile.exists()) {
                    tmpFile.delete();
                }
            }
        }
    }

    private void buildDoc() {
        if (this.directives.hasMoreElements()) {
            this.directive = this.directives.nextElement();
            this.getDoc(this.directive);
            this.progress.progress(++this.loaded);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    AngularDoc.this.buildDoc();
                }
            });
        } else {
            this.progress.finish();
            this.progress = null;
            LOG.log(Level.FINE, "Loading doc finished.");
        }
    }

    static {
        DOC_VERSION = System.getProperty("nb.angular.doc.version", "1.4.0");
    }

    public static class FunctionDocUrl {
        private static final String DOC_URL_BASE = "https://docs.angularjs.org/api/ng/function/";
        private static final String PARTIAL_DOC_URL_BASE = "https://code.angularjs.org/" + DOC_VERSION + "/docs/partials/api/ng/function/";
        private static final String PARTIAL_SUFFIX = ".html";
        private final String functionName;

        public String getFunctionName() {
            return this.functionName;
        }

        public FunctionDocUrl(String functionName) {
            this.functionName = functionName;
        }

        public String getDocumentationUrl() {
            return DOC_URL_BASE + this.functionName;
        }

        public String getDocumentationPartialUrl() {
            return PARTIAL_DOC_URL_BASE + this.functionName + PARTIAL_SUFFIX;
        }
    }
}

