/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.sources;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.web.common.sourcemap.Mapping;
import org.netbeans.modules.web.common.sourcemap.SourceMap;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SourceMapsTranslator {
    private static final Logger LOG = Logger.getLogger(SourceMapsTranslator.class.getName());
    private static final String SOURCE_MAPPING_URL = "//# sourceMappingURL=";
    private static final boolean USE_SOURCE_MAPS = Boolean.parseBoolean(System.getProperty("javascript.debugger.useSourceMaps", "true"));
    private static final Map<FileObject, SourceMapsTranslator> translatedFiles = new WeakHashMap<FileObject, SourceMapsTranslator>();
    private final FileObject parentFolder;
    private final SourceMap sourceMap;

    private SourceMapsTranslator(FileObject parentFolder, SourceMap sourceMap) {
        this.parentFolder = parentFolder;
        this.sourceMap = sourceMap;
    }

    public static synchronized SourceMapsTranslator get(FileObject source) {
        if (!USE_SOURCE_MAPS) {
            return null;
        }
        SourceMapsTranslator smtr = translatedFiles.get(source);
        if (smtr != null) {
            return smtr;
        }
        String lastLine = null;
        try {
            Iterator i$ = source.asLines().iterator();
            while (i$.hasNext()) {
                String line;
                lastLine = line = (String)i$.next();
            }
        }
        catch (IOException ioex) {
            return null;
        }
        if (lastLine != null && lastLine.startsWith(SOURCE_MAPPING_URL)) {
            String sourceMapFileName = lastLine.substring(SOURCE_MAPPING_URL.length()).trim();
            File sourceMapFile = new File(sourceMapFileName);
            FileObject fo = sourceMapFile.isAbsolute() ? FileUtil.toFileObject((File)FileUtil.normalizeFile((File)sourceMapFile)) : source.getParent().getFileObject(sourceMapFileName);
            if (fo == null) {
                return null;
            }
            try {
                return new SourceMapsTranslator(source.getParent(), SourceMap.parse((String)fo.asText()));
            }
            catch (IOException | IllegalArgumentException ex) {
                LOG.log(Level.INFO, "Could not read source map " + fo, ex);
                return null;
            }
        }
        return null;
    }

    public FileObject getTranslatedFile(int line) {
        Mapping mapping = this.sourceMap.findMapping(line);
        if (mapping == null) {
            return null;
        }
        int sourceIndex = mapping.getSourceIndex();
        String sourcePath = this.sourceMap.getSourcePath(sourceIndex);
        File sourceFile = new File(sourcePath);
        FileObject fo = sourceFile.isAbsolute() ? FileUtil.toFileObject((File)FileUtil.normalizeFile((File)sourceFile)) : this.parentFolder.getFileObject(sourcePath);
        return fo;
    }

    public int getTranslatedLine(int line) {
        Mapping mapping = this.sourceMap.findMapping(line);
        if (mapping == null) {
            return line;
        }
        return mapping.getOriginalLine();
    }
}

