/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.vars;

import java.awt.EventQueue;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.lib.v8debug.V8Arguments;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.lib.v8debug.V8Request;
import org.netbeans.lib.v8debug.V8Response;
import org.netbeans.lib.v8debug.commands.Lookup;
import org.netbeans.lib.v8debug.vars.V8Value;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.vars.EvaluationError;
import org.netbeans.modules.javascript.v8debug.vars.Variable;
import org.openide.util.RequestProcessor;

public class VarValuesLoader {
    private static final Logger LOG = Logger.getLogger(VarValuesLoader.class.getName());
    private static final int THROUGHPUT = 3;
    private static final RequestProcessor RP = new RequestProcessor(VarValuesLoader.class.getName(), 3);
    private final V8Debugger dbg;
    private final Set<Variable> varQueue = new LinkedHashSet<Variable>();
    private final Queue<Loader> loadTasks = new ArrayDeque<Loader>(3);

    public VarValuesLoader(V8Debugger dbg) {
        this.dbg = dbg;
        for (int i = 0; i < 3; ++i) {
            this.loadTasks.offer(new Loader());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V8Value getValue(Variable var) throws EvaluationError {
        assert (!EventQueue.isDispatchThread());
        Set<Variable> set = this.varQueue;
        synchronized (set) {
            V8Value value = var.getValue();
            if (value == null || var.hasIncompleteValue()) {
                this.varQueue.add(var);
                Loader loader = this.loadTasks.poll();
                if (loader != null) {
                    RP.post((Runnable)loader);
                }
                do {
                    try {
                        this.varQueue.wait();
                    }
                    catch (InterruptedException ex) {
                        throw new EvaluationError(ex.getLocalizedMessage());
                    }
                } while ((value = var.getValue()) == null);
            }
            return value;
        }
    }

    public void updateValue(Variable var, V8Value evalVal) {
        var.setValue(evalVal);
    }

    private final class Loader
    implements Runnable {
        private Loader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedHashMap<Long, Variable> varsByRef = new LinkedHashMap<Long, Variable>();
            Set set = VarValuesLoader.this.varQueue;
            synchronized (set) {
                for (Variable var : VarValuesLoader.this.varQueue) {
                    varsByRef.put(var.getRef(), var);
                }
                VarValuesLoader.this.varQueue.clear();
            }
            if (varsByRef.isEmpty()) {
                return;
            }
            long[] handles = new long[varsByRef.size()];
            int i = 0;
            Iterator i$ = varsByRef.keySet().iterator();
            while (i$.hasNext()) {
                long h = (Long)i$.next();
                handles[i++] = h;
            }
            final V8Response[] responseRef = new V8Response[]{null};
            final boolean[] responsed = new boolean[]{false};
            V8Request lookupCommandRequest = VarValuesLoader.this.dbg.sendCommandRequest(V8Command.Lookup, (V8Arguments)new Lookup.Arguments(handles, Boolean.FALSE), new V8Debugger.CommandResponseCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void notifyResponse(V8Request request, V8Response response) {
                    V8Response[] v8ResponseArray = responseRef;
                    synchronized (responseRef) {
                        responseRef[0] = response;
                        responsed[0] = true;
                        responseRef.notifyAll();
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                }
            });
            V8Response[] v8ResponseArray = responseRef;
            synchronized (responseRef) {
                if (lookupCommandRequest != null && !responsed[0]) {
                    try {
                        responseRef.wait();
                    }
                    catch (InterruptedException iex) {
                        // empty catch block
                    }
                }
                V8Response response = responseRef[0];
                // ** MonitorExit[var8_10] (shouldn't be in output)
                if (response == null || !response.isSuccess()) {
                    String err = response != null ? response.getErrorMessage() : "interrupted";
                    Set iex = VarValuesLoader.this.varQueue;
                    synchronized (iex) {
                        for (Variable var : varsByRef.values()) {
                            var.setValueLoadError(err);
                        }
                        VarValuesLoader.this.varQueue.notifyAll();
                        if (!VarValuesLoader.this.varQueue.isEmpty()) {
                            RP.post((Runnable)this);
                        } else {
                            VarValuesLoader.this.loadTasks.offer(this);
                        }
                    }
                }
                Lookup.ResponseBody lrb = (Lookup.ResponseBody)response.getBody();
                Map valuesByHandle = lrb.getValuesByHandle();
                Set set2 = VarValuesLoader.this.varQueue;
                synchronized (set2) {
                    for (Long ref : valuesByHandle.keySet()) {
                        Variable var = (Variable)varsByRef.get(ref);
                        if (var == null) continue;
                        var.setValue((V8Value)valuesByHandle.get(ref));
                    }
                    VarValuesLoader.this.varQueue.notifyAll();
                    if (!VarValuesLoader.this.varQueue.isEmpty()) {
                        RP.post((Runnable)this);
                    } else {
                        VarValuesLoader.this.loadTasks.offer(this);
                    }
                }
                return;
            }
        }
    }
}

