/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.vars.tooltip;

import java.util.concurrent.CancellationException;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.lib.v8debug.vars.V8Value;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.frames.CallFrame;
import org.netbeans.modules.javascript.v8debug.vars.EvaluationError;
import org.netbeans.modules.javascript.v8debug.vars.V8Evaluator;
import org.netbeans.modules.javascript.v8debug.vars.Variable;
import org.netbeans.modules.javascript.v8debug.vars.models.VariablesModel;
import org.netbeans.modules.javascript.v8debug.vars.tooltip.V8DebuggerTooltipSupport;
import org.netbeans.modules.javascript2.debug.tooltip.AbstractJSToolTipAnnotation;
import org.openide.util.Pair;

public class ToolTipAnnotation
extends AbstractJSToolTipAnnotation<V8DebuggerTooltipSupport> {
    protected V8DebuggerTooltipSupport getEngineDebugger(Session session, DebuggerEngine engine) {
        V8Debugger debugger = (V8Debugger)engine.lookupFirst(null, V8Debugger.class);
        if (debugger == null || !debugger.isSuspended()) {
            return null;
        }
        CallFrame currentFrame = debugger.getCurrentFrame();
        return new V8DebuggerTooltipSupport(debugger, currentFrame);
    }

    protected Pair<String, Object> evaluate(String expression, DebuggerEngine engine, V8DebuggerTooltipSupport dbg) throws CancellationException {
        String toolTipText;
        Variable var = null;
        try {
            V8Value value = V8Evaluator.evaluate(dbg.getDebugger(), expression);
            if (value == null) {
                throw new CancellationException();
            }
            toolTipText = expression + " = " + V8Evaluator.getStringValue(value);
            if (VariablesModel.hasChildren(value)) {
                var = new Variable(Variable.Kind.LOCAL, expression, value.getHandle(), value, false);
            }
        }
        catch (EvaluationError ex) {
            toolTipText = expression + " = >" + ex.getMessage() + "<";
        }
        return Pair.of((Object)toolTipText, var);
    }
}

