/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion.api;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.web.core.syntax.AutoTagImporterProvider;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.netbeans.modules.web.core.syntax.completion.JspCompletionProvider;
import org.netbeans.modules.web.core.syntax.completion.Util;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.netbeans.swing.plaf.LFCustoms;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

public class JspCompletionItem
implements CompletionItem {
    private static final Color COLOR_BASE_COMPLETION = new Color(0, 0, 255);
    private static final Color COLOR_ATTRIBUTE_REQUIRED = new Color(255, 0, 0);
    private static final Color COLOR_ATTRIBUTE_NOT_REQUIRED = new Color(0, 170, 0);
    private static final Color COLOR_HELP_HEADER_BG = new Color(204, 204, 255);
    private static final Color COLOR_HELP_HEADER_FG = new Color(0, 0, 0);
    private static final int DEFAULT_SORT_PRIORITY = 10;
    private static final Logger logger = Logger.getLogger(JspCompletionItem.class.getName());
    protected int substitutionOffset;
    protected String text;
    protected String help;
    protected boolean shift;

    public static JspCompletionItem createJspAttributeValueCompletionItem(String value, int substitutionOffset) {
        return new AttributeValue(value, substitutionOffset);
    }

    public static JspCompletionItem createFileCompletionItem(String value, int substitutionOffset, Color color, ImageIcon icon) {
        return new FileAttributeValue(value, substitutionOffset, color, icon);
    }

    public static JspCompletionItem createGoUpFileCompletionItem(int substitutionOffset, Color color, ImageIcon icon) {
        return new GoUpFileAttributeValue(substitutionOffset, color, icon);
    }

    public static JspCompletionItem createPrefixTag(String prefix, int substitutionOffset) {
        return new PrefixTag(prefix, substitutionOffset);
    }

    public static JspCompletionItem createPrefixTag(String prefix, int substitutionOffset, TagInfo ti) {
        return new PrefixTag(prefix, substitutionOffset, ti);
    }

    public static JspCompletionItem createPrefixTag(String prefix, int substitutionOffset, TagInfo ti, SyntaxElement.Tag tagSyntaxElement) {
        return new PrefixTag(prefix, substitutionOffset, ti, tagSyntaxElement);
    }

    public static JspCompletionItem createAttribute(String name, int substitutionOffset) {
        return new Attribute(name, substitutionOffset);
    }

    public static JspCompletionItem createAttribute(int substitutionOffset, TagAttributeInfo tai) {
        return new Attribute(substitutionOffset, tai);
    }

    public static JspCompletionItem createTag(String name, int substitutionOffset) {
        return new Tag(name, substitutionOffset);
    }

    public static JspCompletionItem createTag(String name, int substitutionOffset, TagInfo tagInfo) {
        return new Tag(name, substitutionOffset, tagInfo);
    }

    public static JspCompletionItem createDelimiter(String name, int substitutionOffset) {
        return new Delimiter(name, substitutionOffset);
    }

    public static JspCompletionItem createDirective(String name, int substitutionOffset) {
        return new Directive(name, substitutionOffset);
    }

    public static JspCompletionItem createDirective(String name, int substitutionOffset, TagInfo tagInfo) {
        return new Directive(name, substitutionOffset, tagInfo);
    }

    protected JspCompletionItem(String text, int substituteOffset) {
        this.substitutionOffset = substituteOffset;
        this.text = text;
    }

    protected JspCompletionItem(String text, int substituteOffset, String help) {
        this(text, substituteOffset);
        this.help = help;
    }

    public String getItemText() {
        return this.text;
    }

    public int getSortPriority() {
        return 10;
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public void processKeyEvent(KeyEvent e) {
        this.shift = e.getKeyCode() == 10 && e.getID() == 401 && e.isShiftDown();
    }

    public void defaultAction(JTextComponent component) {
        if (component != null) {
            if (!this.shift) {
                Completion.get().hideDocumentation();
                Completion.get().hideCompletion();
            }
            int caretOffset = component.getSelectionEnd();
            this.substituteText(component, caretOffset - this.substitutionOffset);
        }
    }

    protected int getMoveBackLength() {
        return 0;
    }

    protected String getSubstituteText() {
        return this.getItemText();
    }

    protected boolean substituteText(JTextComponent c, int len) {
        return this.substituteText(c, len, this.getMoveBackLength());
    }

    protected boolean substituteText(JTextComponent c, int len, int moveBack) {
        return this.substituteText(c, this.getSubstituteText(), len, moveBack);
    }

    protected boolean substituteText(final JTextComponent c, final String substituteText, final int len, int moveBack) {
        final BaseDocument doc = (BaseDocument)c.getDocument();
        final boolean[] result = new boolean[]{true};
        doc.runAtomic(new Runnable(){

            @Override
            public void run() {
                try {
                    String currentText = doc.getText(JspCompletionItem.this.substitutionOffset, doc.getLength() - JspCompletionItem.this.substitutionOffset < substituteText.length() ? doc.getLength() - JspCompletionItem.this.substitutionOffset : substituteText.length());
                    if (!substituteText.equals(currentText)) {
                        doc.remove(JspCompletionItem.this.substitutionOffset, len);
                        doc.insertString(JspCompletionItem.this.substitutionOffset, substituteText, null);
                    } else {
                        c.setCaretPosition(c.getCaret().getDot() + substituteText.length() - len);
                    }
                }
                catch (BadLocationException ex) {
                    result[0] = false;
                }
            }
        });
        this.reindent(c);
        if (moveBack != 0) {
            Caret caret = c.getCaret();
            int dot = caret.getDot();
            caret.setDot(dot - moveBack);
        }
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindent(JTextComponent component) {
        final BaseDocument doc = (BaseDocument)component.getDocument();
        final int dotPos = component.getCaretPosition();
        final Indent indent = Indent.get((Document)doc);
        indent.lock();
        try {
            doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        int startOffset = Utilities.getRowStart((BaseDocument)doc, (int)dotPos);
                        int endOffset = Utilities.getRowEnd((BaseDocument)doc, (int)dotPos);
                        indent.reindent(startOffset, endOffset);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
        finally {
            indent.unlock();
        }
    }

    public boolean instantSubstitution(JTextComponent component) {
        if (component != null) {
            try {
                int caretOffset = component.getSelectionEnd();
                if (caretOffset > this.substitutionOffset) {
                    String currentText = component.getDocument().getText(this.substitutionOffset, caretOffset - this.substitutionOffset);
                    if (!this.getSubstituteText().toString().startsWith(currentText)) {
                        return false;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.defaultAction(component);
        return true;
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    protected ImageIcon getIcon() {
        return null;
    }

    protected String getLeftHtmlText() {
        return this.getItemText();
    }

    protected String getRightHtmlText() {
        return null;
    }

    public URL getHelpURL() {
        if (this.help == null || this.help.equals("")) {
            return null;
        }
        try {
            return new URL(this.help);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getHelp() {
        return this.help;
    }

    public boolean hasHelp() {
        return this.help != null && this.help.length() > 0;
    }

    public CompletionTask createDocumentationTask() {
        return new AsyncCompletionTask((AsyncCompletionQuery)new JspCompletionProvider.DocQuery(this));
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    private static String constructHelp(URL url) {
        if (url == null) {
            return null;
        }
        try {
            InputStream is = JspCompletionItem.getInputStreamForUrl(url);
            if (is == null) {
                logger.log(Level.INFO, "Cannot read: {0}", url.toString());
                return null;
            }
            byte[] buffer = new byte[1000];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int count = 0;
            do {
                if ((count = is.read(buffer)) <= 0) continue;
                baos.write(buffer, 0, count);
            } while (count > 0);
            is.close();
            String text = baos.toString();
            baos.close();
            return text;
        }
        catch (IOException e) {
            logger.log(Level.INFO, url.toString(), e);
            return null;
        }
    }

    protected static InputStream getInputStreamForUrl(URL url) throws IOException {
        URL archiveUrl = FileUtil.getArchiveFile((URL)url);
        FileObject resource = null;
        if (archiveUrl == null) {
            return url.openStream();
        }
        String path = url.getPath();
        String filePath = path.substring(path.indexOf("!/") + 2);
        File f = JspCompletionItem.getFileForUrl(archiveUrl);
        JarFileSystem jfs = new JarFileSystem(f);
        resource = jfs.findResource(filePath);
        if (resource == null) {
            return null;
        }
        return resource.getInputStream();
    }

    private static File getFileForUrl(URL url) throws IOException {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    private static String constructHelp(TagInfo tagInfo) {
        if (tagInfo == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<h2>").append(JspCompletionItem.getString("LBL_TagName")).append(" ");
        sb.append(tagInfo.getTagName()).append("</h2>");
        String val = tagInfo.getDisplayName();
        if (val != null) {
            sb.append("<p>").append(JspCompletionItem.getString("LBL_DisplayName"));
            sb.append("<i>").append(val).append("</i>");
        }
        if ((val = tagInfo.getInfoString()) != null) {
            sb.append("<hr>").append(val).append("<hr>");
        }
        sb.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"3\" border=\"1\">");
        sb.append("<tr bgcolor=\"#");
        sb.append(JspCompletionItem.hexColorCode(COLOR_HELP_HEADER_BG));
        sb.append("\"><td colspan=\"2\"><font color=\"#");
        sb.append(JspCompletionItem.hexColorCode(COLOR_HELP_HEADER_FG));
        sb.append("\" ");
        sb.append("size=\"+2\"><b>");
        sb.append("Tag Information</b></font></td></tr>");
        sb.append("<tr><td>Tag Class</td><td>");
        if (tagInfo.getTagClassName() != null && !tagInfo.getClass().equals("")) {
            sb.append(tagInfo.getTagClassName());
        } else {
            sb.append("<i>None</i>");
        }
        sb.append("</td></tr><tr><td>Body Content</td><td>");
        sb.append(tagInfo.getBodyContent());
        sb.append("</td></tr><tr><td>Display Name</td><td>");
        if (tagInfo.getDisplayName() != null && !tagInfo.getDisplayName().equals("")) {
            sb.append(tagInfo.getDisplayName());
        } else {
            sb.append("<i>None</i>");
        }
        sb.append("</td></tr></table><br>");
        sb.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"3\" border=\"1\">");
        sb.append("<tr bgcolor=\"#");
        sb.append(JspCompletionItem.hexColorCode(COLOR_HELP_HEADER_BG));
        sb.append("\"><td colspan=\"3\"><font color=\"#");
        sb.append(JspCompletionItem.hexColorCode(COLOR_HELP_HEADER_FG));
        sb.append("\" ");
        sb.append("size=\"+2\"><b>Attributes</b></font></td></tr>");
        TagAttributeInfo[] attrs = tagInfo.getAttributes();
        if (attrs != null && attrs.length > 0) {
            sb.append("<tr><td><b>Name</b></td><td><b>Required</b></td><td><b>Request-time</b></td></tr>");
            for (int i = 0; i < attrs.length; ++i) {
                sb.append("<tr><td>");
                sb.append(attrs[i].getName());
                sb.append("</td><td>");
                sb.append(attrs[i].isRequired());
                sb.append("</td><td>");
                sb.append(attrs[i].canBeRequestTime());
                sb.append("</td></tr>");
            }
        } else {
            sb.append("<tr><td colspan=\"3\"><i>No Attributes Defined.</i></td></tr>");
        }
        sb.append("</table><br>");
        sb.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"3\" border=\"1\">");
        sb.append("<tr bgcolor=\"#");
        sb.append(JspCompletionItem.hexColorCode(COLOR_HELP_HEADER_BG));
        sb.append("\"><td colspan=\"4\"><font color=\"#");
        sb.append(JspCompletionItem.hexColorCode(COLOR_HELP_HEADER_FG));
        sb.append("\" ");
        sb.append("size=\"+2\"><b>Variables</b></font></td></tr>");
        TagVariableInfo[] variables = tagInfo.getTagVariableInfos();
        if (variables != null && variables.length > 0) {
            sb.append("<tr><td><b>Name</b></td><td><b>Type</b></td><td><b>Declare</b></td><td><b>Scope</b></td></tr>");
            for (int i = 0; i < variables.length; ++i) {
                sb.append("<tr><td>");
                if (variables[i].getNameGiven() != null && !variables[i].getNameGiven().equals("")) {
                    sb.append(variables[i].getNameGiven());
                } else if (variables[i].getNameFromAttribute() != null && !variables[i].getNameFromAttribute().equals("")) {
                    sb.append("<i>From attribute '").append(variables[i].getNameFromAttribute()).append("'</i>");
                } else {
                    sb.append("<i>Unknown</i>");
                }
                sb.append("</td><td><code>");
                if (variables[i].getClassName() == null || variables[i].getClassName().equals("")) {
                    sb.append("java.lang.String");
                } else {
                    sb.append(variables[i].getClassName());
                }
                sb.append("</code></td></tr>");
                sb.append("</td><td>");
                sb.append(variables[i].getDeclare());
                sb.append("</td></tr>");
                sb.append("</td><td>");
                switch (variables[i].getScope()) {
                    case 1: {
                        sb.append("AT_BEGIN");
                        break;
                    }
                    case 2: {
                        sb.append("AT_END");
                        break;
                    }
                    default: {
                        sb.append("NESTED");
                    }
                }
                sb.append("</td></tr>");
            }
        } else {
            sb.append("<tr><td colspan=\"4\"><i>No Variables Defined.</i></td></tr>");
        }
        sb.append("</table><br>");
        return sb.toString();
    }

    private static String getString(String key) {
        return NbBundle.getMessage(JspCompletionItem.class, (String)key);
    }

    public static String hexColorCode(Color c) {
        Color lookAndFeelTweakedColor = LFCustoms.shiftColor((Color)c);
        return Integer.toHexString(lookAndFeelTweakedColor.getRGB()).substring(2);
    }

    private static String escape(String s) {
        if (s != null) {
            try {
                return XMLUtil.toAttributeValue((String)s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    public static class GoUpFileAttributeValue
    extends FileAttributeValue {
        GoUpFileAttributeValue(int substitutionOffset, Color color, ImageIcon icon) {
            super("../", substitutionOffset, color, icon);
        }

        @Override
        public int getSortPriority() {
            return super.getSortPriority() - 1;
        }
    }

    public static class FileAttributeValue
    extends JspCompletionItem {
        private ImageIcon icon;
        private Color color;

        FileAttributeValue(String text, int substitutionOffset, Color color, ImageIcon icon) {
            super(text, substitutionOffset);
            this.color = color;
            this.icon = icon;
        }

        @Override
        protected ImageIcon getIcon() {
            return this.icon;
        }

        @Override
        protected String getLeftHtmlText() {
            return "<font color='" + FileAttributeValue.hexColorCode(this.color) + "'>" + this.getItemText() + "</font>";
        }
    }

    static class AttributeValue
    extends JspCompletionItem {
        public AttributeValue(String value, int anchor) {
            super(value, anchor);
        }
    }

    public static class Attribute
    extends JspCompletionItem {
        private TagAttributeInfo tagAttributeInfo;
        private boolean required;

        Attribute(String text, int substitutionOffset) {
            super(text, substitutionOffset);
            this.tagAttributeInfo = null;
            this.required = false;
        }

        Attribute(int substitutionOffset, TagAttributeInfo tai) {
            super(tai.getName(), substitutionOffset, tai.getTypeName() == null && tai.isFragment() ? "fragment" : tai.getTypeName());
            this.required = tai.isRequired();
            this.tagAttributeInfo = tai;
        }

        @Override
        protected int getMoveBackLength() {
            return 1;
        }

        @Override
        protected String getSubstituteText() {
            return this.getItemText() + "=\"\"";
        }

        @Override
        protected String getLeftHtmlText() {
            return "<font color=#" + (this.required ? Attribute.hexColorCode(COLOR_ATTRIBUTE_REQUIRED) : Attribute.hexColorCode(COLOR_ATTRIBUTE_NOT_REQUIRED)) + ">" + this.getItemText() + "</font>";
        }

        @Override
        public String getHelp() {
            URL url = super.getHelpURL();
            if (url != null) {
                int last;
                String surl = url.toString();
                int first = surl.indexOf(35) + 1;
                String from = first < (last = surl.lastIndexOf(35) + 1) ? surl.substring(first, last - 1) : surl.substring(first);
                String helpText = JspCompletionItem.constructHelp(this.getHelpURL());
                if (helpText != null) {
                    String to;
                    first = helpText.indexOf(from);
                    if (first > 0 && (first = first + from.length() + 2) < helpText.length()) {
                        helpText = helpText.substring(first);
                    }
                    if ((last = helpText.indexOf(to = surl.substring(last))) > 0) {
                        helpText = helpText.substring(0, last);
                    }
                    return helpText;
                }
            }
            if (this.tagAttributeInfo != null) {
                StringBuffer helpText = new StringBuffer();
                helpText.append("<table border=\"0\"><tr><td><b>Name:</b></td><td>");
                helpText.append(this.tagAttributeInfo.getName());
                helpText.append("</td></tr><tr><td><b>Required:</b></td><td>");
                helpText.append(this.tagAttributeInfo.isRequired());
                helpText.append("</td></tr><tr><td><b>Request-time:</b></td><td>");
                helpText.append(this.tagAttributeInfo.canBeRequestTime());
                helpText.append("</td></tr><tr><td><b>Fragment:</b></td><td>");
                helpText.append(this.tagAttributeInfo.isFragment());
                helpText.append("</td></tr></table>");
                return helpText.toString();
            }
            return super.getHelp();
        }

        @Override
        public URL getHelpURL() {
            URL url = super.getHelpURL();
            if (url != null) {
                String surl = url.toString();
                int index = surl.lastIndexOf(35);
                if (index > 0) {
                    surl = surl.substring(0, index);
                }
                try {
                    url = new URL(surl);
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            return url;
        }
    }

    static class Directive
    extends JspCompletionItem {
        private static final int DIRECTIVE_SORT_PRIORITY = 5;
        TagInfo tagInfo;

        Directive(String text, int substitutionOffset) {
            super(text, substitutionOffset);
            this.tagInfo = null;
        }

        Directive(String text, int substitutionOffset, TagInfo tagInfo) {
            super(text, substitutionOffset, tagInfo != null ? tagInfo.getInfoString() : null);
            this.tagInfo = tagInfo;
        }

        @Override
        public int getSortPriority() {
            return 5;
        }

        @Override
        public String getHelp() {
            String helpText;
            if (this.getHelpURL() != null && (helpText = JspCompletionItem.constructHelp(this.getHelpURL())) != null) {
                helpText = helpText.substring(helpText.indexOf("<h2>"));
                helpText = helpText.substring(0, helpText.lastIndexOf("<h4>"));
                return helpText;
            }
            return JspCompletionItem.constructHelp(this.tagInfo);
        }

        public TagInfo getTagInfo() {
            return this.tagInfo;
        }

        @Override
        protected String getSubstituteText() {
            return "<%@" + this.getItemText() + "  %>";
        }

        @Override
        protected int getMoveBackLength() {
            return 3;
        }

        @Override
        protected String getLeftHtmlText() {
            return "<b>&lt;%@<font color=#" + Directive.hexColorCode(COLOR_BASE_COMPLETION) + ">" + this.getItemText() + "</font>%&gt;</b>";
        }
    }

    public static class Delimiter
    extends JspCompletionItem {
        private static final int DELIMITER_SORT_PRIORITY = 4;

        Delimiter(String name, int substitutionOffset) {
            super(name, substitutionOffset);
        }

        @Override
        public int getSortPriority() {
            return 4;
        }

        @Override
        protected String getLeftHtmlText() {
            return "<b>" + JspCompletionItem.escape(this.getItemText()) + "</b>";
        }
    }

    public static class Tag
    extends JspCompletionItem {
        private TagInfo ti = null;

        public Tag(String text, int substitutionOffset) {
            super(text, substitutionOffset);
        }

        public Tag(String text, int substitutionOffset, TagInfo ti) {
            super(text, substitutionOffset, ti != null ? ti.getInfoString() : null);
            this.ti = ti;
        }

        public TagInfo getTagInfo() {
            return this.ti;
        }

        @Override
        public String getHelp() {
            URL url = super.getHelpURL();
            if (url != null) {
                String surl = url.toString();
                int first = surl.indexOf(35) + 1;
                String helpText = JspCompletionItem.constructHelp(url);
                if (helpText == null) {
                    return null;
                }
                if (first > 0) {
                    int last = surl.lastIndexOf(35) + 1;
                    String from = surl.substring(first, last - 1);
                    String to = surl.substring(last);
                    first = helpText.indexOf(from);
                    if (first > 0 && (first = first + from.length() + 2) < helpText.length()) {
                        helpText = helpText.substring(first);
                    }
                    if ((last = helpText.indexOf(to)) > 0) {
                        helpText = helpText.substring(0, last);
                    }
                    return helpText;
                }
                helpText = helpText.substring(helpText.indexOf("<h2>"));
                helpText = helpText.substring(0, helpText.lastIndexOf("<h4>"));
                return helpText;
            }
            return JspCompletionItem.constructHelp(this.ti);
        }

        @Override
        protected String getLeftHtmlText() {
            return "<b>&lt;<font color=#" + Tag.hexColorCode(COLOR_BASE_COMPLETION) + ">" + this.getItemText() + "</font>&gt;</b>";
        }

        @Override
        protected String getSubstituteText() {
            return this.getItemText().startsWith("/") ? this.getItemText().substring(1) + ">" : this.getItemText() + " ";
        }
    }

    public static class PrefixTag
    extends JspCompletionItem {
        private TagInfo tagInfo;
        private boolean isEmpty = false;
        private boolean hasAttributes = false;

        PrefixTag(String text, int substitutionOffset) {
            super(text, substitutionOffset);
        }

        PrefixTag(String prefix, int substitutionOffset, TagInfo ti, SyntaxElement.Tag set) {
            super(prefix + ":" + (ti != null ? ti.getTagName() : "<null>"), substitutionOffset, ti != null ? ti.getInfoString() : null);
            this.tagInfo = ti;
            if (this.tagInfo != null && this.tagInfo.getBodyContent().equalsIgnoreCase("empty")) {
                this.isEmpty = true;
            }
            if (set != null) {
                this.hasAttributes = set.getAttributes().size() != 0;
            }
        }

        PrefixTag(String prefix, int substitutionOffset, TagInfo ti) {
            this(prefix, substitutionOffset, ti, null);
        }

        public TagInfo getTagInfo() {
            return this.tagInfo;
        }

        @Override
        public String getHelp() {
            URL url = super.getHelpURL();
            if (url != null) {
                String surl = url.toString();
                int first = surl.indexOf(35) + 1;
                String helpText = JspCompletionItem.constructHelp(url);
                if (helpText == null) {
                    return null;
                }
                if (first > 0) {
                    int last = surl.lastIndexOf(35) + 1;
                    String from = surl.substring(first, last - 1);
                    String to = surl.substring(last);
                    first = helpText.indexOf(from);
                    if (first > 0 && (first = first + from.length() + 2) < helpText.length()) {
                        helpText = helpText.substring(first);
                    }
                    if ((last = helpText.indexOf(to)) > 0) {
                        helpText = helpText.substring(0, last);
                    }
                    return helpText;
                }
                helpText = helpText.substring(helpText.indexOf("<h2>"));
                helpText = helpText.substring(0, helpText.lastIndexOf("<h4>"));
                return helpText;
            }
            return JspCompletionItem.constructHelp(this.tagInfo);
        }

        @Override
        public boolean substituteText(JTextComponent c, int len) {
            String suffix;
            String string = suffix = this.isEmpty ? "/>" : ">";
            if (this.hasAttributes) {
                suffix = "";
            }
            if (!this.getItemText().startsWith("/")) {
                if (!this.shift) {
                    return super.substituteText(c, len, 0);
                }
                boolean hasAttrs = true;
                if (this.tagInfo != null) {
                    TagAttributeInfo[] tAttrs = this.tagInfo.getAttributes();
                    boolean bl = tAttrs != null ? tAttrs.length > 0 : (hasAttrs = true);
                }
                if (hasAttrs) {
                    return this.substituteText(c, this.getItemText() + (this.hasAttributes ? "" : " ") + suffix, len, suffix.length());
                }
                return this.substituteText(c, this.getItemText() + suffix, len, 0);
            }
            return this.substituteText(c, this.getItemText().substring(1) + ">", len, 0);
        }

        @Override
        public void defaultAction(JTextComponent component) {
            super.defaultAction(component);
            if (component == null) {
                return;
            }
            final BaseDocument doc = (BaseDocument)component.getDocument();
            doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    String mimeType = NbEditorUtilities.getFileObject((Document)doc).getMIMEType();
                    Lookup mimeLookup = MimeLookup.getLookup((MimePath)MimePath.get((String)mimeType));
                    Collection providers = mimeLookup.lookup(new Lookup.Template(AutoTagImporterProvider.class)).allInstances();
                    if (providers != null) {
                        for (AutoTagImporterProvider provider : providers) {
                            provider.importLibrary((Document)doc, PrefixTag.this.tagInfo.getTagLibrary().getPrefixString(), PrefixTag.this.tagInfo.getTagLibrary().getURI());
                        }
                    }
                }
            });
        }

        @Override
        protected String getLeftHtmlText() {
            return "<b>&lt;<font color=#" + PrefixTag.hexColorCode(COLOR_BASE_COMPLETION) + "><b>" + this.getItemText() + "</font>" + (this.isEmpty ? "/&gt;" : "&gt;</b>");
        }
    }

    public static class UnresolvedPrefixTag
    extends PrefixTag {
        private String tagLibURI;
        private String tagLibPrefix;

        public UnresolvedPrefixTag(String text, int substitutionOffset, String tagLibURI, String tagLibPrefix) {
            super(text, substitutionOffset);
            this.tagLibURI = tagLibURI;
            this.tagLibPrefix = tagLibPrefix;
        }

        @Override
        public void defaultAction(JTextComponent component) {
            super.defaultAction(component);
            final BaseDocument doc = (BaseDocument)component.getDocument();
            doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        doc.insertString(Util.findPositionForJspDirective(doc), "<%@ taglib prefix=\"" + UnresolvedPrefixTag.this.tagLibPrefix + "\" uri=\"" + UnresolvedPrefixTag.this.tagLibURI + "\" %>\n", null);
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
    }
}

