/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ContextRootConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DatasourceConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentPlanConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.jboss4.config.JBDeploymentConfiguration;
import org.netbeans.modules.j2ee.jboss4.config.JBossDatasource;
import org.netbeans.modules.j2ee.jboss4.config.ResourceConfigurationHelper;
import org.netbeans.modules.j2ee.jboss4.config.gen.EjbRef;
import org.netbeans.modules.j2ee.jboss4.config.gen.JbossWeb;
import org.netbeans.modules.j2ee.jboss4.config.gen.MessageDestinationRef;
import org.netbeans.modules.j2ee.jboss4.config.gen.ResourceRef;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class WarDeploymentConfiguration
extends JBDeploymentConfiguration
implements ModuleConfiguration,
ContextRootConfiguration,
DatasourceConfiguration,
DeploymentPlanConfiguration,
PropertyChangeListener {
    private File jbossWebFile;
    private JbossWeb jbossWeb;

    public WarDeploymentConfiguration(J2eeModule j2eeModule) {
        this(j2eeModule, null);
    }

    public WarDeploymentConfiguration(J2eeModule j2eeModule, JBPluginUtils.Version version) {
        super(j2eeModule, version);
        this.jbossWebFile = j2eeModule.getDeploymentConfigurationFile("WEB-INF/jboss-web.xml");
        this.getJbossWeb();
        if (this.deploymentDescriptorDO == null) {
            try {
                this.deploymentDescriptorDO = DataObject.find((FileObject)FileUtil.toFileObject((File)this.jbossWebFile));
                this.deploymentDescriptorDO.addPropertyChangeListener((PropertyChangeListener)this);
            }
            catch (DataObjectNotFoundException donfe) {
                Exceptions.printStackTrace((Throwable)donfe);
            }
        }
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this});
    }

    public void dispose() {
    }

    public boolean supportsCreateDatasource() {
        return !this.isAs7();
    }

    public boolean supportsCreateMessageDestination() {
        return !this.isAs7();
    }

    public String getContextRoot() throws ConfigurationException {
        JbossWeb jbossWeb = this.getJbossWeb();
        if (jbossWeb == null) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotReadContextRoot", (Object)this.jbossWebFile.getAbsolutePath());
            throw new ConfigurationException(msg);
        }
        return jbossWeb.getContextRoot();
    }

    public void setContextRoot(String contextPath) throws ConfigurationException {
        if (!this.isCorrectCP(contextPath)) {
            String ctxRoot = contextPath;
            StringTokenizer tok = new StringTokenizer(contextPath, "/");
            StringBuffer buf = new StringBuffer();
            while (tok.hasMoreTokens()) {
                buf.append("/" + tok.nextToken());
            }
            ctxRoot = buf.toString();
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_invalidCP", (Object)contextPath), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            contextPath = ctxRoot;
        }
        final String newContextPath = contextPath;
        this.modifyJbossWeb(new JbossWebModifier(){

            @Override
            public void modify(JbossWeb jbossWeb) {
                jbossWeb.setContextRoot(newContextPath);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        if (evt.getPropertyName() == "modified" && newValue == Boolean.FALSE) {
            if (evt.getSource() == this.deploymentDescriptorDO) {
                WarDeploymentConfiguration warDeploymentConfiguration = this;
                synchronized (warDeploymentConfiguration) {
                    this.jbossWeb = null;
                }
            }
        } else if (evt.getOldValue() == null) {
            if (newValue instanceof org.netbeans.modules.j2ee.dd.api.common.ResourceRef) {
                org.netbeans.modules.j2ee.dd.api.common.ResourceRef resourceRef = (org.netbeans.modules.j2ee.dd.api.common.ResourceRef)newValue;
                try {
                    String resType = resourceRef.getResType();
                    if ("javax.sql.DataSource".equals(resType)) {
                        this.addResReference(resourceRef.getResRefName(), "java:/" + resourceRef.getResRefName());
                    } else if ("javax.mail.Session".equals(resType)) {
                        this.addMailReference(resourceRef.getResRefName());
                    } else if ("javax.jms.ConnectionFactory".equals(resType)) {
                        this.addConnectionFactoryReference(resourceRef.getResRefName());
                    }
                }
                catch (ConfigurationException ce) {
                    Exceptions.printStackTrace((Throwable)ce);
                }
            } else if (newValue instanceof org.netbeans.modules.j2ee.dd.api.common.EjbRef) {
                org.netbeans.modules.j2ee.dd.api.common.EjbRef ejbRef = (org.netbeans.modules.j2ee.dd.api.common.EjbRef)newValue;
                try {
                    String ejbRefType = ejbRef.getEjbRefType();
                    if ("Session".equals(ejbRefType) || "Entity".equals(ejbRefType)) {
                        this.addEjbReference(ejbRef.getEjbRefName(), ejbRef.getEjbRefName());
                    }
                }
                catch (ConfigurationException ce) {
                    Exceptions.printStackTrace((Throwable)ce);
                }
            } else if (newValue instanceof org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef) {
                org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef messageDestinationRef = (org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef)newValue;
                try {
                    String messageDestinationType = messageDestinationRef.getMessageDestinationType();
                    String destPrefix = "javax.jms.Queue".equals(messageDestinationType) ? "queue/" : "topic/";
                    this.addMsgDestReference(messageDestinationRef.getMessageDestinationRefName(), destPrefix);
                }
                catch (ConfigurationException ce) {
                    Exceptions.printStackTrace((Throwable)ce);
                }
            }
        }
    }

    @Override
    public void bindDatasourceReference(String referenceName, String jndiName) throws ConfigurationException {
        this.addResReference(referenceName, jndiName);
    }

    @Override
    public String findDatasourceJndiName(String referenceName) throws ConfigurationException {
        ResourceRef[] resourceRefs;
        for (ResourceRef resourceRef : resourceRefs = this.getJbossWeb().getResourceRef()) {
            String jndiName;
            String rrn = resourceRef.getResRefName();
            if (!referenceName.equals(rrn) || (jndiName = resourceRef.getJndiName()) == null) continue;
            return JBossDatasource.getJndiName(jndiName);
        }
        return null;
    }

    private void addResReference(final String name, final String jndiName) throws ConfigurationException {
        this.modifyJbossWeb(new JbossWebModifier(){

            @Override
            public void modify(JbossWeb modifiedJbossWeb) {
                ResourceRef[] resourceRefs = modifiedJbossWeb.getResourceRef();
                for (int i = 0; i < resourceRefs.length; ++i) {
                    String rrn = resourceRefs[i].getResRefName();
                    if (!name.equals(rrn)) continue;
                    return;
                }
                ResourceRef newRR = new ResourceRef();
                newRR.setResRefName(name);
                newRR.setJndiName(jndiName);
                modifiedJbossWeb.addResourceRef(newRR);
            }
        });
    }

    private void addMailReference(final String name) throws ConfigurationException {
        this.modifyJbossWeb(new JbossWebModifier(){

            @Override
            public void modify(JbossWeb modifiedJbossWeb) {
                ResourceRef[] resourceRefs = modifiedJbossWeb.getResourceRef();
                for (int i = 0; i < resourceRefs.length; ++i) {
                    String rrn = resourceRefs[i].getResRefName();
                    if (!name.equals(rrn)) continue;
                    return;
                }
                ResourceRef newRR = new ResourceRef();
                newRR.setResRefName(name);
                newRR.setJndiName("java:Mail");
                modifiedJbossWeb.addResourceRef(newRR);
            }
        });
    }

    @Override
    public void bindMessageDestinationReference(String referenceName, String connectionFactoryName, String destName, MessageDestination.Type type) throws ConfigurationException {
        this.addConnectionFactoryReference(connectionFactoryName);
        String jndiName = null;
        if (MessageDestination.Type.QUEUE.equals((Object)type)) {
            jndiName = "queue/" + destName;
        } else if (MessageDestination.Type.TOPIC.equals((Object)type)) {
            jndiName = "topic/" + destName;
        }
        this.addMsgDestReference(referenceName, jndiName);
    }

    private void addConnectionFactoryReference(final String name) throws ConfigurationException {
        this.modifyJbossWeb(new JbossWebModifier(){

            @Override
            public void modify(JbossWeb modifiedJbossWeb) {
                ResourceRef[] resourceRefs = modifiedJbossWeb.getResourceRef();
                for (int i = 0; i < resourceRefs.length; ++i) {
                    String rrn = resourceRefs[i].getResRefName();
                    if (!name.equals(rrn)) continue;
                    return;
                }
                ResourceRef newRR = new ResourceRef();
                newRR.setResRefName(name);
                newRR.setJndiName("ConnectionFactory");
                modifiedJbossWeb.addResourceRef(newRR);
            }
        });
    }

    private void addMsgDestReference(final String name, final String jndiName) throws ConfigurationException {
        this.modifyJbossWeb(new JbossWebModifier(){

            @Override
            public void modify(JbossWeb modifiedJbossWeb) {
                MessageDestinationRef[] mdRefs = modifiedJbossWeb.getMessageDestinationRef();
                for (int i = 0; i < mdRefs.length; ++i) {
                    String mdrn = mdRefs[i].getMessageDestinationRefName();
                    if (!name.equals(mdrn)) continue;
                    return;
                }
                MessageDestinationRef mdr = new MessageDestinationRef();
                mdr.setMessageDestinationRefName(name);
                mdr.setJndiName(jndiName);
                modifiedJbossWeb.addMessageDestinationRef(mdr);
            }
        });
    }

    @Override
    public void bindEjbReference(String referenceName, String ejbName) throws ConfigurationException {
        if (Double.parseDouble(this.j2eeModule.getModuleVersion()) > 2.4) {
            return;
        }
        this.addEjbReference(referenceName, ejbName);
    }

    private void addEjbReference(final String referenceName, final String ejbName) throws ConfigurationException {
        this.modifyJbossWeb(new JbossWebModifier(){

            @Override
            public void modify(JbossWeb modifiedJbossWeb) {
                EjbRef[] ejbRefs = modifiedJbossWeb.getEjbRef();
                for (int i = 0; i < ejbRefs.length; ++i) {
                    String ern = ejbRefs[i].getEjbRefName();
                    if (!referenceName.equals(ern)) continue;
                    return;
                }
                EjbRef newER = new EjbRef();
                newER.setEjbRefName(referenceName);
                newER.setJndiName(ejbName);
                modifiedJbossWeb.addEjbRef(newER);
            }
        });
    }

    public synchronized JbossWeb getJbossWeb() {
        if (this.jbossWeb == null) {
            try {
                if (this.jbossWebFile.exists()) {
                    try {
                        this.jbossWeb = JbossWeb.createGraph(this.jbossWebFile);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    catch (RuntimeException re) {}
                } else {
                    this.jbossWeb = this.generateJbossWeb();
                    ResourceConfigurationHelper.writeFile(this.jbossWebFile, this.jbossWeb);
                }
            }
            catch (ConfigurationException ce) {
                Exceptions.printStackTrace((Throwable)ce);
            }
        }
        return this.jbossWeb;
    }

    public void save(OutputStream os) throws ConfigurationException {
        JbossWeb jbossWeb = this.getJbossWeb();
        if (jbossWeb == null) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_cannotSaveNotParseableConfFile", (Object)this.jbossWebFile.getAbsolutePath());
            throw new ConfigurationException(msg);
        }
        try {
            jbossWeb.write(os);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.jbossWebFile.getAbsolutePath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyJbossWeb(JbossWebModifier modifier) throws ConfigurationException {
        assert (this.deploymentDescriptorDO != null) : "DataObject has not been initialized yet";
        try {
            SaveCookie cookie;
            EditorCookie editor = (EditorCookie)this.deploymentDescriptorDO.getCookie(EditorCookie.class);
            StyledDocument doc = editor.getDocument();
            if (doc == null) {
                doc = editor.openDocument();
            }
            JbossWeb newJbossWeb = null;
            try {
                byte[] docString = doc.getText(0, doc.getLength()).getBytes();
                newJbossWeb = JbossWeb.createGraph(new ByteArrayInputStream(docString));
            }
            catch (RuntimeException e) {
                JbossWeb oldJbossWeb = this.getJbossWeb();
                if (oldJbossWeb == null) {
                    String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_jbossXmlCannotParse", (Object)this.jbossWebFile.getAbsolutePath());
                    throw new ConfigurationException(msg);
                }
                NotifyDescriptor.Confirmation notDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_jbossWebXmlNotValid"), 2);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                if (result == NotifyDescriptor.CANCEL_OPTION) {
                    return;
                }
                newJbossWeb = oldJbossWeb;
            }
            modifier.modify(newJbossWeb);
            boolean modified = this.deploymentDescriptorDO.isModified();
            ResourceConfigurationHelper.replaceDocument(doc, newJbossWeb);
            if (!modified && (cookie = (SaveCookie)this.deploymentDescriptorDO.getCookie(SaveCookie.class)) != null) {
                cookie.save();
            }
            WarDeploymentConfiguration warDeploymentConfiguration = this;
            synchronized (warDeploymentConfiguration) {
                this.jbossWeb = newJbossWeb;
            }
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.jbossWebFile.getAbsolutePath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
    }

    private JbossWeb generateJbossWeb() {
        JbossWeb jbossWeb = new JbossWeb(null, 2);
        jbossWeb.setContextRoot("");
        return jbossWeb;
    }

    private boolean isCorrectCP(String contextPath) {
        boolean correct = true;
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            correct = false;
        } else if (contextPath.endsWith("/")) {
            correct = false;
        } else if (contextPath.indexOf("//") >= 0) {
            correct = false;
        }
        return correct;
    }

    private static interface JbossWebModifier {
        public void modify(JbossWeb var1);
    }
}

