/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade.systemoptions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.upgrade.systemoptions.DefaultResult;
import org.netbeans.upgrade.systemoptions.JUnitContentProcessor;
import org.netbeans.upgrade.systemoptions.PropertyProcessor;
import org.netbeans.upgrade.systemoptions.Result;
import org.netbeans.upgrade.systemoptions.SerParser;

class ContentProcessor {
    private static Map<String, ContentProcessor> clsname2Delegate = new HashMap<String, ContentProcessor>();
    protected String systemOptionInstanceName;

    private static void registerContentProcessor(ContentProcessor instance) {
        if (clsname2Delegate.put(instance.systemOptionInstanceName, instance) != null) {
            throw new IllegalArgumentException();
        }
    }

    protected ContentProcessor(String systemOptionInstanceName) {
        this.systemOptionInstanceName = systemOptionInstanceName;
    }

    protected Result parseContent(Iterator<Object> it, boolean types) {
        DefaultResult result = null;
        try {
            Map<String, Object> props = this.parseProperties(it);
            assert (props != null);
            Map<String, String> m = this.processProperties(props, types);
            result = new DefaultResult(this.systemOptionInstanceName, m);
        }
        catch (IllegalStateException isx) {
            Logger.getLogger(ContentProcessor.class.getName()).log(Level.WARNING, this.systemOptionInstanceName + " not parsed", isx);
        }
        return result;
    }

    static Result parseContent(String systemOptionInstanceName, boolean types, Iterator<Object> it) {
        ContentProcessor cp = clsname2Delegate.get(systemOptionInstanceName);
        if (cp == null) {
            cp = new ContentProcessor(systemOptionInstanceName);
        }
        return cp.parseContent(it, types);
    }

    private final Map<String, String> processProperties(Map<String, Object> properties, boolean types) {
        HashMap<String, String> allProps = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            allProps.putAll(PropertyProcessor.processProperty(name, value, types));
        }
        return allProps;
    }

    private final Map<String, Object> parseProperties(Iterator<Object> it) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        while (it.hasNext()) {
            Object name = it.next();
            if ("null".equals(name) || name == null) {
                return properties;
            }
            if (!(name instanceof String)) {
                throw new IllegalStateException(name.getClass().getName());
            }
            if (!it.hasNext()) {
                throw new IllegalStateException(name.toString());
            }
            Object value = it.next();
            properties.put((String)name, value);
            Object propertyRead = it.next();
            if (!(propertyRead instanceof SerParser.ObjectWrapper)) {
                throw new IllegalStateException(propertyRead.getClass().getName());
            }
            SerParser.ObjectWrapper ow = (SerParser.ObjectWrapper)propertyRead;
            if (ow.classdesc.name.endsWith("java.lang.Boolean;")) continue;
            throw new IllegalStateException(ow.classdesc.name);
        }
        throw new IllegalStateException("Unexpected end");
    }

    static {
        ContentProcessor.registerContentProcessor(new JUnitContentProcessor("org.netbeans.modules.junit.JUnitSettings"));
    }
}

