/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.utils;

public class VMUtils {
    public static final String BOOLEAN_CODE = "Z";
    public static final String CHAR_CODE = "C";
    public static final String BYTE_CODE = "B";
    public static final String SHORT_CODE = "S";
    public static final String INT_CODE = "I";
    public static final String LONG_CODE = "J";
    public static final String FLOAT_CODE = "F";
    public static final String DOUBLE_CODE = "D";
    public static final String VOID_CODE = "V";
    public static final String BOOLEAN_STRING = "boolean";
    public static final String CHAR_STRING = "char";
    public static final String BYTE_STRING = "byte";
    public static final String SHORT_STRING = "short";
    public static final String INT_STRING = "int";
    public static final String LONG_STRING = "long";
    public static final String FLOAT_STRING = "float";
    public static final String DOUBLE_STRING = "double";
    public static final String VOID_STRING = "void";

    public static String typeToVMSignature(String type) {
        int arIdx;
        String ret = type.replace('.', '/');
        ret = ret.startsWith(BOOLEAN_STRING) ? ret.replace(BOOLEAN_STRING, BOOLEAN_CODE) : (ret.startsWith(CHAR_STRING) ? ret.replace(CHAR_STRING, CHAR_CODE) : (ret.startsWith(BYTE_STRING) ? ret.replace(BYTE_STRING, BYTE_CODE) : (ret.startsWith(SHORT_STRING) ? ret.replace(SHORT_STRING, SHORT_CODE) : (ret.startsWith(INT_STRING) ? ret.replace(INT_STRING, INT_CODE) : (ret.startsWith(LONG_STRING) ? ret.replace(LONG_STRING, LONG_CODE) : (ret.startsWith(FLOAT_STRING) ? ret.replace(FLOAT_STRING, FLOAT_CODE) : (ret.startsWith(DOUBLE_STRING) ? ret.replace(DOUBLE_STRING, DOUBLE_CODE) : (ret.startsWith(VOID_STRING) ? ret.replace(VOID_STRING, VOID_CODE) : ((arIdx = ret.indexOf(91)) == -1 ? "L" + ret + ";" : "L" + ret.substring(0, arIdx) + ";" + ret.substring(arIdx))))))))));
        while (ret.endsWith("[]")) {
            ret = "[" + ret.substring(0, ret.length() - 2);
        }
        return ret;
    }

    public static boolean isVMPrimitiveType(String className) {
        if (className == null || className.length() != 1) {
            return false;
        }
        return BOOLEAN_CODE.equals(className) || CHAR_CODE.equals(className) || BYTE_CODE.equals(className) || SHORT_CODE.equals(className) || INT_CODE.equals(className) || LONG_CODE.equals(className) || FLOAT_CODE.equals(className) || DOUBLE_CODE.equals(className);
    }

    public static boolean isPrimitiveType(String className) {
        if (className == null || className.length() < 1) {
            return false;
        }
        return BOOLEAN_STRING.equals(className) || CHAR_STRING.equals(className) || BYTE_STRING.equals(className) || SHORT_STRING.equals(className) || INT_STRING.equals(className) || LONG_STRING.equals(className) || FLOAT_STRING.equals(className) || DOUBLE_STRING.equals(className);
    }
}

