/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.spi.project;

import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.filters.FilterUtils;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.project.ProfilingSettingsSupport;
import org.netbeans.modules.profiler.spi.project.Bundle;
import org.openide.util.Lookup;

public abstract class ProfilingSettingsSupportProvider {
    public abstract float getProfilingOverhead(ProfilingSettings var1);

    public abstract ProfilingSettingsSupport.SettingsCustomizer getSettingsCustomizer();

    public abstract String getProjectOnlyFilterName();

    public abstract String getProjectSubprojectsFilterName();

    public static class Default
    extends Basic {
        @Override
        public String getProjectOnlyFilterName() {
            return Bundle.ProfilingSettingsSupportProvider_ProfileProjectClassesString();
        }

        @Override
        public String getProjectSubprojectsFilterName() {
            return !ProjectUtilities.hasSubprojects(this.getProject()) ? null : Bundle.ProfilingSettingsSupportProvider_ProfileProjectSubprojectClassesString();
        }

        public Default(Lookup.Provider project) {
            super(project);
        }
    }

    public static class Basic
    extends ProfilingSettingsSupportProvider {
        private final Lookup.Provider project;

        @Override
        public float getProfilingOverhead(ProfilingSettings settings) {
            float o = 0.0f;
            int profilingType = settings.getProfilingType();
            if (!ProfilingSettings.isMonitorSettings((ProfilingSettings)settings)) {
                if (ProfilingSettings.isCPUSettings((ProfilingSettings)settings)) {
                    if (profilingType == 64) {
                        o += 0.05f;
                    } else if (profilingType == 8) {
                        o += this.project == null ? 0.85f : 0.5f;
                    } else if (profilingType == 16) {
                        o += 0.2f;
                    }
                    if (FilterUtils.NONE_FILTER.equals(settings.getSelectedInstrumentationFilter()) && profilingType != 64) {
                        o += 0.5f;
                    }
                } else if (ProfilingSettings.isMemorySettings((ProfilingSettings)settings)) {
                    if (profilingType == 128) {
                        o += 0.05f;
                    } else {
                        if (profilingType == 2) {
                            o += 0.5f;
                        } else if (profilingType == 4) {
                            o += 0.7f;
                        }
                        if (settings.getAllocStackTraceLimit() != 0) {
                            o += 0.3f;
                        }
                    }
                }
            }
            return Math.min(o, 1.0f);
        }

        @Override
        public ProfilingSettingsSupport.SettingsCustomizer getSettingsCustomizer() {
            return null;
        }

        @Override
        public String getProjectOnlyFilterName() {
            return null;
        }

        @Override
        public String getProjectSubprojectsFilterName() {
            return null;
        }

        protected final Lookup.Provider getProject() {
            return this.project;
        }

        public Basic(Lookup.Provider project) {
            this.project = project;
        }
    }
}

