/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.actions;

import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.actions.AbstractExecutorRunAction;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.builds.ImportUtils;
import org.netbeans.modules.cnd.loaders.QtProjectDataObject;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlg;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionDescriptor;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionService;
import org.netbeans.modules.nativeexecution.api.execution.PostMessageDisplayer;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.WindowManager;

public class QMakeAction
extends AbstractExecutorRunAction {
    public String getName() {
        return QMakeAction.getString("BTN_Qmake");
    }

    @Override
    protected boolean accept(DataObject object) {
        return object instanceof QtProjectDataObject;
    }

    protected void performAction(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            this.performAction(activatedNodes[i]);
        }
    }

    protected void performAction(Node node) {
        QMakeAction.performAction(node, null, null, QMakeAction.getProject(node), null);
    }

    public static Future<Integer> performAction(final Node node, final ExecutionListener listener, final Writer outputListener, final Project project, final InputOutput inputOutput) {
        if (SwingUtilities.isEventDispatchThread()) {
            ModalMessageDlg.LongWorker runner = new ModalMessageDlg.LongWorker(){
                private NativeExecutionService es;

                public void doWork() {
                    this.es = QMakeAction.prepare(node, listener, outputListener, project, inputOutput);
                }

                public void doPostRunInEDT() {
                    if (this.es != null) {
                        this.es.run();
                    }
                }
            };
            Frame mainWindow = WindowManager.getDefault().getMainWindow();
            String title = QMakeAction.getString("DLG_TITLE_Prepare", "qmake");
            String msg = QMakeAction.getString("MSG_TITLE_Prepare", "qmake");
            ModalMessageDlg.runLongTask((Window)mainWindow, (String)title, (String)msg, (ModalMessageDlg.LongWorker)runner, null);
        } else {
            NativeExecutionService es = QMakeAction.prepare(node, listener, outputListener, project, inputOutput);
            if (es != null) {
                return es.run();
            }
        }
        return null;
    }

    private static NativeExecutionService prepare(Node node, ExecutionListener listener, Writer outputListener, Project project, InputOutput inputOutput) {
        RemoteSyncWorker syncWorker;
        QMakeAction.saveNode(node);
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        FileObject buildDirFileObject = QMakeAction.getBuildDirectory(node, PredefinedToolKind.QMakeTool);
        if (buildDirFileObject == null) {
            QMakeAction.trace("Run folder folder is null");
            return null;
        }
        String buildDir = buildDirFileObject.getPath();
        String executable = QMakeAction.getCommand(node, project, PredefinedToolKind.QMakeTool, "qmake");
        String arguments = CndPathUtilities.toRelativePath((String)buildDir, (FileObject)fileObject);
        String[] args = QMakeAction.getArguments(node, PredefinedToolKind.QMakeTool);
        ExecutionEnvironment execEnv = QMakeAction.getExecutionEnvironment(fileObject, project);
        if (FileSystemProvider.getExecutionEnvironment((FileObject)buildDirFileObject).isLocal()) {
            buildDir = QMakeAction.convertToRemoteIfNeeded(execEnv, buildDir, project);
        }
        if (buildDir == null) {
            QMakeAction.trace("Run folder folder is null");
            return null;
        }
        Map<String, String> envMap = QMakeAction.getEnv(execEnv, node, project, null);
        StringBuilder argsFlat = new StringBuilder(arguments);
        for (int i = 0; i < args.length; ++i) {
            argsFlat.append(" ");
            argsFlat.append(args[i]);
        }
        if (inputOutput == null) {
            String tabName = execEnv.isLocal() ? QMakeAction.getString("QMAKE_LABEL", node.getName()) : QMakeAction.getString("QMAKE_REMOTE_LABEL", node.getName(), execEnv.getDisplayName());
            InputOutput _tab = IOProvider.getDefault().getIO(tabName, false);
            _tab.closeInputOutput();
            InputOutput tab = IOProvider.getDefault().getIO(tabName, true);
            try {
                tab.getOut().reset();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            inputOutput = tab;
        }
        if ((syncWorker = RemoteSyncSupport.createSyncWorker((Lookup.Provider)project, (PrintWriter)inputOutput.getOut(), (PrintWriter)inputOutput.getErr())) != null && !syncWorker.startup(envMap)) {
            QMakeAction.trace("RemoteSyncWorker is not started up");
            return null;
        }
        MacroMap mm = MacroMap.forExecEnv((ExecutionEnvironment)execEnv);
        mm.putAll(envMap);
        QMakeAction.traceExecutable(executable, buildDir, argsFlat, execEnv.toString(), (Map<String, String>)mm.toMap());
        AbstractExecutorRunAction.ProcessChangeListener processChangeListener = new AbstractExecutorRunAction.ProcessChangeListener(listener, outputListener, null, syncWorker);
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv).setWorkingDirectory(buildDir).unbufferOutput(false).addNativeProcessListener((ChangeListener)processChangeListener);
        npb.getEnvironment().putAll(mm);
        npb.redirectError();
        List<String> list = ImportUtils.parseArgs(argsFlat.toString());
        list = ImportUtils.normalizeParameters(list);
        npb.setExecutable(executable);
        npb.setArguments(list.toArray(new String[list.size()]));
        NativeExecutionDescriptor descr = new NativeExecutionDescriptor().controllable(true).frontWindow(true).inputVisible(true).inputOutput(inputOutput).outLineBased(true).showProgress(!CndUtils.isStandalone()).postExecution((Runnable)processChangeListener).postMessageDisplayer((PostMessageDisplayer)new PostMessageDisplayer.Default("QMake")).outConvertorFactory((ExecutionDescriptor.LineConvertorFactory)processChangeListener);
        descr.noReset(true);
        inputOutput.getOut().println("cd '" + buildDir + "'");
        inputOutput.getOut().println(executable + " " + argsFlat);
        return NativeExecutionService.newService((NativeProcessBuilder)npb, (NativeExecutionDescriptor)descr, (String)"qmake");
    }
}

