/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.parser;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import nu.validator.htmlparser.common.TransitionHandler;
import nu.validator.htmlparser.impl.CoalescingTreeBuilder;
import nu.validator.htmlparser.impl.ElementName;
import nu.validator.htmlparser.impl.HtmlAttributes;
import org.netbeans.modules.html.editor.lib.api.elements.CloseTag;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.Named;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.parser.ElementsFactory;
import org.netbeans.modules.html.parser.Util;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.util.Lookup;
import org.xml.sax.SAXException;

public class ParseTreeBuilder
extends CoalescingTreeBuilder<Named>
implements TransitionHandler {
    static final Logger LOGGER = Logger.getLogger(ParseTreeBuilder.class.getName());
    static boolean LOG;
    static boolean LOG_FINER;
    private final ElementsFactory factory;
    private ElementsFactory.Root root;
    private int offset;
    private int tag_lt_offset;
    private int data_section_start = -1;
    private boolean self_closing_starttag;
    private Stack<ElementsFactory.ModifiableOpenTag> stack = new Stack();
    LinkedList<ElementsFactory.ModifiableCloseTag> physicalEndTagsQueue = new LinkedList();
    private ElementName startTag;
    private Stack<AttrInfo> attrs = new Stack();
    private ElementsFactory.ModifiableOpenTag currentOpenTag;
    private ElementsFactory.ModifiableCloseTag currentCloseTag;
    private final CharSequence sourceCode;
    private boolean ADD_TEXT_NODES = false;

    private static void initLogLevels() {
        LOG = LOGGER.isLoggable(Level.FINE);
        LOG_FINER = LOGGER.isLoggable(Level.FINER);
    }

    public ParseTreeBuilder(CharSequence sourceCode, Lookup lookup) {
        this.sourceCode = sourceCode;
        this.factory = new ElementsFactory(sourceCode);
        this.root = this.factory.createRoot();
        Properties properties = (Properties)lookup.lookup(Properties.class);
        if (properties != null) {
            this.ADD_TEXT_NODES = Boolean.parseBoolean(properties.getProperty("add_text_nodes"));
        }
    }

    public Node getRoot() {
        return this.root;
    }

    public Node getCurrentNode() {
        return (Node)this.stack.peek();
    }

    int getOffset() {
        return this.offset;
    }

    private boolean isVirtual(Named named) {
        return named instanceof ElementsFactory.VirtualOpenTag;
    }

    @Override
    protected void elementPopped(String namespace, String name, Named t) throws SAXException {
        if (LOG) {
            LOGGER.fine(String.format("- %s %s; stack: %s", t, this.isVirtual(t) ? "[virtual]" : "", this.dumpStack()));
        }
        ElementsFactory.ModifiableOpenTag openTag = (ElementsFactory.ModifiableOpenTag)t;
        ElementsFactory.ModifiableOpenTag top = null;
        Stack<ElementsFactory.ModifiableOpenTag> removedFromStack = new Stack<ElementsFactory.ModifiableOpenTag>();
        while (!this.stack.isEmpty()) {
            top = this.stack.pop();
            removedFromStack.push(top);
            if (top != t) continue;
        }
        if (t != top) {
            LOGGER.info(String.format("The node %s has been popped but not previously pushed!", t));
            while (!removedFromStack.isEmpty()) {
                this.stack.push((ElementsFactory.ModifiableOpenTag)removedFromStack.pop());
            }
        }
        assert (!this.stack.isEmpty());
        ElementsFactory.ModifiableCloseTag match = null;
        for (ElementsFactory.ModifiableCloseTag n : this.physicalEndTagsQueue) {
            if (!LexerUtils.equals((CharSequence)n.name(), (CharSequence)t.name(), (boolean)true, (boolean)false)) continue;
            match = n;
            break;
        }
        if (match != null) {
            List toremove = this.physicalEndTagsQueue.subList(0, this.physicalEndTagsQueue.indexOf(match) + 1);
            if (toremove.size() > 1) {
                for (ElementsFactory.ModifiableCloseTag n : toremove.subList(0, toremove.size() - 1)) {
                    openTag.addChild(n);
                }
            }
            toremove.clear();
            if (!this.stack.isEmpty()) {
                this.stack.peek().addChild(match);
            }
            openTag.setMatchingCloseTag(match);
            match.setMatchingOpenTag(openTag);
            int match_end = match.to();
            if (match_end == -1) {
                match_end = match.from() + match.name().length() + 2;
            }
            openTag.setSemanticEndOffset(match_end);
        } else {
            CloseTag latestEndTag = this.physicalEndTagsQueue.peek();
            if (latestEndTag != null) {
                if (latestEndTag.from() != -1) {
                    openTag.setSemanticEndOffset(latestEndTag.from());
                }
            } else if (this.startTag != null) {
                if (this.tag_lt_offset != -1) {
                    openTag.setSemanticEndOffset(this.tag_lt_offset);
                }
            } else {
                openTag.setSemanticEndOffset(this.offset);
            }
        }
        if (this.stack.size() == 1 && !this.physicalEndTagsQueue.isEmpty()) {
            if (LOG) {
                LOGGER.fine(String.format("LEFT in stack of end tags: %s", this.dumpEndTags()));
            }
            ListIterator leftEndTags = this.physicalEndTagsQueue.listIterator();
            while (leftEndTags.hasNext()) {
                ElementsFactory.ModifiableCloseTag left = (ElementsFactory.ModifiableCloseTag)leftEndTags.next();
                openTag.addChild(left);
                leftEndTags.remove();
            }
        }
        super.elementPopped(namespace, name, t);
    }

    @Override
    protected void elementPushed(String namespace, String name, Named t) throws SAXException {
        if (LOG) {
            LOGGER.fine(String.format("+ %s %s; stack: %s", t, this.isVirtual(t) ? "[virtual]" : "", this.dumpStack()));
        }
        ElementsFactory.ModifiableOpenTag openTag = (ElementsFactory.ModifiableOpenTag)t;
        this.stack.push(openTag);
        if (!this.isVirtual(t)) {
            ElementsFactory.ModifiableCloseTag head;
            while ((head = this.physicalEndTagsQueue.poll()) != null) {
                this.stack.peek().addChild(head);
            }
        }
        super.elementPushed(namespace, name, t);
    }

    private String dumpStack() {
        return this.collectionOfNodesToString(this.stack);
    }

    private String dumpEndTags() {
        return this.collectionOfNodesToString(this.physicalEndTagsQueue);
    }

    private String collectionOfNodesToString(Collection<? extends Named> col) {
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (Named named : col) {
            b.append(named.name());
            b.append(", ");
        }
        b.append(']');
        return b.toString();
    }

    @Override
    public void transition(int from, int to, boolean reconsume, int offset) throws SAXException {
        if (LOG_FINER) {
            LOGGER.finer(String.format("%s -> %s at %s", Util.TOKENIZER_STATE_NAMES[from], Util.TOKENIZER_STATE_NAMES[to], offset));
        }
        this.offset = offset;
        int tag_gt_offset = -1;
        if (this.ADD_TEXT_NODES) {
            switch (from) {
                case 0: 
                case 1: 
                case 2: {
                    if (this.data_section_start == -1) break;
                    this.stack.peek().addChild(this.factory.createText(this.data_section_start, offset));
                    this.data_section_start = -1;
                }
            }
        }
        switch (to) {
            case 55: {
                if (LOG_FINER) {
                    LOGGER.finer("Set self closing start tag flag.");
                }
                this.self_closing_starttag = true;
                break;
            }
            case 9: {
                this.tag_lt_offset = offset;
                break;
            }
            case 39: {
                if (from != 66 && from != 60) break;
                this.tag_lt_offset = offset - 1;
                break;
            }
            case 3: {
                switch (from) {
                    case 7: 
                    case 11: 
                    case 12: 
                    case 16: {
                        tag_gt_offset = offset + 1;
                    }
                }
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                switch (from) {
                    case 7: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 39: 
                    case 55: {
                        tag_gt_offset = offset + 1;
                    }
                }
                break;
            }
            case 13: {
                switch (from) {
                    case 12: 
                    case 14: {
                        AttrInfo ainfo = new AttrInfo();
                        this.attrs.push(ainfo);
                        ainfo.nameOffset = offset;
                        if (!LOG_FINER) break;
                        LOGGER.log(Level.FINER, String.format("pushed attribute %s", ainfo));
                    }
                }
                break;
            }
            case 15: {
                switch (from) {
                    case 13: {
                        this.attrs.peek().equalSignOffset = offset;
                    }
                }
                break;
            }
            case 5: {
                if (from != 15) break;
                this.attrs.peek().valueQuotationType = AttrInfo.ValueQuotation.DOUBLE;
                this.attrs.peek().valueOffset = offset;
                break;
            }
            case 6: {
                if (from != 15) break;
                this.attrs.peek().valueQuotationType = AttrInfo.ValueQuotation.SINGLE;
                this.attrs.peek().valueOffset = offset;
                break;
            }
            case 7: {
                if (from != 15) break;
                this.attrs.peek().valueQuotationType = AttrInfo.ValueQuotation.NONE;
                this.attrs.peek().valueOffset = offset;
            }
        }
        this.data_section_start = tag_gt_offset;
        if (tag_gt_offset != -1) {
            if (this.currentOpenTag != null) {
                this.currentOpenTag.setEndOffset(tag_gt_offset);
                this.currentOpenTag.setSemanticEndOffset(tag_gt_offset);
            }
            if (this.currentCloseTag != null) {
                this.currentCloseTag.setEndOffset(tag_gt_offset);
                OpenTag match = this.currentCloseTag.matchingOpenTag();
                if (match != null) {
                    ((ElementsFactory.ModifiableOpenTag)match).setSemanticEndOffset(tag_gt_offset);
                }
            }
            this.currentOpenTag = null;
            this.currentCloseTag = null;
        }
    }

    @Override
    public void startTag(ElementName en, HtmlAttributes ha, boolean bln) throws SAXException {
        if (LOG) {
            LOGGER.fine(String.format("open tag %s at %s", en.name, this.tag_lt_offset));
        }
        this.startTag = en;
        super.startTag(en, ha, bln);
        this.startTag = null;
    }

    @Override
    public void endTag(ElementName en) throws SAXException {
        ElementsFactory.ModifiableCloseTag closeTag;
        if (LOG) {
            LOGGER.fine(String.format("close tag %s at %s", en.name, this.tag_lt_offset));
        }
        this.currentCloseTag = closeTag = this.factory.createCloseTag(this.tag_lt_offset, -1, (byte)en.name.length());
        this.physicalEndTagsQueue.add(closeTag);
        if (LOG) {
            LOGGER.fine(String.format("end tags: %s", this.dumpEndTags()));
        }
        super.endTag(en);
    }

    private void resetInternalPositions() {
        this.tag_lt_offset = -1;
        this.self_closing_starttag = false;
        this.attrs.clear();
        if (LOG) {
            LOGGER.fine("Internal state reset.");
        }
    }

    @Override
    protected void appendCharacters(Named t, String string) throws SAXException {
    }

    @Override
    protected void appendComment(Named t, String string) throws SAXException {
    }

    @Override
    protected void appendCommentToDocument(String string) throws SAXException {
    }

    @Override
    protected void insertFosterParentedCharacters(String string, Named t, Named t1) throws SAXException {
    }

    @Override
    protected Named createElement(String namespace, String name, HtmlAttributes attributes) throws SAXException {
        ElementsFactory.ModifiableOpenTag node;
        if (LOG) {
            LOGGER.fine(String.format("createElement(%s)", name));
        }
        if (this.startTag != null && this.startTag.name.equals(name)) {
            this.currentOpenTag = this.self_closing_starttag ? (node = this.factory.createEmptyOpenTag(this.tag_lt_offset, -1, (byte)name.length())) : (node = this.factory.createOpenTag(this.tag_lt_offset, -1, (byte)name.length()));
            this.addAttributesToElement((Named)node, attributes);
            this.resetInternalPositions();
        } else {
            node = this.factory.createVirtualOpenTag(name);
            this.addAttributesToElement((Named)node, attributes);
        }
        return node;
    }

    @Override
    protected Named createHtmlElementSetAsRoot(HtmlAttributes attributes) throws SAXException {
        if (LOG) {
            LOGGER.fine("createHtmlElementSetAsRoot()");
        }
        Named rootTag = this.createElement("http://www.w3.org/1999/xhtml", "html", attributes);
        this.stack.push(this.root);
        this.root.addChild((Element)rootTag);
        return rootTag;
    }

    @Override
    protected void detachFromParent(Named node) throws SAXException {
        ((ElementsFactory.ModifiableElement)node).detachFromParent();
    }

    @Override
    protected boolean hasChildren(Named node) throws SAXException {
        OpenTag ot = (OpenTag)node;
        return !ot.children().isEmpty();
    }

    @Override
    protected void appendElement(Named child, Named parent) throws SAXException {
        ((ElementsFactory.ModifiableOpenTag)parent).addChild((Element)child);
    }

    @Override
    protected void appendChildrenToNewParent(Named from, Named to) throws SAXException {
        Collection children = ((OpenTag)from).children();
        ((ElementsFactory.ModifiableOpenTag)from).removeChildren(children);
        ((ElementsFactory.ModifiableOpenTag)to).addChildren(children);
    }

    @Override
    protected void insertFosterParentedChild(Named child, Named table, Named stackParent) throws SAXException {
        Node parent = table.parent();
        if (parent != null) {
            ((ElementsFactory.ModifiableOpenTag)parent).insertChildBefore((Element)child, (Element)table);
        } else {
            ((ElementsFactory.ModifiableOpenTag)stackParent).addChild((Element)child);
        }
    }

    @Override
    protected void addAttributesToElement(Named node, HtmlAttributes attributes) throws SAXException {
        ElementsFactory.ModifiableOpenTag mot = (ElementsFactory.ModifiableOpenTag)node;
        int attrs_count = Math.min(attributes.getLength(), this.attrs.size());
        for (int i = 0; i < attrs_count; ++i) {
            ElementsFactory.CommonAttribute attr;
            String attributeName;
            int attributeNameLength;
            int attrNameEndOffset;
            AttrInfo attrInfo = (AttrInfo)this.attrs.elementAt(i);
            if (attrInfo.nameOffset == -1 || attrInfo.nameOffset < node.from() || (attrNameEndOffset = attrInfo.nameOffset + (attributeNameLength = (attributeName = attributes.getLocalName(i)).length())) > this.sourceCode.length()) continue;
            if (attrInfo.valueOffset == -1) {
                attr = this.factory.createAttribute(attrInfo.nameOffset, (short)attributeNameLength);
            } else {
                int attributeValueLength = attributes.getValue(i).length() + (attrInfo.valueQuotationType == AttrInfo.ValueQuotation.NONE ? 0 : 2);
                attr = this.factory.createAttribute(attrInfo.nameOffset, attrInfo.valueOffset, (short)attributeNameLength, attributeValueLength);
            }
            mot.setAttribute(attr);
        }
    }

    static void setLoggerLevel(Level level) {
        LOGGER.setLevel(level);
        LOGGER.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                System.out.println(record.getMessage());
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
        ParseTreeBuilder.initLogLevels();
    }

    static {
        ParseTreeBuilder.initLogLevels();
    }

    private static class AttrInfo {
        public int nameOffset = -1;
        public int equalSignOffset = -1;
        public int valueOffset = -1;
        public ValueQuotation valueQuotationType;

        private AttrInfo() {
        }

        public String toString() {
            return "AttrInfo[" + "nameOffset=" + this.nameOffset + ",equalSignOffset=" + this.equalSignOffset + ",valueOffset=" + this.valueOffset + "]";
        }

        private static enum ValueQuotation {
            NONE,
            SINGLE,
            DOUBLE;

        }
    }
}

