/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.IdentifierInfo;
import org.clang.basic.IdentifierInfoLookup;
import org.clang.basic.IdentifierInfoStringMapEntry;
import org.clang.basic.LangOptions;
import org.clang.basic.impl.IdentifierTableStatics;
import org.clang.basic.impl.StringMapIdentifierInfo;
import org.clang.basic.impl.StringMapIteratorIdentifierInfo;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.BumpPtrAllocator;
import org.llvm.support.StringMapBumpPtrAllocator;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class IdentifierTable
implements Destructors.ClassWithDestructor {
    private static final int IDENT_TABLE_SIZE = Integer.getInteger("clank.identifiers.size", 8192);
    public static final String REUSE_LEXER_IDENTIFIERS_PROP = "clank.identifiers.reuse";
    public static final boolean REUSE_LEXER_IDENTIFIERS = Boolean.valueOf(System.getProperty("clank.identifiers.reuse", "false"));
    private static final SmallVector<HashTableTy> POOL = new SmallVector(2 * Native.availableProcessors(), null);
    private HashTableTy HashTable;
    private IdentifierInfoLookup ExternalLookup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashTableTy $getHashTable(IdentifierInfoLookup ExternalLookup) {
        if (REUSE_LEXER_IDENTIFIERS && ExternalLookup == null) {
            SmallVector<HashTableTy> smallVector = POOL;
            synchronized (smallVector) {
                if (!POOL.empty()) {
                    return (HashTableTy)((Object)POOL.pop_back_val());
                }
            }
            return new HashTableTy(IDENT_TABLE_SIZE);
        }
        return new HashTableTy(IDENT_TABLE_SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void $releaseHashTable(HashTableTy Table, IdentifierInfoLookup ExternalLookup) {
        if (REUSE_LEXER_IDENTIFIERS && ExternalLookup == null) {
            Table.$release();
            SmallVector<HashTableTy> smallVector = POOL;
            synchronized (smallVector) {
                POOL.push_back((Object)Table);
            }
        } else {
            Table.$destroy();
        }
    }

    public IdentifierTable(LangOptions LangOpts) {
        this(LangOpts, null);
    }

    public IdentifierTable(LangOptions LangOpts, IdentifierInfoLookup externalLookup) {
        this.HashTable = IdentifierTable.$getHashTable(externalLookup);
        this.ExternalLookup = externalLookup;
        this.AddKeywords(LangOpts);
        this.get(StringRef.IMPORT).setModulesImport(true);
    }

    public void setExternalIdentifierLookup(IdentifierInfoLookup IILookup) {
        this.ExternalLookup = IILookup;
    }

    public IdentifierInfoLookup getExternalIdentifierLookup() {
        return this.ExternalLookup;
    }

    public BumpPtrAllocator getAllocator() {
        return this.HashTable.getAllocator();
    }

    public IdentifierInfo get(StringRef Name) {
        return this.get(Name.data(), Name.size());
    }

    public IdentifierInfo get(char.ptr Name, int Len) {
        IdentifierInfoStringMapEntry Entry2 = this.HashTable.GetOrCreateValue(Name, Len);
        IdentifierInfo II = Entry2.getValue();
        if (II != null) {
            assert (Entry2.getValue() == II);
            assert (II.getEntryImpl() == Entry2);
            return II;
        }
        if (this.ExternalLookup != null && (II = this.ExternalLookup.get(new StringRef(Name))) != null) {
            Entry2.setValue(II);
            return II;
        }
        Entry2.setValue(IdentifierInfo.SET_VALUE_PLACEHOLDER);
        II = Entry2.getValue();
        II.setEntry(Entry2);
        assert (Entry2.getValue() == II);
        assert (II.getEntryImpl() == Entry2);
        return II;
    }

    public IdentifierInfo get(byte[] Name, int NameStIndex, int Len) {
        IdentifierInfoStringMapEntry Entry2 = this.HashTable.GetOrCreateValue(Name, NameStIndex, Len);
        IdentifierInfo II = Entry2.getValue();
        if (II != null) {
            assert (Entry2.getValue() == II);
            assert (II.getEntryImpl() == Entry2);
            return II;
        }
        if (this.ExternalLookup != null && (II = this.ExternalLookup.get(new StringRef(Name, NameStIndex, Len))) != null) {
            Entry2.setValue(II);
            return Entry2.getValue();
        }
        Entry2.setValue(IdentifierInfo.SET_VALUE_PLACEHOLDER);
        II = Entry2.getValue();
        II.setEntry(Entry2);
        assert (Entry2.getValue() == II);
        assert (II.getEntryImpl() == Entry2);
        return II;
    }

    public IdentifierInfo get(StringRef Name, short TokenCode) {
        IdentifierInfo II = this.get(Name);
        II.setTokenID(TokenCode);
        assert (II.$TokenID() == TokenCode) : "TokenCode too large";
        return II;
    }

    public IdentifierInfo getOwn(StringRef Name) {
        IdentifierInfoStringMapEntry Entry2 = this.HashTable.GetOrCreateValue(Name);
        IdentifierInfo II = Entry2.getValue();
        if (II == null) {
            Entry2.setValue(IdentifierInfo.SET_VALUE_PLACEHOLDER);
            II = Entry2.getValue();
            II.setEntry(Entry2);
            if (Name.equals(StringRef.IMPORT)) {
                II.setModulesImport(true);
            }
        }
        assert (Entry2.getValue() == II);
        assert (II.getEntryImpl() == Entry2);
        return II;
    }

    public StringMapIteratorIdentifierInfo begin() {
        return this.HashTable.begin();
    }

    public StringMapIteratorIdentifierInfo end() {
        return this.HashTable.end();
    }

    public int size() {
        return this.HashTable.size();
    }

    public void PrintStats() {
        this.PrintStats(llvm.errs());
    }

    public void PrintStats(raw_ostream OS) {
        int NumBuckets = this.HashTable.getNumBuckets();
        int NumIdentifiers = this.HashTable.getNumItems();
        int NumEmptyBuckets = NumBuckets - NumIdentifiers;
        int AverageIdentifierSize = 0;
        int MaxIdentifierLength = 0;
        StringMapIteratorIdentifierInfo I = this.HashTable.begin();
        StringMapIteratorIdentifierInfo E = this.HashTable.end();
        while (I.$noteq(E)) {
            int IdLen = I.$arrow().getKeyLength();
            AverageIdentifierSize += IdLen;
            if (MaxIdentifierLength < IdLen) {
                MaxIdentifierLength = IdLen;
            }
            I.$preInc();
        }
        OS.$out((CharSequence)String.format("\n*** Identifier Table Stats:\n", new Object[0]));
        OS.$out((CharSequence)String.format("# Identifiers:   %s\n", NativeTrace.formatNumber((long)NumIdentifiers)));
        OS.$out((CharSequence)String.format("# Empty Buckets: %s\n", NativeTrace.formatNumber((long)NumEmptyBuckets)));
        OS.$out((CharSequence)String.format("Hash density (#identifiers per bucket): %f\n", (double)NumIdentifiers / (double)NumBuckets));
        OS.$out((CharSequence)String.format("Ave identifier length: %f\n", (double)AverageIdentifierSize / (double)NumIdentifiers));
        OS.$out((CharSequence)String.format("Max identifier length: %d\n", MaxIdentifierLength));
        this.HashTable.getAllocator().PrintStats(OS);
    }

    public void AddKeywords(LangOptions LangOpts) {
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"auto")), (short)74, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"break")), (short)75, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"case")), (short)76, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"char")), (short)77, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"const")), (short)78, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"continue")), (short)79, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"default")), (short)80, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"do")), (short)81, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"double")), (short)82, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"else")), (short)83, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"enum")), (short)84, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"extern")), (short)85, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"float")), (short)86, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"for")), (short)87, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"goto")), (short)88, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"if")), (short)89, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"inline")), (short)90, 11L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"int")), (short)91, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"long")), (short)92, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"register")), (short)93, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"restrict")), (short)94, 1L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"return")), (short)95, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"short")), (short)96, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"signed")), (short)97, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"sizeof")), (short)98, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"static")), (short)99, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"struct")), (short)100, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"switch")), (short)101, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"typedef")), (short)102, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"union")), (short)103, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"unsigned")), (short)104, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"void")), (short)105, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"volatile")), (short)106, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"while")), (short)107, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_Alignas")), (short)108, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_Alignof")), (short)109, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_Atomic")), (short)110, 65535L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_Bool")), (short)111, 128L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_Complex")), (short)112, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_Generic")), (short)113, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_Imaginary")), (short)114, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_Noreturn")), (short)115, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_Static_assert")), (short)116, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_Thread_local")), (short)117, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__func__")), (short)118, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__objc_yes")), (short)119, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__objc_no")), (short)120, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"asm")), (short)121, 10L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"bool")), (short)122, 32L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"catch")), (short)123, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"class")), (short)124, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"const_cast")), (short)125, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"delete")), (short)126, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"dynamic_cast")), (short)127, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"explicit")), (short)128, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"export")), (short)129, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"false")), (short)130, 32L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"friend")), (short)131, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"mutable")), (short)132, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"namespace")), (short)133, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"new")), (short)134, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"operator")), (short)135, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"private")), (short)136, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"protected")), (short)137, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"public")), (short)138, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"reinterpret_cast")), (short)139, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"static_cast")), (short)140, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"template")), (short)141, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"this")), (short)142, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"throw")), (short)143, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"true")), (short)144, 32L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"try")), (short)145, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"typename")), (short)146, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"typeid")), (short)147, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"using")), (short)148, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"virtual")), (short)149, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"wchar_t")), (short)150, 8192L, LangOpts, this);
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword(new StringRef(NativePointer.$((String)"and")), (short)28, this);
        }
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword(new StringRef(NativePointer.$((String)"and_eq")), (short)29, this);
        }
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword(new StringRef(NativePointer.$((String)"bitand")), (short)27, this);
        }
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword(new StringRef(NativePointer.$((String)"bitor")), (short)56, this);
        }
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword(new StringRef(NativePointer.$((String)"compl")), (short)39, this);
        }
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword(new StringRef(NativePointer.$((String)"not")), (short)40, this);
        }
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword(new StringRef(NativePointer.$((String)"not_eq")), (short)41, this);
        }
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword(new StringRef(NativePointer.$((String)"or")), (short)57, this);
        }
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword(new StringRef(NativePointer.$((String)"or_eq")), (short)58, this);
        }
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword(new StringRef(NativePointer.$((String)"xor")), (short)54, this);
        }
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword(new StringRef(NativePointer.$((String)"xor_eq")), (short)55, this);
        }
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"alignas")), (short)151, 4L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"alignof")), (short)152, 4L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"char16_t")), (short)153, 4100L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"char32_t")), (short)154, 4100L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"constexpr")), (short)155, 4L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"decltype")), (short)156, 4L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"noexcept")), (short)157, 4L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"nullptr")), (short)158, 4L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"static_assert")), (short)159, 4L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"thread_local")), (short)160, 4L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_Decimal32")), (short)161, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_Decimal64")), (short)162, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_Decimal128")), (short)163, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__null")), (short)164, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__alignof")), (short)165, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__attribute")), (short)166, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__builtin_choose_expr")), (short)167, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__builtin_offsetof")), (short)168, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__builtin_types_compatible_p")), (short)169, 128L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__builtin_va_arg")), (short)170, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__extension__")), (short)171, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__imag")), (short)172, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__int128")), (short)173, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__label__")), (short)174, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__real")), (short)175, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__thread")), (short)176, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__FUNCTION__")), (short)177, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__PRETTY_FUNCTION__")), (short)178, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"typeof")), (short)179, 8L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__FUNCDNAME__")), (short)180, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__FUNCSIG__")), (short)181, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"L__FUNCTION__")), (short)182, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_interface_class")), (short)183, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_sealed")), (short)184, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_destructible")), (short)185, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_nothrow_destructible")), (short)186, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_nothrow_assignable")), (short)187, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_constructible")), (short)188, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_nothrow_constructible")), (short)189, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__has_nothrow_assign")), (short)190, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__has_nothrow_move_assign")), (short)191, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__has_nothrow_copy")), (short)192, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__has_nothrow_constructor")), (short)193, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__has_trivial_assign")), (short)194, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__has_trivial_move_assign")), (short)195, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__has_trivial_copy")), (short)196, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__has_trivial_constructor")), (short)197, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__has_trivial_move_constructor")), (short)198, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__has_trivial_destructor")), (short)199, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__has_virtual_destructor")), (short)200, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_abstract")), (short)201, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_base_of")), (short)202, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_class")), (short)203, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_convertible_to")), (short)204, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_empty")), (short)205, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_enum")), (short)206, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_final")), (short)207, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_literal")), (short)208, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_literal_type")), (short)208, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_pod")), (short)209, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_polymorphic")), (short)210, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_trivial")), (short)211, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_union")), (short)212, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_trivially_constructible")), (short)213, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_trivially_copyable")), (short)214, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_trivially_assignable")), (short)215, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__underlying_type")), (short)216, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_lvalue_expr")), (short)217, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_rvalue_expr")), (short)218, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_arithmetic")), (short)219, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_floating_point")), (short)220, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_integral")), (short)221, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_complete_type")), (short)222, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_void")), (short)223, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_array")), (short)224, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_function")), (short)225, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_reference")), (short)226, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_lvalue_reference")), (short)227, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_rvalue_reference")), (short)228, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_fundamental")), (short)229, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_object")), (short)230, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_scalar")), (short)231, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_compound")), (short)232, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_pointer")), (short)233, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_member_object_pointer")), (short)234, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_member_function_pointer")), (short)235, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_member_pointer")), (short)236, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_const")), (short)237, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_volatile")), (short)238, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_standard_layout")), (short)239, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_signed")), (short)240, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_unsigned")), (short)241, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_same")), (short)242, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__is_convertible")), (short)243, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__array_rank")), (short)244, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__array_extent")), (short)245, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__private_extern__")), (short)246, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__module_private__")), (short)247, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__declspec")), (short)248, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__cdecl")), (short)249, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__stdcall")), (short)250, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__fastcall")), (short)251, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__thiscall")), (short)252, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__vectorcall")), (short)253, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__forceinline")), (short)254, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__unaligned")), (short)255, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__super")), (short)256, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__global")), (short)257, 512L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__local")), (short)258, 512L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__constant")), (short)259, 512L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__private")), (short)260, 512L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__generic")), (short)261, 512L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"global")), (short)257, 512L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"local")), (short)258, 512L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"constant")), (short)259, 512L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"private")), (short)260, 512L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"generic")), (short)261, 512L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__kernel")), (short)262, 512L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"kernel")), (short)262, 512L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__read_only")), (short)263, 512L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__write_only")), (short)264, 512L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__read_write")), (short)265, 512L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"read_only")), (short)263, 512L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"write_only")), (short)264, 512L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"read_write")), (short)265, 512L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__builtin_astype")), (short)266, 512L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"vec_step")), (short)267, 576L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__pascal")), (short)268, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__vector")), (short)269, 64L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__pixel")), (short)270, 64L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__bool")), (short)271, 64L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__fp16")), (short)272, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"half")), (short)272, 16384L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__bridge")), (short)273, 2048L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__bridge_transfer")), (short)274, 2048L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__bridge_retained")), (short)275, 2048L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__bridge_retain")), (short)276, 2048L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__alignof__")), (short)165, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__asm")), (short)121, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__asm__")), (short)121, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__attribute__")), (short)166, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__complex")), (short)112, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__complex__")), (short)112, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__const")), (short)78, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__const__")), (short)78, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__decltype")), (short)156, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__imag__")), (short)172, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__inline")), (short)90, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__inline__")), (short)90, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__nullptr")), (short)158, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__real__")), (short)175, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__restrict")), (short)94, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__restrict__")), (short)94, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__signed")), (short)97, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__signed__")), (short)97, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__typeof")), (short)179, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__typeof__")), (short)179, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__volatile")), (short)106, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__volatile__")), (short)106, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__ptr64")), (short)277, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__ptr32")), (short)278, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__sptr")), (short)279, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__uptr")), (short)280, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__w64")), (short)281, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__uuidof")), (short)282, 272L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__try")), (short)283, 272L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__finally")), (short)284, 272L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__leave")), (short)285, 272L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__int64")), (short)286, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__if_exists")), (short)287, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__if_not_exists")), (short)288, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__single_inheritance")), (short)289, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__multiple_inheritance")), (short)290, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__virtual_inheritance")), (short)291, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__interface")), (short)292, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__int8")), (short)77, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_int8")), (short)77, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__int16")), (short)96, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_int16")), (short)96, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__int32")), (short)91, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_int32")), (short)91, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_int64")), (short)286, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__wchar_t")), (short)150, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_asm")), (short)121, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_alignof")), (short)165, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__builtin_alignof")), (short)165, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_cdecl")), (short)249, 272L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_fastcall")), (short)251, 272L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_stdcall")), (short)250, 272L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_thiscall")), (short)252, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_vectorcall")), (short)253, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_uuidof")), (short)282, 272L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_inline")), (short)90, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_declspec")), (short)248, 16L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"_pascal")), (short)268, 256L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__builtin_convertvector")), (short)293, 61439L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__char16_t")), (short)153, 2L, LangOpts, this);
        IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__char32_t")), (short)154, 2L, LangOpts, this);
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"not_keyword")), (short)0, this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"class")), (short)1, this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"compatibility_alias")), (short)2, this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"defs")), (short)3, this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"encode")), (short)4, this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"end")), (short)5, this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"implementation")), (short)6, this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"interface")), (short)7, this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"private")), (short)8, this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"protected")), (short)9, this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"protocol")), (short)10, this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"public")), (short)11, this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"selector")), (short)12, this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"throw")), (short)13, this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"try")), (short)14, this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"catch")), (short)15, this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"finally")), (short)16, this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"synchronized")), (short)17, this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"autoreleasepool")), (short)18, this);
        }
        if (LangOpts.ObjC2) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"property")), (short)19, this);
        }
        if (LangOpts.ObjC2) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"package")), (short)20, this);
        }
        if (LangOpts.ObjC2) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"required")), (short)21, this);
        }
        if (LangOpts.ObjC2) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"optional")), (short)22, this);
        }
        if (LangOpts.ObjC2) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"synthesize")), (short)23, this);
        }
        if (LangOpts.ObjC2) {
            IdentifierTableStatics.AddObjCKeyword(new StringRef(NativePointer.$((String)"dynamic")), (short)24, this);
        }
        if (LangOpts.ObjC2) {
            IdentifierTableStatics.AddObjCKeyword(StringRef.IMPORT, (short)25, this);
        }
        if (LangOpts.ParseUnknownAnytype) {
            IdentifierTableStatics.AddKeyword(new StringRef(NativePointer.$((String)"__unknown_anytype")), (short)294, 61439L, LangOpts, this);
        }
    }

    public void $destroy() {
        IdentifierTable.$releaseHashTable(this.HashTable, this.ExternalLookup);
        this.HashTable = null;
    }

    private static final class HashTableTy
    extends StringMapIdentifierInfo {
        private HashTableTy(int size) {
            super(size, new StringMapBumpPtrAllocator(), null);
        }

        private void $release() {
            super.resetForReuse();
        }
    }
}

