/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.ClangGlobals;
import org.clang.basic.Linkage;
import org.clang.basic.Visibility;

public class LinkageInfo {
    private Linkage linkage_;
    private Visibility visibility_;
    private boolean explicit_;

    private void setVisibility(Visibility V, boolean E) {
        this.visibility_ = V;
        this.explicit_ = E;
    }

    public LinkageInfo() {
        this.linkage_ = Linkage.ExternalLinkage;
        this.visibility_ = Visibility.DefaultVisibility;
        this.explicit_ = false;
    }

    public LinkageInfo(Linkage L, Visibility V, boolean E) {
        this.linkage_ = L;
        this.visibility_ = V;
        this.explicit_ = E;
        assert (this.getLinkage() == L && this.getVisibility() == V && this.isVisibilityExplicit() == E) : "Enum truncated!";
    }

    public static LinkageInfo external() {
        return new LinkageInfo();
    }

    public static LinkageInfo internal() {
        return new LinkageInfo(Linkage.InternalLinkage, Visibility.DefaultVisibility, false);
    }

    public static LinkageInfo uniqueExternal() {
        return new LinkageInfo(Linkage.UniqueExternalLinkage, Visibility.DefaultVisibility, false);
    }

    public static LinkageInfo none() {
        return new LinkageInfo(Linkage.NoLinkage, Visibility.DefaultVisibility, false);
    }

    public Linkage getLinkage() {
        return this.linkage_;
    }

    public Visibility getVisibility() {
        return this.visibility_;
    }

    public boolean isVisibilityExplicit() {
        return this.explicit_;
    }

    public void setLinkage(Linkage L) {
        this.linkage_ = L;
    }

    public void mergeLinkage(Linkage L) {
        this.setLinkage(ClangGlobals.minLinkage(this.getLinkage(), L));
    }

    public void mergeLinkage(LinkageInfo other) {
        this.mergeLinkage(other.getLinkage());
    }

    public void mergeExternalVisibility(Linkage L) {
        Linkage ThisL = this.getLinkage();
        if (!ClangGlobals.isExternallyVisible(L)) {
            if (ThisL == Linkage.VisibleNoLinkage) {
                ThisL = Linkage.NoLinkage;
            } else if (ThisL == Linkage.ExternalLinkage) {
                ThisL = Linkage.UniqueExternalLinkage;
            }
        }
        this.setLinkage(ThisL);
    }

    public void mergeExternalVisibility(LinkageInfo Other) {
        this.mergeExternalVisibility(Other.getLinkage());
    }

    public void mergeVisibility(Visibility newVis, boolean newExplicit) {
        Visibility oldVis = this.getVisibility();
        if (oldVis.getValue() < newVis.getValue()) {
            return;
        }
        if (oldVis == newVis && !newExplicit) {
            return;
        }
        this.setVisibility(newVis, newExplicit);
    }

    public void mergeVisibility(LinkageInfo other) {
        this.mergeVisibility(other.getVisibility(), other.isVisibilityExplicit());
    }

    public void merge(LinkageInfo other) {
        this.mergeLinkage(other);
        this.mergeVisibility(other);
    }

    public void mergeMaybeWithVisibility(LinkageInfo other, boolean withVis) {
        this.mergeLinkage(other);
        if (withVis) {
            this.mergeVisibility(other);
        }
    }

    public LinkageInfo(LinkageInfo $Prm0) {
        this.linkage_ = $Prm0.linkage_;
        this.visibility_ = $Prm0.visibility_;
        this.explicit_ = $Prm0.explicit_;
    }
}

