/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.impl;

import org.clang.basic.vfs.File;
import org.clang.basic.vfs.Status;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.sys.fs;

public class RealFile
extends File
implements Destructors.ClassWithDestructor {
    private int FD;
    private Status S;

    RealFile(int FD) {
        this.FD = FD;
        this.S = new Status();
        assert (FD >= 0) : "Invalid or inactive file descriptor";
    }

    @Override
    public void $destroy() {
        this.close();
        this.S.$destroy();
        super.$destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ErrorOr<Status> status() {
        assert (this.FD != -1) : "cannot stat closed file";
        if (!this.S.isStatusKnown()) {
            Status NewS = null;
            try {
                fs.file_status RealStatus = new fs.file_status();
                std_errors.error_code EC = fs.status((int)this.FD, (fs.file_status)RealStatus);
                if (EC.$boolean()) {
                    ErrorOr errorOr = new ErrorOr(new std_errors.error_code(EC));
                    return errorOr;
                }
                NewS = new Status(RealStatus);
                NewS.setName(this.S.getName());
                this.S.$assign((Status)std.move((Object)NewS));
            }
            finally {
                if (NewS != null) {
                    NewS.$destroy();
                }
            }
        }
        return new ErrorOr((Object)new Status(this.S));
    }

    @Override
    public ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getBuffer(Twine Name) {
        return this.getBuffer(Name, -1L, true, false);
    }

    @Override
    public ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getBuffer(Twine Name, long FileSize) {
        return this.getBuffer(Name, FileSize, true, false);
    }

    @Override
    public ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getBuffer(Twine Name, long FileSize, boolean RequiresNullTerminator) {
        return this.getBuffer(Name, FileSize, RequiresNullTerminator, false);
    }

    @Override
    public ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getBuffer(Twine Name, long FileSize, boolean RequiresNullTerminator, boolean IsVolatile) {
        assert (this.FD != -1) : "cannot get buffer for closed file";
        return MemoryBuffer.getOpenFile((int)this.FD, (Twine)Name, (long)FileSize, (boolean)RequiresNullTerminator, (boolean)IsVolatile);
    }

    @Override
    public std_errors.error_code close() {
        if (std.close((int)this.FD) != 0) {
            return new std_errors.error_code(std.errno(), std.generic_category());
        }
        this.FD = -1;
        return new std_errors.error_code();
    }

    @Override
    public void setName(StringRef Name) {
        this.S.setName(Name);
    }

    @Override
    public String toString() {
        return "FD=" + this.FD + ", S=" + this.S + super.toString();
    }
}

