/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.impl.OSTargetInfo;
import org.clang.basic.target.impl.TargetsStatics;
import org.clank.support.JavaDifferentiators;
import org.clank.support.NativePointer;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;

public class FreeBSDTargetInfo<Target extends TargetInfo>
extends OSTargetInfo<Target> {
    @Override
    protected void getOSDefines(LangOptions Opts, Triple Triple2, MacroBuilder Builder) {
        long Release = Triple2.getOSMajorVersion();
        if (Release == 0L) {
            Release = 8L;
        }
        Builder.defineMacro(new Twine(NativePointer.$((String)"__FreeBSD__")), new Twine(JavaDifferentiators.Uint.INSTANCE, Release));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__FreeBSD_cc_version")), new Twine(JavaDifferentiators.Uint.INSTANCE, Release * 100000L + 1L));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__KPRINTF_ATTRIBUTE__")));
        TargetsStatics.DefineStd(Builder, new StringRef(NativePointer.$((String)"unix")), Opts);
        Builder.defineMacro(new Twine(NativePointer.$((String)"__ELF__")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__STDC_MB_MIGHT_NEQ_WC__")), new Twine(NativePointer.$((String)"1")));
    }

    public FreeBSDTargetInfo(Target T, Triple Triple2) {
        super(T, Triple2);
        this.UserLabelPrefix = NativePointer.$((String)"");
        switch (Triple2.getArch()) {
            default: {
                this.MCountName = NativePointer.$((String)".mcount");
                break;
            }
            case mips: 
            case mipsel: 
            case ppc: 
            case ppc64: 
            case ppc64le: {
                this.MCountName = NativePointer.$((String)"_mcount");
                break;
            }
            case arm: {
                this.MCountName = NativePointer.$((String)"__mcount");
            }
        }
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

