/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.CallingConv;
import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.impl.OSTargetInfo;
import org.clang.basic.target.impl.TargetsStatics;
import org.clank.support.NativePointer;
import org.llvm.adt.APFloat;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;

public class NaClTargetInfo<Target extends TargetInfo>
extends OSTargetInfo<Target> {
    @Override
    protected void getOSDefines(LangOptions Opts, Triple Triple2, MacroBuilder Builder) {
        if (Opts.POSIXThreads) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"_REENTRANT")));
        }
        if (Opts.CPlusPlus) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"_GNU_SOURCE")));
        }
        TargetsStatics.DefineStd(Builder, new StringRef(NativePointer.$((String)"unix")), Opts);
        Builder.defineMacro(new Twine(NativePointer.$((String)"__ELF__")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__native_client__")));
    }

    public NaClTargetInfo(Target T, Triple _Triple) {
        super(T, _Triple);
        this.UserLabelPrefix = NativePointer.$((String)"");
        this.LongAlign = (short)32;
        this.LongWidth = (short)32;
        this.PointerAlign = (short)32;
        this.PointerWidth = (short)32;
        this.IntMaxType = TargetInfo.IntType.SignedLongLong;
        this.Int64Type = TargetInfo.IntType.SignedLongLong;
        this.DoubleAlign = (short)64;
        this.LongDoubleWidth = (short)64;
        this.LongDoubleAlign = (short)64;
        this.LongLongWidth = (short)64;
        this.LongLongAlign = (short)64;
        this.SizeType = TargetInfo.IntType.UnsignedInt;
        this.PtrDiffType = TargetInfo.IntType.SignedInt;
        this.IntPtrType = TargetInfo.IntType.SignedInt;
        this.LongDoubleFormat = APFloat.IEEEdouble;
        if (_Triple.getArch() == Triple.ArchType.arm) {
            this.DescriptionString = NativePointer.$((String)"e-m:e-p:32:32-i64:64-v128:64:128-a:0:32-n32-S128");
        } else if (_Triple.getArch() == Triple.ArchType.x86) {
            this.DescriptionString = NativePointer.$((String)"e-m:e-p:32:32-i64:64-n8:16:32-S128");
        } else if (_Triple.getArch() == Triple.ArchType.x86_64) {
            this.DescriptionString = NativePointer.$((String)"e-m:e-p:32:32-i64:64-n8:16:32:64-S128");
        } else if (_Triple.getArch() != Triple.ArchType.mipsel) {
            assert (_Triple.getArch() == Triple.ArchType.le32);
            this.DescriptionString = NativePointer.$((String)"e-p:32:32-i64:64");
        }
    }

    @Override
    public TargetInfo.CallingConvCheckResult checkCallingConvention(CallingConv CC) {
        return CC == CallingConv.CC_PnaclCall ? TargetInfo.CallingConvCheckResult.CCCR_OK : super.checkCallingConvention(CC);
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

