/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.Builtin;
import org.clang.basic.CallingConv;
import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.X86;
import org.clang.basic.target.impl.TargetsStatics;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.APFloat;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.StringMapBool;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public abstract class X86TargetInfo
extends TargetInfo
implements Destructors.ClassWithDestructor {
    private X86SSEEnum SSELevel = X86SSEEnum.NoSSE;
    private MMX3DNowEnum MMX3DNowLevel = MMX3DNowEnum.NoMMX3DNow;
    private XOPEnum XOPLevel = XOPEnum.NoXOP;
    private boolean HasAES = false;
    private boolean HasPCLMUL = false;
    private boolean HasLZCNT = false;
    private boolean HasRDRND = false;
    private boolean HasFSGSBASE = false;
    private boolean HasBMI = false;
    private boolean HasBMI2 = false;
    private boolean HasPOPCNT = false;
    private boolean HasRTM = false;
    private boolean HasPRFCHW = false;
    private boolean HasRDSEED = false;
    private boolean HasADX = false;
    private boolean HasTBM = false;
    private boolean HasFMA = false;
    private boolean HasF16C = false;
    private boolean HasAVX512CD = false;
    private boolean HasAVX512ER = false;
    private boolean HasAVX512PF = false;
    private boolean HasAVX512DQ = false;
    private boolean HasAVX512BW = false;
    private boolean HasAVX512VL = false;
    private boolean HasSHA = false;
    private boolean HasCX16 = false;
    private CPUKind CPU = CPUKind.CK_Generic;
    private FPMathKind FPMath = FPMathKind.FP_Default;

    public X86TargetInfo(Triple Triple2) {
        super(Triple2);
        this.BigEndian = false;
        this.LongDoubleFormat = APFloat.x87DoubleExtended;
    }

    @Override
    public int getFloatEvalMethod() {
        return this.SSELevel == X86SSEEnum.NoSSE ? 2 : 0;
    }

    @Override
    public void getTargetBuiltins(type.ref<Builtin.Info[]> Records, uint.ref NumRecords) {
        Records.$set((Object)TargetsStatics.BuiltinInfo);
        NumRecords.$set((long)(X86.LastTSBuiltin - Builtin.ID.FirstTSBuiltin.getValue()));
    }

    @Override
    public void getGCCRegNames(type.ref<CharSequence[]> Names, uint.ref NumNames) {
        Names.$set((Object)TargetsStatics.GCCRegNames);
        NumNames.$set((long)llvm.array_lengthof((Object[])TargetsStatics.GCCRegNames));
    }

    @Override
    public void getGCCRegAliases(type.ref<TargetInfo.GCCRegAlias[]> Aliases, uint.ref NumAliases) {
        Aliases.$set(null);
        NumAliases.$set(0L);
    }

    @Override
    public void getGCCAddlRegNames(type.ref<TargetInfo.AddlRegName[]> Names, uint.ref NumNames) {
        Names.$set((Object)TargetsStatics.AddlRegNames);
        NumNames.$set((long)llvm.array_lengthof((Object[])TargetsStatics.AddlRegNames));
    }

    @Override
    public boolean validateAsmConstraint(char.ptr Name, TargetInfo.ConstraintInfo Info2) {
        switch (Name.$star()) {
            default: {
                return false;
            }
            case 73: {
                Info2.setRequiresImmediate(0, 31);
                return true;
            }
            case 74: {
                Info2.setRequiresImmediate(0, 63);
                return true;
            }
            case 75: {
                Info2.setRequiresImmediate(-128, 127);
                return true;
            }
            case 76: {
                return true;
            }
            case 77: {
                Info2.setRequiresImmediate(0, 3);
                return true;
            }
            case 78: {
                Info2.setRequiresImmediate(0, 255);
                return true;
            }
            case 79: {
                Info2.setRequiresImmediate(0, 127);
                return true;
            }
            case 89: {
                switch (((char.ptr)Name.$add(1)).$star()) {
                    default: {
                        return false;
                    }
                    case 48: 
                    case 105: 
                    case 109: 
                    case 116: 
                }
            }
            case 102: {
                if (Info2.ConstraintStr.$at(0) == NativePointer.$((char)'=')) {
                    return false;
                }
                Info2.setAllowsRegister();
                return true;
            }
            case 65: 
            case 68: 
            case 81: 
            case 82: 
            case 83: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 108: 
            case 113: 
            case 116: 
            case 117: 
            case 120: 
            case 121: {
                Info2.setAllowsRegister();
                return true;
            }
            case 67: 
            case 71: 
            case 90: 
            case 101: 
        }
        return true;
    }

    @Override
    public boolean validateOutputSize(StringRef Constraint, int Size) {
        while (Constraint.$at(0) == NativePointer.$((char)'=') || Constraint.$at(0) == NativePointer.$((char)'+') || Constraint.$at(0) == NativePointer.$((char)'&')) {
            Constraint.$assign(Constraint.substr(1));
        }
        return this.validateOperandSize(Constraint, Size);
    }

    @Override
    public boolean validateInputSize(StringRef Constraint, int Size) {
        return this.validateOperandSize(Constraint, Size);
    }

    public boolean validateOperandSize(StringRef Constraint, int Size) {
        switch (Constraint.$at(0)) {
            default: {
                break;
            }
            case 121: {
                return Size <= 64;
            }
            case 102: 
            case 116: 
            case 117: {
                return Size <= 128;
            }
            case 120: {
                return (long)Size <= (this.SSELevel.getValue() >= X86SSEEnum.AVX.getValue() ? 256L : 128L);
            }
        }
        return true;
    }

    @Override
    public std.string convertConstraint(char.ptr Constraint) {
        switch (Constraint.$star()) {
            case 97: {
                return new std.string(NativePointer.$((String)"{ax}"));
            }
            case 98: {
                return new std.string(NativePointer.$((String)"{bx}"));
            }
            case 99: {
                return new std.string(NativePointer.$((String)"{cx}"));
            }
            case 100: {
                return new std.string(NativePointer.$((String)"{dx}"));
            }
            case 83: {
                return new std.string(NativePointer.$((String)"{si}"));
            }
            case 68: {
                return new std.string(NativePointer.$((String)"{di}"));
            }
            case 112: {
                return new std.string(NativePointer.$((String)"im"));
            }
            case 116: {
                return new std.string(NativePointer.$((String)"{st}"));
            }
            case 117: {
                return new std.string(NativePointer.$((String)"{st(1)}"));
            }
        }
        return new std.string(1, Constraint.$star());
    }

    @Override
    public char.ptr getClobbers() {
        return NativePointer.$((String)"~{dirflag},~{fpsr},~{flags}");
    }

    @Override
    public void getTargetDefines(LangOptions Opts, MacroBuilder Builder) {
        if (this.getTriple().getArch() == Triple.ArchType.x86_64) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__amd64__")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__amd64")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__x86_64")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__x86_64__")));
            if (llvm.$eq_StringRef((StringRef)this.getTriple().getArchName(), (StringRef)new StringRef(NativePointer.$((String)"x86_64h")))) {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__x86_64h")));
                Builder.defineMacro(new Twine(NativePointer.$((String)"__x86_64h__")));
            }
        } else {
            TargetsStatics.DefineStd(Builder, new StringRef(NativePointer.$((String)"i386")), Opts);
        }
        switch (this.CPU) {
            case CK_Generic: {
                break;
            }
            case CK_i386: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__tune_i386__")));
                break;
            }
            case CK_i486: 
            case CK_WinChipC6: 
            case CK_WinChip2: 
            case CK_C3: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"i486")));
                break;
            }
            case CK_PentiumMMX: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__pentium_mmx__")));
                Builder.defineMacro(new Twine(NativePointer.$((String)"__tune_pentium_mmx__")));
            }
            case CK_i586: 
            case CK_Pentium: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"i586")));
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"pentium")));
                break;
            }
            case CK_Pentium3: 
            case CK_Pentium3M: 
            case CK_PentiumM: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__tune_pentium3__")));
            }
            case CK_Pentium2: 
            case CK_C3_2: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__tune_pentium2__")));
            }
            case CK_PentiumPro: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__tune_i686__")));
                Builder.defineMacro(new Twine(NativePointer.$((String)"__tune_pentiumpro__")));
            }
            case CK_i686: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__i686")));
                Builder.defineMacro(new Twine(NativePointer.$((String)"__i686__")));
                Builder.defineMacro(new Twine(NativePointer.$((String)"__pentiumpro")));
                Builder.defineMacro(new Twine(NativePointer.$((String)"__pentiumpro__")));
                break;
            }
            case CK_Pentium4: 
            case CK_Pentium4M: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"pentium4")));
                break;
            }
            case CK_Yonah: 
            case CK_Prescott: 
            case CK_Nocona: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"nocona")));
                break;
            }
            case CK_Core2: 
            case CK_Penryn: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"core2")));
                break;
            }
            case CK_Bonnell: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"atom")));
                break;
            }
            case CK_Silvermont: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"slm")));
                break;
            }
            case CK_Nehalem: 
            case CK_Westmere: 
            case CK_SandyBridge: 
            case CK_IvyBridge: 
            case CK_Haswell: 
            case CK_Broadwell: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"corei7")));
                break;
            }
            case CK_Skylake: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"skx")));
                break;
            }
            case CK_KNL: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"knl")));
                break;
            }
            case CK_K6_2: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__k6_2__")));
                Builder.defineMacro(new Twine(NativePointer.$((String)"__tune_k6_2__")));
            }
            case CK_K6_3: {
                if (this.CPU != CPUKind.CK_K6_2) {
                    Builder.defineMacro(new Twine(NativePointer.$((String)"__k6_3__")));
                    Builder.defineMacro(new Twine(NativePointer.$((String)"__tune_k6_3__")));
                }
            }
            case CK_K6: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"k6")));
                break;
            }
            case CK_Athlon: 
            case CK_AthlonThunderbird: 
            case CK_Athlon4: 
            case CK_AthlonXP: 
            case CK_AthlonMP: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"athlon")));
                if (this.SSELevel == X86SSEEnum.NoSSE) break;
                Builder.defineMacro(new Twine(NativePointer.$((String)"__athlon_sse__")));
                Builder.defineMacro(new Twine(NativePointer.$((String)"__tune_athlon_sse__")));
                break;
            }
            case CK_K8: 
            case CK_K8SSE3: 
            case CK_x86_64: 
            case CK_Opteron: 
            case CK_OpteronSSE3: 
            case CK_Athlon64: 
            case CK_Athlon64SSE3: 
            case CK_AthlonFX: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"k8")));
                break;
            }
            case CK_AMDFAM10: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"amdfam10")));
                break;
            }
            case CK_BTVER1: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"btver1")));
                break;
            }
            case CK_BTVER2: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"btver2")));
                break;
            }
            case CK_BDVER1: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"bdver1")));
                break;
            }
            case CK_BDVER2: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"bdver2")));
                break;
            }
            case CK_BDVER3: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"bdver3")));
                break;
            }
            case CK_BDVER4: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"bdver4")));
                break;
            }
            case CK_Geode: {
                TargetsStatics.defineCPUMacros(Builder, new StringRef(NativePointer.$((String)"geode")));
            }
        }
        Builder.defineMacro(new Twine(NativePointer.$((String)"__REGISTER_PREFIX__")), new Twine(NativePointer.$((String)"")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__NO_MATH_INLINES")));
        if (this.HasAES) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__AES__")));
        }
        if (this.HasPCLMUL) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__PCLMUL__")));
        }
        if (this.HasLZCNT) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__LZCNT__")));
        }
        if (this.HasRDRND) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__RDRND__")));
        }
        if (this.HasFSGSBASE) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__FSGSBASE__")));
        }
        if (this.HasBMI) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__BMI__")));
        }
        if (this.HasBMI2) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__BMI2__")));
        }
        if (this.HasPOPCNT) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__POPCNT__")));
        }
        if (this.HasRTM) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__RTM__")));
        }
        if (this.HasPRFCHW) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__PRFCHW__")));
        }
        if (this.HasRDSEED) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__RDSEED__")));
        }
        if (this.HasADX) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__ADX__")));
        }
        if (this.HasTBM) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__TBM__")));
        }
        switch (this.XOPLevel) {
            case XOP: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__XOP__")));
            }
            case FMA4: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__FMA4__")));
            }
            case SSE4A: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__SSE4A__")));
            }
        }
        if (this.HasFMA) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__FMA__")));
        }
        if (this.HasF16C) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__F16C__")));
        }
        if (this.HasAVX512CD) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__AVX512CD__")));
        }
        if (this.HasAVX512ER) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__AVX512ER__")));
        }
        if (this.HasAVX512PF) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__AVX512PF__")));
        }
        if (this.HasAVX512DQ) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__AVX512DQ__")));
        }
        if (this.HasAVX512BW) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__AVX512BW__")));
        }
        if (this.HasAVX512VL) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__AVX512VL__")));
        }
        if (this.HasSHA) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__SHA__")));
        }
        if (this.HasCX16) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GCC_HAVE_SYNC_COMPARE_AND_SWAP_16")));
        }
        switch (this.SSELevel) {
            case AVX512F: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__AVX512F__")));
            }
            case AVX2: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__AVX2__")));
            }
            case AVX: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__AVX__")));
            }
            case SSE42: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__SSE4_2__")));
            }
            case SSE41: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__SSE4_1__")));
            }
            case SSSE3: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__SSSE3__")));
            }
            case SSE3: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__SSE3__")));
            }
            case SSE2: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__SSE2__")));
                Builder.defineMacro(new Twine(NativePointer.$((String)"__SSE2_MATH__")));
            }
            case SSE1: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__SSE__")));
                Builder.defineMacro(new Twine(NativePointer.$((String)"__SSE_MATH__")));
            }
        }
        if (Opts.MicrosoftExt && this.getTriple().getArch() == Triple.ArchType.x86) {
            switch (this.SSELevel) {
                case AVX512F: 
                case AVX2: 
                case AVX: 
                case SSE42: 
                case SSE41: 
                case SSSE3: 
                case SSE3: 
                case SSE2: {
                    Builder.defineMacro(new Twine(NativePointer.$((String)"_M_IX86_FP")), new Twine(JavaDifferentiators.Int.INSTANCE, 2));
                    break;
                }
                case SSE1: {
                    Builder.defineMacro(new Twine(NativePointer.$((String)"_M_IX86_FP")), new Twine(JavaDifferentiators.Int.INSTANCE, 1));
                    break;
                }
                default: {
                    Builder.defineMacro(new Twine(NativePointer.$((String)"_M_IX86_FP")), new Twine(JavaDifferentiators.Int.INSTANCE, 0));
                }
            }
        }
        switch (this.MMX3DNowLevel) {
            case AMD3DNowAthlon: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__3dNOW_A__")));
            }
            case AMD3DNow: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__3dNOW__")));
            }
            case MMX: {
                Builder.defineMacro(new Twine(NativePointer.$((String)"__MMX__")));
            }
        }
        if (this.CPU.getValue() >= CPUKind.CK_i486.getValue()) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GCC_HAVE_SYNC_COMPARE_AND_SWAP_1")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GCC_HAVE_SYNC_COMPARE_AND_SWAP_2")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GCC_HAVE_SYNC_COMPARE_AND_SWAP_4")));
        }
        if (this.CPU.getValue() >= CPUKind.CK_i586.getValue()) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__GCC_HAVE_SYNC_COMPARE_AND_SWAP_8")));
        }
    }

    public static void setSSELevel(StringMapBool Features, X86SSEEnum Level2, boolean Enabled) {
        if (Enabled) {
            switch (Level2) {
                case AVX512F: {
                    Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"avx512f")), true);
                }
                case AVX2: {
                    Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"avx2")), true);
                }
                case AVX: {
                    Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"avx")), true);
                }
                case SSE42: {
                    Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"sse4.2")), true);
                }
                case SSE41: {
                    Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"sse4.1")), true);
                }
                case SSSE3: {
                    Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"ssse3")), true);
                }
                case SSE3: {
                    Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"sse3")), true);
                }
                case SSE2: {
                    Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"sse2")), true);
                }
                case SSE1: {
                    Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"sse")), true);
                }
            }
            return;
        }
        switch (Level2) {
            case SSE1: 
            case NoSSE: {
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"sse")), false);
            }
            case SSE2: {
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"sse2")), false);
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"pclmul")), false);
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"aes")), false);
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"sha")), false);
            }
            case SSE3: {
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"sse3")), false);
                X86TargetInfo.setXOPLevel(Features, XOPEnum.NoXOP, false);
            }
            case SSSE3: {
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"ssse3")), false);
            }
            case SSE41: {
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"sse4.1")), false);
            }
            case SSE42: {
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"sse4.2")), false);
            }
            case AVX: {
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"fma")), false);
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"avx")), false);
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"f16c")), false);
                X86TargetInfo.setXOPLevel(Features, XOPEnum.FMA4, false);
            }
            case AVX2: {
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"avx2")), false);
            }
            case AVX512F: {
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"avx512f")), false);
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"avx512cd")), false);
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"avx512er")), false);
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"avx512pf")), false);
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"avx512dq")), false);
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"avx512bw")), false);
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"avx512vl")), false);
            }
        }
    }

    public static void setMMXLevel(StringMapBool Features, MMX3DNowEnum Level2, boolean Enabled) {
        if (Enabled) {
            switch (Level2) {
                case AMD3DNowAthlon: {
                    Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"3dnowa")), true);
                }
                case AMD3DNow: {
                    Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"3dnow")), true);
                }
                case MMX: {
                    Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"mmx")), true);
                }
            }
            return;
        }
        switch (Level2) {
            case MMX: 
            case NoMMX3DNow: {
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"mmx")), false);
            }
            case AMD3DNow: {
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"3dnow")), false);
            }
            case AMD3DNowAthlon: {
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"3dnowa")), false);
            }
        }
    }

    public static void setXOPLevel(StringMapBool Features, XOPEnum Level2, boolean Enabled) {
        if (Enabled) {
            switch (Level2) {
                case XOP: {
                    Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"xop")), true);
                }
                case FMA4: {
                    Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"fma4")), true);
                    X86TargetInfo.setSSELevel(Features, X86SSEEnum.AVX, true);
                }
                case SSE4A: {
                    Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"sse4a")), true);
                    X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSE3, true);
                }
            }
            return;
        }
        switch (Level2) {
            case SSE4A: 
            case NoXOP: {
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"sse4a")), false);
            }
            case FMA4: {
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"fma4")), false);
            }
            case XOP: {
                Features.GetOrCreateValue(new StringRef(NativePointer.$((String)"xop")), false);
            }
        }
    }

    @Override
    public void setFeatureEnabled(StringMapBool Features, StringRef Name, boolean Enabled) {
        X86TargetInfo.setFeatureEnabledImpl(Features, Name, Enabled);
    }

    public static void setFeatureEnabledImpl(StringMapBool Features, StringRef Name, boolean Enabled) {
        if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"sse4")))) {
            Name.$assign(NativePointer.$((String)"sse4.2"));
        }
        Features.GetOrCreateValue(Name, Enabled);
        if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"mmx")))) {
            X86TargetInfo.setMMXLevel(Features, MMX3DNowEnum.MMX, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"sse")))) {
            X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSE1, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"sse2")))) {
            X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSE2, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"sse3")))) {
            X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSE3, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"ssse3")))) {
            X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSSE3, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"sse4.2")))) {
            X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSE42, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"sse4.1")))) {
            X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSE41, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"3dnow")))) {
            X86TargetInfo.setMMXLevel(Features, MMX3DNowEnum.AMD3DNow, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"3dnowa")))) {
            X86TargetInfo.setMMXLevel(Features, MMX3DNowEnum.AMD3DNowAthlon, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"aes")))) {
            if (Enabled) {
                X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSE2, Enabled);
            }
        } else if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"pclmul")))) {
            if (Enabled) {
                X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSE2, Enabled);
            }
        } else if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"avx")))) {
            X86TargetInfo.setSSELevel(Features, X86SSEEnum.AVX, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"avx2")))) {
            X86TargetInfo.setSSELevel(Features, X86SSEEnum.AVX2, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"avx512f")))) {
            X86TargetInfo.setSSELevel(Features, X86SSEEnum.AVX512F, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"avx512cd"))) || llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"avx512er"))) || llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"avx512pf"))) || llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"avx512dq"))) || llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"avx512bw"))) || llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"avx512vl")))) {
            if (Enabled) {
                X86TargetInfo.setSSELevel(Features, X86SSEEnum.AVX512F, Enabled);
            }
        } else if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"fma")))) {
            if (Enabled) {
                X86TargetInfo.setSSELevel(Features, X86SSEEnum.AVX, Enabled);
            }
        } else if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"fma4")))) {
            X86TargetInfo.setXOPLevel(Features, XOPEnum.FMA4, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"xop")))) {
            X86TargetInfo.setXOPLevel(Features, XOPEnum.XOP, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"sse4a")))) {
            X86TargetInfo.setXOPLevel(Features, XOPEnum.SSE4A, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"f16c")))) {
            if (Enabled) {
                X86TargetInfo.setSSELevel(Features, X86SSEEnum.AVX, Enabled);
            }
        } else if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"sha"))) && Enabled) {
            X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSE2, Enabled);
        }
    }

    @Override
    public void getDefaultFeatures(StringMapBool Features) {
        if (this.getTriple().getArch() == Triple.ArchType.x86_64) {
            X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"sse2")), true);
        }
        switch (this.CPU) {
            case CK_Generic: 
            case CK_i386: 
            case CK_i486: 
            case CK_i586: 
            case CK_Pentium: 
            case CK_PentiumPro: 
            case CK_i686: {
                break;
            }
            case CK_WinChipC6: 
            case CK_PentiumMMX: 
            case CK_Pentium2: 
            case CK_K6: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"mmx")), true);
                break;
            }
            case CK_Pentium3: 
            case CK_Pentium3M: 
            case CK_C3_2: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"sse")), true);
                break;
            }
            case CK_PentiumM: 
            case CK_Pentium4: 
            case CK_Pentium4M: 
            case CK_x86_64: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"sse2")), true);
                break;
            }
            case CK_Yonah: 
            case CK_Prescott: 
            case CK_Nocona: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"sse3")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"cx16")), true);
                break;
            }
            case CK_Core2: 
            case CK_Bonnell: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"ssse3")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"cx16")), true);
                break;
            }
            case CK_Penryn: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"sse4.1")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"cx16")), true);
                break;
            }
            case CK_Skylake: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"avx512f")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"avx512cd")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"avx512dq")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"avx512bw")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"avx512vl")), true);
            }
            case CK_Broadwell: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"rdseed")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"adx")), true);
            }
            case CK_Haswell: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"avx2")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"lzcnt")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"bmi")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"bmi2")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"rtm")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"fma")), true);
            }
            case CK_IvyBridge: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"rdrnd")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"f16c")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"fsgsbase")), true);
            }
            case CK_SandyBridge: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"avx")), true);
            }
            case CK_Silvermont: 
            case CK_Westmere: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"aes")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"pclmul")), true);
            }
            case CK_Nehalem: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"sse4.2")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"cx16")), true);
                break;
            }
            case CK_KNL: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"avx512f")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"avx512cd")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"avx512er")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"avx512pf")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"rdseed")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"adx")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"lzcnt")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"bmi")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"bmi2")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"rtm")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"fma")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"rdrnd")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"f16c")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"fsgsbase")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"aes")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"pclmul")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"cx16")), true);
                break;
            }
            case CK_WinChip2: 
            case CK_C3: 
            case CK_K6_2: 
            case CK_K6_3: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"3dnow")), true);
                break;
            }
            case CK_Athlon: 
            case CK_AthlonThunderbird: 
            case CK_Geode: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"3dnowa")), true);
                break;
            }
            case CK_Athlon4: 
            case CK_AthlonXP: 
            case CK_AthlonMP: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"sse")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"3dnowa")), true);
                break;
            }
            case CK_K8: 
            case CK_Opteron: 
            case CK_Athlon64: 
            case CK_AthlonFX: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"sse2")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"3dnowa")), true);
                break;
            }
            case CK_AMDFAM10: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"sse4a")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"lzcnt")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"popcnt")), true);
            }
            case CK_K8SSE3: 
            case CK_OpteronSSE3: 
            case CK_Athlon64SSE3: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"sse3")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"3dnowa")), true);
                break;
            }
            case CK_BTVER2: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"avx")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"aes")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"pclmul")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"bmi")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"f16c")), true);
            }
            case CK_BTVER1: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"ssse3")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"sse4a")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"lzcnt")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"popcnt")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"prfchw")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"cx16")), true);
                break;
            }
            case CK_BDVER4: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"avx2")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"bmi2")), true);
            }
            case CK_BDVER3: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"fsgsbase")), true);
            }
            case CK_BDVER2: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"bmi")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"fma")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"f16c")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"tbm")), true);
            }
            case CK_BDVER1: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"xop")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"lzcnt")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"aes")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"pclmul")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"prfchw")), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef(NativePointer.$((String)"cx16")), true);
            }
        }
    }

    @Override
    public boolean hasFeature(StringRef Feature2) {
        return (Boolean)new StringSwitch(Feature2).Case(NativePointer.$((String)"aes"), (Object)this.HasAES).Case(NativePointer.$((String)"avx"), (Object)(this.SSELevel.getValue() >= X86SSEEnum.AVX.getValue() ? 1 : 0)).Case(NativePointer.$((String)"avx2"), (Object)(this.SSELevel.getValue() >= X86SSEEnum.AVX2.getValue() ? 1 : 0)).Case(NativePointer.$((String)"avx512f"), (Object)(this.SSELevel.getValue() >= X86SSEEnum.AVX512F.getValue() ? 1 : 0)).Case(NativePointer.$((String)"avx512cd"), (Object)this.HasAVX512CD).Case(NativePointer.$((String)"avx512er"), (Object)this.HasAVX512ER).Case(NativePointer.$((String)"avx512pf"), (Object)this.HasAVX512PF).Case(NativePointer.$((String)"avx512dq"), (Object)this.HasAVX512DQ).Case(NativePointer.$((String)"avx512bw"), (Object)this.HasAVX512BW).Case(NativePointer.$((String)"avx512vl"), (Object)this.HasAVX512VL).Case(NativePointer.$((String)"bmi"), (Object)this.HasBMI).Case(NativePointer.$((String)"bmi2"), (Object)this.HasBMI2).Case(NativePointer.$((String)"cx16"), (Object)this.HasCX16).Case(NativePointer.$((String)"f16c"), (Object)this.HasF16C).Case(NativePointer.$((String)"fma"), (Object)this.HasFMA).Case(NativePointer.$((String)"fma4"), (Object)(this.XOPLevel.getValue() >= XOPEnum.FMA4.getValue() ? 1 : 0)).Case(NativePointer.$((String)"fsgsbase"), (Object)this.HasFSGSBASE).Case(NativePointer.$((String)"lzcnt"), (Object)this.HasLZCNT).Case(NativePointer.$((String)"mm3dnow"), (Object)(this.MMX3DNowLevel.getValue() >= MMX3DNowEnum.AMD3DNow.getValue() ? 1 : 0)).Case(NativePointer.$((String)"mm3dnowa"), (Object)(this.MMX3DNowLevel.getValue() >= MMX3DNowEnum.AMD3DNowAthlon.getValue() ? 1 : 0)).Case(NativePointer.$((String)"mmx"), (Object)(this.MMX3DNowLevel.getValue() >= MMX3DNowEnum.MMX.getValue() ? 1 : 0)).Case(NativePointer.$((String)"pclmul"), (Object)this.HasPCLMUL).Case(NativePointer.$((String)"popcnt"), (Object)this.HasPOPCNT).Case(NativePointer.$((String)"prfchw"), (Object)this.HasPRFCHW).Case(NativePointer.$((String)"rdrnd"), (Object)this.HasRDRND).Case(NativePointer.$((String)"rdseed"), (Object)this.HasRDSEED).Case(NativePointer.$((String)"rtm"), (Object)this.HasRTM).Case(NativePointer.$((String)"sha"), (Object)this.HasSHA).Case(NativePointer.$((String)"sse"), (Object)(this.SSELevel.getValue() >= X86SSEEnum.SSE1.getValue() ? 1 : 0)).Case(NativePointer.$((String)"sse2"), (Object)(this.SSELevel.getValue() >= X86SSEEnum.SSE2.getValue() ? 1 : 0)).Case(NativePointer.$((String)"sse3"), (Object)(this.SSELevel.getValue() >= X86SSEEnum.SSE3.getValue() ? 1 : 0)).Case(NativePointer.$((String)"ssse3"), (Object)(this.SSELevel.getValue() >= X86SSEEnum.SSSE3.getValue() ? 1 : 0)).Case(NativePointer.$((String)"sse4.1"), (Object)(this.SSELevel.getValue() >= X86SSEEnum.SSE41.getValue() ? 1 : 0)).Case(NativePointer.$((String)"sse4.2"), (Object)(this.SSELevel.getValue() >= X86SSEEnum.SSE42.getValue() ? 1 : 0)).Case(NativePointer.$((String)"sse4a"), (Object)(this.XOPLevel.getValue() >= XOPEnum.SSE4A.getValue() ? 1 : 0)).Case(NativePointer.$((String)"tbm"), (Object)this.HasTBM).Case(NativePointer.$((String)"x86"), (Object)true).Case(NativePointer.$((String)"x86_32"), (Object)(this.getTriple().getArch() == Triple.ArchType.x86 ? 1 : 0)).Case(NativePointer.$((String)"x86_64"), (Object)(this.getTriple().getArch() == Triple.ArchType.x86_64 ? 1 : 0)).Case(NativePointer.$((String)"xop"), (Object)(this.XOPLevel.getValue() >= XOPEnum.XOP.getValue() ? 1 : 0)).Default((Object)false);
    }

    @Override
    public boolean handleTargetFeatures(std.vectorString Features, DiagnosticsEngine Diags) {
        int e = Features.size();
        for (int i = 0; i != e; ++i) {
            if (Features.$at(i).$at(0) == NativePointer.$((char)'-')) continue;
            StringRef Feature2 = new StringRef(Features.$at(i)).substr(1);
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"aes")))) {
                this.HasAES = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"pclmul")))) {
                this.HasPCLMUL = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"lzcnt")))) {
                this.HasLZCNT = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"rdrnd")))) {
                this.HasRDRND = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"fsgsbase")))) {
                this.HasFSGSBASE = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"bmi")))) {
                this.HasBMI = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"bmi2")))) {
                this.HasBMI2 = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"popcnt")))) {
                this.HasPOPCNT = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"rtm")))) {
                this.HasRTM = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"prfchw")))) {
                this.HasPRFCHW = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"rdseed")))) {
                this.HasRDSEED = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"adx")))) {
                this.HasADX = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"tbm")))) {
                this.HasTBM = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"fma")))) {
                this.HasFMA = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"f16c")))) {
                this.HasF16C = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"avx512cd")))) {
                this.HasAVX512CD = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"avx512er")))) {
                this.HasAVX512ER = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"avx512pf")))) {
                this.HasAVX512PF = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"avx512dq")))) {
                this.HasAVX512DQ = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"avx512bw")))) {
                this.HasAVX512BW = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"avx512vl")))) {
                this.HasAVX512VL = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"sha")))) {
                this.HasSHA = true;
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (StringRef)new StringRef(NativePointer.$((String)"cx16")))) {
                this.HasCX16 = true;
                continue;
            }
            assert (Features.$at(i).$at(0) == 43) : "Invalid target feature!";
            X86SSEEnum Level2 = (X86SSEEnum)((Object)new StringSwitch(Feature2).Case(NativePointer.$((String)"avx512f"), (Object)X86SSEEnum.AVX512F).Case(NativePointer.$((String)"avx2"), (Object)X86SSEEnum.AVX2).Case(NativePointer.$((String)"avx"), (Object)X86SSEEnum.AVX).Case(NativePointer.$((String)"sse4.2"), (Object)X86SSEEnum.SSE42).Case(NativePointer.$((String)"sse4.1"), (Object)X86SSEEnum.SSE41).Case(NativePointer.$((String)"ssse3"), (Object)X86SSEEnum.SSSE3).Case(NativePointer.$((String)"sse3"), (Object)X86SSEEnum.SSE3).Case(NativePointer.$((String)"sse2"), (Object)X86SSEEnum.SSE2).Case(NativePointer.$((String)"sse"), (Object)X86SSEEnum.SSE1).Default((Object)X86SSEEnum.NoSSE));
            this.SSELevel = (X86SSEEnum)std.max((Enum)this.SSELevel, (Enum)Level2);
            MMX3DNowEnum ThreeDNowLevel = (MMX3DNowEnum)((Object)new StringSwitch(Feature2).Case(NativePointer.$((String)"3dnowa"), (Object)MMX3DNowEnum.AMD3DNowAthlon).Case(NativePointer.$((String)"3dnow"), (Object)MMX3DNowEnum.AMD3DNow).Case(NativePointer.$((String)"mmx"), (Object)MMX3DNowEnum.MMX).Default((Object)MMX3DNowEnum.NoMMX3DNow));
            this.MMX3DNowLevel = (MMX3DNowEnum)std.max((Enum)this.MMX3DNowLevel, (Enum)ThreeDNowLevel);
            XOPEnum XLevel = (XOPEnum)((Object)new StringSwitch(Feature2).Case(NativePointer.$((String)"xop"), (Object)XOPEnum.XOP).Case(NativePointer.$((String)"fma4"), (Object)XOPEnum.FMA4).Case(NativePointer.$((String)"sse4a"), (Object)XOPEnum.SSE4A).Default((Object)XOPEnum.NoXOP));
            this.XOPLevel = (XOPEnum)std.max((Enum)this.XOPLevel, (Enum)XLevel);
        }
        if (!this.HasPOPCNT && this.SSELevel.getValue() >= X86SSEEnum.SSE42.getValue() && !Features.contains((Object)"-popcnt")) {
            this.HasPOPCNT = true;
            Features.push_back(NativePointer.$((String)"+popcnt"));
        }
        if (!this.HasPRFCHW && this.MMX3DNowLevel.getValue() >= MMX3DNowEnum.AMD3DNow.getValue() && !Features.contains((Object)NativePointer.$((String)"-prfchw"))) {
            this.HasPRFCHW = true;
            Features.push_back(NativePointer.$((String)"+prfchw"));
        }
        if (this.FPMath == FPMathKind.FP_SSE && this.SSELevel.getValue() < X86SSEEnum.SSE1.getValue()) {
            ClangGlobals.$out_DiagnosticBuilder_char$ptr(Diags.Report(30L), NativePointer.$((String)"sse")).$destroy();
            return false;
        }
        if (this.FPMath == FPMathKind.FP_387 && this.SSELevel.getValue() >= X86SSEEnum.SSE1.getValue()) {
            ClangGlobals.$out_DiagnosticBuilder_char$ptr(Diags.Report(30L), NativePointer.$((String)"387")).$destroy();
            return false;
        }
        if (!Features.erase((Object)"-mmx") && this.SSELevel.getValue() > X86SSEEnum.NoSSE.getValue()) {
            this.MMX3DNowLevel = (MMX3DNowEnum)std.max((Enum)this.MMX3DNowLevel, (Enum)MMX3DNowEnum.MMX);
        }
        return true;
    }

    @Override
    public StringRef getABI() {
        if (this.getTriple().getArch() == Triple.ArchType.x86_64 && this.SSELevel.getValue() >= X86SSEEnum.AVX.getValue()) {
            return new StringRef(NativePointer.$((String)"avx"));
        }
        if (this.getTriple().getArch() == Triple.ArchType.x86 && this.MMX3DNowLevel == MMX3DNowEnum.NoMMX3DNow) {
            return new StringRef(NativePointer.$((String)"no-mmx"));
        }
        return StringRef.EMPTY;
    }

    @Override
    public boolean setCPU(std.string Name) {
        this.CPU = (CPUKind)((Object)new StringSwitch(new StringRef(Name)).Case(NativePointer.$((String)"i386"), (Object)CPUKind.CK_i386).Case(NativePointer.$((String)"i486"), (Object)CPUKind.CK_i486).Case(NativePointer.$((String)"winchip-c6"), (Object)CPUKind.CK_WinChipC6).Case(NativePointer.$((String)"winchip2"), (Object)CPUKind.CK_WinChip2).Case(NativePointer.$((String)"c3"), (Object)CPUKind.CK_C3).Case(NativePointer.$((String)"i586"), (Object)CPUKind.CK_i586).Case(NativePointer.$((String)"pentium"), (Object)CPUKind.CK_Pentium).Case(NativePointer.$((String)"pentium-mmx"), (Object)CPUKind.CK_PentiumMMX).Case(NativePointer.$((String)"i686"), (Object)CPUKind.CK_i686).Case(NativePointer.$((String)"pentiumpro"), (Object)CPUKind.CK_PentiumPro).Case(NativePointer.$((String)"pentium2"), (Object)CPUKind.CK_Pentium2).Case(NativePointer.$((String)"pentium3"), (Object)CPUKind.CK_Pentium3).Case(NativePointer.$((String)"pentium3m"), (Object)CPUKind.CK_Pentium3M).Case(NativePointer.$((String)"pentium-m"), (Object)CPUKind.CK_PentiumM).Case(NativePointer.$((String)"c3-2"), (Object)CPUKind.CK_C3_2).Case(NativePointer.$((String)"yonah"), (Object)CPUKind.CK_Yonah).Case(NativePointer.$((String)"pentium4"), (Object)CPUKind.CK_Pentium4).Case(NativePointer.$((String)"pentium4m"), (Object)CPUKind.CK_Pentium4M).Case(NativePointer.$((String)"prescott"), (Object)CPUKind.CK_Prescott).Case(NativePointer.$((String)"nocona"), (Object)CPUKind.CK_Nocona).Case(NativePointer.$((String)"core2"), (Object)CPUKind.CK_Core2).Case(NativePointer.$((String)"penryn"), (Object)CPUKind.CK_Penryn).Case(NativePointer.$((String)"bonnell"), (Object)CPUKind.CK_Bonnell).Case(NativePointer.$((String)"atom"), (Object)CPUKind.CK_Bonnell).Case(NativePointer.$((String)"silvermont"), (Object)CPUKind.CK_Silvermont).Case(NativePointer.$((String)"slm"), (Object)CPUKind.CK_Silvermont).Case(NativePointer.$((String)"nehalem"), (Object)CPUKind.CK_Nehalem).Case(NativePointer.$((String)"corei7"), (Object)CPUKind.CK_Nehalem).Case(NativePointer.$((String)"westmere"), (Object)CPUKind.CK_Westmere).Case(NativePointer.$((String)"sandybridge"), (Object)CPUKind.CK_SandyBridge).Case(NativePointer.$((String)"corei7-avx"), (Object)CPUKind.CK_SandyBridge).Case(NativePointer.$((String)"ivybridge"), (Object)CPUKind.CK_IvyBridge).Case(NativePointer.$((String)"core-avx-i"), (Object)CPUKind.CK_IvyBridge).Case(NativePointer.$((String)"haswell"), (Object)CPUKind.CK_Haswell).Case(NativePointer.$((String)"core-avx2"), (Object)CPUKind.CK_Haswell).Case(NativePointer.$((String)"broadwell"), (Object)CPUKind.CK_Broadwell).Case(NativePointer.$((String)"skylake"), (Object)CPUKind.CK_Skylake).Case(NativePointer.$((String)"skx"), (Object)CPUKind.CK_Skylake).Case(NativePointer.$((String)"knl"), (Object)CPUKind.CK_KNL).Case(NativePointer.$((String)"k6"), (Object)CPUKind.CK_K6).Case(NativePointer.$((String)"k6-2"), (Object)CPUKind.CK_K6_2).Case(NativePointer.$((String)"k6-3"), (Object)CPUKind.CK_K6_3).Case(NativePointer.$((String)"athlon"), (Object)CPUKind.CK_Athlon).Case(NativePointer.$((String)"athlon-tbird"), (Object)CPUKind.CK_AthlonThunderbird).Case(NativePointer.$((String)"athlon-4"), (Object)CPUKind.CK_Athlon4).Case(NativePointer.$((String)"athlon-xp"), (Object)CPUKind.CK_AthlonXP).Case(NativePointer.$((String)"athlon-mp"), (Object)CPUKind.CK_AthlonMP).Case(NativePointer.$((String)"athlon64"), (Object)CPUKind.CK_Athlon64).Case(NativePointer.$((String)"athlon64-sse3"), (Object)CPUKind.CK_Athlon64SSE3).Case(NativePointer.$((String)"athlon-fx"), (Object)CPUKind.CK_AthlonFX).Case(NativePointer.$((String)"k8"), (Object)CPUKind.CK_K8).Case(NativePointer.$((String)"k8-sse3"), (Object)CPUKind.CK_K8SSE3).Case(NativePointer.$((String)"opteron"), (Object)CPUKind.CK_Opteron).Case(NativePointer.$((String)"opteron-sse3"), (Object)CPUKind.CK_OpteronSSE3).Case(NativePointer.$((String)"barcelona"), (Object)CPUKind.CK_AMDFAM10).Case(NativePointer.$((String)"amdfam10"), (Object)CPUKind.CK_AMDFAM10).Case(NativePointer.$((String)"btver1"), (Object)CPUKind.CK_BTVER1).Case(NativePointer.$((String)"btver2"), (Object)CPUKind.CK_BTVER2).Case(NativePointer.$((String)"bdver1"), (Object)CPUKind.CK_BDVER1).Case(NativePointer.$((String)"bdver2"), (Object)CPUKind.CK_BDVER2).Case(NativePointer.$((String)"bdver3"), (Object)CPUKind.CK_BDVER3).Case(NativePointer.$((String)"bdver4"), (Object)CPUKind.CK_BDVER4).Case(NativePointer.$((String)"x86-64"), (Object)CPUKind.CK_x86_64).Case(NativePointer.$((String)"geode"), (Object)CPUKind.CK_Geode).Default((Object)CPUKind.CK_Generic));
        switch (this.CPU) {
            case CK_Generic: {
                return false;
            }
            case CK_i386: 
            case CK_i486: 
            case CK_WinChipC6: 
            case CK_WinChip2: 
            case CK_C3: 
            case CK_PentiumMMX: 
            case CK_i586: 
            case CK_Pentium: 
            case CK_Pentium3: 
            case CK_Pentium3M: 
            case CK_PentiumM: 
            case CK_Pentium2: 
            case CK_C3_2: 
            case CK_PentiumPro: 
            case CK_i686: 
            case CK_Pentium4: 
            case CK_Pentium4M: 
            case CK_Yonah: 
            case CK_Prescott: 
            case CK_K6_2: 
            case CK_K6_3: 
            case CK_K6: 
            case CK_Athlon: 
            case CK_AthlonThunderbird: 
            case CK_Athlon4: 
            case CK_AthlonXP: 
            case CK_AthlonMP: 
            case CK_Geode: {
                if (this.getTriple().getArch() != Triple.ArchType.x86) {
                    return false;
                }
            }
            case CK_Nocona: 
            case CK_Core2: 
            case CK_Penryn: 
            case CK_Bonnell: 
            case CK_Silvermont: 
            case CK_Nehalem: 
            case CK_Westmere: 
            case CK_SandyBridge: 
            case CK_IvyBridge: 
            case CK_Haswell: 
            case CK_Broadwell: 
            case CK_Skylake: 
            case CK_KNL: 
            case CK_K8: 
            case CK_K8SSE3: 
            case CK_x86_64: 
            case CK_Opteron: 
            case CK_OpteronSSE3: 
            case CK_Athlon64: 
            case CK_Athlon64SSE3: 
            case CK_AthlonFX: 
            case CK_AMDFAM10: 
            case CK_BTVER1: 
            case CK_BTVER2: 
            case CK_BDVER1: 
            case CK_BDVER2: 
            case CK_BDVER3: 
            case CK_BDVER4: {
                return true;
            }
        }
        throw new llvm_unreachable((CharSequence)"Unhandled CPU kind");
    }

    @Override
    public boolean setFPMath(StringRef Name) {
        if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"387")))) {
            this.FPMath = FPMathKind.FP_387;
            return true;
        }
        if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"sse")))) {
            this.FPMath = FPMathKind.FP_SSE;
            return true;
        }
        return false;
    }

    @Override
    public TargetInfo.CallingConvCheckResult checkCallingConvention(CallingConv CC) {
        return CC == CallingConv.CC_X86ThisCall || CC == CallingConv.CC_X86FastCall || CC == CallingConv.CC_X86StdCall || CC == CallingConv.CC_X86VectorCall || CC == CallingConv.CC_C || CC == CallingConv.CC_X86Pascal || CC == CallingConv.CC_IntelOclBicc ? TargetInfo.CallingConvCheckResult.CCCR_OK : TargetInfo.CallingConvCheckResult.CCCR_Warning;
    }

    @Override
    public CallingConv getDefaultCallingConv(TargetInfo.CallingConvMethodType MT) {
        return MT == TargetInfo.CallingConvMethodType.CCMT_Member ? CallingConv.CC_X86ThisCall : CallingConv.CC_C;
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "SSELevel=" + (Object)((Object)this.SSELevel) + ", MMX3DNowLevel=" + (Object)((Object)this.MMX3DNowLevel) + ", XOPLevel=" + (Object)((Object)this.XOPLevel) + ", HasAES=" + this.HasAES + ", HasPCLMUL=" + this.HasPCLMUL + ", HasLZCNT=" + this.HasLZCNT + ", HasRDRND=" + this.HasRDRND + ", HasFSGSBASE=" + this.HasFSGSBASE + ", HasBMI=" + this.HasBMI + ", HasBMI2=" + this.HasBMI2 + ", HasPOPCNT=" + this.HasPOPCNT + ", HasRTM=" + this.HasRTM + ", HasPRFCHW=" + this.HasPRFCHW + ", HasRDSEED=" + this.HasRDSEED + ", HasADX=" + this.HasADX + ", HasTBM=" + this.HasTBM + ", HasFMA=" + this.HasFMA + ", HasF16C=" + this.HasF16C + ", HasAVX512CD=" + this.HasAVX512CD + ", HasAVX512ER=" + this.HasAVX512ER + ", HasAVX512PF=" + this.HasAVX512PF + ", HasAVX512DQ=" + this.HasAVX512DQ + ", HasAVX512BW=" + this.HasAVX512BW + ", HasAVX512VL=" + this.HasAVX512VL + ", HasSHA=" + this.HasSHA + ", HasCX16=" + this.HasCX16 + ", CPU=" + (Object)((Object)this.CPU) + ", FPMath=" + (Object)((Object)this.FPMath) + super.toString();
    }

    private static final class FPMathKind
    extends Enum<FPMathKind> {
        public static final /* enum */ FPMathKind FP_Default = new FPMathKind(0);
        public static final /* enum */ FPMathKind FP_SSE = new FPMathKind(FP_Default.getValue() + 1);
        public static final /* enum */ FPMathKind FP_387 = new FPMathKind(FP_SSE.getValue() + 1);
        private final int value;
        private static final /* synthetic */ FPMathKind[] $VALUES;

        public static FPMathKind[] values() {
            return (FPMathKind[])$VALUES.clone();
        }

        public static FPMathKind valueOf(String name) {
            return Enum.valueOf(FPMathKind.class, name);
        }

        public static FPMathKind valueOf(int val) {
            FPMathKind out;
            FPMathKind fPMathKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private FPMathKind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new FPMathKind[]{FP_Default, FP_SSE, FP_387};
        }

        private static final class Values {
            private static final FPMathKind[] VALUES;
            private static final FPMathKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (FPMathKind kind : FPMathKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new FPMathKind[min < 0 ? 1 - min : 0];
                VALUES = new FPMathKind[max >= 0 ? 1 + max : 0];
                for (FPMathKind kind : FPMathKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((FPMathKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((FPMathKind)kind).value] = kind;
                }
            }
        }
    }

    private static final class CPUKind
    extends Enum<CPUKind> {
        public static final /* enum */ CPUKind CK_Generic = new CPUKind(0);
        public static final /* enum */ CPUKind CK_i386 = new CPUKind(CK_Generic.getValue() + 1);
        public static final /* enum */ CPUKind CK_i486 = new CPUKind(CK_i386.getValue() + 1);
        public static final /* enum */ CPUKind CK_WinChipC6 = new CPUKind(CK_i486.getValue() + 1);
        public static final /* enum */ CPUKind CK_WinChip2 = new CPUKind(CK_WinChipC6.getValue() + 1);
        public static final /* enum */ CPUKind CK_C3 = new CPUKind(CK_WinChip2.getValue() + 1);
        public static final /* enum */ CPUKind CK_i586 = new CPUKind(CK_C3.getValue() + 1);
        public static final /* enum */ CPUKind CK_Pentium = new CPUKind(CK_i586.getValue() + 1);
        public static final /* enum */ CPUKind CK_PentiumMMX = new CPUKind(CK_Pentium.getValue() + 1);
        public static final /* enum */ CPUKind CK_i686 = new CPUKind(CK_PentiumMMX.getValue() + 1);
        public static final /* enum */ CPUKind CK_PentiumPro = new CPUKind(CK_i686.getValue() + 1);
        public static final /* enum */ CPUKind CK_Pentium2 = new CPUKind(CK_PentiumPro.getValue() + 1);
        public static final /* enum */ CPUKind CK_Pentium3 = new CPUKind(CK_Pentium2.getValue() + 1);
        public static final /* enum */ CPUKind CK_Pentium3M = new CPUKind(CK_Pentium3.getValue() + 1);
        public static final /* enum */ CPUKind CK_PentiumM = new CPUKind(CK_Pentium3M.getValue() + 1);
        public static final /* enum */ CPUKind CK_C3_2 = new CPUKind(CK_PentiumM.getValue() + 1);
        public static final /* enum */ CPUKind CK_Yonah = new CPUKind(CK_C3_2.getValue() + 1);
        public static final /* enum */ CPUKind CK_Pentium4 = new CPUKind(CK_Yonah.getValue() + 1);
        public static final /* enum */ CPUKind CK_Pentium4M = new CPUKind(CK_Pentium4.getValue() + 1);
        public static final /* enum */ CPUKind CK_Prescott = new CPUKind(CK_Pentium4M.getValue() + 1);
        public static final /* enum */ CPUKind CK_Nocona = new CPUKind(CK_Prescott.getValue() + 1);
        public static final /* enum */ CPUKind CK_Core2 = new CPUKind(CK_Nocona.getValue() + 1);
        public static final /* enum */ CPUKind CK_Penryn = new CPUKind(CK_Core2.getValue() + 1);
        public static final /* enum */ CPUKind CK_Bonnell = new CPUKind(CK_Penryn.getValue() + 1);
        public static final /* enum */ CPUKind CK_Silvermont = new CPUKind(CK_Bonnell.getValue() + 1);
        public static final /* enum */ CPUKind CK_Nehalem = new CPUKind(CK_Silvermont.getValue() + 1);
        public static final /* enum */ CPUKind CK_Westmere = new CPUKind(CK_Nehalem.getValue() + 1);
        public static final /* enum */ CPUKind CK_SandyBridge = new CPUKind(CK_Westmere.getValue() + 1);
        public static final /* enum */ CPUKind CK_IvyBridge = new CPUKind(CK_SandyBridge.getValue() + 1);
        public static final /* enum */ CPUKind CK_Haswell = new CPUKind(CK_IvyBridge.getValue() + 1);
        public static final /* enum */ CPUKind CK_Broadwell = new CPUKind(CK_Haswell.getValue() + 1);
        public static final /* enum */ CPUKind CK_Skylake = new CPUKind(CK_Broadwell.getValue() + 1);
        public static final /* enum */ CPUKind CK_KNL = new CPUKind(CK_Skylake.getValue() + 1);
        public static final /* enum */ CPUKind CK_K6 = new CPUKind(CK_KNL.getValue() + 1);
        public static final /* enum */ CPUKind CK_K6_2 = new CPUKind(CK_K6.getValue() + 1);
        public static final /* enum */ CPUKind CK_K6_3 = new CPUKind(CK_K6_2.getValue() + 1);
        public static final /* enum */ CPUKind CK_Athlon = new CPUKind(CK_K6_3.getValue() + 1);
        public static final /* enum */ CPUKind CK_AthlonThunderbird = new CPUKind(CK_Athlon.getValue() + 1);
        public static final /* enum */ CPUKind CK_Athlon4 = new CPUKind(CK_AthlonThunderbird.getValue() + 1);
        public static final /* enum */ CPUKind CK_AthlonXP = new CPUKind(CK_Athlon4.getValue() + 1);
        public static final /* enum */ CPUKind CK_AthlonMP = new CPUKind(CK_AthlonXP.getValue() + 1);
        public static final /* enum */ CPUKind CK_Athlon64 = new CPUKind(CK_AthlonMP.getValue() + 1);
        public static final /* enum */ CPUKind CK_Athlon64SSE3 = new CPUKind(CK_Athlon64.getValue() + 1);
        public static final /* enum */ CPUKind CK_AthlonFX = new CPUKind(CK_Athlon64SSE3.getValue() + 1);
        public static final /* enum */ CPUKind CK_K8 = new CPUKind(CK_AthlonFX.getValue() + 1);
        public static final /* enum */ CPUKind CK_K8SSE3 = new CPUKind(CK_K8.getValue() + 1);
        public static final /* enum */ CPUKind CK_Opteron = new CPUKind(CK_K8SSE3.getValue() + 1);
        public static final /* enum */ CPUKind CK_OpteronSSE3 = new CPUKind(CK_Opteron.getValue() + 1);
        public static final /* enum */ CPUKind CK_AMDFAM10 = new CPUKind(CK_OpteronSSE3.getValue() + 1);
        public static final /* enum */ CPUKind CK_BTVER1 = new CPUKind(CK_AMDFAM10.getValue() + 1);
        public static final /* enum */ CPUKind CK_BTVER2 = new CPUKind(CK_BTVER1.getValue() + 1);
        public static final /* enum */ CPUKind CK_BDVER1 = new CPUKind(CK_BTVER2.getValue() + 1);
        public static final /* enum */ CPUKind CK_BDVER2 = new CPUKind(CK_BDVER1.getValue() + 1);
        public static final /* enum */ CPUKind CK_BDVER3 = new CPUKind(CK_BDVER2.getValue() + 1);
        public static final /* enum */ CPUKind CK_BDVER4 = new CPUKind(CK_BDVER3.getValue() + 1);
        public static final /* enum */ CPUKind CK_x86_64 = new CPUKind(CK_BDVER4.getValue() + 1);
        public static final /* enum */ CPUKind CK_Geode = new CPUKind(CK_x86_64.getValue() + 1);
        private final int value;
        private static final /* synthetic */ CPUKind[] $VALUES;

        public static CPUKind[] values() {
            return (CPUKind[])$VALUES.clone();
        }

        public static CPUKind valueOf(String name) {
            return Enum.valueOf(CPUKind.class, name);
        }

        public static CPUKind valueOf(int val) {
            CPUKind out;
            CPUKind cPUKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private CPUKind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new CPUKind[]{CK_Generic, CK_i386, CK_i486, CK_WinChipC6, CK_WinChip2, CK_C3, CK_i586, CK_Pentium, CK_PentiumMMX, CK_i686, CK_PentiumPro, CK_Pentium2, CK_Pentium3, CK_Pentium3M, CK_PentiumM, CK_C3_2, CK_Yonah, CK_Pentium4, CK_Pentium4M, CK_Prescott, CK_Nocona, CK_Core2, CK_Penryn, CK_Bonnell, CK_Silvermont, CK_Nehalem, CK_Westmere, CK_SandyBridge, CK_IvyBridge, CK_Haswell, CK_Broadwell, CK_Skylake, CK_KNL, CK_K6, CK_K6_2, CK_K6_3, CK_Athlon, CK_AthlonThunderbird, CK_Athlon4, CK_AthlonXP, CK_AthlonMP, CK_Athlon64, CK_Athlon64SSE3, CK_AthlonFX, CK_K8, CK_K8SSE3, CK_Opteron, CK_OpteronSSE3, CK_AMDFAM10, CK_BTVER1, CK_BTVER2, CK_BDVER1, CK_BDVER2, CK_BDVER3, CK_BDVER4, CK_x86_64, CK_Geode};
        }

        private static final class Values {
            private static final CPUKind[] VALUES;
            private static final CPUKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (CPUKind kind : CPUKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new CPUKind[min < 0 ? 1 - min : 0];
                VALUES = new CPUKind[max >= 0 ? 1 + max : 0];
                for (CPUKind kind : CPUKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((CPUKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((CPUKind)kind).value] = kind;
                }
            }
        }
    }

    private static final class XOPEnum
    extends Enum<XOPEnum> {
        public static final /* enum */ XOPEnum NoXOP = new XOPEnum(0);
        public static final /* enum */ XOPEnum SSE4A = new XOPEnum(NoXOP.getValue() + 1);
        public static final /* enum */ XOPEnum FMA4 = new XOPEnum(SSE4A.getValue() + 1);
        public static final /* enum */ XOPEnum XOP = new XOPEnum(FMA4.getValue() + 1);
        private final int value;
        private static final /* synthetic */ XOPEnum[] $VALUES;

        public static XOPEnum[] values() {
            return (XOPEnum[])$VALUES.clone();
        }

        public static XOPEnum valueOf(String name) {
            return Enum.valueOf(XOPEnum.class, name);
        }

        public static XOPEnum valueOf(int val) {
            XOPEnum out;
            XOPEnum xOPEnum = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private XOPEnum(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new XOPEnum[]{NoXOP, SSE4A, FMA4, XOP};
        }

        private static final class Values {
            private static final XOPEnum[] VALUES;
            private static final XOPEnum[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (XOPEnum kind : XOPEnum.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new XOPEnum[min < 0 ? 1 - min : 0];
                VALUES = new XOPEnum[max >= 0 ? 1 + max : 0];
                for (XOPEnum kind : XOPEnum.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((XOPEnum)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((XOPEnum)kind).value] = kind;
                }
            }
        }
    }

    private static final class MMX3DNowEnum
    extends Enum<MMX3DNowEnum> {
        public static final /* enum */ MMX3DNowEnum NoMMX3DNow = new MMX3DNowEnum(0);
        public static final /* enum */ MMX3DNowEnum MMX = new MMX3DNowEnum(NoMMX3DNow.getValue() + 1);
        public static final /* enum */ MMX3DNowEnum AMD3DNow = new MMX3DNowEnum(MMX.getValue() + 1);
        public static final /* enum */ MMX3DNowEnum AMD3DNowAthlon = new MMX3DNowEnum(AMD3DNow.getValue() + 1);
        private final int value;
        private static final /* synthetic */ MMX3DNowEnum[] $VALUES;

        public static MMX3DNowEnum[] values() {
            return (MMX3DNowEnum[])$VALUES.clone();
        }

        public static MMX3DNowEnum valueOf(String name) {
            return Enum.valueOf(MMX3DNowEnum.class, name);
        }

        public static MMX3DNowEnum valueOf(int val) {
            MMX3DNowEnum out;
            MMX3DNowEnum mMX3DNowEnum = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private MMX3DNowEnum(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new MMX3DNowEnum[]{NoMMX3DNow, MMX, AMD3DNow, AMD3DNowAthlon};
        }

        private static final class Values {
            private static final MMX3DNowEnum[] VALUES;
            private static final MMX3DNowEnum[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (MMX3DNowEnum kind : MMX3DNowEnum.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new MMX3DNowEnum[min < 0 ? 1 - min : 0];
                VALUES = new MMX3DNowEnum[max >= 0 ? 1 + max : 0];
                for (MMX3DNowEnum kind : MMX3DNowEnum.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((MMX3DNowEnum)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((MMX3DNowEnum)kind).value] = kind;
                }
            }
        }
    }

    private static final class X86SSEEnum
    extends Enum<X86SSEEnum> {
        public static final /* enum */ X86SSEEnum NoSSE = new X86SSEEnum(0);
        public static final /* enum */ X86SSEEnum SSE1 = new X86SSEEnum(NoSSE.getValue() + 1);
        public static final /* enum */ X86SSEEnum SSE2 = new X86SSEEnum(SSE1.getValue() + 1);
        public static final /* enum */ X86SSEEnum SSE3 = new X86SSEEnum(SSE2.getValue() + 1);
        public static final /* enum */ X86SSEEnum SSSE3 = new X86SSEEnum(SSE3.getValue() + 1);
        public static final /* enum */ X86SSEEnum SSE41 = new X86SSEEnum(SSSE3.getValue() + 1);
        public static final /* enum */ X86SSEEnum SSE42 = new X86SSEEnum(SSE41.getValue() + 1);
        public static final /* enum */ X86SSEEnum AVX = new X86SSEEnum(SSE42.getValue() + 1);
        public static final /* enum */ X86SSEEnum AVX2 = new X86SSEEnum(AVX.getValue() + 1);
        public static final /* enum */ X86SSEEnum AVX512F = new X86SSEEnum(AVX2.getValue() + 1);
        private final int value;
        private static final /* synthetic */ X86SSEEnum[] $VALUES;

        public static X86SSEEnum[] values() {
            return (X86SSEEnum[])$VALUES.clone();
        }

        public static X86SSEEnum valueOf(String name) {
            return Enum.valueOf(X86SSEEnum.class, name);
        }

        public static X86SSEEnum valueOf(int val) {
            X86SSEEnum out;
            X86SSEEnum x86SSEEnum = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private X86SSEEnum(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new X86SSEEnum[]{NoSSE, SSE1, SSE2, SSE3, SSSE3, SSE41, SSE42, AVX, AVX2, AVX512F};
        }

        private static final class Values {
            private static final X86SSEEnum[] VALUES;
            private static final X86SSEEnum[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (X86SSEEnum kind : X86SSEEnum.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new X86SSEEnum[min < 0 ? 1 - min : 0];
                VALUES = new X86SSEEnum[max >= 0 ? 1 + max : 0];
                for (X86SSEEnum kind : X86SSEEnum.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((X86SSEEnum)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((X86SSEEnum)kind).value] = kind;
                }
            }
        }
    }
}

