/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.CallingConv;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.impl.X86TargetInfo;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.Triple;

public class X86_64TargetInfo
extends X86TargetInfo {
    public X86_64TargetInfo(Triple _Triple) {
        super(_Triple);
        boolean IsX32 = this.getTriple().getEnvironment() == Triple.EnvironmentType.GNUX32;
        this.PointerWidth = this.PointerAlign = (short)(IsX32 ? 32 : 64);
        this.LongAlign = this.PointerAlign;
        this.LongWidth = this.PointerAlign;
        this.LongDoubleWidth = (short)128;
        this.LongDoubleAlign = (short)128;
        this.LargeArrayMinWidth = (short)128;
        this.LargeArrayAlign = (short)128;
        this.SuitableAlign = (short)128;
        this.SizeType = IsX32 ? TargetInfo.IntType.UnsignedInt : TargetInfo.IntType.UnsignedLong;
        this.PtrDiffType = IsX32 ? TargetInfo.IntType.SignedInt : TargetInfo.IntType.SignedLong;
        this.IntPtrType = IsX32 ? TargetInfo.IntType.SignedInt : TargetInfo.IntType.SignedLong;
        this.IntMaxType = IsX32 ? TargetInfo.IntType.SignedLongLong : TargetInfo.IntType.SignedLong;
        this.Int64Type = IsX32 ? TargetInfo.IntType.SignedLongLong : TargetInfo.IntType.SignedLong;
        this.RegParmMax = (short)6;
        this.DescriptionString = Native.$tryClone((char.ptr)(IsX32 ? NativePointer.$((String)"e-m:e-p:32:32-i64:64-f80:128-n8:16:32:64-S128") : NativePointer.$((String)"e-m:e-i64:64-f80:128-n8:16:32:64-S128")));
        this.RealTypeUsesObjCFPRet = (byte)(1 << TargetInfo.RealType.LongDouble.getValue());
        this.ComplexLongDoubleUsesFP2Ret = true;
        this.MaxAtomicPromoteWidth = (short)128;
        this.MaxAtomicInlineWidth = (short)128;
    }

    @Override
    public TargetInfo.BuiltinVaListKind getBuiltinVaListKind() {
        return TargetInfo.BuiltinVaListKind.X86_64ABIBuiltinVaList;
    }

    @Override
    public int getEHDataRegisterNumber(int RegNo) {
        if (RegNo == 0) {
            return 0;
        }
        if (RegNo == 1) {
            return 1;
        }
        return -1;
    }

    @Override
    public TargetInfo.CallingConvCheckResult checkCallingConvention(CallingConv CC) {
        return CC == CallingConv.CC_C || CC == CallingConv.CC_X86VectorCall || CC == CallingConv.CC_IntelOclBicc || CC == CallingConv.CC_X86_64Win64 ? TargetInfo.CallingConvCheckResult.CCCR_OK : TargetInfo.CallingConvCheckResult.CCCR_Warning;
    }

    @Override
    public CallingConv getDefaultCallingConv(TargetInfo.CallingConvMethodType MT) {
        return CallingConv.CC_C;
    }

    @Override
    public boolean hasInt128Type() {
        return true;
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

