/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.impl;

import java.awt.Image;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.callgraph.api.Function;
import org.netbeans.modules.cnd.callgraph.impl.CallChildren;
import org.netbeans.modules.cnd.callgraph.impl.CallGraphState;
import org.netbeans.modules.cnd.callgraph.impl.CallNode;
import org.netbeans.modules.cnd.callgraph.impl.GoToReferenceAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

public class FunctionRootNode
extends AbstractNode
implements Comparable<FunctionRootNode> {
    private final Function object;
    private final CallGraphState model;
    private final boolean isCalls;
    private volatile Image image;
    private static final RequestProcessor RP = new RequestProcessor("Call Graph icon updater", 1);

    public FunctionRootNode(Function element, CallGraphState model, boolean isCalls) {
        super((Children)new CallChildren(element, model, isCalls));
        this.object = element;
        this.model = model;
        this.isCalls = isCalls;
        this.setName(element.getName());
        model.addFunctionToScene(element);
    }

    public String getShortDescription() {
        return this.object.getDescription();
    }

    public String getHtmlDisplayName() {
        return this.object.getHtmlDisplayName();
    }

    public Image getIcon(int param) {
        Image res = this.image;
        if (res != null) {
            return res;
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                if (SwingUtilities.isEventDispatchThread()) {
                    FunctionRootNode.this.fireIconChange();
                    FunctionRootNode.this.fireOpenedIconChange();
                } else {
                    Image icon = FunctionRootNode.this.object.getIcon();
                    FunctionRootNode.this.image = FunctionRootNode.this.mergeBadge(icon);
                    SwingUtilities.invokeLater(this);
                }
            }
        });
        res = super.getIcon(param);
        return this.mergeBadge(res);
    }

    private Image mergeBadge(Image original) {
        if (this.isCalls) {
            return ImageUtilities.mergeImages((Image)original, (Image)CallNode.downBadge, (int)0, (int)0);
        }
        return original;
    }

    public Image getOpenedIcon(int param) {
        return this.getIcon(param);
    }

    public Action getPreferredAction() {
        return new GoToReferenceAction(this.object, 0);
    }

    public Action[] getActions(boolean context) {
        Action action = this.getPreferredAction();
        if (action != null) {
            ArrayList<Action> actions = new ArrayList<Action>();
            actions.add(action);
            actions.add(null);
            for (Action a : this.model.getActions()) {
                actions.add(a);
            }
            return actions.toArray(new Action[actions.size()]);
        }
        return this.model.getActions();
    }

    Function getFunction() {
        return this.object;
    }

    @Override
    public int compareTo(FunctionRootNode o) {
        return this.getFunction().getName().compareTo(o.getFunction().getName());
    }
}

