/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils;

import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.dlight.libs.common.DLightLibsCommonLogger;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;

public class CndUtils {
    private static final Logger LOG = Logger.getLogger("cnd.logger");
    private static boolean releaseMode;
    private static volatile Throwable lastAssertion;
    private static final ConcurrentHashMap<CharSequence, AtomicInteger> restrictLog;

    private CndUtils() {
    }

    public static boolean isStandalone() {
        if ("true".equals(System.getProperty("cnd.command.line.utility"))) {
            return true;
        }
        if (CndUtils.getBoolean("java.awt.headless", false)) {
            return true;
        }
        return !CndUtils.class.getClassLoader().getClass().getName().startsWith("org.netbeans.");
    }

    public static boolean isReleaseMode() {
        return releaseMode;
    }

    public static boolean isDebugMode() {
        return !CndUtils.isReleaseMode();
    }

    public static boolean isUnitTestMode() {
        return Boolean.getBoolean("cnd.mode.unittest");
    }

    public static boolean isCodeCompletionUnitTestMode() {
        return Boolean.getBoolean("cnd.mode.completion.unittest");
    }

    public static boolean getBoolean(String name, boolean result) {
        String text = System.getProperty(name);
        if (text != null) {
            result = Boolean.parseBoolean(text);
        }
        return result;
    }

    public static void threadsDump() {
        Set<Map.Entry<Thread, StackTraceElement[]>> stack = Thread.getAllStackTraces().entrySet();
        System.err.println("-----Start Thread Dump-----");
        for (Map.Entry<Thread, StackTraceElement[]> entry : stack) {
            System.err.println(entry.getKey().getName());
            for (StackTraceElement element : entry.getValue()) {
                System.err.println("\tat " + element.toString());
            }
            System.err.println();
        }
        System.err.println("-----End Thread Dump-----");
    }

    public static void assertTrue(boolean value) {
        if (!value && CndUtils.isDebugMode()) {
            CndUtils.severe("Assertion error");
        }
    }

    public static void assertNotNull(Object object, String message) {
        if (object == null && CndUtils.isDebugMode()) {
            CndUtils.severe(message);
        }
    }

    public static void assertUnconditional(String message) {
        if (CndUtils.isDebugMode()) {
            CndUtils.severe(message);
        }
    }

    public static void assertNotNull(Object object, CharSequence prefix, Object message) {
        if (object == null && CndUtils.isDebugMode()) {
            CndUtils.severe(prefix.toString() + message);
        }
    }

    public static void assertNotNullInConsole(Object object, String message) {
        if (object == null && CndUtils.isDebugMode()) {
            CndUtils.info(message);
        }
    }

    public static void assertNull(Object object, String message) {
        if (object != null && CndUtils.isDebugMode()) {
            CndUtils.severe(message);
        }
    }

    public static int getNumberCndWorkerThreads() {
        int threadCount = Math.min(4, Runtime.getRuntime().availableProcessors() - 2);
        if (System.getProperty("cnd.modelimpl.parser.threads") != null) {
            threadCount = Integer.getInteger("cnd.modelimpl.parser.threads");
        }
        return Math.max(threadCount, 1);
    }

    public static int getConcurrencyLevel() {
        return CndUtils.getNumberCndWorkerThreads();
    }

    public static void assertFalse(boolean value) {
        if (value && CndUtils.isDebugMode()) {
            CndUtils.severe("Assertion error");
        }
    }

    public static void assertFalse(boolean value, String message) {
        CndUtils.assertTrue(!value, message);
    }

    public static void assertTrue(boolean value, String message) {
        if (CndUtils.isDebugMode() && !value) {
            CndUtils.severe(message);
        }
    }

    private static String addThreadName(String msg) {
        return msg + "\n@[" + Thread.currentThread().getName() + "]";
    }

    public static void assertTrue(boolean value, String prefix, Object message) {
        if (CndUtils.isDebugMode() && !value) {
            lastAssertion = new Exception(CndUtils.addThreadName(prefix + message));
            CndUtils.printStackTraceOnce(lastAssertion);
        }
    }

    public static void severe(Exception exception) {
        lastAssertion = exception;
        LOG.log(Level.SEVERE, exception.getMessage(), lastAssertion);
    }

    private static void severe(String message) {
        lastAssertion = new Exception(CndUtils.addThreadName(message));
        LOG.log(Level.SEVERE, message, lastAssertion);
    }

    private static void info(String message) {
        if (LOG.isLoggable(Level.INFO)) {
            lastAssertion = new Exception(CndUtils.addThreadName(message));
            LOG.log(Level.INFO, message, lastAssertion);
        }
    }

    public static void assertTrueInConsole(boolean value, String message) {
        if (CndUtils.isDebugMode() && !value && LOG.isLoggable(Level.INFO)) {
            StackTraceElement[] stackTrace;
            Exception exception = new Exception(CndUtils.addThreadName(message));
            Level level = Level.INFO;
            for (StackTraceElement element : stackTrace = exception.getStackTrace()) {
                int i;
                AtomicInteger counter;
                String className = element.getClassName();
                if (className.contains(".CndUtils")) continue;
                int lineNumber = element.getLineNumber();
                CharSequence key = CharSequences.create((CharSequence)(className + "-" + lineNumber));
                AtomicInteger old = restrictLog.putIfAbsent(key, counter = new AtomicInteger());
                if (old != null) {
                    counter = old;
                }
                if ((i = counter.incrementAndGet()) <= 3) break;
                level = Level.FINE;
                break;
            }
            lastAssertion = exception;
            LOG.log(level, message, exception);
        }
    }

    private static boolean pathsEqual(CharSequence path1, CharSequence path2) {
        if (path1 == null) {
            return path2 == null;
        }
        if (path2 == null) {
            return false;
        }
        if (path1 == path2) {
            return true;
        }
        int len = path1.length();
        if (len == path2.length()) {
            for (int i = len - 1; i >= 0; --i) {
                char c1 = path1.charAt(i);
                char c2 = path2.charAt(i);
                if (!(c1 == '/' || c1 == '\\' ? c2 != '/' && c2 != '\\' : c1 != c2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void assertPathsEqualInConsole(CharSequence path1, CharSequence path2, String format, Object ... args) {
        if (CndUtils.isDebugMode() && !CndUtils.pathsEqual(path1, path2)) {
            String text = MessageFormat.format(format, args);
            CndUtils.assertTrueInConsole(false, text);
        }
    }

    public static void assertTrueInConsole(boolean value, String prefix, Object message) {
        if (CndUtils.isDebugMode() && !value && LOG.isLoggable(Level.INFO)) {
            CndUtils.assertTrueInConsole(value, prefix + message);
        }
    }

    public static Throwable getLastAssertion() {
        return lastAssertion;
    }

    public static void clearLastAssertion() {
        lastAssertion = null;
    }

    public static void assertAbsolutePathInConsole(String path) {
        if (CndUtils.isDebugMode() && !CndPathUtilities.isPathAbsolute(path)) {
            CndUtils.assertTrueInConsole(false, "path must be absolute " + path);
        }
    }

    public static void assertAbsolutePathInConsole(String path, String message) {
        if (CndUtils.isDebugMode() && !CndPathUtilities.isPathAbsolute(path)) {
            CndUtils.assertTrueInConsole(false, message + ' ' + path);
        }
    }

    public static void assertAbsoluteFileInConsole(File file) {
        CndUtils.assertAbsoluteFileInConsole(file, "Absolute path should be used");
    }

    public static void assertAbsoluteFileInConsole(File file, String message) {
        if (CndUtils.isDebugMode() && !file.isAbsolute()) {
            CndUtils.assertTrueInConsole(false, message + ' ' + file.getPath());
        }
    }

    public static void printStackTraceOnce(Throwable exception, int stackCompareSize) {
        DLightLibsCommonLogger.printStackTraceOnce((Throwable)exception, (Level)Level.INFO, (boolean)true, (int)stackCompareSize);
    }

    public static void printStackTraceOnce(Throwable exception) {
        DLightLibsCommonLogger.printStackTraceOnce((Throwable)exception, (Level)Level.INFO, (boolean)true);
    }

    public static void assertNonUiThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            DLightLibsCommonLogger.assertNonUiThreadOnce((Level)Level.INFO);
        }
    }

    public static void assertUiThread() {
        CndUtils.assertTrue(SwingUtilities.isEventDispatchThread(), "Should be called only from UI thread");
    }

    public static void assertNormalized(File file) {
        File normFile;
        if (CndUtils.isDebugMode() && !file.equals(normFile = CndFileUtils.normalizeFile(file))) {
            CndUtils.assertTrueInConsole(false, "Parameter file was not normalized. Was " + file + " instead of " + normFile);
        }
    }

    public static void assertNormalized(FileSystem fs, CharSequence absPath) {
        String normFile;
        if (CndUtils.isDebugMode() && !(normFile = CndFileUtils.normalizeAbsolutePath(fs, absPath.toString())).contentEquals(absPath)) {
            CndUtils.assertTrueInConsole(false, "Parameter file was not normalized. Was " + absPath + " instead of " + normFile);
        }
    }

    public static Logger getLogger() {
        return LOG;
    }

    static {
        String text = System.getProperty("cnd.release.mode");
        if (text == null) {
            releaseMode = true;
            if (!$assertionsDisabled) {
                releaseMode = false;
                if (false) {
                    throw new AssertionError();
                }
            }
        } else {
            releaseMode = Boolean.parseBoolean(text);
        }
        restrictLog = new ConcurrentHashMap();
    }
}

