/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.filters;

import java.io.File;
import org.netbeans.modules.cnd.utils.FileAndFileObjectFilter;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class MakefileFileFilter
extends FileAndFileObjectFilter {
    private static final String[] suffixes = new String[]{"mk", "Makefile", "makefile"};
    private static MakefileFileFilter instance = null;

    public static MakefileFileFilter getInstance() {
        if (instance == null) {
            instance = new MakefileFileFilter();
        }
        return instance;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(MakefileFileFilter.class, (String)"FILECHOOSER_MAKEFILE_FILEFILTER");
    }

    @Override
    protected boolean mimeAccept(File f) {
        return this.checkMakefileName(f.getName());
    }

    @Override
    protected boolean mimeAccept(FileObject f) {
        return this.checkMakefileName(f.getNameExt());
    }

    private boolean checkMakefileName(String name) {
        return name.indexOf("Makefile") >= 0 || name.indexOf("makefile") >= 0;
    }

    @Override
    protected String[] getSuffixes() {
        return suffixes;
    }
}

