/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.clientlib;

import com.sun.javacard.apduio.Apdu;
import com.sun.javacard.apduio.CadClientInterface;
import com.sun.javacard.apduio.CadDevice;
import com.sun.javacard.clientlib.CardAccessor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Enumeration;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class ApduIOCardAccessor
implements CardAccessor {
    static boolean debug = false;
    private static ResourceBundle _messages = PropertyResourceBundle.getBundle("com/sun/javacard/clientlib/MessagesBundle");
    private ResourceBundle params = ResourceBundle.getBundle("jcclient");
    protected CadClientInterface cad;
    private static String[] dig = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public ApduIOCardAccessor() throws Exception {
        Object object;
        String string = this.params.getString("connection");
        if (string.equals("TCP")) {
            object = this.params.getString("TCP_HOST");
            int n = Integer.parseInt(this.params.getString("TCP_PORT"));
            Socket socket = new Socket((String)object, n);
            socket.setTcpNoDelay(true);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
            byte by = 0;
            if (this.params.getString("protocol").equals("T0")) {
                by = 0;
            } else if (this.params.getString("protocol").equals("T1")) {
                by = 1;
            } else {
                throw new Exception(_messages.getString("error.1"));
            }
            this.cad = CadDevice.getCadClientInstance(by, bufferedInputStream, bufferedOutputStream);
        } else if (string.equals("SERIAL")) {
            byte by = 0;
            if (this.params.getString("protocol").equals("T0")) {
                by = 0;
            } else if (this.params.getString("protocol").equals("T1")) {
                by = 1;
            } else {
                throw new Exception(_messages.getString("error.2"));
            }
            this.cad = ApduIOCardAccessor.connectToSerialPort(this.params.getString("SERIAL_PORT"), by);
        } else if (string.equals("PCSC")) {
            System.out.println(_messages.getString("pcsc.1"));
            this.cad = CadDevice.getCadClientInstance((byte)-85, null, null);
        } else {
            throw new Exception(_messages.getString("error.3"));
        }
        object = this.cad.powerUp();
    }

    @Override
    public byte[] exchangeAPDU(byte[] byArray) throws IOException {
        try {
            Apdu apdu = ApduIOCardAccessor.cAPDUtoCrefapdu(byArray);
            if (debug) {
                System.out.println(apdu);
            }
            this.cad.exchangeApdu(apdu);
            byte[] byArray2 = apdu.getResponseApduBytes();
            if (debug) {
                System.out.println(apdu);
            }
            int n = apdu.getLe() + 2;
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray2, byArray2.length - n, byArray3, 0, n);
            byte by = byArray3[byArray3.length - 2];
            byte by2 = byArray3[byArray3.length - 1];
            System.arraycopy(byArray3, 0, byArray3, 2, byArray3.length - 2);
            byArray3[0] = by;
            byArray3[1] = by2;
            if (debug) {
                for (int i = 0; i < byArray3.length; ++i) {
                    System.out.print(Integer.toHexString(byArray3[i] & 0xFF) + " ");
                }
                System.out.println();
                System.out.println();
            }
            return byArray3;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception);
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    public void closeCard() throws Exception {
        this.cad.powerDown(true);
    }

    private static Apdu cAPDUtoCrefapdu(byte[] byArray) {
        Apdu apdu = new Apdu();
        System.arraycopy(byArray, 0, apdu.command, 0, 4);
        if (byArray.length != 4) {
            if (byArray.length == 5) {
                int n = byArray[4] & 0xFF;
                if (n == 0) {
                    n = 256;
                }
                apdu.setLe(n);
            } else if (byArray.length == 7) {
                if (byArray[4] == 0) {
                    apdu.setLe(ApduIOCardAccessor.makeShort(byArray[5], byArray[6]));
                    apdu.isExtended = true;
                } else if (byArray[4] == 1) {
                    byte[] byArray2 = new byte[]{byArray[5]};
                    apdu.setDataIn(byArray2);
                    apdu.setLe(byArray[6] & 0xFF);
                } else if (byArray[4] == 2) {
                    byte[] byArray3 = new byte[]{byArray[5], byArray[6]};
                    apdu.setDataIn(byArray3);
                }
            } else if (byArray.length > 5) {
                if (byArray[4] == 0) {
                    short s = ApduIOCardAccessor.makeShort(byArray[5], byArray[6]);
                    byte[] byArray4 = new byte[s];
                    System.arraycopy(byArray, 7, byArray4, 0, s);
                    apdu.setDataIn(byArray4);
                    if (byArray.length == s + 9) {
                        short s2 = ApduIOCardAccessor.makeShort(byArray[byArray.length - 2], byArray[byArray.length - 1]);
                        apdu.setLe(s2);
                        if (s2 > 256) {
                            apdu.isExtended = true;
                        }
                    }
                } else {
                    int n = byArray[4] & 0xFF;
                    byte[] byArray5 = new byte[n];
                    System.arraycopy(byArray, 5, byArray5, 0, n);
                    apdu.setDataIn(byArray5);
                    if (byArray.length == n + 6) {
                        int n2 = byArray[byArray.length - 1] & 0xFF;
                        n2 = n2 != 0 ? n2 : 256;
                        apdu.setLe(n2);
                    }
                }
            }
        }
        return apdu;
    }

    private static short makeShort(byte by, byte by2) {
        return (short)(((short)by << 8) + ((short)by2 & 0xFF));
    }

    private static void printArray(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            if (i != 0 && i % 16 == 0) {
                System.out.println();
            }
            System.out.print(ApduIOCardAccessor.getHexString(byArray[i]) + " ");
        }
        System.out.println();
    }

    static String getHexString(byte by) {
        return dig[(by & 0xFF) >> 4] + dig[by & 0xF];
    }

    private static CadClientInterface connectToSerialPort(String string, byte by) throws Exception {
        try {
            Class<?> clazz = Class.forName("javax.comm.CommPort");
            Class<?> clazz2 = Class.forName("javax.comm.CommPortIdentifier");
            Method method = clazz2.getMethod("getPortIdentifier", String.class);
            Object object = method.invoke(null, string);
            Method method2 = clazz2.getMethod("open", String.class, Integer.TYPE);
            Object object2 = method2.invoke(object, "apdutool", new Integer(30000));
            Method method3 = clazz.getMethod("getInputStream", new Class[0]);
            Method method4 = clazz.getMethod("getOutputStream", new Class[0]);
            InputStream inputStream = (InputStream)method3.invoke(object2, new Object[0]);
            OutputStream outputStream = (OutputStream)method4.invoke(object2, new Object[0]);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            return CadDevice.getCadClientInstance(by, bufferedInputStream, bufferedOutputStream);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Exception(_messages.getString("error.4"));
        }
        catch (Exception exception) {
            System.out.println(_messages.getString("error.5"));
            try {
                Class<?> clazz = Class.forName("javax.comm.CommPortIdentifier");
                Method method = clazz.getMethod("getPortIdentifiers", new Class[0]);
                Method method5 = clazz.getMethod("getName", new Class[0]);
                Enumeration enumeration = (Enumeration)method.invoke(null, new Object[0]);
                System.out.println(_messages.getString("error.6"));
                if (enumeration != null && enumeration.hasMoreElements()) {
                    while (enumeration.hasMoreElements()) {
                        Object e = enumeration.nextElement();
                        System.out.println(method5.invoke(e, new Object[0]));
                    }
                } else {
                    System.out.println(_messages.getString("error.7"));
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new Exception(_messages.getString("error.8"));
        }
    }
}

