/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.basicstructure.FieldDefinition;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.exportfile.EfAttribute;
import com.sun.javacard.exportfile.EfConstantPool;
import com.sun.javacard.exportfile.EfConstantValueAttribute;
import com.sun.javacard.exportfile.ExportFileFormatError;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;

public class EfField
extends FieldDefinition {
    private int name_index;
    private int descriptor_index;
    private EfAttribute[] attributes;
    private EfConstantPool constant_pool;

    public EfField(EfConstantPool efConstantPool) {
        this.constant_pool = efConstantPool;
    }

    public EfField(FieldDefinition fieldDefinition, EfConstantPool efConstantPool) {
        super(fieldDefinition);
        this.constant_pool = efConstantPool;
        this.name_index = this.constant_pool.addConstantUtf8(this.field_name);
        this.descriptor_index = this.constant_pool.addConstantUtf8(this.descriptor);
        if (Modifier.isStatic(this.access_flags) && Modifier.isFinal(this.access_flags) && DataType.getType(this.descriptor) != 10) {
            if (this.value.length == 0) {
                throw new ExportFileFormatError();
            }
            this.attributes = new EfAttribute[1];
            this.attributes[0] = new EfConstantValueAttribute(efConstantPool, this.value[0]);
        } else {
            this.attributes = new EfAttribute[0];
        }
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
        this.token = dataInputStream.readUnsignedByte();
        this.access_flags = dataInputStream.readShort();
        this.name_index = dataInputStream.readUnsignedShort();
        this.descriptor_index = dataInputStream.readUnsignedShort();
        int n = dataInputStream.readUnsignedShort();
        if (n == 1) {
            this.attributes = new EfAttribute[1];
            this.attributes[0] = new EfConstantValueAttribute(this.constant_pool);
            this.attributes[0].parse(dataInputStream);
        } else if (n == 0) {
            this.attributes = new EfAttribute[0];
        } else {
            throw new ExportFileFormatError();
        }
    }

    public void resolve() {
        this.field_name = this.constant_pool.getConstantUtf8(this.name_index).getUtf8String();
        this.descriptor = this.constant_pool.getConstantUtf8(this.descriptor_index).getUtf8String();
        for (EfAttribute efAttribute : this.attributes) {
            efAttribute.resolve();
            if (!(efAttribute instanceof EfConstantValueAttribute)) continue;
            this.value = new int[1];
            this.value[0] = ((EfConstantValueAttribute)efAttribute).getValue();
        }
    }

    public void toText(PrintWriter printWriter, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
        }
        String string = stringBuffer.toString();
        printWriter.println(string + "field_info {");
        printWriter.println(string + "\ttoken\t" + this.token);
        printWriter.println(string + "\taccess_flags\t" + Modifier.toString(this.access_flags));
        printWriter.println(string + "\tname_index\t" + this.name_index + "\t\t// " + this.field_name);
        printWriter.println(string + "\tDescriptor_Index\t" + this.descriptor_index + "\t\t// " + this.descriptor);
        printWriter.println(string + "\tattributes_count\t" + this.attributes.length);
        if (this.attributes != null) {
            printWriter.println(string + "\tattributes {");
            for (EfAttribute efAttribute : this.attributes) {
                efAttribute.toText(printWriter, n + 1);
            }
            printWriter.println(string + "\t}");
        }
        printWriter.println(string + "}");
    }

    public void toBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.token);
        dataOutputStream.writeShort(this.access_flags);
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeShort(this.descriptor_index);
        dataOutputStream.writeShort(this.attributes.length);
        for (EfAttribute efAttribute : this.attributes) {
            efAttribute.toBinary(dataOutputStream);
        }
    }

    public int getNameIndex() {
        return this.name_index;
    }

    public int getDescriptorIndex() {
        return this.descriptor_index;
    }

    public EfAttribute getAttribute() {
        if (this.attributes != null) {
            return this.attributes[0];
        }
        return null;
    }
}

