/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.normalizer;

import com.sun.javacard.cli.CommandOption;
import com.sun.javacard.cli.SubCommand;
import com.sun.javacard.components.ClassicCAPFile;
import com.sun.javacard.normalizer.OptionNames;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Verifier;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class NormalizeCommand
extends SubCommand {
    private File inFile;
    Vector<File> exportFiles;
    boolean keepall = false;
    String keepallDirectory;

    public NormalizeCommand() {
        super("normalize");
    }

    @Override
    public void setup() {
        this.addOption(new CommandOption("i", "in"));
        this.addOption(new CommandOption("p", "exportpath"));
        this.addOption(new CommandOption("f", "exportfile"));
        this.addOption(new CommandOption("o", "out"));
        this.addOption(new CommandOption("k", "keepall"));
    }

    @Override
    public int execute() throws Exception {
        String string = null;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        String string2 = ".";
        block7: for (Object object : this.optionsArray) {
            switch (OptionNames.valueOf(object.getLongOpt().toUpperCase())) {
                case IN: {
                    string = object.getValue();
                    continue block7;
                }
                case EXPORTPATH: {
                    vector.addElement(object.getValue());
                    continue block7;
                }
                case EXPORTFILE: {
                    vector2.addElement(object.getValue());
                    continue block7;
                }
                case OUT: {
                    string2 = object.getValue();
                    continue block7;
                }
                case KEEPALL: {
                    this.keepall = true;
                    this.keepallDirectory = object.getValue();
                }
            }
        }
        if (string == null) {
            throw new Exception(this.getResourceString("normalize.error.0"));
        }
        this.inFile = new File(string);
        if (!this.inFile.exists()) {
            throw new Exception(this.getResourceString("normalize.error.0"));
        }
        this.exportFiles = new Vector();
        for (String string3 : vector) {
            File file = new File(string3);
            if (!file.exists()) {
                throw new Exception(this.getFormattedResourceString("normalize.error.3", string3));
            }
            if (!file.isDirectory()) {
                throw new Exception(this.getFormattedResourceString("normalize.error.1", string3));
            }
            this.populateExportFiles(this.exportFiles, file);
        }
        for (String string4 : vector2) {
            File file = new File(string4);
            if (!file.exists()) {
                throw new Exception(this.getResourceString("normalize.error.2"));
            }
            this.exportFiles.addElement(file);
        }
        this.toolsLogger.info(this.getResourceString("normalize.info.0"), new Object[0]);
        ClassicCAPFile classicCAPFile = new ClassicCAPFile(this.inFile, this.exportFiles, string2, this.keepallDirectory);
        if (this.keepall) {
            Object object;
            this.toolsLogger.info(this.getResourceString("normalize.info.5"), new Object[0]);
            FileInputStream fileInputStream = new FileInputStream(this.inFile);
            this.toolsLogger.info(this.getResourceString("normalize.info.1"), new Object[0]);
            Verifier.verifyCap(fileInputStream, null, this.exportFiles);
            String string5 = new String(Cap.packageDirectory);
            this.toolsLogger.info(this.getResourceString("normalize.info.4"), new Object[0]);
            object = this.getFinalCAPFile(string5, string2);
            JarEntry jarEntry = null;
            JarFile jarFile = new JarFile((File)object);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                jarEntry = enumeration.nextElement();
                if (!jarEntry.getName().endsWith(".cap") && !jarEntry.getName().endsWith(".class")) continue;
                byte[] byArray = new byte[(int)jarEntry.getSize()];
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                inputStream.read(byArray);
                File file = new File(this.keepallDirectory, this.getFileName(jarEntry.getName()));
                File file2 = file.getParentFile();
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
                dataOutputStream.write(byArray);
                dataOutputStream.close();
            }
        }
        return 0;
    }

    String getFileName(String string) {
        int n = "APPLET-INF/classes/".length();
        if (string.startsWith("APPLET-INF/classes/")) {
            return string.substring(n);
        }
        return string;
    }

    private File getFinalCAPFile(String string, String string2) throws Exception {
        char c = File.separatorChar;
        int n = string.lastIndexOf("/");
        String string3 = string;
        if (n >= 0) {
            string3 = string.substring(string.lastIndexOf("/"));
        }
        string3 = string2 + c + string.replace('/', c) + c + "javacard" + c + string3 + ".cap";
        return new File(string3);
    }

    private void populateExportFiles(Vector<File> vector, File file) {
        File[] fileArray;
        if (file.isFile()) {
            if (file.getName().endsWith(".exp")) {
                vector.addElement(file);
            }
            return;
        }
        for (File file2 : fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".exp");
            }
        })) {
            this.populateExportFiles(vector, file2);
        }
    }
}

