/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardinstaller;

import com.sun.javacard.offcardinstaller.TargetHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public class RCTargetHelper
extends TargetHelper {
    private HttpMethodRetryHandler retryhandler = new HttpMethodRetryHandler(){

        public boolean retryMethod(HttpMethod httpMethod, IOException iOException, int n) {
            if (n >= 5) {
                return false;
            }
            if (iOException instanceof ConnectException) {
                return false;
            }
            if (iOException instanceof SocketException) {
                return false;
            }
            if (iOException instanceof NoHttpResponseException) {
                return true;
            }
            return !httpMethod.isRequestSent();
        }
    };

    public RCTargetHelper(ResourceBundle resourceBundle) {
        super(resourceBundle);
    }

    @Override
    public int load(String string, String string2, String string3, String string4, File file, File file2, String string5, String string6, String string7, String string8, String string9, String string10, String string11, int n) throws Exception {
        if (string4 == null) {
            throw new Exception(this.getResourceString("load.error.1"));
        }
        if (n == -1) {
            throw new Exception(this.getResourceString("load.error.11"));
        }
        if (!file.exists()) {
            throw new Exception(this.getFormattedResourceString("load.error.4", file.getAbsolutePath()));
        }
        Vector<Header> vector = new Vector<Header>();
        vector.add(new Header("bundleID", String.valueOf(string4)));
        vector.add(new Header("type", Integer.toString(n)));
        if (string5 != null) {
            vector.add(new Header("certificate", string5));
        }
        if (string6 != null) {
            vector.add(new Header("signature", string6));
        }
        if (string7 != null) {
            vector.add(new Header("selfIdServer", string7));
        }
        if (string8 != null) {
            vector.add(new Header("sslPrivKeyMod", string8));
        }
        if (string9 != null) {
            vector.add(new Header("sslPrivKeyExp", string9));
        }
        if (string10 != null) {
            vector.add(new Header("trustedCA", string10));
        }
        if (string11 != null) {
            vector.add(new Header("acceptedIssuer", string11));
        }
        return this.doPost(string, string2, string3, "load", vector, file);
    }

    @Override
    public int create(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws Exception {
        if (string4 == null) {
            throw new Exception(this.getResourceString("create.error.1"));
        }
        Vector<Header> vector = new Vector<Header>();
        vector.addElement(new Header("bundleID", string4));
        if (string5 != null) {
            vector.addElement(new Header("appletID", string5));
        }
        if (string6 != null) {
            vector.addElement(new Header("instanceID", string6));
        }
        return this.doPost(string, string2, string3, "create", vector, null);
    }

    @Override
    public int delete(String string, String string2, String string3, String string4) throws Exception {
        if (string4 == null) {
            throw new Exception(this.getResourceString("delete.error.1"));
        }
        Vector<Header> vector = new Vector<Header>();
        vector.addElement(new Header("instanceID", string4));
        return this.doPost(string, string2, string3, "delete", vector, null);
    }

    @Override
    public int unload(String string, String string2, String string3, String string4, boolean bl) throws Exception {
        if (string4 == null) {
            throw new Exception(this.getResourceString("unload.error.1"));
        }
        Vector<Header> vector = new Vector<Header>();
        vector.addElement(new Header("bundleID", string4));
        vector.addElement(new Header("force", bl ? "1" : "0"));
        return this.doPost(string, string2, string3, "unload", vector, null);
    }

    @Override
    public int list(String string, String string2, String string3, boolean bl) throws Exception {
        Vector<Header> vector = new Vector<Header>();
        vector.addElement(new Header("detailed", bl ? "1" : "0"));
        return this.doPost(string, string2, string3, "list", vector, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doPost(String string, String string2, String string3, String string4, Vector<Header> vector, File file) throws Exception {
        String string5;
        int n = 0;
        String string6 = null;
        String string7 = null;
        HttpClient httpClient = new HttpClient();
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        string = string + string4;
        PostMethod postMethod = new PostMethod(string);
        Object object = vector.iterator();
        while (object.hasNext()) {
            Header header = object.next();
            postMethod.setRequestHeader(header);
        }
        postMethod.setRequestHeader("Content-Type", "javacard/module");
        postMethod.getParams().setParameter("http.method.retry-handler", (Object)this.retryhandler);
        if (string4.equals("load")) {
            object = new FileInputStream(file);
            postMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)object));
        }
        try {
            httpClient.executeMethod((HttpMethod)postMethod);
            n = postMethod.getStatusCode();
            string6 = postMethod.getStatusText();
            if (n == 401) {
                if (string2 == null) {
                    throw new Exception(this.getResourceString("installer.error.2"));
                }
                if (string3 == null) {
                    throw new Exception(this.getResourceString("installer.error.3"));
                }
                httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(string2, string3));
                httpClient.executeMethod((HttpMethod)postMethod);
                n = postMethod.getStatusCode();
                string6 = postMethod.getStatusText();
            }
            if ((object = postMethod.getResponseHeader("JC-Status")) == null) {
                throw new Exception(this.getResourceString("installer.error.4"));
            }
            string5 = object.getValue();
            string7 = postMethod.getResponseBodyAsString();
            if (string7 == null) {
                string7 = "";
            }
            this.handleResponse(string4, n, string6, string5, string7);
        }
        finally {
            postMethod.releaseConnection();
        }
        int n2 = Integer.parseInt(string5);
        if (n2 != 2000 && n2 != 2010) {
            if (n2 == 4089) {
                return n2;
            }
            return 1;
        }
        return 0;
    }

    private void handleResponse(String string, int n, String string2, String string3, String string4) {
        if (n != 200 && n != 400) {
            System.err.println(this.getResourceString("installer.error.5"));
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "\r\n");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken().trim();
        }
        try {
            String string5 = this.getFormattedResourceString("response." + string3, stringArray);
            System.out.println("\n\n" + string5);
            if (string.equals("list")) {
                System.out.println("\n\n" + string4);
            }
        }
        catch (Exception exception) {
            System.err.println(this.getFormattedResourceString("installer.error.6", string3));
            System.out.println("HTTP Status Code: " + n);
            System.out.println("    message: " + string2);
            System.out.println("JC-Status: " + string4);
            System.out.println("description: " + string4);
        }
    }
}

