/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.el.lexer;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.el.lexer.ELState;
import org.netbeans.modules.el.lexer.api.ELTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public class ELLexer
implements Lexer<ELTokenId> {
    private static final Logger LOGGER = Logger.getLogger(ELLexer.class.getName());
    private static final boolean LOG = Boolean.getBoolean("j2ee_lexer_debug");
    private static final int EOF = -1;
    private final LexerInput input;
    private final TokenFactory<ELTokenId> tokenFactory;
    private int lexerState = 1;
    private int conditionalOperatorCount;
    private static final int INIT = 1;
    private static final int ISI_IDENTIFIER = 2;
    private static final int ISI_CHAR = 3;
    private static final int ISI_CHAR_A_BSLASH = 4;
    private static final int ISI_STRING = 5;
    private static final int ISI_STRING_A_BSLASH = 6;
    private static final int ISI_CHAR_STRING = 7;
    private static final int ISI_CHAR_STRING_A_BSLASH = 8;
    private static final int ISA_ZERO = 9;
    private static final int ISI_INT = 10;
    private static final int ISI_OCTAL = 11;
    private static final int ISI_DOUBLE = 12;
    private static final int ISI_DOUBLE_EXP = 13;
    private static final int ISI_HEX = 14;
    private static final int ISA_DOT = 15;
    private static final int ISI_WHITESPACE = 16;
    private static final int ISA_EQ = 17;
    private static final int ISA_GT = 18;
    private static final int ISA_LT = 19;
    private static final int ISA_PLUS = 20;
    private static final int ISA_MINUS = 21;
    private static final int ISA_PIPE = 23;
    private static final int ISA_AND = 24;
    private static final int ISA_EXCLAMATION = 25;
    private static final int ISI_BRACKET = 26;
    private static final int ISI_BRACKET_A_WHITESPACE = 27;
    private static final int ISI_BRACKET_A_IDENTIFIER = 28;
    private static final int ISI_BRACKET_ISA_EQ = 29;
    private static final int ISI_BRACKET_ISA_GT = 30;
    private static final int ISI_BRACKET_ISA_LT = 31;
    private static final int ISI_BRACKET_ISA_PIPE = 32;
    private static final int ISI_BRACKET_ISA_AND = 33;
    private static final int ISI_BRACKET_ISA_ZERO = 34;
    private static final int ISI_BRACKET_ISA_DOT = 35;
    private static final int ISI_BRACKET_ISI_INT = 36;
    private static final int ISI_BRACKET_ISI_OCTAL = 37;
    private static final int ISI_BRACKET_ISI_DOUBLE = 38;
    private static final int ISI_BRACKET_ISI_DOUBLE_EXP = 39;
    private static final int ISI_BRACKET_ISI_HEX = 40;
    private static final int ISI_DOULE_EXP_ISA_SIGN = 41;
    private static final int ISI_BRACKET_ISI_DOULE_EXP_ISA_SIGN = 42;
    private static final int ISI_BRACKET_ISA_MINUS = 43;
    private static final int ISI_BRACKET_ISA_PLUS = 44;

    public Object state() {
        return new ELState(this.lexerState, this.conditionalOperatorCount);
    }

    public ELLexer(LexerRestartInfo<ELTokenId> info) {
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
        if (info.state() == null) {
            this.lexerState = 1;
            this.conditionalOperatorCount = 0;
        } else {
            ELState current = (ELState)info.state();
            this.lexerState = current.getState();
            this.conditionalOperatorCount = current.getConditionalCount();
        }
    }

    public Token<ELTokenId> nextToken() {
        block191: while (true) {
            int actChar;
            if ((actChar = this.input.read()) == -1) {
                if (this.input.readLengthEOF() == 1) {
                    return null;
                }
                break;
            }
            block0 : switch (this.lexerState) {
                case 1: {
                    switch (actChar) {
                        case 34: {
                            this.lexerState = 5;
                            break block0;
                        }
                        case 39: {
                            this.lexerState = 3;
                            break block0;
                        }
                        case 47: {
                            return this.token(ELTokenId.DIV);
                        }
                        case 61: {
                            this.lexerState = 17;
                            break block0;
                        }
                        case 62: {
                            this.lexerState = 18;
                            break block0;
                        }
                        case 60: {
                            this.lexerState = 19;
                            break block0;
                        }
                        case 43: {
                            this.lexerState = 20;
                            break block0;
                        }
                        case 45: {
                            this.lexerState = 21;
                            break block0;
                        }
                        case 42: {
                            return this.token(ELTokenId.MUL);
                        }
                        case 124: {
                            this.lexerState = 23;
                            break block0;
                        }
                        case 38: {
                            this.lexerState = 24;
                            break block0;
                        }
                        case 91: {
                            return this.token(ELTokenId.LBRACKET);
                        }
                        case 93: {
                            return this.token(ELTokenId.RBRACKET);
                        }
                        case 37: {
                            return this.token(ELTokenId.MOD);
                        }
                        case 58: {
                            --this.conditionalOperatorCount;
                            return this.token(ELTokenId.COLON);
                        }
                        case 59: {
                            return this.token(ELTokenId.SEMICOLON);
                        }
                        case 33: {
                            this.lexerState = 25;
                            break block0;
                        }
                        case 40: {
                            return this.token(ELTokenId.LPAREN);
                        }
                        case 41: {
                            return this.token(ELTokenId.RPAREN);
                        }
                        case 44: {
                            return this.token(ELTokenId.COMMA);
                        }
                        case 63: {
                            ++this.conditionalOperatorCount;
                            return this.token(ELTokenId.QUESTION);
                        }
                        case 10: {
                            return this.token(ELTokenId.EOL);
                        }
                        case 48: {
                            this.lexerState = 9;
                            break block0;
                        }
                        case 46: {
                            this.lexerState = 15;
                            break block0;
                        }
                        case 92: {
                            int nextChar = this.input.read();
                            this.input.backup(1);
                            if (nextChar != 34) continue block191;
                            return this.token(ELTokenId.STRING_LITERAL);
                        }
                        default: {
                            if (Character.isWhitespace(actChar)) {
                                this.lexerState = 16;
                                break block0;
                            }
                            if (Character.isJavaIdentifierStart(actChar)) {
                                this.lexerState = 2;
                                break block0;
                            }
                            if (Character.isDigit(actChar)) {
                                this.lexerState = 10;
                                break block0;
                            }
                            return this.token(ELTokenId.INVALID_CHAR);
                        }
                    }
                }
                case 16: {
                    if (Character.isWhitespace(actChar)) break;
                    this.lexerState = 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.WHITESPACE);
                }
                case 26: {
                    switch (actChar) {
                        case 93: {
                            this.lexerState = 1;
                            this.input.backup(1);
                            return this.token(ELTokenId.IDENTIFIER);
                        }
                        case 34: {
                            return this.token(ELTokenId.LBRACKET);
                        }
                        case 39: {
                            return this.token(ELTokenId.LBRACKET);
                        }
                        case 47: {
                            return this.token(ELTokenId.DIV);
                        }
                        case 43: {
                            this.lexerState = 44;
                            break block0;
                        }
                        case 45: {
                            this.lexerState = 43;
                            break block0;
                        }
                        case 42: {
                            return this.token(ELTokenId.MUL);
                        }
                        case 91: {
                            return this.token(ELTokenId.LBRACKET);
                        }
                        case 37: {
                            return this.token(ELTokenId.MOD);
                        }
                        case 58: {
                            return this.token(ELTokenId.COLON);
                        }
                        case 59: {
                            return this.token(ELTokenId.SEMICOLON);
                        }
                        case 40: {
                            return this.token(ELTokenId.LPAREN);
                        }
                        case 41: {
                            return this.token(ELTokenId.RPAREN);
                        }
                        case 44: {
                            return this.token(ELTokenId.COMMA);
                        }
                        case 63: {
                            return this.token(ELTokenId.QUESTION);
                        }
                        case 61: {
                            this.lexerState = 29;
                            break block0;
                        }
                        case 62: {
                            this.lexerState = 30;
                            break block0;
                        }
                        case 60: {
                            this.lexerState = 31;
                            break block0;
                        }
                        case 124: {
                            this.lexerState = 32;
                            break block0;
                        }
                        case 38: {
                            this.lexerState = 33;
                            break block0;
                        }
                        case 48: {
                            this.lexerState = 34;
                            break block0;
                        }
                        case 46: {
                            this.lexerState = 35;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace(actChar)) {
                        this.lexerState = 27;
                        break;
                    }
                    if (Character.isJavaIdentifierStart(actChar)) {
                        this.lexerState = 28;
                        break;
                    }
                    if (Character.isDigit(actChar)) {
                        this.lexerState = 36;
                        break;
                    }
                    return this.token(ELTokenId.INVALID_CHAR);
                }
                case 27: {
                    if (Character.isWhitespace(actChar)) break;
                    this.lexerState = 26;
                    this.input.backup(1);
                    return this.token(ELTokenId.WHITESPACE);
                }
                case 17: 
                case 29: {
                    switch (actChar) {
                        case 61: {
                            this.lexerState = 1;
                            return this.token(ELTokenId.EQ_EQ);
                        }
                    }
                    this.lexerState = this.lexerState == 29 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.EQ);
                }
                case 21: 
                case 43: {
                    switch (actChar) {
                        case 62: {
                            this.lexerState = 1;
                            return this.token(ELTokenId.LAMBDA);
                        }
                    }
                    this.lexerState = this.lexerState == 43 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.MINUS);
                }
                case 20: 
                case 44: {
                    switch (actChar) {
                        case 61: {
                            this.lexerState = 1;
                            return this.token(ELTokenId.CONCAT);
                        }
                    }
                    this.lexerState = this.lexerState == 44 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.PLUS);
                }
                case 18: 
                case 30: {
                    switch (actChar) {
                        case 61: {
                            this.lexerState = 1;
                            return this.token(ELTokenId.GT_EQ);
                        }
                    }
                    this.lexerState = this.lexerState == 30 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.GT);
                }
                case 19: 
                case 31: {
                    switch (actChar) {
                        case 61: {
                            this.lexerState = 1;
                            return this.token(ELTokenId.LT_EQ);
                        }
                    }
                    this.lexerState = this.lexerState == 31 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.LT);
                }
                case 23: 
                case 32: {
                    switch (actChar) {
                        case 124: {
                            this.lexerState = 1;
                            return this.token(ELTokenId.OR_OR);
                        }
                    }
                    this.lexerState = this.lexerState == 32 ? 26 : 1;
                    this.input.backup(1);
                    break;
                }
                case 24: 
                case 33: {
                    switch (actChar) {
                        case 38: {
                            this.lexerState = 1;
                            return this.token(ELTokenId.AND_AND);
                        }
                    }
                    this.lexerState = this.lexerState == 33 ? 26 : 1;
                    this.input.backup(1);
                    break;
                }
                case 25: {
                    switch (actChar) {
                        case 61: {
                            this.lexerState = 1;
                            return this.token(ELTokenId.NOT_EQ);
                        }
                    }
                    this.lexerState = 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.NOT);
                }
                case 5: {
                    switch (actChar) {
                        case 92: {
                            this.lexerState = 6;
                            break block0;
                        }
                        case 10: {
                            this.lexerState = 1;
                            this.input.backup(1);
                            return this.token(ELTokenId.STRING_LITERAL);
                        }
                        case 34: {
                            this.lexerState = 1;
                            return this.token(ELTokenId.STRING_LITERAL);
                        }
                    }
                    break;
                }
                case 6: {
                    this.lexerState = 5;
                    break;
                }
                case 2: 
                case 28: {
                    if (Character.isJavaIdentifierPart(actChar)) break;
                    switch (this.lexerState) {
                        case 2: {
                            this.lexerState = 1;
                            break;
                        }
                        case 28: {
                            this.lexerState = 26;
                        }
                    }
                    this.input.backup(1);
                    Token<ELTokenId> tid = this.matchKeyword(this.input);
                    if (tid == null) {
                        tid = actChar == 58 ? (this.conditionalOperatorCount > 0 ? this.token(ELTokenId.IDENTIFIER) : this.token(ELTokenId.TAG_LIB_PREFIX)) : this.token(ELTokenId.IDENTIFIER);
                    }
                    return tid;
                }
                case 3: {
                    switch (actChar) {
                        case 92: {
                            this.lexerState = 4;
                            break block0;
                        }
                        case 10: {
                            this.lexerState = 1;
                            this.input.backup(1);
                            return this.token(ELTokenId.CHAR_LITERAL);
                        }
                        case 39: {
                            this.lexerState = 1;
                            return this.token(ELTokenId.CHAR_LITERAL);
                        }
                    }
                    char prevChar = this.input.readText().charAt(this.input.readLength() - 1);
                    if (prevChar == '\'' || prevChar == '\\') continue block191;
                    this.lexerState = 7;
                    break;
                }
                case 4: {
                    switch (actChar) {
                        case 39: 
                        case 92: {
                            break;
                        }
                        default: {
                            this.input.backup(1);
                        }
                    }
                    this.lexerState = 3;
                    break;
                }
                case 7: {
                    switch (actChar) {
                        case 92: {
                            this.lexerState = 8;
                            break block0;
                        }
                        case 10: {
                            this.lexerState = 1;
                            this.input.backup(1);
                            return this.token(ELTokenId.STRING_LITERAL);
                        }
                        case 39: {
                            this.lexerState = 1;
                            return this.token(ELTokenId.STRING_LITERAL);
                        }
                    }
                    break;
                }
                case 8: {
                    switch (actChar) {
                        case 39: 
                        case 92: {
                            break;
                        }
                        default: {
                            this.input.backup(1);
                        }
                    }
                    this.lexerState = 7;
                    break;
                }
                case 9: 
                case 34: {
                    switch (actChar) {
                        case 46: {
                            this.lexerState = this.lexerState == 34 ? 38 : 12;
                            break block0;
                        }
                        case 88: 
                        case 120: {
                            this.lexerState = this.lexerState == 34 ? 40 : 14;
                            break block0;
                        }
                        case 76: 
                        case 108: {
                            this.lexerState = this.lexerState == 34 ? 26 : 1;
                            return this.token(ELTokenId.LONG_LITERAL);
                        }
                        case 70: 
                        case 102: {
                            this.lexerState = this.lexerState == 34 ? 26 : 1;
                            return this.token(ELTokenId.FLOAT_LITERAL);
                        }
                        case 68: 
                        case 100: {
                            this.lexerState = this.lexerState == 34 ? 26 : 1;
                            return this.token(ELTokenId.DOUBLE_LITERAL);
                        }
                        case 56: 
                        case 57: {
                            this.lexerState = this.lexerState == 34 ? 26 : 1;
                            return this.token(ELTokenId.INVALID_OCTAL_LITERAL);
                        }
                        case 69: 
                        case 101: {
                            this.lexerState = this.lexerState == 34 ? 39 : 13;
                            break block0;
                        }
                    }
                    if (Character.isDigit(actChar)) {
                        this.lexerState = this.lexerState == 34 ? 37 : 11;
                        break;
                    }
                    this.lexerState = this.lexerState == 34 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.INT_LITERAL);
                }
                case 10: 
                case 36: {
                    switch (actChar) {
                        case 76: 
                        case 108: {
                            this.lexerState = this.lexerState == 36 ? 26 : 1;
                            return this.token(ELTokenId.LONG_LITERAL);
                        }
                        case 46: {
                            this.lexerState = this.lexerState == 36 ? 38 : 12;
                            break block0;
                        }
                        case 70: 
                        case 102: {
                            this.lexerState = this.lexerState == 36 ? 26 : 1;
                            return this.token(ELTokenId.FLOAT_LITERAL);
                        }
                        case 68: 
                        case 100: {
                            this.lexerState = this.lexerState == 36 ? 26 : 1;
                            return this.token(ELTokenId.DOUBLE_LITERAL);
                        }
                        case 69: 
                        case 101: {
                            this.lexerState = 13;
                            break block0;
                        }
                    }
                    if (actChar >= 48 && actChar <= 57) continue block191;
                    this.lexerState = this.lexerState == 36 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.INT_LITERAL);
                }
                case 11: 
                case 37: {
                    if (actChar >= 48 && actChar <= 55) continue block191;
                    this.lexerState = this.lexerState == 37 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.OCTAL_LITERAL);
                }
                case 12: 
                case 38: {
                    switch (actChar) {
                        case 70: 
                        case 102: {
                            this.lexerState = this.lexerState == 38 ? 26 : 1;
                            return this.token(ELTokenId.FLOAT_LITERAL);
                        }
                        case 68: 
                        case 100: {
                            this.lexerState = this.lexerState == 38 ? 26 : 1;
                            return this.token(ELTokenId.DOUBLE_LITERAL);
                        }
                        case 69: 
                        case 101: {
                            this.lexerState = this.lexerState == 38 ? 39 : 13;
                            break block0;
                        }
                    }
                    if (actChar >= 48 && actChar <= 57 || actChar == 46) continue block191;
                    this.lexerState = this.lexerState == 38 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.DOUBLE_LITERAL);
                }
                case 13: 
                case 39: {
                    switch (actChar) {
                        case 70: 
                        case 102: {
                            this.lexerState = this.lexerState == 39 ? 26 : 1;
                            return this.token(ELTokenId.FLOAT_LITERAL);
                        }
                        case 68: 
                        case 100: {
                            this.lexerState = this.lexerState == 39 ? 26 : 1;
                            return this.token(ELTokenId.DOUBLE_LITERAL);
                        }
                        case 43: 
                        case 45: {
                            this.lexerState = 41;
                            break block0;
                        }
                    }
                    if (Character.isDigit(actChar)) break;
                    this.lexerState = this.lexerState == 39 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.DOUBLE_LITERAL);
                }
                case 41: 
                case 42: {
                    if (Character.isDigit(actChar)) break;
                    this.lexerState = this.lexerState == 42 ? 26 : 1;
                    switch (actChar) {
                        case 70: 
                        case 102: {
                            return this.token(ELTokenId.FLOAT_LITERAL);
                        }
                        case 68: 
                        case 100: {
                            return this.token(ELTokenId.DOUBLE_LITERAL);
                        }
                    }
                    this.input.backup(1);
                    return this.token(ELTokenId.DOUBLE_LITERAL);
                }
                case 14: 
                case 40: {
                    if (actChar >= 97 && actChar <= 102 || actChar >= 65 && actChar <= 70 || Character.isDigit(actChar)) continue block191;
                    this.lexerState = this.lexerState == 40 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.HEX_LITERAL);
                }
                case 15: 
                case 35: {
                    if (Character.isDigit(actChar)) {
                        this.lexerState = this.lexerState == 35 ? 38 : 12;
                        break;
                    }
                    this.lexerState = this.lexerState == 35 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.DOT);
                }
            }
        }
        this.input.backup(1);
        switch (this.lexerState) {
            case 1: {
                if (this.input.readLength() != 0) break;
                return null;
            }
            case 16: {
                this.lexerState = 1;
                return this.token(ELTokenId.WHITESPACE);
            }
            case 2: {
                this.lexerState = 1;
                Token<ELTokenId> kwd = this.matchKeyword(this.input);
                return kwd != null ? kwd : this.token(ELTokenId.IDENTIFIER);
            }
            case 5: 
            case 6: {
                return this.token(ELTokenId.STRING_LITERAL);
            }
            case 3: 
            case 4: {
                return this.token(ELTokenId.CHAR_LITERAL);
            }
            case 7: 
            case 8: {
                return this.token(ELTokenId.STRING_LITERAL);
            }
            case 9: 
            case 10: {
                this.lexerState = 1;
                return this.token(ELTokenId.INT_LITERAL);
            }
            case 11: {
                this.lexerState = 1;
                return this.token(ELTokenId.OCTAL_LITERAL);
            }
            case 12: 
            case 13: 
            case 41: 
            case 42: {
                this.lexerState = 1;
                return this.token(ELTokenId.DOUBLE_LITERAL);
            }
            case 14: {
                this.lexerState = 1;
                return this.token(ELTokenId.HEX_LITERAL);
            }
            case 15: {
                this.lexerState = 1;
                return this.token(ELTokenId.DOT);
            }
            case 17: {
                this.lexerState = 1;
                return this.token(ELTokenId.EQ);
            }
            case 21: {
                this.lexerState = 1;
                return this.token(ELTokenId.MINUS);
            }
            case 20: {
                this.lexerState = 1;
                return this.token(ELTokenId.PLUS);
            }
            case 18: {
                this.lexerState = 1;
                return this.token(ELTokenId.GT);
            }
            case 19: {
                this.lexerState = 1;
                return this.token(ELTokenId.LT);
            }
            case 23: {
                this.lexerState = 1;
                return this.token(ELTokenId.OR_OR);
            }
            case 24: {
                this.lexerState = 1;
                return this.token(ELTokenId.AND_AND);
            }
            case 25: {
                this.lexerState = 1;
                return this.token(ELTokenId.NOT);
            }
            case 26: 
            case 28: {
                this.lexerState = 1;
                return this.token(ELTokenId.IDENTIFIER);
            }
            case 27: {
                this.lexerState = 26;
                return this.token(ELTokenId.WHITESPACE);
            }
            case 29: {
                this.lexerState = 26;
                return this.token(ELTokenId.EQ);
            }
            case 43: {
                this.lexerState = 26;
                return this.token(ELTokenId.MINUS);
            }
            case 44: {
                this.lexerState = 26;
                return this.token(ELTokenId.PLUS);
            }
            case 30: {
                this.lexerState = 26;
                return this.token(ELTokenId.GT_EQ);
            }
            case 31: {
                this.lexerState = 26;
                return this.token(ELTokenId.LT_EQ);
            }
            case 33: {
                this.lexerState = 26;
                return this.token(ELTokenId.AND_AND);
            }
            case 32: {
                this.lexerState = 26;
                return this.token(ELTokenId.OR_OR);
            }
            case 35: {
                this.lexerState = 26;
                return this.token(ELTokenId.DOT);
            }
            case 34: 
            case 36: {
                this.lexerState = 26;
                return this.token(ELTokenId.INT_LITERAL);
            }
        }
        return null;
    }

    public Token<ELTokenId> matchKeyword(LexerInput lexerInput) {
        int len = lexerInput.readLength();
        char[] buffer = new char[len];
        String read = lexerInput.readText().toString();
        read.getChars(0, read.length(), buffer, 0);
        int offset = 0;
        if (len > 10) {
            return null;
        }
        if (len <= 1) {
            return null;
        }
        switch (buffer[offset++]) {
            case 'a': {
                if (len <= 2) {
                    return null;
                }
                return len == 3 && buffer[offset++] == 'n' && buffer[offset++] == 'd' ? this.token(ELTokenId.AND_KEYWORD) : null;
            }
            case 'd': {
                if (len <= 2) {
                    return null;
                }
                return len == 3 && buffer[offset++] == 'i' && buffer[offset++] == 'v' ? this.token(ELTokenId.DIV_KEYWORD) : null;
            }
            case 'e': {
                switch (buffer[offset++]) {
                    case 'q': {
                        return len == 2 ? this.token(ELTokenId.EQ_KEYWORD) : null;
                    }
                    case 'm': {
                        return len == 5 && buffer[offset++] == 'p' && buffer[offset++] == 't' && buffer[offset++] == 'y' ? this.token(ELTokenId.EMPTY_KEYWORD) : null;
                    }
                }
                return null;
            }
            case 'f': {
                return len == 5 && buffer[offset++] == 'a' && buffer[offset++] == 'l' && buffer[offset++] == 's' && buffer[offset++] == 'e' ? this.token(ELTokenId.FALSE_KEYWORD) : null;
            }
            case 'g': {
                switch (buffer[offset++]) {
                    case 'e': {
                        return len == 2 ? this.token(ELTokenId.GE_KEYWORD) : null;
                    }
                    case 't': {
                        return len == 2 ? this.token(ELTokenId.GT_KEYWORD) : null;
                    }
                }
                return null;
            }
            case 'l': {
                switch (buffer[offset++]) {
                    case 'e': {
                        return len == 2 ? this.token(ELTokenId.LE_KEYWORD) : null;
                    }
                    case 't': {
                        return len == 2 ? this.token(ELTokenId.LT_KEYWORD) : null;
                    }
                }
                return null;
            }
            case 'i': {
                if (len <= 9) {
                    return null;
                }
                return len == 10 && buffer[offset++] == 'n' && buffer[offset++] == 's' && buffer[offset++] == 't' && buffer[offset++] == 'a' && buffer[offset++] == 'n' && buffer[offset++] == 'c' && buffer[offset++] == 'e' && buffer[offset++] == 'o' && buffer[offset++] == 'f' ? this.token(ELTokenId.INSTANCEOF_KEYWORD) : null;
            }
            case 'm': {
                if (len <= 2) {
                    return null;
                }
                return len == 3 && buffer[offset++] == 'o' && buffer[offset++] == 'd' ? this.token(ELTokenId.MOD_KEYWORD) : null;
            }
            case 'n': {
                switch (buffer[offset++]) {
                    case 'e': {
                        return len == 2 ? this.token(ELTokenId.NE_KEYWORD) : null;
                    }
                    case 'o': {
                        return len == 3 && buffer[offset++] == 't' ? this.token(ELTokenId.NOT_KEYWORD) : null;
                    }
                    case 'u': {
                        return len == 4 && buffer[offset++] == 'l' && buffer[offset++] == 'l' ? this.token(ELTokenId.NULL_KEYWORD) : null;
                    }
                }
                return null;
            }
            case 'o': {
                return len == 2 && buffer[offset++] == 'r' ? this.token(ELTokenId.OR_KEYWORD) : null;
            }
            case 't': {
                return len == 4 && buffer[offset++] == 'r' && buffer[offset++] == 'u' && buffer[offset++] == 'e' ? this.token(ELTokenId.TRUE_KEYWORD) : null;
            }
        }
        return null;
    }

    private Token<ELTokenId> token(ELTokenId tokenId) {
        if (LOG) {
            if (this.input.readLength() == 0) {
                LOGGER.log(Level.INFO, "[" + this.getClass().getSimpleName() + "] Found zero length token: ");
            }
            LOGGER.log(Level.INFO, "[" + this.getClass().getSimpleName() + "] token ('" + this.input.readText().toString() + "'; id=" + (Object)((Object)tokenId) + ")\n");
        }
        return this.tokenFactory.createToken((TokenId)tokenId);
    }

    public void release() {
    }
}

