/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.common.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.netbeans.modules.j2me.common.ant.Bundle;
import org.netbeans.modules.j2me.common.ant.EMapFormat;

public class ObfuscateTask
extends Task {
    private static final boolean DELETE_SCRIPT = true;
    private static final String LIBS_OBFUSCATOR_CLASSPATH_PROPERTY_NAME = "libs.{0}.classpath";
    private static final String OBFUSCATOR_TYPE_NONE = "NONE";
    private File srcJar;
    private File destJar;
    private String obfuscatorType = "PROGUARD";
    private Path classPath;
    private String exclude;
    private String extraScript;
    private Path obfuscatorClassPath;
    private int obfuscationLevel;

    public void execute() throws BuildException {
        PrintWriter pw;
        File script;
        String tmp;
        String p;
        if (this.srcJar == null) {
            throw new BuildException(Bundle.getMessage("ERR_MissingAttr", "srcJar"));
        }
        if (this.destJar == null) {
            throw new BuildException(Bundle.getMessage("ERR_MissingAttr", "destJar"));
        }
        if (this.destJar.exists() && this.srcJar.lastModified() <= this.destJar.lastModified()) {
            this.log(Bundle.getMessage("MSG_JarIsUpToDate", this.destJar.getAbsolutePath()), 1);
            return;
        }
        if (this.obfuscatorClassPath == null) {
            this.createObfuscatorClassPath();
        }
        ArrayList<Object> obfuscators = Collections.list(new StringTokenizer(Bundle.getMessage("LIST_Obfuscators"), ","));
        ArrayList<String> foundObfuscators = new ArrayList<String>();
        for (int a = 0; a < obfuscators.size(); ++a) {
            String obfs = (String)obfuscators.get(a);
            String[] jointClassPaths = this.obfuscatorClassPath.list();
            String libsObfsClassPath = this.getProject().getProperty(MessageFormat.format(LIBS_OBFUSCATOR_CLASSPATH_PROPERTY_NAME, obfs.toLowerCase()));
            if (libsObfsClassPath != null) {
                jointClassPaths = ObfuscateTask.joinPaths(jointClassPaths, new Path(this.getProject(), libsObfsClassPath).list());
            }
            try {
                if (!ObfuscateTask.isPresent(jointClassPaths, Bundle.getMessage("COND_" + obfs))) {
                    continue;
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            foundObfuscators.add(obfs);
        }
        if (this.obfuscatorType == null || !foundObfuscators.contains(this.obfuscatorType)) {
            if (foundObfuscators.size() <= 0) {
                throw new BuildException(Bundle.getMessage("ERR_NoObfuscator"));
            }
            String old = this.obfuscatorType;
            this.obfuscatorType = (String)foundObfuscators.get(0);
            if (old == null) {
                this.log(Bundle.getMessage("WARN_ObfuscatorTypeNullMissing", this.obfuscatorType), 1);
            } else {
                this.log(Bundle.getMessage("WARN_ObfuscatorTypeMissing", old, this.obfuscatorType), 1);
            }
        }
        if (!obfuscators.contains(this.obfuscatorType)) {
            throw new BuildException(Bundle.getMessage("ERR_UnknownObfuscator", this.obfuscatorType));
        }
        if (this.obfuscationLevel < 0 || this.obfuscationLevel >= 10) {
            this.log(Bundle.getMessage("WARN_InvalidObfuscationLevel", "" + this.obfuscationLevel), 1);
            this.obfuscationLevel = 0;
        }
        if (OBFUSCATOR_TYPE_NONE.equals(this.obfuscatorType) || this.obfuscationLevel == 0) {
            this.doNoObfuscation();
            return;
        }
        String commandLine = Bundle.getMessage("CMD_" + this.obfuscatorType);
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("javahome", System.getProperty("java.home"));
        if (this.obfuscatorType != null && (p = this.getProject().getProperty(MessageFormat.format(LIBS_OBFUSCATOR_CLASSPATH_PROPERTY_NAME, this.obfuscatorType.toLowerCase()))) != null) {
            this.createObfuscatorClassPath().add(new Path(this.getProject(), p));
        }
        if (this.obfuscatorClassPath != null && (tmp = this.obfuscatorClassPath.toString()).length() > 0) {
            args.put("obfuscatorclasspath", tmp);
        }
        if (this.classPath != null && (tmp = this.classPath.toString()).length() > 0) {
            args.put("classpath", tmp);
            String[] paths = this.classPath.list();
            StringBuffer sb = new StringBuffer();
            if (paths != null && paths.length > 0) {
                for (int a = 0; a < paths.length; ++a) {
                    if (new File(paths[a]).exists()) {
                        if (sb.length() > 0) {
                            sb.append(File.pathSeparator);
                        }
                        sb.append("'" + paths[a] + "'");
                        continue;
                    }
                    this.log(Bundle.getMessage("MSG_SkippingPathElement", paths[a]), 3);
                }
                args.put("quotedclasspath", sb.toString());
            }
        }
        args.put("srcjar", this.srcJar.getAbsolutePath());
        args.put("destjar", this.destJar.getAbsolutePath());
        args.put(":", File.pathSeparator);
        args.put("/", File.separator);
        ArrayList<String> excludeClasses = new ArrayList<String>();
        if (this.exclude != null && !"".equals(this.exclude)) {
            StringTokenizer e = new StringTokenizer(this.exclude, ",");
            while (e.hasMoreTokens()) {
                excludeClasses.add(e.nextToken());
            }
        }
        this.log(Bundle.getMessage("MSG_ExcludingClasses", excludeClasses.toString()), 3);
        try {
            script = File.createTempFile("obfuscator.script.", null);
        }
        catch (IOException e) {
            throw new BuildException(Bundle.getMessage("ERR_CannotCreateTempFile", System.getProperty("java.io.tmpdir")));
        }
        try {
            pw = new PrintWriter(new FileOutputStream(script));
        }
        catch (FileNotFoundException e) {
            script.delete();
            throw new BuildException(Bundle.getMessage("ERR_IOException", script.getAbsolutePath()));
        }
        String obfuscatorScriptName = "obfuscators/" + this.obfuscatorType.toLowerCase() + "." + this.obfuscationLevel + ".txt";
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(obfuscatorScriptName);
        if (is == null) {
            throw new BuildException(Bundle.getMessage("ERR_ObfuscatorScriptIsMissing", obfuscatorScriptName));
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            String readLine;
            while ((readLine = br.readLine()) != null) {
                pw.println(readLine);
            }
        }
        catch (IOException e) {
            throw new BuildException(Bundle.getMessage("ERR_ErrorReadingObfsScript", obfuscatorScriptName));
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ioe) {}
        }
        if (this.extraScript != null) {
            pw.println(this.extraScript);
        }
        HashMap<String, Object> excludeClassesMap = new HashMap<String, Object>();
        excludeClassesMap.put("leftbrace", "{");
        excludeClassesMap.put("rightbrace", "}");
        for (int a = 0; a < excludeClasses.size(); ++a) {
            excludeClassesMap.put("classname", excludeClasses.get(a));
            excludeClassesMap.put("slashedclassname", ((String)excludeClasses.get(a)).replace('.', '/'));
            pw.println(EMapFormat.format(Bundle.getMessage("SCR_ExcludeClasses_" + this.obfuscatorType), excludeClassesMap));
        }
        if (pw.checkError()) {
            pw.close();
            script.delete();
            throw new BuildException(Bundle.getMessage("ERR_IOException", script.getAbsolutePath()));
        }
        pw.close();
        args.put("script", script.getAbsolutePath());
        commandLine = EMapFormat.format(commandLine, args);
        String[] commands = Commandline.translateCommandline((String)commandLine);
        this.log(Bundle.getMessage("MSG_ExecCmd", commandLine), 3);
        for (int a = 0; a < commands.length; ++a) {
            this.log(">" + commands[a] + "<", 3);
        }
        try {
            Execute exec = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.out));
            exec.setAntRun(this.getProject());
            exec.setVMLauncher(true);
            exec.setCommandline(commands);
            int i = exec.execute();
            if (i != 0) {
                script.delete();
                throw new BuildException(Bundle.getMessage("ERR_ObfuscationFailed", String.valueOf(i)));
            }
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
        finally {
            script.delete();
        }
    }

    private void doNoObfuscation() {
        this.log(Bundle.getMessage("MSG_CopyingJarFile", this.srcJar.getAbsolutePath(), this.destJar.getAbsolutePath()), 2);
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int len;
            fis = new FileInputStream(this.srcJar);
            fos = new FileOutputStream(this.destJar);
            byte[] buffer = new byte[16384];
            while ((len = fis.read(buffer)) >= 0) {
                fos.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new BuildException(Bundle.getMessage("ERR_CopyingJarFile", this.srcJar.getAbsolutePath(), this.destJar.getAbsolutePath()), (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static String[] joinPaths(String[] classPath, String[] obfuscatorPath) {
        int size = 0;
        if (classPath != null) {
            size += classPath.length;
        }
        if (obfuscatorPath != null) {
            size += obfuscatorPath.length;
        }
        String[] ret = new String[size];
        int pos = 0;
        if (classPath != null) {
            System.arraycopy(classPath, 0, ret, pos, classPath.length);
            pos += classPath.length;
        }
        if (obfuscatorPath != null) {
            System.arraycopy(obfuscatorPath, 0, ret, pos, obfuscatorPath.length);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPresent(String[] classPath, String conditions) {
        if (conditions == null) {
            return true;
        }
        StringTokenizer tokens = new StringTokenizer(conditions, ",");
        while (tokens.hasMoreTokens()) {
            String condition = tokens.nextToken();
            boolean found = false;
            if (classPath != null) {
                for (int a = 0; a < classPath.length; ++a) {
                    File part;
                    if (classPath[a] == null || !(part = new File(classPath[a])).exists()) continue;
                    if (part.isDirectory()) {
                        File classFile = new File(part, condition);
                        if (!classFile.exists() || !classFile.isFile()) continue;
                        found = true;
                        break;
                    }
                    ZipFile zip = null;
                    try {
                        zip = new ZipFile(part);
                        ZipEntry entry = zip.getEntry(condition);
                        if (entry == null || entry.isDirectory()) continue;
                        found = true;
                        break;
                    }
                    catch (IOException e) {
                        continue;
                    }
                    finally {
                        if (zip != null) {
                            try {
                                zip.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public void setSrcJar(File srcJar) {
        this.srcJar = srcJar;
    }

    public void setDestJar(File destJar) {
        this.destJar = destJar;
    }

    public void setObfuscatorType(String obfuscatorType) {
        this.obfuscatorType = obfuscatorType.toUpperCase();
    }

    public void setClassPath(Path classPath) {
        this.createClassPath().append(classPath);
    }

    public Path createClassPath() {
        if (this.classPath == null) {
            this.classPath = new Path(this.getProject());
        }
        return this.classPath.createPath();
    }

    public void setClassPathRef(Reference classPathRef) {
        this.createClassPath().setRefid(classPathRef);
    }

    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    public void setObfuscatorClassPath(Path obfuscatorClassPath) {
        this.createObfuscatorClassPath().append(obfuscatorClassPath);
    }

    public Path createObfuscatorClassPath() {
        if (this.obfuscatorClassPath == null) {
            this.obfuscatorClassPath = new Path(this.getProject());
        }
        return this.obfuscatorClassPath.createPath();
    }

    public void setObfuscatorClassPathRef(Reference obfuscatorClassPathRef) {
        this.createObfuscatorClassPath().setRefid(obfuscatorClassPathRef);
    }

    public void setObfuscationLevel(int obfuscationLevel) {
        this.obfuscationLevel = obfuscationLevel;
    }

    public void setExtraScript(String extraScript) {
        this.extraScript = extraScript;
    }
}

